/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.process.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.AbstractTreeIterator;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.epf.library.edit.IConfigurator;
import org.eclipse.epf.library.edit.LibraryEditResources;
import org.eclipse.epf.library.edit.Providers;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.command.BatchCommand;
import org.eclipse.epf.library.edit.command.IResourceAwareCommand;
import org.eclipse.epf.library.edit.process.command.BSDropCommand;
import org.eclipse.epf.library.edit.process.command.BasicSynchronizeDescriptorCommand;
import org.eclipse.epf.library.edit.process.command.DeleteUnusedDescriptorsCommand;
import org.eclipse.epf.library.edit.process.command.OBSDropCommand;
import org.eclipse.epf.library.edit.process.command.PBSDropCommand;
import org.eclipse.epf.library.edit.process.command.ProcessCommandUtil;
import org.eclipse.epf.library.edit.process.command.ProcessElementDeleteCommand;
import org.eclipse.epf.library.edit.process.command.RemoveDuplicateReferenceCommand;
import org.eclipse.epf.library.edit.process.command.SynchronizeDeliverableDescriptorCommand;
import org.eclipse.epf.library.edit.process.command.WBSDropCommand;
import org.eclipse.epf.library.edit.ui.UserInteractionHelper;
import org.eclipse.epf.library.edit.util.Messenger;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.Deliverable;
import org.eclipse.epf.uma.Descriptor;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.Process;
import org.eclipse.epf.uma.Role;
import org.eclipse.epf.uma.RoleDescriptor;
import org.eclipse.epf.uma.Task;
import org.eclipse.epf.uma.TaskDescriptor;
import org.eclipse.epf.uma.TeamProfile;
import org.eclipse.epf.uma.VariabilityElement;
import org.eclipse.epf.uma.WorkProduct;
import org.eclipse.epf.uma.WorkProductDescriptor;

public class SynchronizeCommand
extends CompoundCommand
implements IResourceAwareCommand {
    private Collection elements;
    private IConfigurator configurator;
    protected boolean aborted;
    private ArrayList deleteList;
    protected boolean preExecSuccessful;
    protected List deleteCommandList;
    protected boolean successful;
    private MethodConfiguration config;
    private Set synchFeatures;
    private DeleteUnusedDescriptorsCommand deleteUnusedDescriptorsCommand;
    private Collection activities;
    private boolean showSuccessfulMsg = true;
    private boolean intialized;
    private BatchCommand batchCommand = new BatchCommand(false);
    private Map<VariabilityElement, VariabilityElement> replacerToBaseMap = new HashMap<VariabilityElement, VariabilityElement>();

    public SynchronizeCommand(String label, Collection elements) {
        super(label);
        this.elements = elements;
    }

    public SynchronizeCommand(Collection elements, MethodConfiguration config, Set synchFeatures, boolean showSuccessfulMsg) {
        super(LibraryEditResources.AutoSynchronizeCommand_label);
        this.elements = elements;
        this.config = config;
        this.synchFeatures = synchFeatures;
        this.showSuccessfulMsg = showSuccessfulMsg;
    }

    public void setMethodConfiguration(MethodConfiguration config) {
        this.config = config;
        if (this.configurator != null) {
            this.configurator.setMethodConfiguration(config);
        }
    }

    public void setSynchronizationFeatures(Set synchFeatures) {
        this.synchFeatures = synchFeatures;
    }

    private boolean doInitialize() {
        this.commandList.clear();
        if (this.elements == null || this.elements.isEmpty()) {
            return false;
        }
        this.deleteCommandList = new ArrayList();
        this.deleteList = new ArrayList();
        this.activities = new ArrayList();
        for (Object element : this.elements) {
            this.addToDeleteList(element, this.deleteList);
            if (!(element instanceof Activity)) continue;
            this.activities.add(element);
        }
        this.elements.removeAll(this.deleteList);
        for (Object object : this.elements) {
            if (object instanceof Descriptor) {
                if (this.deleteList.contains(object)) continue;
                Descriptor descriptor = (Descriptor)object;
                if (descriptor.getIsSynchronizedWithSource().booleanValue()) {
                    WorkProduct wp;
                    if (descriptor.getSuperActivities() == null) {
                        if (descriptor instanceof WorkProductDescriptor && ((WorkProductDescriptor)descriptor).getWorkProduct() instanceof Deliverable) {
                            this.append(new SynchronizeDeliverableDescriptorCommand((WorkProductDescriptor)descriptor, this.synchFeatures, this.config));
                            continue;
                        }
                        this.append(new BasicSynchronizeDescriptorCommand(descriptor, this.synchFeatures, this.config));
                        continue;
                    }
                    Activity act = descriptor.getSuperActivities();
                    if (object instanceof TaskDescriptor) {
                        Task task = ((TaskDescriptor)object).getTask();
                        if (task == null) continue;
                        if (this.replacerToBaseMap.containsKey(task)) {
                            task = (Task)this.replacerToBaseMap.get(task);
                        }
                        this.append(new WBSDropCommand(act, Collections.singletonList(task), Collections.singletonList((TaskDescriptor)object), this.config, this.synchFeatures));
                        continue;
                    }
                    if (object instanceof RoleDescriptor) {
                        Role role = ((RoleDescriptor)object).getRole();
                        if (role == null) continue;
                        if (this.replacerToBaseMap.containsKey(role)) {
                            role = (Role)this.replacerToBaseMap.get(role);
                        }
                        this.append(new OBSDropCommand(act, Collections.singletonList(role), this.config, this.synchFeatures, this.configurator));
                        continue;
                    }
                    if (!(object instanceof WorkProductDescriptor) || (wp = ((WorkProductDescriptor)object).getWorkProduct()) == null) continue;
                    if (this.replacerToBaseMap.containsKey(wp)) {
                        wp = (WorkProduct)this.replacerToBaseMap.get(wp);
                    }
                    this.append(new PBSDropCommand(act, Collections.singletonList(wp), this.config, this.synchFeatures, this.configurator));
                    continue;
                }
                this.appendRemoveDuplicateGuidanceRefCommand(descriptor);
                continue;
            }
            if (object instanceof Activity) {
                this.appendCommands((Activity)object);
                continue;
            }
            if (!(object instanceof TeamProfile)) continue;
            this.appendCommands((TeamProfile)object);
        }
        return !this.deleteList.isEmpty() || !this.commandList.isEmpty() || !this.activities.isEmpty();
    }

    public boolean initilize() {
        boolean b = this.isPrepared;
        try {
            this.isPrepared = false;
            boolean bl = this.intialized = this.doInitialize();
            return bl;
        }
        finally {
            this.isPrepared = b;
        }
    }

    public boolean isIntialized() {
        return this.intialized;
    }

    private void appendCommands(Activity activity) {
        ArrayList<Task> tasks = new ArrayList<Task>();
        ArrayList<TaskDescriptor> tds = new ArrayList<TaskDescriptor>();
        ArrayList<Role> roles = new ArrayList<Role>();
        ArrayList<WorkProduct> workProducts = new ArrayList<WorkProduct>();
        ArrayList<Activity> activities = new ArrayList<Activity>();
        for (Object element : activity.getBreakdownElements()) {
            if (element instanceof Descriptor) {
                if (this.deleteList.contains(element)) continue;
                Descriptor descriptor = (Descriptor)element;
                if (descriptor.getIsSynchronizedWithSource().booleanValue()) {
                    WorkProduct wp;
                    if (element instanceof TaskDescriptor) {
                        Task task = ((TaskDescriptor)element).getTask();
                        if (task == null) continue;
                        if (this.replacerToBaseMap.containsKey(task)) {
                            task = (Task)this.replacerToBaseMap.get(task);
                        }
                        tasks.add(task);
                        tds.add((TaskDescriptor)element);
                        continue;
                    }
                    if (element instanceof RoleDescriptor) {
                        Role role = ((RoleDescriptor)element).getRole();
                        if (role == null) continue;
                        if (this.replacerToBaseMap.containsKey(role)) {
                            role = (Role)this.replacerToBaseMap.get(role);
                        }
                        roles.add(role);
                        continue;
                    }
                    if (!(element instanceof WorkProductDescriptor) || (wp = ((WorkProductDescriptor)element).getWorkProduct()) == null) continue;
                    if (this.replacerToBaseMap.containsKey(wp)) {
                        wp = (WorkProduct)this.replacerToBaseMap.get(wp);
                    }
                    workProducts.add(wp);
                    continue;
                }
                this.appendRemoveDuplicateGuidanceRefCommand(descriptor);
                continue;
            }
            if (element instanceof Activity) {
                activities.add((Activity)element);
                continue;
            }
            if (!(element instanceof TeamProfile)) continue;
            this.appendCommands((TeamProfile)element);
        }
        if (!tasks.isEmpty()) {
            this.append(new WBSDropCommand(activity, tasks, tds, this.config, this.synchFeatures));
        }
        if (!roles.isEmpty()) {
            this.append(new OBSDropCommand(activity, roles, this.config, this.synchFeatures, this.configurator));
        }
        if (!workProducts.isEmpty()) {
            this.append(new PBSDropCommand(activity, workProducts, this.config, this.synchFeatures, this.configurator));
        }
        Iterator iter = activities.iterator();
        while (iter.hasNext()) {
            this.appendCommands((Activity)iter.next());
        }
    }

    private void appendRemoveDuplicateGuidanceRefCommand(Descriptor descriptor) {
        this.append(new RemoveDuplicateReferenceCommand(descriptor, ProcessCommandUtil.CONTENT_ELEMENT_GUIDANCE_REFERENCES, this.config));
    }

    private void appendCommands(TeamProfile team) {
        AbstractTreeIterator iter = new AbstractTreeIterator(team, false){
            private static final long serialVersionUID = 1L;

            protected Iterator getChildren(Object object) {
                if (object instanceof TeamProfile) {
                    TeamProfile team = (TeamProfile)object;
                    ArrayList children = new ArrayList(team.getSubTeam());
                    children.addAll(team.getTeamRoles());
                    return children.iterator();
                }
                return Collections.EMPTY_LIST.iterator();
            }
        };
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (!(obj instanceof RoleDescriptor) || ((RoleDescriptor)obj).getSuperActivities() != null) continue;
            this.append(new BasicSynchronizeDescriptorCommand((Descriptor)obj, this.synchFeatures, this.config));
        }
    }

    public Collection getModifiedResources() {
        HashSet<? extends Resource> modifiedResources = new HashSet<Resource>();
        for (Object cmd : this.commandList) {
            if (!(cmd instanceof IResourceAwareCommand)) continue;
            modifiedResources.addAll(((IResourceAwareCommand)cmd).getModifiedResources());
        }
        return modifiedResources;
    }

    public void execute() {
        Command cmd;
        if (!this.deleteList.isEmpty() && (cmd = this.delete(this.deleteList)) != null) {
            this.deleteCommandList.add(cmd);
        }
        this.batchCommand.execute();
        if (!this.aborted) {
            Runnable runnable = new Runnable(){

                public void run() {
                    SynchronizeCommand.this.preExecSuccessful = SynchronizeCommand.this.preExecute();
                    if (SynchronizeCommand.this.preExecute()) {
                        SynchronizeCommand.this.superRedo();
                        SynchronizeCommand.this.successful = true;
                    }
                }
            };
            UserInteractionHelper.runInUI(runnable, this.getLabel());
            if (this.successful) {
                if (!this.activities.isEmpty()) {
                    if (this.deleteUnusedDescriptorsCommand == null) {
                        this.deleteUnusedDescriptorsCommand = new DeleteUnusedDescriptorsCommand(this.elements, true, this.deleteList){

                            protected Command delete(List elements) {
                                return SynchronizeCommand.this.delete(elements);
                            }
                        };
                        this.deleteCommandList.add(this.deleteUnusedDescriptorsCommand);
                    }
                    this.deleteUnusedDescriptorsCommand.execute();
                }
                if (this.showSuccessfulMsg) {
                    if (!this.replacerToBaseMap.isEmpty()) {
                        this.refreshViewer();
                    }
                    Messenger.INSTANCE.showInfo(LibraryEditResources.SynchronizeCompleteDialog_Title, LibraryEditResources.AutoSynchronizeCommand_sucessful);
                }
            }
        }
    }

    private void refreshViewer() {
        if (this.elements.isEmpty()) {
            return;
        }
        Process proc = TngUtil.getOwningProcess(this.elements.iterator().next());
        if (proc != null) {
            int i = 0;
            while (i < TngAdapterFactory.processAdapterFactories.length) {
                AdapterFactory adapterFactory = TngAdapterFactory.processAdapterFactories[i];
                ProcessUtil.refreshViewer(adapterFactory, proc);
                ++i;
            }
        }
    }

    private void superRedo() {
        super.redo();
    }

    public void redo() {
        this.execute();
    }

    public boolean isSucessful() {
        return this.successful;
    }

    protected boolean preExecute() {
        ListIterator commands = this.commandList.listIterator();
        while (commands.hasNext()) {
            Object command = commands.next();
            if (command instanceof BSDropCommand && !((BSDropCommand)command).preExecute()) {
                return false;
            }
            Thread.yield();
        }
        return true;
    }

    protected Command delete(List elements) {
        AdapterFactoryEditingDomain domain = new AdapterFactoryEditingDomain((AdapterFactory)TngAdapterFactory.INSTANCE.getProcessComposedAdapterFactory(), (CommandStack)new BasicCommandStack());
        ProcessElementDeleteCommand cmd = new ProcessElementDeleteCommand(RemoveCommand.create((EditingDomain)domain, (Collection)elements), elements);
        cmd.execute();
        return cmd;
    }

    private IConfigurator getConfigurator() {
        if (this.configurator == null) {
            MethodConfiguration config = this.config;
            if (config == null) {
                Process proc = TngUtil.getOwningProcess((BreakdownElement)this.elements.iterator().next());
                config = proc.getDefaultContext();
            }
            this.configurator = Providers.getConfiguratorFactory().createConfigurator(config);
        }
        return this.configurator;
    }

    private void addToDeleteList(Object element, List deleteList) {
        if (element instanceof Descriptor) {
            if (!this.getConfigurator().accept(element)) {
                MethodElement linkedElement = ProcessUtil.getAssociatedElement((Descriptor)element);
                if (linkedElement instanceof VariabilityElement && TngUtil.isReplacer((VariabilityElement)linkedElement)) {
                    VariabilityElement base = ((VariabilityElement)linkedElement).getVariabilityBasedOnElement();
                    while (base != null && TngUtil.isContributorOrReplacer(base)) {
                        base = base.getVariabilityBasedOnElement();
                    }
                    if (base != null) {
                        if (!this.getConfigurator().accept(base)) {
                            deleteList.add(element);
                        } else {
                            this.batchCommand.addFeatureValue((EObject)element, (EStructuralFeature)ProcessUtil.getLinkReference((Descriptor)element), base);
                            this.replacerToBaseMap.put((VariabilityElement)linkedElement, base);
                        }
                    }
                } else {
                    deleteList.add(element);
                }
            }
        } else if (element instanceof Activity) {
            Iterator iter = ((Activity)element).getBreakdownElements().iterator();
            while (iter.hasNext()) {
                this.addToDeleteList(iter.next(), deleteList);
            }
        }
    }

    private void superUndo() {
        super.undo();
    }

    public void undo() {
        UserInteractionHelper.getUIHelper().runWithBusyIndicator(new Runnable(){

            public void run() {
                if (!SynchronizeCommand.this.deleteCommandList.isEmpty()) {
                    ListIterator commands = SynchronizeCommand.this.deleteCommandList.listIterator(SynchronizeCommand.this.deleteCommandList.size());
                    while (commands.hasPrevious()) {
                        try {
                            Command command = (Command)commands.previous();
                            command.undo();
                            continue;
                        }
                        catch (RuntimeException exception) {
                            commands.next();
                            try {
                                while (commands.hasNext()) {
                                    Command command = (Command)commands.next();
                                    command.redo();
                                }
                            }
                            catch (RuntimeException nestedException) {
                                CommonPlugin.INSTANCE.log((Object)new WrappedException(CommonPlugin.INSTANCE.getString("_UI_IgnoreException_exception"), (Exception)nestedException).fillInStackTrace());
                            }
                        }
                        throw exception;
                    }
                }
                SynchronizeCommand.this.superUndo();
                SynchronizeCommand.this.batchCommand.undo();
            }
        });
    }

    protected boolean prepare() {
        return true;
    }

    public void dispose() {
        if (this.activities != null) {
            this.activities.clear();
        }
        if (this.deleteCommandList != null) {
            for (Command cmd : this.deleteCommandList) {
                cmd.dispose();
            }
        }
        if (this.deleteList != null) {
            this.deleteList.clear();
        }
        super.dispose();
    }
}

