/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.process.consolidated;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.emf.edit.provider.WrapperItemProvider;
import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.library.edit.meta.TypeDefUtil;
import org.eclipse.epf.library.edit.process.BreakdownElementWrapperItemProvider;
import org.eclipse.epf.library.edit.process.IBSItemProvider;
import org.eclipse.epf.library.edit.process.IBreakdownElementWrapperItemProviderFactory;
import org.eclipse.epf.library.edit.process.consolidated.ActivityItemProvider;
import org.eclipse.epf.library.edit.process.consolidated.TaskDescriptorItemProvider;
import org.eclipse.epf.library.edit.util.Comparators;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.library.edit.util.PropUtil;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.Process;
import org.eclipse.epf.uma.Role;
import org.eclipse.epf.uma.RoleDescriptor;
import org.eclipse.epf.uma.UmaFactory;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.util.AssociationHelper;
import org.eclipse.epf.uma.util.ExtendedReference;
import org.eclipse.epf.uma.util.ModifiedTypeMeta;

public class RoleDescriptorItemProvider
extends org.eclipse.epf.library.edit.process.RoleDescriptorItemProvider {
    public RoleDescriptorItemProvider(AdapterFactory adapterFactory, ItemProviderAdapter delegateItemProvider) {
        super(adapterFactory, delegateItemProvider);
    }

    protected void collectNewChildDescriptors(Collection newChildDescriptors, Object object) {
        newChildDescriptors.add(new CommandParameter((Object)this.target, (Object)UmaPackage.eINSTANCE.getRoleDescriptor_ResponsibleFor(), (Object)UmaFactory.eINSTANCE.createWorkProductDescriptor()));
    }

    public Collection getChildrenFeatures(Object object) {
        if (this.childrenFeatures == null) {
            this.childrenFeatures = new ArrayList();
            this.childrenFeatures.add(UmaPackage.eINSTANCE.getRoleDescriptor_ResponsibleFor());
        }
        return this.childrenFeatures;
    }

    protected boolean isWrappingNeeded(Object object) {
        return true;
    }

    public String getCreateChildText(Object owner, Object feature, Object child, Collection selection) {
        return this.getFeatureText(feature);
    }

    public Object getCreateChildImage(Object owner, Object feature, Object child, Collection selection) {
        Object img = TngUtil.getImage(child);
        return img != null ? img : super.getCreateChildImage(owner, feature, child, selection);
    }

    protected Object createWrapper(EObject object, EStructuralFeature feature, Object value, int index) {
        BreakdownElementWrapperItemProvider wrapper = (BreakdownElementWrapperItemProvider)IBreakdownElementWrapperItemProviderFactory.INSTANCE.createWrapper(value, object, feature, index, this.adapterFactory);
        wrapper.setReadOnly(false);
        return wrapper;
    }

    public void notifyChanged(Notification notification) {
        this.updateChildren(notification);
        switch (notification.getFeatureID(RoleDescriptor.class)) {
            case 36: {
                this.refreshChildren(notification);
                return;
            }
        }
        super.notifyChanged(notification);
    }

    private void refreshChildren(Notification notification) {
        if (ProcessUtil.isRefreshRequired(notification, null)) {
            Process topAct = (Process)this.getTopItem();
            AdapterFactory rootAdapterFactory = this.getRootAdapterFactory();
            ProcessUtil.refreshViewer(rootAdapterFactory, topAct);
        }
        TaskDescriptorItemProvider.refreshChildren((ItemProviderAdapter)this, notification);
    }

    private void updateCachedChildren(Collection children) {
    }

    public Collection getChildren(Object obj) {
        ArrayList<Object> newChildren;
        RoleDescriptor roleDesc = (RoleDescriptor)obj;
        if (!(AssociationHelper.getPrimaryTaskDescriptors((RoleDescriptor)roleDesc).isEmpty() && AssociationHelper.getAdditionalTaskDescriptors((RoleDescriptor)roleDesc).isEmpty() && AssociationHelper.getAssistedTaskDescriptors((RoleDescriptor)roleDesc).isEmpty())) {
            newChildren = Collections.EMPTY_LIST;
        } else {
            ModifiedTypeMeta meta;
            Collection children = super.getChildren(obj);
            newChildren = new ArrayList<Object>();
            IFilter filter = this.getFilter(obj);
            for (Object o : children) {
                if (!(o instanceof WrapperItemProvider)) continue;
                Object child = ((WrapperItemProvider)o).getValue();
                if (filter == null || !filter.accept(child)) continue;
                newChildren.add(o);
            }
            Role role = roleDesc.getRole();
            if (role != null && (meta = TypeDefUtil.getMdtMeta((MethodElement)role)) != null) {
                for (ExtendedReference eRef : meta.getReferences()) {
                    if (!"workproducts".equals(eRef.getContributeTo())) continue;
                    List<MethodElement> list = PropUtil.getPropUtil().getExtendedReferenceList((MethodElement)roleDesc, eRef, false);
                    int ix = 0;
                    for (MethodElement item : list) {
                        Object wrapped = this.wrap((EObject)roleDesc, (EStructuralFeature)eRef.getReference(), item, ix++);
                        newChildren.add(wrapped);
                    }
                }
            }
        }
        Collections.sort(newChildren, Comparators.PRESENTATION_NAME_COMPARATOR);
        this.updateCachedChildren(newChildren);
        return newChildren;
    }

    private IFilter getFilter(Object obj) {
        IFilter filter = null;
        Object parent = this.getParent(obj);
        IBSItemProvider adapter = (IBSItemProvider)this.getRootAdapterFactory().adapt(parent, ITreeItemContentProvider.class);
        if (adapter instanceof ActivityItemProvider) {
            filter = ((ActivityItemProvider)adapter).getFilter();
        }
        return filter;
    }
}

