/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.uma;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.epf.library.edit.meta.ReferenceTable;
import org.eclipse.epf.library.edit.meta.TypeDefUtil;
import org.eclipse.epf.library.edit.meta.internal.ExtendedReferenceImpl;
import org.eclipse.epf.library.edit.util.LibraryEditUtil;
import org.eclipse.epf.library.edit.util.MethodElementPropUtil;
import org.eclipse.epf.library.edit.util.PracticePropUtil;
import org.eclipse.epf.library.edit.util.PropUtil;
import org.eclipse.epf.library.edit.util.XmlEditUtil;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.Practice;
import org.eclipse.epf.uma.UmaFactory;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.util.ExtendedReference;
import org.eclipse.epf.uma.util.ExtendedTable;
import org.eclipse.epf.uma.util.MeList;
import org.eclipse.epf.uma.util.ModifiedTypeMeta;
import org.eclipse.epf.uma.util.QualifiedReference;
import org.eclipse.epf.uma.util.UmaUtil;
import org.eclipse.epf.uma.util.UserDefinedTypeMeta;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtendReferenceMap {
    private static final String Opposite_ = "opposite_";
    public static final String QReference_ = "qReference_";
    public static final String WSpace = "__ws__";
    private Map<String, Object> map;
    private Map<String, Object> oldValueMap;
    private MethodElement ownerElement;
    private List<ExtendedReference> extendedReferences;
    private boolean retrieved = false;
    private static ExtendedReference eUdtList = ExtendReferenceMap.createLocalExtendedReference(UmaUtil.MethodElement_UdtList);
    public static String UdtList = UmaUtil.MethodElement_UdtList.getName();
    private Map<ExtendedTable, ReferenceTable> tableMap;

    public ExtendReferenceMap(MethodElement ownerElement) {
        List<ExtendedReference> refs;
        this.ownerElement = ownerElement;
        this.extendedReferences = new ArrayList<ExtendedReference>();
        this.extendedReferences.add(eUdtList);
        Set<EReference> qualifiedReferences = this.getQualifiedReferences(ownerElement);
        if (qualifiedReferences != null && !qualifiedReferences.isEmpty()) {
            for (EReference qref : qualifiedReferences) {
                this.extendedReferences.add(ExtendReferenceMap.createLocalExtendedReference(qref));
            }
        }
        if ((refs = this.getAllMdtReferences()) != null) {
            this.extendedReferences.addAll(refs);
        }
    }

    private static ExtendedReference createLocalExtendedReference(EReference ref) {
        ExtendedReferenceImpl eRef = new ExtendedReferenceImpl(null);
        eRef.setId(ref.getName());
        TypeDefUtil.getInstance().associate(eRef, ref);
        return eRef;
    }

    public boolean isRetrieved() {
        return this.retrieved;
    }

    private Set<EReference> getQualifiedReferences(MethodElement element) {
        if (!(element instanceof Practice)) {
            return null;
        }
        PracticePropUtil propUtil = PracticePropUtil.getPracticePropUtil();
        UserDefinedTypeMeta meta = propUtil.getUdtMeta((Practice)element);
        return meta == null ? null : meta.getQualifiedReferences();
    }

    private List<ExtendedReference> getAllMdtReferences() {
        PropUtil propUtil = PropUtil.getPropUtil();
        ModifiedTypeMeta meta = propUtil.getGlobalMdtMeta(this.getOwnerElement());
        if (meta == null) {
            return null;
        }
        if (!meta.getTables().isEmpty()) {
            this.tableMap = new HashMap<ExtendedTable, ReferenceTable>();
            for (ExtendedTable tableMeta : meta.getTables()) {
                ReferenceTable table = propUtil.retrieveExtendedTable(this.getOwnerElement(), tableMeta);
                if (table == null) continue;
                this.tableMap.put(tableMeta, table);
            }
        }
        ArrayList<ExtendedReference> references = new ArrayList<ExtendedReference>();
        for (ExtendedReference extendRef : meta.getReferences()) {
            references.add(extendRef);
            for (QualifiedReference qref : extendRef.getQualifiedReferences()) {
                references.add((ExtendedReference)qref);
            }
        }
        return references;
    }

    public ReferenceTable getReferenceTable(ExtendedTable meta) {
        return this.tableMap == null ? null : this.tableMap.get(meta);
    }

    public MethodElement getOwnerElement() {
        return this.ownerElement;
    }

    public void notifyOwnerElementSaved() {
        this.getOldValueMap().clear();
    }

    public void retrieveReferencesFromElement(Element element) {
        Practice practice;
        PracticePropUtil propUtil;
        this.retrieved = true;
        HashSet<MethodElement> referenceSet = null;
        if (this.ownerElement instanceof Practice && (propUtil = PracticePropUtil.getPracticePropUtil()).isUdtType((MethodElement)(practice = (Practice)this.ownerElement))) {
            referenceSet = new HashSet<MethodElement>();
            referenceSet.addAll(practice.getActivityReferences());
            referenceSet.addAll(practice.getContentReferences());
        }
        HashMap<String, Set<MethodElement>> mdtQrValidSetMap = new HashMap<String, Set<MethodElement>>();
        for (ExtendedReference eRef : this.extendedReferences) {
            String name = eRef.getGlobalId();
            String value = element.getAttribute(name);
            if (value == null || value.length() == 0) continue;
            UnresolvedGuidHandler uHandler = new UnresolvedGuidHandler();
            Set<MethodElement> validSet = null;
            if (eRef.getParent() instanceof ExtendedReference) {
                validSet = this.getMdtQrValidSet(element, mdtQrValidSetMap, uHandler, eRef.getParent().getGlobalId());
            } else if (referenceSet != null && name.startsWith(QReference_)) {
                validSet = referenceSet;
            }
            MeList items = XmlEditUtil.convertToMethodElements(value, this.getRetrieveType(name), uHandler, validSet);
            if (items == null || items.isEmpty()) continue;
            this.getMap().put(name, items);
        }
    }

    private Set<MethodElement> getMdtQrValidSet(Element element, Map<String, Set<MethodElement>> mdtQrValidSetMap, UnresolvedGuidHandler uHandler, String parentRefName) {
        Set<MethodElement> validSet = mdtQrValidSetMap.get(parentRefName);
        if (validSet == null) {
            validSet = new HashSet<MethodElement>();
            String parentRefValue = element.getAttribute(parentRefName);
            MeList items = XmlEditUtil.convertToMethodElements(parentRefValue, this.getRetrieveType(parentRefName), uHandler, null);
            validSet.addAll((Collection<MethodElement>)items);
            mdtQrValidSetMap.put(parentRefName, validSet);
        }
        return validSet;
    }

    private EClass getRetrieveType(String referenceName) {
        if (referenceName.equals(UdtList)) {
            return UmaPackage.eINSTANCE.getPractice();
        }
        return null;
    }

    public Object get(String name, boolean toModify) {
        if (!toModify && this.map == null) {
            return null;
        }
        Object value = this.getMap().get(name);
        if (!this.isMany(name)) {
            return value;
        }
        if (value == null && toModify) {
            value = new MeList();
            this.getMap().put(name, value);
        }
        if (!(value instanceof MeList)) {
            return value;
        }
        MeList meList = (MeList)value;
        if (!meList.isOFeatureHandled()) {
            for (Object obj : meList) {
                if (!(obj instanceof MethodElement)) continue;
                MethodElement element = (MethodElement)obj;
                this.addOpposite(name, element);
            }
            meList.setOFeatureHandled(true);
        }
        if (meList.isHasUnresolved()) {
            boolean allResoved = true;
            int i = 0;
            while (i < meList.size()) {
                MethodElement element;
                Object obj = meList.get(i);
                if (obj instanceof MethodElement && UmaUtil.isUnresolved((MethodElement)(element = (MethodElement)obj))) {
                    MethodElement resolveElement = LibraryEditUtil.getInstance().getMethodElement(element.getGuid());
                    if (resolveElement == null) {
                        allResoved = false;
                    } else {
                        meList.set(i, (Object)resolveElement);
                        this.addOpposite(name, resolveElement);
                    }
                }
                ++i;
            }
            if (allResoved) {
                meList.setHasUnresolved(false);
            }
        }
        if (toModify && !this.getOldValueMap().containsKey(name)) {
            Object oldValue = meList.clone();
            this.getOldValueMap().put(name, oldValue);
        }
        return meList;
    }

    public void addOpposite(String name, MethodElement element) {
        if (UmaUtil.isUnresolved((MethodElement)element)) {
            return;
        }
        MethodElementPropUtil propUtil = MethodElementPropUtil.getMethodElementPropUtil();
        ExtendReferenceMap otherMap = propUtil.getExtendReferenceMap(element, true);
        Object ovalue = otherMap.get(ExtendReferenceMap.getOppositeName(name), true);
        if (ovalue instanceof MeList) {
            ((MeList)ovalue).add((Object)this.getOwnerElement());
        }
    }

    public void removeOpposite(String name, MethodElement element) {
        if (UmaUtil.isUnresolved((MethodElement)element)) {
            return;
        }
        MethodElementPropUtil propUtil = MethodElementPropUtil.getMethodElementPropUtil();
        ExtendReferenceMap otherMap = propUtil.getExtendReferenceMap(element, true);
        Object ovalue = otherMap.get(ExtendReferenceMap.getOppositeName(name), true);
        if (ovalue instanceof MeList) {
            ((MeList)ovalue).remove((Object)this.getOwnerElement());
        }
    }

    public void addOpposite(ExtendedReference reference, MethodElement element) {
        this.addOpposite(reference.getGlobalId(), element);
    }

    public void removeOpposite(ExtendedReference reference, MethodElement element) {
        this.removeOpposite(reference.getGlobalId(), element);
    }

    public void set(String name, Object value) {
        Object oldValue = this.get(name, false);
        if (oldValue instanceof MeList) {
            oldValue = ((MeList)oldValue).clone();
        }
        this.getOldValueMap().put(name, oldValue);
        this.getMap().put(name, value);
    }

    private Map<String, Object> getMap() {
        if (this.map == null) {
            this.map = new HashMap<String, Object>();
        }
        return this.map;
    }

    private Map<String, Object> getOldValueMap() {
        if (this.oldValueMap == null) {
            this.oldValueMap = new HashMap<String, Object>();
        }
        return this.oldValueMap;
    }

    public void storeReferencesToElement(Element element, boolean rollback) {
        for (ExtendedReference eRef : this.extendedReferences) {
            String name = eRef.getGlobalId();
            Object value = this.get(name, false);
            if (rollback && this.getOldValueMap().containsKey(name)) {
                value = this.getOldValueMap().get(name);
                if (value == null) {
                    this.getMap().remove(name);
                } else {
                    this.getMap().put(name, value);
                }
            }
            if (value instanceof MethodElement) {
                MethodElement eValue = (MethodElement)value;
                element.setAttribute(name, eValue.getGuid());
                continue;
            }
            if (!(value instanceof List)) continue;
            String str = "";
            for (Object item : (List)value) {
                if (!(item instanceof MethodElement)) continue;
                MethodElement eValue = (MethodElement)item;
                if (str.length() > 0) {
                    str = String.valueOf(str) + "/";
                }
                str = String.valueOf(str) + eValue.getGuid();
            }
            element.setAttribute(name, str);
        }
        if (rollback) {
            this.getOldValueMap().clear();
        }
    }

    public static String getOppositeName(String name) {
        return Opposite_ + name;
    }

    public boolean isMany(String name) {
        return true;
    }

    public Set<MethodElement> getExtendedReferencingSet(MethodElement element) {
        HashSet<MethodElement> set = new HashSet<MethodElement>();
        for (Map.Entry<String, Object> entry : this.getMap().entrySet()) {
            String name = entry.getKey();
            Object value = entry.getValue();
            if (!name.startsWith(Opposite_) || !(value instanceof List)) continue;
            set.addAll((List)value);
        }
        return set;
    }

    private static class UnresolvedGuidHandler
    extends XmlEditUtil.UnresolvedGuidHandler {
        private UnresolvedGuidHandler() {
        }

        public MethodElement getElement(String guid) {
            Practice practic = UmaFactory.eINSTANCE.createPractice();
            practic.setGuid(guid);
            UmaUtil.setUnresolved((MethodElement)practic);
            return practic;
        }

        public boolean hasUnresolvedElement() {
            return false;
        }
    }
}

