/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.command.CopyCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.AdapterFactoryTreeIterator;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.epf.library.edit.IConfigurator;
import org.eclipse.epf.library.edit.LibraryEditPlugin;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.process.IBSItemProvider;
import org.eclipse.epf.library.edit.process.command.ActivityDeepCopyCommand;
import org.eclipse.epf.library.edit.process.command.CopyHelper;
import org.eclipse.epf.library.edit.util.ConstraintManager;
import org.eclipse.epf.library.edit.util.DescriptorPropUtil;
import org.eclipse.epf.library.edit.util.PredecessorList;
import org.eclipse.epf.library.edit.util.ProcessScopeUtil;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.Constraint;
import org.eclipse.epf.uma.Descriptor;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.Milestone;
import org.eclipse.epf.uma.Process;
import org.eclipse.epf.uma.ProcessComponent;
import org.eclipse.epf.uma.ProcessPackage;
import org.eclipse.epf.uma.TaskDescriptor;
import org.eclipse.epf.uma.UmaFactory;
import org.eclipse.epf.uma.VariabilityType;
import org.eclipse.epf.uma.WorkBreakdownElement;
import org.eclipse.epf.uma.edit.domain.TraceableAdapterFactoryEditingDomain;
import org.eclipse.epf.uma.util.Scope;
import org.eclipse.epf.uma.util.UmaUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActivityHandler {
    private ArrayList<ProcessPackage> procPackages;
    private ArrayList<Object> activitiesToDeepCopy;
    private MethodConfiguration deepCopyConfig;
    private List deepCopies;
    private Map deepCopyToOriginalMap;
    private ArrayList<Activity> activities = new ArrayList();
    private Map copyToOriginal;
    private AdapterFactoryEditingDomain editingDomain;
    private CopyCommand.Helper copyHelper;
    private CopyHelper deepCopyHelper;
    private Process targetProcess;
    private IProgressMonitor monitor;
    private IConfigurator activityDeepCopyConfigurator;
    private boolean copyExternalVariations = true;

    public ActivityHandler() {
        this.activitiesToDeepCopy = new ArrayList();
        this.deepCopies = new ArrayList();
        this.deepCopyToOriginalMap = new HashMap();
        this.copyToOriginal = new HashMap();
        this.procPackages = new ArrayList();
        this.copyHelper = new CopyCommand.Helper();
    }

    public Map<Object, Object> cloneOrignaltoCopyMap() {
        Map oMap = null;
        if (this.deepCopyToOriginalMap != null && !this.deepCopyToOriginalMap.isEmpty()) {
            oMap = this.getDeepCopyHelper().getObjectToCopyMap();
        } else if (this.editingDomain instanceof TraceableAdapterFactoryEditingDomain) {
            TraceableAdapterFactoryEditingDomain td = (TraceableAdapterFactoryEditingDomain)this.editingDomain;
            oMap = ActivityHandler.copy(td.getOriginalToClipboardMap());
        }
        return oMap;
    }

    public static Map copy(Map map) {
        if (map == null) {
            return null;
        }
        HashMap ret = new HashMap();
        for (Map.Entry entry : map.entrySet()) {
            Object key = entry.getKey();
            Object val = entry.getValue();
            ret.put(key, val);
        }
        return ret;
    }

    public void dispose() {
        this.activities.clear();
        this.activitiesToDeepCopy.clear();
        this.copyToOriginal.clear();
        this.procPackages.clear();
        this.copyHelper.clear();
        this.deepCopies.clear();
        if (this.deepCopyHelper != null) {
            this.deepCopyHelper.clear();
        }
        this.deepCopyToOriginalMap.clear();
    }

    public void setCopyExternalVariations(boolean copyExternalVariations) {
        this.copyExternalVariations = copyExternalVariations;
    }

    public void copy(Activity activity) {
        this.procPackages.add((ProcessPackage)activity.eContainer());
    }

    public MethodConfiguration getDeepCopyConfig() {
        return this.deepCopyConfig;
    }

    public void setDeepCopyConfig(MethodConfiguration deepCopyConfig) {
        this.deepCopyConfig = deepCopyConfig;
    }

    public Process getTargetProcess() {
        return this.targetProcess;
    }

    public void setTargetProcess(Process proc) {
        this.targetProcess = proc;
    }

    public void setMonitor(IProgressMonitor monitor) {
        this.monitor = monitor;
    }

    public List getDeepCopies() {
        return this.deepCopies;
    }

    public void deepCopy(Object activityOrWrapper) {
        Object unwrapped = TngUtil.unwrap(activityOrWrapper);
        if (unwrapped instanceof Activity && ((Activity)unwrapped).eContainer() != null) {
            this.activitiesToDeepCopy.add(activityOrWrapper);
        }
    }

    public void extend(Activity act) {
        Activity extendedAct = ProcessUtil.generalize(act, VariabilityType.EXTENDS);
        this.activities.add(extendedAct);
    }

    public List<Activity> getActivities() {
        if (!this.procPackages.isEmpty() || !this.activitiesToDeepCopy.isEmpty()) {
            this.editingDomain = new TraceableAdapterFactoryEditingDomain((AdapterFactory)TngAdapterFactory.INSTANCE.getWBS_ComposedAdapterFactory(), (CommandStack)new BasicCommandStack());
            if (!this.procPackages.isEmpty()) {
                this.activities.addAll(this.copy(this.procPackages));
                ActivityHandler.fixGuidReferences((Map<? extends Object, ? extends Object>)this.copyHelper, false, false, null);
            }
            if (!this.activitiesToDeepCopy.isEmpty()) {
                if (this.monitor == null) {
                    this.monitor = new NullProgressMonitor();
                }
                for (Object act : this.activitiesToDeepCopy) {
                    ActivityDeepCopyCommand cmd = new ActivityDeepCopyCommand(act, this.getDeepCopyHelper(), this.deepCopyConfig, this.targetProcess, this.monitor, this.activityDeepCopyConfigurator);
                    cmd.setCopyExternalVariations(this.copyExternalVariations);
                    try {
                        Collection<?> result;
                        long time = 0L;
                        if (TngUtil.DEBUG) {
                            time = System.currentTimeMillis();
                        }
                        cmd.execute();
                        if (TngUtil.DEBUG) {
                            System.out.println("ActivityDeepCopyCommand executed: " + (System.currentTimeMillis() - time) + " ms");
                            time = System.currentTimeMillis();
                        }
                        if (!(result = cmd.getResult()).isEmpty()) {
                            Activity deepCopy = (Activity)result.iterator().next();
                            ProcessUtil.fixBreakdonwElementOrderRecursively(deepCopy);
                            if (TngUtil.DEBUG) {
                                System.out.println("ProcessUtil.fixBreakdonwElementOrderRecursively(): " + (System.currentTimeMillis() - time) + " ms");
                                time = System.currentTimeMillis();
                            }
                            cmd.copySuppressionStates();
                            if (TngUtil.DEBUG) {
                                System.out.println("ActivityDeepCopyCommand.copySuppressionStates(): " + (System.currentTimeMillis() - time) + " ms");
                                time = System.currentTimeMillis();
                            }
                            cmd.fixReferences();
                            this.deepCopies.add(deepCopy);
                            this.deepCopyToOriginalMap.put(deepCopy, act);
                        }
                    }
                    finally {
                        cmd.dispose();
                    }
                    ActivityHandler.fixGuidReferences((Map<? extends Object, ? extends Object>)((Object)this.deepCopyHelper));
                }
                this.activities.addAll(this.deepCopies);
            }
        }
        return this.activities;
    }

    public static void fixGuidReferences(Map<? extends Object, ? extends Object> objectToCopyMap) {
        ActivityHandler.fixGuidReferences(objectToCopyMap, true, false, null);
    }

    public static void fixGuidReferences(Map<? extends Object, ? extends Object> objectToCopyMap, boolean deepCopy, boolean reverseMap, Set<Resource> resouresToSave) {
        try {
            ActivityHandler.fixGuidReferences_(objectToCopyMap, deepCopy, reverseMap, resouresToSave);
        }
        catch (Throwable e) {
            LibraryEditPlugin.getDefault().getLogger().logError(e);
        }
    }

    private static void fixGuidReferences_(Map<? extends Object, ? extends Object> objectToCopyMap, boolean deepCopy, boolean reverseMap, Set<Resource> resouresToSave) {
        HashSet<Object> cpySet = new HashSet<Object>();
        HashMap<String, String> srcGuidToCpyGuidMap = new HashMap<String, String>();
        for (Map.Entry<? extends Object, ? extends Object> entry : objectToCopyMap.entrySet()) {
            Object cpy;
            Object object = cpy = reverseMap ? entry.getKey() : entry.getValue();
            if (!(cpy instanceof Process)) continue;
            Process cpyProcess = (Process)cpy;
            Scope scope = ProcessScopeUtil.getInstance().getScope(cpyProcess);
            if (scope == null) continue;
            cpyProcess.setDefaultContext(null);
            cpyProcess.getValidContext().clear();
        }
        for (Map.Entry<? extends Object, ? extends Object> entry : objectToCopyMap.entrySet()) {
            Object cpy;
            Object src = reverseMap ? entry.getValue() : entry.getKey();
            Object object = cpy = reverseMap ? entry.getKey() : entry.getValue();
            if (src == cpy) continue;
            if (src instanceof Descriptor && cpy instanceof Descriptor) {
                Descriptor srcDes = (Descriptor)src;
                Descriptor cpyDes = (Descriptor)cpy;
                srcGuidToCpyGuidMap.put(srcDes.getGuid(), cpyDes.getGuid());
                if (!(cpy instanceof TaskDescriptor)) continue;
                cpySet.add(cpyDes);
                continue;
            }
            if (!(src instanceof Milestone) || !(cpy instanceof Milestone)) continue;
            cpySet.add((Milestone)cpy);
        }
        boolean isSynFree = ProcessUtil.isSynFree();
        DescriptorPropUtil propUtil = DescriptorPropUtil.getDesciptorPropUtil();
        for (Object cpy : cpySet) {
            ProcessComponent proc;
            if (cpy instanceof TaskDescriptor && isSynFree) {
                String newGreenParent;
                TaskDescriptor cpyDes = (TaskDescriptor)cpy;
                propUtil.replaceLocalUseGuidStrings((Descriptor)cpyDes, srcGuidToCpyGuidMap);
                String oldGreenParent = propUtil.getGreenParent((Descriptor)cpyDes);
                if (oldGreenParent != null && (newGreenParent = (String)srcGuidToCpyGuidMap.get(oldGreenParent)) != null && !newGreenParent.equals(oldGreenParent)) {
                    if (deepCopy) {
                        propUtil.setGreenParent((Descriptor)cpyDes, null);
                        Activity parentAct = cpyDes.getSuperActivities();
                        if (parentAct != null) {
                            for (BreakdownElement be : parentAct.getBreakdownElements()) {
                                if (!be.getGuid().equals(newGreenParent)) continue;
                                parentAct.getBreakdownElements().remove(be);
                                break;
                            }
                        }
                    } else {
                        propUtil.setGreenParent((Descriptor)cpyDes, newGreenParent);
                    }
                }
            }
            if (!(cpy instanceof TaskDescriptor) && !(cpy instanceof Milestone)) continue;
            WorkBreakdownElement wbe = (WorkBreakdownElement)cpy;
            for (Constraint c : ConstraintManager.getWpStates(wbe)) {
                String oldWpdGuid = c.getBody();
                String newWpdGuid = (String)srcGuidToCpyGuidMap.get(oldWpdGuid);
                if (newWpdGuid == null || newWpdGuid.equals(oldWpdGuid)) continue;
                c.setBody(newWpdGuid);
            }
            if (resouresToSave == null || (proc = UmaUtil.getProcessComponent((MethodElement)wbe.getSuperActivities())) == null || proc.eResource() == null) continue;
            resouresToSave.add(proc.eResource());
        }
    }

    private void updatePredecessors(List workBreakdownElements) {
        ArrayList<PredecessorList> predecessorLists = new ArrayList<PredecessorList>();
        Object original = this.copyToOriginal.get(workBreakdownElements.get(0));
        AdapterFactory adapterFactory = this.editingDomain.getAdapterFactory();
        IBSItemProvider bsItemProvider2 = (IBSItemProvider)adapterFactory.adapt(original, ITreeItemContentProvider.class);
        int firstID = bsItemProvider2.getId();
        predecessorLists.add(bsItemProvider2.getPredecessors());
        IBSItemProvider lastWBIp = null;
        AdapterFactoryTreeIterator iter = new AdapterFactoryTreeIterator(adapterFactory, original, false);
        while (iter.hasNext()) {
            Object obj = iter.next();
            Object e = TngUtil.unwrap(obj);
            if (!(e instanceof WorkBreakdownElement)) continue;
            IBSItemProvider bsIp = null;
            if (obj instanceof IBSItemProvider) {
                bsIp = (IBSItemProvider)obj;
                predecessorLists.add(bsIp.getPredecessors());
            } else {
                Object ip = adapterFactory.adapt(obj, ITreeItemContentProvider.class);
                if (ip instanceof IBSItemProvider) {
                    bsIp = (IBSItemProvider)ip;
                    predecessorLists.add(bsIp.getPredecessors());
                }
            }
            if (bsIp == null) continue;
            lastWBIp = bsIp;
        }
        int lastID = lastWBIp != null ? lastWBIp.getId() : firstID;
        int size = workBreakdownElements.size();
        Assert.isTrue((size == predecessorLists.size() ? 1 : 0) != 0);
        int i = 0;
        while (i < size) {
            WorkBreakdownElement e = (WorkBreakdownElement)workBreakdownElements.get(i);
            e.getLinkToPredecessor().clear();
            PredecessorList predList = (PredecessorList)predecessorLists.get(i);
            for (IBSItemProvider bsItemProvider2 : predList) {
                int id = bsItemProvider2.getId();
                if (id < firstID || id > lastID) continue;
                WorkBreakdownElement pred = (WorkBreakdownElement)workBreakdownElements.get(id - firstID);
                e.getLinkToPredecessor().add(UmaUtil.createDefaultWorkOrder((WorkBreakdownElement)e, (WorkBreakdownElement)pred));
            }
            ++i;
        }
    }

    private Collection<?> copyProcessPackages(Collection<ProcessPackage> procPackages) {
        Command command = this.createCopyCommand((EditingDomain)this.editingDomain, procPackages);
        if (command != null) {
            try {
                command.execute();
                Collection collection = command.getResult();
                return collection;
            }
            finally {
                command.dispose();
            }
        }
        return Collections.EMPTY_LIST;
    }

    private Command createCopyCommand(EditingDomain domain, Collection collection) {
        if (collection == null || collection.isEmpty()) {
            return UnexecutableCommand.INSTANCE;
        }
        CompoundCommand copyCommand = new CompoundCommand(Integer.MAX_VALUE);
        Iterator objects = collection.iterator();
        while (objects.hasNext()) {
            copyCommand.append(domain.createCommand(CopyCommand.class, new CommandParameter(objects.next(), null, (Object)this.copyHelper)));
        }
        return copyCommand.unwrap();
    }

    private List<Activity> copy(List<ProcessPackage> procPackages) {
        Collection<?> copyPackages = this.copyProcessPackages(procPackages);
        ArrayList<Activity> activities = new ArrayList<Activity>();
        for (ProcessPackage copy : copyPackages) {
            if (copy instanceof ProcessComponent) {
                Process actCopy = ((ProcessComponent)copy).getProcess();
                ProcessPackage pkgCopy = UmaFactory.eINSTANCE.createProcessPackage();
                pkgCopy.setName(actCopy.getName());
                pkgCopy.getProcessElements().add(actCopy);
                pkgCopy.getProcessElements().addAll(copy.getProcessElements());
                pkgCopy.getDiagrams().addAll(copy.getDiagrams());
                pkgCopy.getChildPackages().addAll(copy.getChildPackages());
                activities.add((Activity)actCopy);
                continue;
            }
            activities.add(ProcessUtil.findActivity(copy));
        }
        return activities;
    }

    public Map getDeepCopyToOriginalMap() {
        return this.deepCopyToOriginalMap;
    }

    public CopyCommand.Helper getCopyHelper() {
        return this.copyHelper;
    }

    public CopyHelper getDeepCopyHelper() {
        if (this.deepCopyHelper == null) {
            this.deepCopyHelper = new CopyHelper();
        }
        return this.deepCopyHelper;
    }

    public void setActivityDeepCopyConfigurator(IConfigurator activityDeepCopyConfigurator) {
        this.activityDeepCopyConfigurator = activityDeepCopyConfigurator;
    }
}

