/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.epf.library.edit.LibraryEditResources;
import org.eclipse.epf.library.edit.PresentationContext;
import org.eclipse.epf.library.edit.util.ManualSort;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.edit.util.model.OrderInfo;
import org.eclipse.epf.uma.ContentCategory;
import org.eclipse.epf.uma.CustomCategory;
import org.eclipse.epf.uma.Discipline;
import org.eclipse.epf.uma.Domain;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodElementProperty;
import org.eclipse.epf.uma.RoleSet;
import org.eclipse.epf.uma.Tool;
import org.eclipse.epf.uma.UmaFactory;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.VariabilityElement;
import org.eclipse.epf.uma.WorkProductType;
import org.eclipse.epf.uma.util.AssociationHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CategorySortHelper {
    public static final String KEY_CATEGORY_ELEMENTS__SORT_TYPE = "CategoryElementsSortType";
    public static final String V_CATEGORY_ELEMENTS__SORT_TYPE_ALPHA = "Alphabetic";
    public static final String V_CATEGORY_ELEMENTS__SORT_TYPE_REVERSE_ALPHA = "ReverseAlphabetic";
    public static final String V_CATEGORY_ELEMENTS__SORT_TYPE_METHOD_TYPE = "MethodType";
    public static final String V_CATEGORY_ELEMENTS__SORT_TYPE_MANUAL = "Manual";

    public static MethodElementProperty createNewSortProperty(String sortType) {
        MethodElementProperty prop = UmaFactory.eINSTANCE.createMethodElementProperty();
        prop.setName(KEY_CATEGORY_ELEMENTS__SORT_TYPE);
        if (sortType != null) {
            prop.setValue(sortType);
        }
        return prop;
    }

    public static MethodElementProperty getCategorySortProperty(MethodElement element) {
        List props = element.getMethodElementProperty();
        for (MethodElementProperty prop : props) {
            if (!KEY_CATEGORY_ELEMENTS__SORT_TYPE.equals(prop.getName())) continue;
            return prop;
        }
        return null;
    }

    public static boolean isManualCategorySort(MethodElement element) {
        String sortType = CategorySortHelper.getCategorySortValue(element);
        return V_CATEGORY_ELEMENTS__SORT_TYPE_MANUAL.equals(sortType);
    }

    public static String getCategorySortValue(MethodElement element) {
        MethodElementProperty prop = CategorySortHelper.getCategorySortProperty(element);
        if (prop == null) {
            return V_CATEGORY_ELEMENTS__SORT_TYPE_MANUAL;
        }
        return prop.getValue();
    }

    public static List<String> getCategorySortTypes() {
        List<String> returnList = Arrays.asList(V_CATEGORY_ELEMENTS__SORT_TYPE_MANUAL, V_CATEGORY_ELEMENTS__SORT_TYPE_ALPHA, V_CATEGORY_ELEMENTS__SORT_TYPE_REVERSE_ALPHA, V_CATEGORY_ELEMENTS__SORT_TYPE_METHOD_TYPE);
        return returnList;
    }

    public static String getSortTypeDisplayName(String sortType) {
        if (V_CATEGORY_ELEMENTS__SORT_TYPE_ALPHA.equals(sortType)) {
            return LibraryEditResources.SortType_Alphabetic;
        }
        if (V_CATEGORY_ELEMENTS__SORT_TYPE_REVERSE_ALPHA.equals(sortType)) {
            return LibraryEditResources.SortType_ReverseAlphabetic;
        }
        if (V_CATEGORY_ELEMENTS__SORT_TYPE_METHOD_TYPE.equals(sortType)) {
            return LibraryEditResources.SortType_MethodType;
        }
        if (V_CATEGORY_ELEMENTS__SORT_TYPE_MANUAL.equals(sortType)) {
            return LibraryEditResources.SortType_Manual;
        }
        return "";
    }

    public static List<Object> sortCategoryElements(MethodElement element, Object[] elements) {
        return CategorySortHelper.sortCategoryElements(element, elements, false, null, null);
    }

    public static List<Object> sortCategoryElements(MethodElement element, Object[] elements, MethodConfiguration config) {
        return CategorySortHelper.sortCategoryElements(element, elements, false, null, config);
    }

    public static List<Object> sortCategoryElements(MethodElement element, Object[] elements, boolean forcePresNameSort, EStructuralFeature feature, MethodConfiguration config) {
        ArrayList<Object> returnList = new ArrayList<Object>(Arrays.asList(elements));
        String sortType = CategorySortHelper.getCategorySortValue(element);
        if (V_CATEGORY_ELEMENTS__SORT_TYPE_MANUAL.equals(sortType)) {
            if (element instanceof ContentCategory) {
                return CategorySortHelper.findManualSortOrderInContributors((ContentCategory)element, returnList, feature, config);
            }
            return returnList;
        }
        if (V_CATEGORY_ELEMENTS__SORT_TYPE_ALPHA.equals(sortType)) {
            Comparator comparator = PresentationContext.INSTANCE.getComparator();
            if (forcePresNameSort) {
                comparator = PresentationContext.INSTANCE.getPresNameComparator();
            }
            Collections.sort(returnList, comparator);
        } else if (V_CATEGORY_ELEMENTS__SORT_TYPE_REVERSE_ALPHA.equals(sortType)) {
            Comparator comparator = PresentationContext.INSTANCE.getReverseComparator();
            if (forcePresNameSort) {
                comparator = PresentationContext.INSTANCE.getPresNameReverseComparator();
            }
            Collections.sort(returnList, comparator);
        } else if (V_CATEGORY_ELEMENTS__SORT_TYPE_METHOD_TYPE.equals(sortType)) {
            Comparator comparator = PresentationContext.INSTANCE.getMethodElementTypeComparator();
            if (forcePresNameSort) {
                comparator = PresentationContext.INSTANCE.getPresNameMethodElementTypeComparator();
            }
            Collections.sort(returnList, comparator);
        }
        return returnList;
    }

    private static List<Object> findManualSortOrderInContributors(ContentCategory cc, List<Object> elementList, EStructuralFeature feature, MethodConfiguration config) {
        if (feature == null) {
            return elementList;
        }
        String sortType = CategorySortHelper.getCategorySortValue((MethodElement)cc);
        if (!V_CATEGORY_ELEMENTS__SORT_TYPE_MANUAL.equals(sortType)) {
            return elementList;
        }
        ManualSort manualSort = new ManualSort();
        return manualSort.sort(cc, elementList, feature, config);
    }

    private static List<Object> findManualSortOrderInContributors(ContentCategory cc, List<Object> elementList) {
        OrderInfo latestInfo = null;
        HashMap<String, MethodElement> guidMap = new HashMap<String, MethodElement>();
        String sortType = CategorySortHelper.getCategorySortValue((MethodElement)cc);
        if (V_CATEGORY_ELEMENTS__SORT_TYPE_MANUAL.equals(sortType)) {
            for (Object o : elementList) {
                if (!(o instanceof MethodElement)) continue;
                guidMap.put(((MethodElement)o).getGuid(), (MethodElement)o);
            }
            Iterator iter = TngUtil.getContributors((VariabilityElement)cc);
            while (iter.hasNext()) {
                ContentCategory contributor;
                OrderInfo orderInfo;
                Object obj = iter.next();
                if (!(obj instanceof ContentCategory) || (orderInfo = TngUtil.getOrderInfo((MethodElement)(contributor = (ContentCategory)obj), "content elements")) == null || latestInfo != null && orderInfo.getTimestamp() <= latestInfo.getTimestamp()) continue;
                latestInfo = orderInfo;
            }
            if (latestInfo != null) {
                ArrayList<Object> returnList = new ArrayList<Object>();
                int size = latestInfo.getGUIDs().size();
                int i = 0;
                while (i < size) {
                    String guid = (String)latestInfo.getGUIDs().get(i);
                    Object element = guidMap.get(guid);
                    if (element != null) {
                        returnList.add(element);
                        guidMap.remove(guid);
                    } else {
                        MethodElement me = CategorySortHelper.findElementInVariableElementList(guidMap, guid);
                        if (me != null) {
                            returnList.add(me);
                            guidMap.remove(me.getGuid());
                        }
                    }
                    ++i;
                }
                if (elementList.size() == returnList.size()) {
                    return returnList;
                }
            }
        }
        return elementList;
    }

    private static MethodElement findElementInVariableElementList(Map<String, MethodElement> guidMap, String guid) {
        for (MethodElement value : guidMap.values()) {
            if (!(value instanceof VariabilityElement)) continue;
            HashSet<MethodElement> set = new HashSet<MethodElement>();
            set.add(value);
            Set varElements = AssociationHelper.getVariabilityElements(set, (boolean)true, (boolean)true);
            if (varElements == null || varElements.size() <= 0) continue;
            for (Object variableElement : varElements) {
                if (!(variableElement instanceof MethodElement) || !((MethodElement)variableElement).getGuid().equals(guid)) continue;
                return value;
            }
        }
        return null;
    }

    public static boolean needToSort(MethodElement element, EStructuralFeature feature) {
        if (!(element instanceof ContentCategory)) {
            return false;
        }
        if (element instanceof CustomCategory && feature == UmaPackage.eINSTANCE.getCustomCategory_CategorizedElements()) {
            return true;
        }
        if (element instanceof Discipline && feature == UmaPackage.eINSTANCE.getDiscipline_Tasks()) {
            return true;
        }
        if (element instanceof Domain && feature == UmaPackage.eINSTANCE.getDomain_WorkProducts()) {
            return true;
        }
        if (element instanceof RoleSet && feature == UmaPackage.eINSTANCE.getRoleSet_Roles()) {
            return true;
        }
        if (element instanceof Tool && feature == UmaPackage.eINSTANCE.getTool_ToolMentors()) {
            return true;
        }
        return element instanceof WorkProductType && feature == UmaPackage.eINSTANCE.getWorkProductType_WorkProducts();
    }
}

