/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.epf.library.edit.IConfigurable;
import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.library.edit.LibraryEditPlugin;
import org.eclipse.epf.library.edit.LibraryEditResources;
import org.eclipse.epf.library.edit.util.Messenger;

public class ConfigurableComposedAdapterFactory
extends ComposedAdapterFactory {
    private IFilter filter;

    public ConfigurableComposedAdapterFactory(AdapterFactory[] adapterFactories) {
        super(adapterFactories);
    }

    public Object adapt(Object object, Object type) {
        Object adapter = super.adapt(object, type);
        if (adapter instanceof IConfigurable) {
            ((IConfigurable)adapter).setFilter(this.filter);
        }
        return adapter;
    }

    public Adapter adapt(Notifier target, Object type) {
        Adapter adapter = super.adapt(target, type);
        if (adapter instanceof IConfigurable) {
            ((IConfigurable)adapter).setFilter(this.filter);
        }
        return adapter;
    }

    public IFilter getFilter() {
        return this.filter;
    }

    public void setFilter(IFilter filter) {
        this.filter = filter;
    }

    public void fireNotifyChanged(Notification notification) {
        try {
            super.fireNotifyChanged(notification);
        }
        catch (RuntimeException e) {
            if (notification instanceof ViewerNotification) {
                LibraryEditPlugin.getDefault().getLogger().logError((Throwable)e);
                StringWriter strWriter = new StringWriter();
                e.printStackTrace(new PrintWriter(strWriter));
                Messenger.INSTANCE.showError(LibraryEditResources.util_configurablecomposedadapter_fatalerr, LibraryEditResources.util_configurablecomposedadapter_refershingviewer, LibraryEditResources.util_configurablecomposedadapter_unhandled_exception, strWriter.toString(), e);
                return;
            }
            throw e;
        }
    }

    public void addFirstAdapterFactory(AdapterFactory adapterFactory) {
        if (!this.adapterFactories.contains(adapterFactory)) {
            this.adapterFactories.add(0, adapterFactory);
            if (adapterFactory instanceof ComposeableAdapterFactory) {
                ((ComposeableAdapterFactory)adapterFactory).setParentAdapterFactory((ComposedAdapterFactory)this);
            }
        }
    }
}

