/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.util;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.epf.library.edit.IConfigurator;
import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.uma.MethodConfiguration;

public class ConfigurationSetter {
    private AdapterFactory adapterFactory;
    private IConfigurator configurator;
    private MethodConfiguration oldConfig;

    public ConfigurationSetter(AdapterFactory adapterFactory) {
        this.adapterFactory = adapterFactory;
    }

    public void set(MethodConfiguration config) {
        IFilter filter = ProcessUtil.getFilter(this.adapterFactory);
        IConfigurator iConfigurator = this.configurator = filter instanceof IConfigurator ? (IConfigurator)filter : null;
        if (this.configurator != null) {
            this.oldConfig = this.configurator.getMethodConfiguration();
            this.configurator.setMethodConfiguration(config);
        }
    }

    public void restore() {
        if (this.configurator != null) {
            this.configurator.setMethodConfiguration(this.oldConfig);
        }
    }

    public IConfigurator getConfigurator() {
        return this.configurator;
    }

    public MethodConfiguration getOldConfiguration() {
        return this.oldConfig;
    }
}

