/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.epf.library.edit.command.IActionManager;
import org.eclipse.epf.library.edit.util.MethodElementPropUtil;
import org.eclipse.epf.library.edit.util.MethodPluginPropUtil;
import org.eclipse.epf.library.edit.util.WorkProductPropUtil;
import org.eclipse.epf.uma.Constraint;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.UmaFactory;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.WorkBreakdownElement;
import org.eclipse.epf.uma.WorkProduct;
import org.eclipse.epf.uma.WorkProductDescriptor;
import org.eclipse.epf.uma.util.UmaUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConstraintManager {
    public static final String ACITIVY_DIAGRAM = "diagram";
    public static final String PROCESS_SUPPRESSION = "";
    public static final String Plugin_wpState = "wpState";
    public static final String Wbe_WpStates = "wpStates";

    public static final Constraint getConstraint(MethodElement e, String constraintName, boolean create) {
        if (constraintName == null) {
            return null;
        }
        Constraint constraint = null;
        for (Constraint c : e.getOwnedRules()) {
            if (!c.getName().equals(constraintName)) continue;
            constraint = c;
            break;
        }
        if (constraint == null && create) {
            constraint = UmaFactory.eINSTANCE.createConstraint();
            constraint.setName(constraintName);
            e.getOwnedRules().add(constraint);
        }
        return constraint;
    }

    public static final Constraint getWorkProductState(WorkProduct wp, String stateName, boolean create, IActionManager actionManager) {
        if (wp == null || stateName == null || stateName.trim().length() == 0) {
            return null;
        }
        WorkProductPropUtil propUtil = WorkProductPropUtil.getWorkProductPropUtil();
        List<Constraint> states = propUtil.getWorkProductStates(wp);
        for (Constraint state : states) {
            if (!state.getBody().equals(stateName)) continue;
            return state;
        }
        MethodPlugin plugin = UmaUtil.getMethodPlugin((EObject)wp);
        if (plugin == null) {
            return null;
        }
        return ConstraintManager.getWorkProductState(plugin, stateName, create, actionManager);
    }

    public static Constraint getWorkProductState(MethodPlugin plugin, String stateName, boolean create, IActionManager actionManager) {
        MethodPluginPropUtil pluginPropUtil = MethodPluginPropUtil.getMethodPluginPropUtil(actionManager);
        for (Constraint state : pluginPropUtil.getWorkProductStatesInPlugin(plugin)) {
            if (!state.getBody().equals(stateName)) continue;
            return state;
        }
        if (create) {
            return ConstraintManager.createConstraint((MethodElement)plugin, Plugin_wpState, stateName, actionManager);
        }
        return null;
    }

    private static Constraint createConstraint(MethodElement owner, String name, String body, IActionManager actionManager) {
        Constraint constraint = UmaFactory.eINSTANCE.createConstraint();
        if (actionManager == null) {
            constraint.setName(name);
            constraint.setBody(body);
            owner.getOwnedRules().add(constraint);
        } else {
            UmaPackage up = UmaPackage.eINSTANCE;
            actionManager.doAction(1, (EObject)constraint, (EStructuralFeature)up.getNamedElement_Name(), name, -1);
            actionManager.doAction(1, (EObject)constraint, (EStructuralFeature)up.getConstraint_Body(), body, -1);
            actionManager.doAction(3, (EObject)owner, (EStructuralFeature)up.getMethodElement_OwnedRules(), constraint, -1);
        }
        return constraint;
    }

    public static void addWpState(WorkBreakdownElement wbe, WorkProductDescriptor wpd, Constraint state, EReference ref, IActionManager actionManager) {
        if (wbe == null || wpd == null || state == null || ref == null) {
            return;
        }
        Constraint wpStatesHolder = null;
        for (Constraint constraint : wbe.getOwnedRules()) {
            if (!constraint.getName().equals(Wbe_WpStates) || !constraint.getBody().equals(wpd.getGuid())) continue;
            wpStatesHolder = constraint;
            break;
        }
        if (wpStatesHolder == null) {
            wpStatesHolder = ConstraintManager.createConstraint((MethodElement)wbe, Wbe_WpStates, wpd.getGuid(), actionManager);
        }
        MethodElementPropUtil propUtil = new MethodElementPropUtil(actionManager);
        propUtil.addReferenceInfo((MethodElement)wpStatesHolder, (MethodElement)state, "constraint_wpStates", ref.getName());
    }

    public static void removeWpState(WorkBreakdownElement wbe, WorkProductDescriptor wpd, Constraint state, EReference ref, IActionManager actionManager) {
        if (wbe == null || wpd == null || state == null || ref == null) {
            return;
        }
        Constraint wpStatesHolder = null;
        for (Constraint constraint : wbe.getOwnedRules()) {
            if (!constraint.getName().equals(Wbe_WpStates) || !constraint.getBody().equals(wpd.getGuid())) continue;
            wpStatesHolder = constraint;
            break;
        }
        if (wpStatesHolder == null) {
            return;
        }
        MethodElementPropUtil propUtil = new MethodElementPropUtil(actionManager);
        propUtil.removeReferenceInfo((MethodElement)wpStatesHolder, (MethodElement)state, "constraint_wpStates", ref.getName());
    }

    public static List<Constraint> getWpStates(WorkBreakdownElement wbe, WorkProductDescriptor wpd, EReference ref) {
        WorkProduct wp = wpd.getWorkProduct();
        if (wp == null) {
            return new ArrayList<Constraint>();
        }
        Constraint wpStatesHolder = null;
        for (Constraint constraint : wbe.getOwnedRules()) {
            if (!constraint.getName().equals(Wbe_WpStates) || !constraint.getBody().equals(wpd.getGuid())) continue;
            wpStatesHolder = constraint;
            break;
        }
        if (wpStatesHolder == null) {
            return new ArrayList<Constraint>();
        }
        MethodElementPropUtil propUtil = MethodElementPropUtil.getMethodElementPropUtil();
        return propUtil.extractElements((MethodElement)wpStatesHolder, "constraint_wpStates", ref.getName(), (Set<? extends MethodElement>)WorkProductPropUtil.getWorkProductPropUtil().getAllStates(wp));
    }

    public static List<Constraint> getWpStates(WorkBreakdownElement wbe) {
        ArrayList<Constraint> list = new ArrayList<Constraint>();
        for (Constraint constraint : wbe.getOwnedRules()) {
            if (!constraint.getName().equals(Wbe_WpStates)) continue;
            list.add(constraint);
        }
        return list;
    }
}

