/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.AbstractTreeIterator;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.edit.util.model.ModelFactory;
import org.eclipse.epf.library.edit.util.model.OrderInfo;
import org.eclipse.epf.library.edit.util.model.OrderInfoCollection;
import org.eclipse.epf.library.edit.util.model.util.StringResource;
import org.eclipse.epf.uma.DescribableElement;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.VariabilityElement;
import org.eclipse.epf.uma.VariabilityType;
import org.eclipse.epf.uma.util.AssociationHelper;
import org.eclipse.epf.uma.util.UmaUtil;

public class ContentElementOrderList
extends BasicEList {
    private static final long serialVersionUID = 3257572797487069233L;
    public static final String ORDER_INFO_NAME = "content elements";
    private static final Map DEFAULT_SAVE_OPTIONS = new HashMap();
    public static final int CONTENT_ELEMENTS__FOR_ELEMENT_ONLY = 1;
    public static final int CONTENT_ELEMENTS__FOR_ELEMENT_AND_PARENTS = 2;
    private VariabilityElement editElement;
    private boolean mixed = true;
    private boolean changed = false;
    private EStructuralFeature feature;

    static {
        DEFAULT_SAVE_OPTIONS.put("ENCODING", "ASCII");
    }

    private static boolean isContributor(VariabilityElement e) {
        return TngUtil.isContributor(e);
    }

    public ContentElementOrderList(VariabilityElement e, int scope, EStructuralFeature feature) {
        this.feature = feature;
        this.editElement = e;
        if (scope == 1) {
            this.mixed = false;
        } else if (scope == 2) {
            this.calculateParentsOnly(e);
        } else {
            this.mixed = false;
        }
    }

    private void calculateParentsOnly(VariabilityElement e) {
        Iterator iter = null;
        if (ContentElementOrderList.isContributor(e) || ContentElementOrderList.isExtended(e)) {
            ArrayList<VariabilityElement> supers = new ArrayList<VariabilityElement>();
            UmaUtil.getAllSupersBoth(supers, (VariabilityElement)e, (VariabilityType)VariabilityType.CONTRIBUTES, (VariabilityType)VariabilityType.EXTENDS);
            supers.add(e);
            iter = supers.iterator();
        } else {
            this.mixed = false;
        }
        if (this.mixed) {
            OrderInfo latestInfo = null;
            HashMap<String, DescribableElement> guidMap = new HashMap<String, DescribableElement>();
            LinkedHashSet<DescribableElement> elements = new LinkedHashSet<DescribableElement>();
            while (iter.hasNext()) {
                VariabilityElement element = (VariabilityElement)iter.next();
                ArrayList contentElements = new ArrayList();
                Object eGet = element.eGet(this.feature);
                if (eGet instanceof List) {
                    contentElements.addAll((List)eGet);
                }
                for (DescribableElement categorizedElement : contentElements) {
                    guidMap.put(categorizedElement.getGuid(), categorizedElement);
                    elements.add(categorizedElement);
                }
                OrderInfo orderInfo = TngUtil.getOrderInfo((MethodElement)element, ORDER_INFO_NAME);
                if (orderInfo == null || latestInfo != null && orderInfo.getTimestamp() <= latestInfo.getTimestamp()) continue;
                latestInfo = orderInfo;
            }
            if (latestInfo != null) {
                int size = latestInfo.getGUIDs().size();
                int i = 0;
                while (i < size) {
                    Object guid = latestInfo.getGUIDs().get(i);
                    Object element = guidMap.get(guid);
                    if (element != null) {
                        super.add(element);
                        elements.remove(element);
                    }
                    ++i;
                }
            }
            super.addAll(elements);
        }
    }

    public ContentElementOrderList(VariabilityElement e) {
        this.editElement = e;
        Object iter = null;
        if (ContentElementOrderList.isContributor(e) || TngUtil.hasContributor(e)) {
            VariabilityElement base = TngUtil.getBase(e);
            iter = new AbstractTreeIterator(base){

                protected Iterator getChildren(Object object) {
                    ArrayList<VariabilityElement> children = new ArrayList<VariabilityElement>();
                    for (VariabilityElement element : AssociationHelper.getImmediateVarieties((VariabilityElement)((VariabilityElement)object))) {
                        if (element.getVariabilityType() != VariabilityType.CONTRIBUTES) continue;
                        children.add(element);
                    }
                    return children.iterator();
                }
            };
        } else if (ContentElementOrderList.isExtended(e)) {
            System.out.println("$$$ for " + e.getName() + " = extended is true");
            ArrayList<VariabilityElement> supers = new ArrayList<VariabilityElement>();
            UmaUtil.getAllSupers(supers, (VariabilityElement)e, (VariabilityType)VariabilityType.EXTENDS);
            supers.add(e);
            iter = supers.iterator();
        } else {
            this.mixed = false;
        }
        if (this.mixed) {
            OrderInfo latestInfo = null;
            HashMap<String, VariabilityElement> guidMap = new HashMap<String, VariabilityElement>();
            LinkedList<VariabilityElement> elements = new LinkedList<VariabilityElement>();
            while (iter.hasNext()) {
                VariabilityElement element = (VariabilityElement)iter.next();
                guidMap.put(element.getGuid(), element);
                elements.add(element);
                OrderInfo orderInfo = TngUtil.getOrderInfo((MethodElement)element, ORDER_INFO_NAME);
                if (orderInfo == null || latestInfo != null && orderInfo.getTimestamp() <= latestInfo.getTimestamp()) continue;
                latestInfo = orderInfo;
            }
            if (latestInfo != null) {
                int size = latestInfo.getGUIDs().size();
                int i = 0;
                while (i < size) {
                    Object guid = latestInfo.getGUIDs().get(i);
                    Object element = guidMap.get(guid);
                    if (element != null) {
                        super.add(element);
                        elements.remove(element);
                    }
                    ++i;
                }
            }
            super.addAll(elements);
        }
    }

    private static boolean isExtended(VariabilityElement e) {
        return e.getVariabilityBasedOnElement() != null && e.getVariabilityType() == VariabilityType.EXTENDS;
    }

    public void apply() {
        if (!this.mixed || !this.changed) {
            return;
        }
        String str = this.editElement.getOrderingGuide();
        OrderInfoCollection orderInfos = null;
        StringResource res = null;
        if (str == null || str.length() == 0) {
            orderInfos = ModelFactory.eINSTANCE.createOrderInfoCollection();
        } else {
            res = new StringResource(str);
            try {
                res.load(null);
                orderInfos = res.getContents().isEmpty() ? ModelFactory.eINSTANCE.createOrderInfoCollection() : (OrderInfoCollection)res.getContents().get(0);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        OrderInfo sectOrderInfo = null;
        for (OrderInfo orderInfo : orderInfos.getOrderInfos()) {
            if (!ORDER_INFO_NAME.equalsIgnoreCase(orderInfo.getName())) continue;
            sectOrderInfo = orderInfo;
            break;
        }
        if (sectOrderInfo == null) {
            sectOrderInfo = ModelFactory.eINSTANCE.createOrderInfo();
            sectOrderInfo.setName(ORDER_INFO_NAME);
            orderInfos.getOrderInfos().add((Object)sectOrderInfo);
        } else {
            sectOrderInfo.getGUIDs().clear();
        }
        int size = this.size();
        int i = 0;
        while (i < size) {
            DescribableElement sect = (DescribableElement)this.get(i);
            sectOrderInfo.getGUIDs().add((Object)sect.getGuid());
            ++i;
        }
        sectOrderInfo.setTimestamp(System.currentTimeMillis());
        if (res == null) {
            res = new StringResource(null);
            res.getContents().add((Object)orderInfos);
        }
        try {
            res.save(DEFAULT_SAVE_OPTIONS);
            str = res.getString();
            this.editElement.setOrderingGuide(str);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
    }

    public boolean canRemove(VariabilityElement contentElement) {
        return this.eGet().contains((Object)contentElement);
    }

    public Object remove(int index) {
        if (this.mixed) {
            if (!this.canRemove((VariabilityElement)this.get(index))) {
                return null;
            }
            Object removed = super.remove(index);
            this.eGet().remove(removed);
            return removed;
        }
        return this.eGet().remove(index);
    }

    public boolean remove(Object o) {
        if (!this.canRemove((VariabilityElement)o)) {
            return false;
        }
        if (this.mixed) {
            if (super.remove(o)) {
                this.eGet().remove(o);
                return true;
            }
            return false;
        }
        return this.eGet().remove(o);
    }

    public boolean removeAll(Collection c) {
        if (this.mixed) {
            boolean modified = false;
            Iterator e = this.iterator();
            while (e.hasNext()) {
                Object o = e.next();
                if (!c.contains(o) || !this.canRemove((VariabilityElement)o)) continue;
                e.remove();
                this.eGet().remove(o);
                modified = true;
            }
            return modified;
        }
        return this.eGet().removeAll(c);
    }

    public void add(int index, Object element) {
        if (this.mixed) {
            super.add(index, element);
            this.eGet().add(element);
            this.changed = true;
        } else {
            this.eGet().add(index, element);
        }
    }

    public boolean add(Object o) {
        boolean b = this.eGet().add(o);
        if (this.mixed && (b = super.add(o))) {
            this.changed = true;
        }
        return b;
    }

    public boolean addAll(Collection c) {
        boolean b = this.eGet().addAll(c);
        if (this.mixed && (b = super.addAll(c))) {
            this.changed = true;
        }
        return b;
    }

    public boolean addAll(int index, Collection c) {
        if (this.mixed) {
            this.eGet().addAll(c);
            boolean b = super.addAll(index, c);
            if (b) {
                this.changed = true;
            }
        }
        return this.eGet().addAll(c);
    }

    public Object set(int index, Object element) {
        if (this.mixed) {
            throw new UnsupportedOperationException();
        }
        return this.eGet().set(index, element);
    }

    public void clear() {
        if (this.mixed) {
            throw new UnsupportedOperationException();
        }
        this.eGet().clear();
    }

    public void move(int index, Object object) {
        if (this.mixed) {
            super.move(index, object);
            this.changed = true;
        } else {
            this.eGet().move(index, object);
        }
    }

    public Object move(int targetIndex, int sourceIndex) {
        if (this.mixed) {
            Object moved = super.move(targetIndex, sourceIndex);
            this.changed = true;
            return moved;
        }
        return this.eGet().move(targetIndex, sourceIndex);
    }

    public Object get(int index) {
        if (this.mixed) {
            return super.get(index);
        }
        return this.eGet().get(index);
    }

    public int size() {
        if (this.mixed) {
            return super.size();
        }
        return this.eGet().size();
    }

    public Iterator iterator() {
        if (this.mixed) {
            return super.iterator();
        }
        return this.eGet().iterator();
    }

    public boolean contains(Object object) {
        if (this.mixed) {
            return super.contains(object);
        }
        return this.eGet().contains(object);
    }

    public boolean containsAll(Collection collection) {
        if (this.mixed) {
            return super.containsAll(collection);
        }
        return this.eGet().containsAll(collection);
    }

    public Object[] toArray() {
        if (this.mixed) {
            return super.toArray();
        }
        return this.eGet().toArray();
    }

    public Object[] toArray(Object[] array) {
        if (this.mixed) {
            return super.toArray(array);
        }
        return this.eGet().toArray(array);
    }

    public int indexOf(Object object) {
        if (this.mixed) {
            return super.indexOf(object);
        }
        return this.eGet().indexOf(object);
    }

    public int lastIndexOf(Object object) {
        if (this.mixed) {
            return super.lastIndexOf(object);
        }
        return this.eGet().lastIndexOf(object);
    }

    public boolean isMixed() {
        return this.mixed;
    }

    private EList eGet() {
        EList list = null;
        Object object = this.editElement.eGet(this.feature);
        if (object instanceof EList) {
            list = (EList)object;
        }
        if (list == null) {
            list = new BasicEList();
        }
        return list;
    }
}

