/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.resources.IFile;
import org.eclipse.epf.common.utils.FileUtil;
import org.eclipse.epf.library.edit.util.Comparators;
import org.eclipse.epf.library.edit.util.DebugUtil;
import org.eclipse.epf.uma.MethodElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DebugLog {
    private String indent;
    private String prompt;
    private boolean console = false;
    private boolean log = true;

    public DebugLog(String prompt) {
        this.prompt = prompt;
        int n = 5 + (prompt == null ? 0 : prompt.length());
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < n) {
            sb.append(" ");
            ++i;
        }
        this.indent = sb.toString();
    }

    protected boolean isConsole() {
        return this.console;
    }

    public void setConsole(boolean console) {
        this.console = console;
    }

    protected boolean isLog() {
        return this.log;
    }

    public void setLog(boolean log) {
        this.log = log;
    }

    public void log(String msg) {
        if (this.isConsole()) {
            System.out.println(String.valueOf(this.prompt) + msg);
        }
        if (this.isLog()) {
            FileUtil.log((String)(String.valueOf(this.prompt) + msg));
        }
    }

    public void logElements(String label, Collection<? extends MethodElement> elements, boolean showEmpty) {
        this.logElements(label, elements, showEmpty, true);
    }

    public void logElements(String label, Collection<? extends MethodElement> elements, boolean showEmpty, boolean showTags) {
        boolean empty;
        boolean bl = empty = elements == null || elements.isEmpty();
        if (!showEmpty && empty) {
            return;
        }
        String str = String.valueOf(this.prompt) + label;
        if (!empty) {
            str = String.valueOf(str) + " size = " + elements.size();
            ArrayList<? extends MethodElement> sortedElements = new ArrayList<MethodElement>(elements);
            Collections.sort(sortedElements, Comparators.NAME_GUID_COMPARATOR);
            for (MethodElement methodElement : sortedElements) {
                String line = "\n" + this.indent + this.toString(methodElement, 2, showTags, String.valueOf(this.indent) + this.indent);
                str = String.valueOf(str) + line;
            }
        } else {
            str = String.valueOf(str) + "\n" + this.indent + "Empty list";
        }
        if (this.isConsole()) {
            System.out.println(String.valueOf(str) + "\n");
        }
        if (this.isLog()) {
            FileUtil.log((String)(String.valueOf(str) + "\n"));
        }
    }

    public String toString(MethodElement element, int ix, boolean showTags, String tagLineInden) {
        return DebugUtil.toString(element, ix);
    }

    public void logFiles(String label, IFile[] files, boolean showEmpty) {
        ArrayList<IFile> fileList = new ArrayList<IFile>();
        if (files != null && files.length > 0) {
            IFile[] iFileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                IFile file = iFileArray[n2];
                fileList.add(file);
                ++n2;
            }
        }
        this.logFiles(label, fileList, showEmpty);
    }

    public void logFiles(String label, Collection<IFile> files, boolean showEmpty) {
        boolean empty;
        boolean bl = empty = files == null || files.isEmpty();
        if (!showEmpty && empty) {
            return;
        }
        String str = String.valueOf(this.prompt) + label;
        if (!empty) {
            str = String.valueOf(str) + " size = " + files.size();
            for (IFile file : files) {
                String line = "\n" + this.indent + file;
                str = String.valueOf(str) + line;
            }
        } else {
            str = String.valueOf(str) + "\n" + this.indent + "Empty list";
        }
        if (this.isConsole()) {
            System.out.println(String.valueOf(str) + "\n");
        }
        if (this.isLog()) {
            FileUtil.log((String)(String.valueOf(str) + "\n"));
        }
    }
}

