/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.epf.library.edit.LibraryEditPlugin;
import org.eclipse.epf.library.edit.command.IActionManager;
import org.eclipse.epf.library.edit.uma.DescriptorExt;
import org.eclipse.epf.library.edit.uma.MethodElementExt;
import org.eclipse.epf.library.edit.util.LibraryEditUtil;
import org.eclipse.epf.library.edit.util.PracticePropUtil;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.library.edit.util.WbePropUtil;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.Checklist;
import org.eclipse.epf.uma.Concept;
import org.eclipse.epf.uma.Descriptor;
import org.eclipse.epf.uma.DescriptorDescription;
import org.eclipse.epf.uma.EstimationConsiderations;
import org.eclipse.epf.uma.Example;
import org.eclipse.epf.uma.Guidance;
import org.eclipse.epf.uma.Guideline;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.Practice;
import org.eclipse.epf.uma.Report;
import org.eclipse.epf.uma.ReusableAsset;
import org.eclipse.epf.uma.RoleDescriptor;
import org.eclipse.epf.uma.SupportingMaterial;
import org.eclipse.epf.uma.TaskDescriptor;
import org.eclipse.epf.uma.Template;
import org.eclipse.epf.uma.ToolMentor;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.WorkProductDescriptor;
import org.eclipse.epf.uma.util.UmaUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DescriptorPropUtil
extends WbePropUtil {
    public static boolean useLinkedElementInDiagram = false;
    private static boolean localDebug = false;
    private static final String plus = "+";
    private static final String minus = "-";
    public static final String DESCRIPTOR_NoAutoSyn = "descriptor_noAutoSyn";
    public static final String DESCRIPTOR_CreatedByReference = "descriptor_createdByReference";
    public static final String DESCRIPTOR_Customization = "descriptor_customization";
    public static final String DESCRIPTOR_LocalUsingInfo = "descriptor_localUsingInfo";
    public static final String DESCRIPTOR_GreenParent = "descriptor_greenParent";
    public static final String DESCRIPTOR_GreenRefDelta = "descriptor_greenRefDelta";
    private static int nameReplace = 1;
    private static int presentatioNameReplace = 2;
    private static int briefDesReplace = 4;
    private static int mainDesReplace = 8;
    private static int keyConsiderReplace = 16;
    private static DescriptorPropUtil descriptorPropUtil = new DescriptorPropUtil();

    public static DescriptorPropUtil getDesciptorPropUtil() {
        return descriptorPropUtil;
    }

    public static DescriptorPropUtil getDesciptorPropUtil(IActionManager actionManager) {
        return new DescriptorPropUtil(actionManager);
    }

    protected DescriptorPropUtil() {
    }

    protected DescriptorPropUtil(IActionManager actionManager) {
        super(actionManager);
    }

    public boolean isNoAutoSyn(Descriptor d) {
        if (this.getLinkedElement(d) == null) {
            return true;
        }
        Boolean value = this.getBooleanValue((MethodElement)d, DESCRIPTOR_NoAutoSyn);
        return value == null ? false : value;
    }

    public void setNoAutoSyn(Descriptor d, boolean value) {
        this.setBooleanValue((MethodElement)d, DESCRIPTOR_NoAutoSyn, value);
    }

    public boolean isCreatedByReference(Descriptor d) {
        Boolean value = this.getBooleanValue((MethodElement)d, DESCRIPTOR_CreatedByReference);
        return value == null ? false : value;
    }

    public void setCreatedByReference(Descriptor d, boolean value) {
        this.setBooleanValue((MethodElement)d, DESCRIPTOR_CreatedByReference, value);
    }

    public boolean isNameRepalce(Descriptor d) {
        if (this.hasNoValue(d.getName())) {
            return false;
        }
        return this.getCustomization(d, nameReplace);
    }

    public void setNameRepalce(Descriptor d, boolean value) {
        this.setCustomization(d, nameReplace, value);
    }

    public boolean isPresentationNameRepalce(Descriptor d) {
        if (this.hasNoValue(d.getPresentationName())) {
            return false;
        }
        return this.getCustomization(d, presentatioNameReplace);
    }

    public void setPresentationNameRepalce(Descriptor d, boolean value) {
        this.setCustomization(d, presentatioNameReplace, value);
    }

    public boolean isBriefDesRepalce(Descriptor d) {
        if (this.hasNoValue(d.getBriefDescription())) {
            return false;
        }
        return this.getCustomization(d, briefDesReplace);
    }

    public void setBriefDesRepalce(Descriptor d, boolean value) {
        this.setCustomization(d, briefDesReplace, value);
    }

    public boolean isMainDesRepalce(Descriptor d) {
        String value;
        if (d.getPresentation() instanceof DescriptorDescription && this.hasNoValue(value = ((DescriptorDescription)d.getPresentation()).getRefinedDescription())) {
            return false;
        }
        return this.getCustomization(d, mainDesReplace);
    }

    public void setMainDesRepalce(Descriptor d, boolean value) {
        this.setCustomization(d, mainDesReplace, value);
    }

    public boolean isKeyConsiderRepalce(Descriptor d) {
        String value;
        if (d.getPresentation() instanceof DescriptorDescription && this.hasNoValue(value = ((DescriptorDescription)d.getPresentation()).getKeyConsiderations())) {
            return false;
        }
        return this.getCustomization(d, keyConsiderReplace);
    }

    public void setKeyConsiderRepalce(Descriptor d, boolean value) {
        this.setCustomization(d, keyConsiderReplace, value);
    }

    public Set<Descriptor> getLocalUsedDescriptors(Descriptor usingD) {
        return this.getLocalUsedDescriptors(usingD, null);
    }

    public Set<Descriptor> getLocalUsedDescriptors(Descriptor usingD, EReference feature) {
        if (!ProcessUtil.isSynFree()) {
            return new HashSet<Descriptor>();
        }
        Set<Descriptor> descriptors = this.getLocalUsedDescriptors(usingD, feature, "");
        Descriptor greenParent = this.getGreenParentDescriptor(usingD);
        if (greenParent != null && feature != null) {
            Set<Descriptor> descriptorsFromParent = this.getLocalUsedDescriptors(greenParent, feature, "");
            for (Descriptor usedD : descriptorsFromParent) {
                if (this.localUse_(usedD, usingD, feature, minus)) continue;
                descriptors.add(usedD);
            }
        }
        if (localDebug) {
            System.out.println("LD> getLocalUsedDescriptors, feature: " + feature + "\nl" + descriptors);
        }
        return descriptors;
    }

    private Set<Descriptor> getLocalUsedDescriptors(Descriptor usingD, EReference feature, String featureSuffix) {
        HashSet<Descriptor> descriptors = new HashSet<Descriptor>();
        String value = this.getStringValue((MethodElement)usingD, DESCRIPTOR_LocalUsingInfo);
        if (value == null || value.length() == 0) {
            return descriptors;
        }
        String[] infos = value.split("/");
        if (infos == null || infos.length == 0) {
            return descriptors;
        }
        boolean modified = false;
        String newValue = "";
        int sz = infos.length / 2;
        int i = 0;
        while (i < sz) {
            int i1 = i * 2;
            int i2 = i1 + 1;
            String iGuid = infos[i1];
            String iFeature = infos[i2];
            MethodElement element = LibraryEditUtil.getInstance().getMethodElement(iGuid);
            if (element instanceof Descriptor && UmaUtil.isInLibrary((MethodElement)element)) {
                if (feature == null || iFeature.equals(String.valueOf(feature.getName()) + featureSuffix)) {
                    descriptors.add((Descriptor)element);
                }
                newValue = this.incNewValue(newValue, iGuid, iFeature);
            } else {
                modified = true;
            }
            ++i;
        }
        if (modified) {
            this.setStringValue((MethodElement)usingD, DESCRIPTOR_LocalUsingInfo, newValue);
        }
        return descriptors;
    }

    private String incNewValue(String newValue, String iGuid, String iFeature) {
        if (newValue.length() > 0) {
            newValue = newValue.concat("/");
        }
        newValue = newValue.concat(iGuid.concat("/").concat(iFeature));
        return newValue;
    }

    public boolean localUse(Descriptor usedD, Descriptor usingD, EReference feature) {
        try {
            Descriptor greenParent;
            boolean be = this.localUse_(usedD, usingD, feature);
            if (!be && (greenParent = this.getGreenParentDescriptor(usingD)) != null && !this.localUse_(usedD, usingD, feature, minus)) {
                be = this.localUse_(usedD, greenParent, feature);
            }
            if (localDebug) {
                System.out.println("LD> localUse: " + be + ", usingD: " + usingD.getName() + ", usedD: " + usedD.getName() + ", feature: " + feature.getName());
            }
            return be;
        }
        catch (Throwable e) {
            LibraryEditPlugin.getDefault().getLogger().logError(e);
            return false;
        }
    }

    private boolean localUse_(Descriptor usedD, Descriptor usingD, EReference feature) {
        return this.localUse_(usedD, usingD, feature, "");
    }

    private boolean localUse_(Descriptor usedD, Descriptor usingD, EReference feature, String featureSuffix) {
        String value = this.getStringValue((MethodElement)usingD, DESCRIPTOR_LocalUsingInfo);
        if (value == null || value.length() == 0) {
            return false;
        }
        String[] infos = value.split("/");
        if (infos == null || infos.length == 0) {
            return false;
        }
        int sz = infos.length / 2;
        int i = 0;
        while (i < sz) {
            int i1 = i * 2;
            int i2 = i1 + 1;
            String iGuid = infos[i1];
            String iFeature = infos[i2];
            if (iGuid.equals(usedD.getGuid()) && iFeature.equals(String.valueOf(feature.getName()) + featureSuffix)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void toggleOffGParentLocalUse(Descriptor usedD, Descriptor usingD, EReference feature) {
        this.addLocalUse(usedD, usingD, feature, minus);
    }

    private void untoggleOffGParentLocalUse(Descriptor usedD, Descriptor usingD, EReference feature) {
        this.removeLocalUse(usedD, usingD, feature, minus);
    }

    public void addLocalUse(Descriptor usedD, Descriptor usingD, EReference feature) {
        Descriptor greenParent = this.getGreenParentDescriptor(usingD);
        if (greenParent != null && this.localUse(usedD, greenParent, feature)) {
            this.removeLocalUse(usedD, usingD, feature, minus);
            return;
        }
        this.addLocalUse(usedD, usingD, feature, "");
    }

    private void addLocalUse(Descriptor usedD, Descriptor usingD, EReference feature, String featureSuffix) {
        try {
            if (localDebug) {
                System.out.println("LD> addLocalUse, usingD: " + usingD.getName() + ", usedD: " + usedD.getName() + ", feature: " + feature.getName() + featureSuffix);
            }
            this.addReferenceInfo((MethodElement)usingD, (MethodElement)usedD, DESCRIPTOR_LocalUsingInfo, String.valueOf(feature.getName()) + featureSuffix);
        }
        catch (Throwable e) {
            LibraryEditPlugin.getDefault().getLogger().logError(e);
        }
    }

    public void removeLocalUse(Descriptor usedD, Descriptor usingD, EReference feature) {
        Descriptor greenParent = this.getGreenParentDescriptor(usingD);
        if (greenParent != null && this.localUse(usedD, greenParent, feature)) {
            this.addLocalUse(usedD, usingD, feature, minus);
            return;
        }
        this.removeLocalUse(usedD, usingD, feature, "");
    }

    private void removeLocalUse(Descriptor usedD, Descriptor usingD, EReference feature, String featureSuffix) {
        try {
            this.removeReferenceInfo((MethodElement)usingD, (MethodElement)usedD, DESCRIPTOR_LocalUsingInfo, String.valueOf(feature.getName()) + featureSuffix);
        }
        catch (Throwable e) {
            LibraryEditPlugin.getDefault().getLogger().logError(e);
        }
    }

    public void addLocalUsingInfo(List<Descriptor> deslIst, Descriptor desc, EReference feature) {
        if (!ProcessUtil.isSynFree() || deslIst == null || desc == null || feature == null) {
            return;
        }
        for (Descriptor des : deslIst) {
            this.addLocalUse(des, desc, feature);
        }
    }

    public void removeLocalUsingInfo(List<Descriptor> deslIst, Descriptor desc, EReference feature) {
        if (!ProcessUtil.isSynFree() || deslIst == null || desc == null || feature == null) {
            return;
        }
        for (Descriptor des : deslIst) {
            this.removeLocalUse(des, desc, feature);
        }
    }

    public boolean hasNoValue(String str) {
        return str == null || str.trim().length() == 0;
    }

    protected boolean getCustomization(Descriptor d, int maskBit) {
        int cus;
        Integer cusValue = this.getIntValue((MethodElement)d, DESCRIPTOR_Customization);
        int n = cus = cusValue == null ? 0 : cusValue;
        return (cus & maskBit) > 0;
    }

    protected void setCustomization(Descriptor d, int maskBit, boolean value) {
        boolean oldValue;
        Integer cusValue = this.getIntValue((MethodElement)d, DESCRIPTOR_Customization);
        int cus = cusValue == null ? 0 : cusValue;
        boolean bl = oldValue = (cus & maskBit) > 0;
        if (oldValue == value) {
            return;
        }
        cus = value ? (cus |= maskBit) : (cus ^= maskBit);
        this.setIntValue((MethodElement)d, DESCRIPTOR_Customization, cus);
    }

    public MethodElement getLinkedElement(Descriptor des) {
        return ProcessUtil.getAssociatedElement(des);
    }

    public boolean isValueReplaced(EStructuralFeature feature, Descriptor d) {
        UmaPackage up = UmaPackage.eINSTANCE;
        if (feature == up.getNamedElement_Name()) {
            return this.isNameRepalce(d);
        }
        if (feature == up.getMethodElement_PresentationName()) {
            return this.isPresentationNameRepalce(d);
        }
        if (feature == up.getMethodElement_BriefDescription()) {
            return this.isBriefDesRepalce(d);
        }
        if (feature == up.getDescriptorDescription_RefinedDescription()) {
            return this.isMainDesRepalce(d);
        }
        if (feature == up.getContentDescription_KeyConsiderations()) {
            return this.isKeyConsiderRepalce(d);
        }
        return false;
    }

    public String getGreenParent(Descriptor d) {
        String guid = this.getStringValue((MethodElement)d, DESCRIPTOR_GreenParent);
        if (guid == null || guid.trim().length() == 0) {
            return null;
        }
        return guid;
    }

    public void setGreenParent(Descriptor d, String value) {
        this.setStringValue((MethodElement)d, DESCRIPTOR_GreenParent, value);
    }

    public EReference getExcludeFeature(EReference ref) {
        return LibraryEditUtil.getInstance().getExcludeFeature(ref);
    }

    public boolean checkSelection(List list, Descriptor desc, EReference ref, MethodConfiguration config) {
        int dynamic = 0;
        int dynamicExclude = 0;
        int local = 0;
        int i = 0;
        while (i < list.size()) {
            MethodElement des = (MethodElement)list.get(i);
            if (this.isDynamicAndExclude(des, desc, ref, config)) {
                ++dynamicExclude;
            } else if (this.isDynamic(des, desc, ref)) {
                ++dynamic;
            } else {
                ++local;
            }
            ++i;
        }
        return !(dynamic > 0 && dynamicExclude > 0 || dynamic > 0 && local > 0) && (local <= 0 || dynamicExclude <= 0);
    }

    public boolean CheckSelectionForGuidance(List list, Descriptor desc, MethodConfiguration config) {
        int dynamic = 0;
        int dynamicExclude = 0;
        int local = 0;
        int i = 0;
        while (i < list.size()) {
            EReference ref;
            MethodElement des = (MethodElement)list.get(i);
            if (this.isDynamicAndExclude(des, desc, ref = this.getGuidanceEReference((Guidance)des), config)) {
                ++dynamicExclude;
            } else if (this.isGuidanceDynamic(des, desc, config)) {
                ++dynamic;
            } else {
                ++local;
            }
            ++i;
        }
        return !(dynamic > 0 && dynamicExclude > 0 || dynamic > 0 && local > 0) && (local <= 0 || dynamicExclude <= 0);
    }

    public Descriptor getGreenParentDescriptor(Descriptor des) {
        String guid = this.getGreenParent(des);
        if (guid == null) {
            return null;
        }
        Descriptor parent = (Descriptor)LibraryEditUtil.getInstance().getMethodElement(guid);
        if (!UmaUtil.isInLibrary((MethodElement)parent)) {
            this.setGreenParent(des, "");
            return null;
        }
        this.addToCustomizingChildren(parent, des);
        return parent;
    }

    public void addGreenRefDelta(Descriptor des, MethodElement referenced, EReference feature, boolean positive) {
        String refName = String.valueOf(feature.getName()) + (positive ? plus : minus);
        try {
            this.addReferenceInfo((MethodElement)des, referenced, DESCRIPTOR_GreenRefDelta, refName);
        }
        catch (Throwable e) {
            LibraryEditPlugin.getDefault().getLogger().logError(e);
        }
    }

    public List<MethodElement> getGreenRefDeltaList(Descriptor des, EReference feature, boolean positive) {
        String refName = String.valueOf(feature.getName()) + (positive ? plus : minus);
        try {
            return this.getGreenRefDeltaList_(des, refName);
        }
        catch (Throwable e) {
            LibraryEditPlugin.getDefault().getLogger().logError(e);
            return null;
        }
    }

    public void replaceLocalUseGuidStrings(Descriptor des, Map<String, String> replacedToReplacerMap) {
        this.replaceGuidStrings(des, DESCRIPTOR_LocalUsingInfo, replacedToReplacerMap);
    }

    private void replaceGuidStrings(Descriptor des, String propName, Map<String, String> replacedToReplacerMap) {
        String value = this.getStringValue((MethodElement)des, propName);
        if (value == null || value.length() == 0) {
            return;
        }
        String[] infos = value.split("/");
        if (infos == null || infos.length == 0) {
            return;
        }
        int sz = infos.length / 2;
        HashSet<String> replacedSet = new HashSet<String>();
        int i = 0;
        while (i < sz) {
            String oldGuid = infos[i * 2];
            String newGuid = null;
            if (!replacedSet.contains(oldGuid)) {
                newGuid = replacedToReplacerMap.get(oldGuid);
                replacedSet.add(oldGuid);
            }
            if (newGuid != null) {
                value = value.replaceAll(oldGuid, newGuid);
            }
            ++i;
        }
        this.setStringValue((MethodElement)des, propName, value);
    }

    private List<MethodElement> getGreenRefDeltaList_(Descriptor des, String refName) {
        String value = this.getStringValue((MethodElement)des, DESCRIPTOR_GreenRefDelta);
        if (value == null || value.length() == 0) {
            return null;
        }
        String[] infos = value.split("/");
        if (infos == null || infos.length == 0) {
            return null;
        }
        boolean modified = false;
        String newValue = "";
        ArrayList<MethodElement> deltaList = new ArrayList<MethodElement>();
        int sz = infos.length / 2;
        int i = 0;
        while (i < sz) {
            int i1 = i * 2;
            int i2 = i1 + 1;
            String iGuid = infos[i1];
            String iFeature = infos[i2];
            if (iFeature.equals(refName)) {
                MethodElement element = LibraryEditUtil.getInstance().getMethodElement(iGuid);
                if (element != null && UmaUtil.isInLibrary((MethodElement)element)) {
                    deltaList.add(element);
                    newValue = this.incNewValue(newValue, iGuid, iFeature);
                } else {
                    modified = true;
                }
            } else {
                newValue = this.incNewValue(newValue, iGuid, iFeature);
            }
            ++i;
        }
        if (modified) {
            this.setStringValue((MethodElement)des, DESCRIPTOR_GreenRefDelta, newValue);
        }
        return deltaList;
    }

    public void removeGreenRefDelta(Descriptor des, MethodElement referenced, EReference feature, boolean positive) {
        String refName = String.valueOf(feature.getName()) + (positive ? plus : minus);
        try {
            this.removeReferenceInfo((MethodElement)des, referenced, DESCRIPTOR_GreenRefDelta, refName);
        }
        catch (Throwable e) {
            LibraryEditPlugin.getDefault().getLogger().logError(e);
        }
    }

    public List<? extends Descriptor> getCustomizingChildren(Descriptor des) {
        if (des == null) {
            return null;
        }
        MethodElementExt mext = this.getExtendObject((MethodElement)des, false);
        if (!(mext instanceof DescriptorExt)) {
            return null;
        }
        DescriptorExt ext = (DescriptorExt)mext;
        return ext == null ? null : ext.getCustomizingChildren();
    }

    public void collectCustomizingDescendants(Descriptor des, Set<MethodElement> descendants) {
        List<? extends Descriptor> children = this.getCustomizingChildren(des);
        if (children == null || children.isEmpty()) {
            return;
        }
        for (Descriptor descriptor : children) {
            if (descendants.contains(descriptor)) continue;
            descendants.add((MethodElement)descriptor);
            this.collectCustomizingDescendants(descriptor, descendants);
        }
    }

    public void addToCustomizingChildren(Descriptor parent, Descriptor child) {
        if (parent == null || child == null) {
            return;
        }
        MethodElementExt eObj = this.getExtendObject((MethodElement)parent, true);
        if (eObj instanceof DescriptorExt) {
            DescriptorExt ext = (DescriptorExt)eObj;
            ext.addToCustomizingChildren(child);
        }
    }

    public boolean isDynamicAndExclude(Object obj, Descriptor desc, EReference ref, MethodConfiguration config) {
        return LibraryEditUtil.getInstance().isDynamicAndExclude(obj, desc, ref, config);
    }

    public boolean isDynamic(Object obj, Descriptor desc, EReference ref) {
        return LibraryEditUtil.getInstance().isDynamic(obj, desc, ref);
    }

    public boolean isGuidanceDynamic(Object obj, Descriptor desc, MethodConfiguration config) {
        return LibraryEditUtil.getInstance().isGuidanceDynamic(obj, desc, config);
    }

    public boolean isFromGreenParentLocalList(Object obj, Descriptor desc, EReference ref) {
        Descriptor greenParent;
        return obj instanceof Descriptor && !this.isDynamic(obj, desc, ref) && (greenParent = this.getGreenParentDescriptor(desc)) != null && this.localUse((Descriptor)obj, greenParent, ref);
    }

    public boolean isGuidanceFromGreenParentLocalList(Object obj, Descriptor desc, MethodConfiguration config) {
        Descriptor greenParent;
        return !this.isGuidanceDynamic(obj, desc, config) && (greenParent = this.getGreenParentDescriptor(desc)) != null && !this.isGuidanceDynamic(obj, greenParent, config);
    }

    public boolean isDescriptor(BreakdownElement element) {
        return element instanceof TaskDescriptor || element instanceof RoleDescriptor || element instanceof WorkProductDescriptor;
    }

    public EReference getGuidanceEReference(Guidance item) {
        EReference ref = null;
        if (item instanceof Checklist) {
            ref = UmaPackage.eINSTANCE.getBreakdownElement_Checklists();
        } else if (item instanceof Concept) {
            ref = UmaPackage.eINSTANCE.getBreakdownElement_Concepts();
        } else if (item instanceof Example) {
            ref = UmaPackage.eINSTANCE.getBreakdownElement_Examples();
        } else if (item instanceof SupportingMaterial) {
            ref = UmaPackage.eINSTANCE.getBreakdownElement_SupportingMaterials();
        } else if (item instanceof Guideline) {
            ref = UmaPackage.eINSTANCE.getBreakdownElement_Guidelines();
        } else if (item instanceof ReusableAsset) {
            ref = UmaPackage.eINSTANCE.getBreakdownElement_ReusableAssets();
        } else if (item instanceof Template) {
            ref = UmaPackage.eINSTANCE.getBreakdownElement_Templates();
        } else if (item instanceof Report) {
            ref = UmaPackage.eINSTANCE.getBreakdownElement_Reports();
        } else if (item instanceof ToolMentor) {
            ref = UmaPackage.eINSTANCE.getBreakdownElement_Toolmentor();
        } else if (item instanceof EstimationConsiderations) {
            ref = UmaPackage.eINSTANCE.getBreakdownElement_Estimationconsiderations();
        } else if (item instanceof Practice && PracticePropUtil.getPracticePropUtil().isUdtType((MethodElement)((Practice)item))) {
            ref = UmaUtil.MethodElement_UdtList;
        }
        return ref;
    }

    public void clearAllAutoSynProps(Descriptor des) {
        this.removeProperty((MethodElement)des, DESCRIPTOR_Customization);
        this.removeProperty((MethodElement)des, DESCRIPTOR_LocalUsingInfo);
        this.removeProperty((MethodElement)des, DESCRIPTOR_GreenParent);
        this.removeProperty((MethodElement)des, DESCRIPTOR_GreenRefDelta);
    }
}

