/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.epf.common.utils.StrUtil;
import org.eclipse.epf.library.edit.LibraryEditPlugin;
import org.eclipse.epf.library.edit.meta.TypeDefUtil;
import org.eclipse.epf.library.edit.realization.IRealizationManager;
import org.eclipse.epf.library.edit.util.DescriptorPropUtil;
import org.eclipse.epf.library.edit.util.ExtensionManager;
import org.eclipse.epf.library.edit.util.ILibraryEditUtilProvider;
import org.eclipse.epf.library.edit.util.ModelStructure;
import org.eclipse.epf.library.edit.util.PracticePropUtil;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.library.edit.util.PropUtil;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.edit.util.WorkProductPropUtil;
import org.eclipse.epf.library.edit.util.model.util.StringResource;
import org.eclipse.epf.library.edit.validation.IValidationManager;
import org.eclipse.epf.services.ILibraryPersister;
import org.eclipse.epf.services.Services;
import org.eclipse.epf.uma.CapabilityPattern;
import org.eclipse.epf.uma.ContentElement;
import org.eclipse.epf.uma.ContentPackage;
import org.eclipse.epf.uma.CustomCategory;
import org.eclipse.epf.uma.DeliveryProcess;
import org.eclipse.epf.uma.DescribableElement;
import org.eclipse.epf.uma.Descriptor;
import org.eclipse.epf.uma.Guidance;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.MethodPackage;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.Milestone;
import org.eclipse.epf.uma.Practice;
import org.eclipse.epf.uma.Process;
import org.eclipse.epf.uma.ProcessComponent;
import org.eclipse.epf.uma.ProcessPackage;
import org.eclipse.epf.uma.RoleDescriptor;
import org.eclipse.epf.uma.TaskDescriptor;
import org.eclipse.epf.uma.UmaFactory;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.VariabilityElement;
import org.eclipse.epf.uma.WorkBreakdownElement;
import org.eclipse.epf.uma.WorkProduct;
import org.eclipse.epf.uma.WorkProductDescriptor;
import org.eclipse.epf.uma.ecore.impl.MultiResourceEObject;
import org.eclipse.epf.uma.ecore.util.OppositeFeature;
import org.eclipse.epf.uma.util.AssociationHelper;
import org.eclipse.epf.uma.util.ExtendedReference;
import org.eclipse.epf.uma.util.ModifiedTypeMeta;
import org.eclipse.epf.uma.util.UmaUtil;
import org.eclipse.epf.uma.util.UserDefinedTypeMeta;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LibraryEditUtil {
    private static boolean debug = false;
    private static LibraryEditUtil instance = new LibraryEditUtil();
    private IRealizationManager defaultRealizationManager;
    private ILibraryEditUtilProvider provider;
    private boolean junitTest = false;
    private static Map<EReference, EReference> taskGuidanceRefMap;
    private static Map<EReference, EReference> roleGuidanceRefMap;
    private static Map<EReference, EReference> workproductGuidanceRefMap;
    private static UmaPackage up;
    private static Set<EReference> autoSynReferences;

    static {
        up = UmaPackage.eINSTANCE;
    }

    public static LibraryEditUtil getInstance() {
        return instance;
    }

    private LibraryEditUtil() {
    }

    public ILibraryEditUtilProvider getProvider() {
        if (this.provider == null) {
            this.provider = ExtensionManager.getLibraryEditUtilProvider();
        }
        return this.provider;
    }

    public IValidationManager getValidationManager() {
        ILibraryEditUtilProvider p = this.getProvider();
        return p == null ? null : p.getValidationManager();
    }

    public IRealizationManager getDefaultRealizationManager() {
        return ProcessUtil.isSynFree() ? this.defaultRealizationManager : null;
    }

    public void setDefaultRealizationManager(IRealizationManager defaultRealizationManager) {
        this.defaultRealizationManager = defaultRealizationManager;
    }

    public Set<Descriptor> collectDescriptors(Process process) {
        HashSet<Descriptor> descriptors = new HashSet<Descriptor>();
        EObject container = process.eContainer();
        if (!(container instanceof ProcessComponent)) {
            return descriptors;
        }
        TreeIterator iter = container.eAllContents();
        while (iter.hasNext()) {
            EObject element = (EObject)iter.next();
            if (!(element instanceof Descriptor)) continue;
            descriptors.add((Descriptor)element);
        }
        return descriptors;
    }

    public Set<Process> collectProcesses(MethodElement libOrPlugin) {
        HashSet<Process> processes = new HashSet<Process>();
        if (!(libOrPlugin instanceof MethodLibrary) && !(libOrPlugin instanceof MethodPlugin)) {
            return processes;
        }
        TreeIterator iter = libOrPlugin.eAllContents();
        while (iter.hasNext()) {
            EObject element = (EObject)iter.next();
            if (!(element instanceof Process)) continue;
            this.collectProcess((Process)element, processes);
        }
        return processes;
    }

    private void collectProcess(Process process, Set<Process> processes) {
        if ((process instanceof CapabilityPattern || process instanceof DeliveryProcess) && process.eContainer() instanceof ProcessComponent) {
            processes.add(process);
        }
    }

    public Set<Process> collectProcessesFromConfig(MethodConfiguration config) {
        HashSet<Process> result = new HashSet<Process>();
        List plugins = config.getMethodPluginSelection();
        int i = 0;
        while (i < plugins.size()) {
            Set<Process> set = this.collectProcesses((MethodElement)plugins.get(i));
            result.addAll(set);
            ++i;
        }
        return result;
    }

    public boolean isSynFree() {
        ILibraryEditUtilProvider p = this.getProvider();
        return p == null ? true : p.isSynFree();
    }

    public MethodElement getMethodElement(String guid) {
        return this.getMethodElement(guid, true);
    }

    public MethodElement getMethodElement(String guid, boolean skipContent) {
        ILibraryEditUtilProvider p = this.getProvider();
        return p == null ? null : p.getMethodElement(guid, skipContent);
    }

    public String getPresentationName(MethodElement element, MethodConfiguration config) {
        String pName = element.getPresentationName();
        if (!StrUtil.isBlank((String)pName)) {
            return pName;
        }
        ILibraryEditUtilProvider p = this.getProvider();
        if (p == null) {
            return pName;
        }
        return p.getPresentationName(element, config);
    }

    public boolean isDynamicAndExclude(Object obj, Descriptor desc, EReference ref, MethodConfiguration config) {
        return this.getProvider().isDynamicAndExclude(obj, desc, ref, config);
    }

    public boolean isDynamic(Object obj, Descriptor desc, EReference ref) {
        return this.getProvider().isDynamic(obj, desc, ref);
    }

    public MethodLibrary getCurrentMethodLibrary() {
        return this.getProvider().getCurrentMethodLibrary();
    }

    public boolean isGuidanceDynamic(Object obj, Descriptor desc, MethodConfiguration config) {
        return this.getProvider().isGuidanceDynamic(obj, desc, config);
    }

    public EReference getExcludeFeature(EReference ref) {
        if (ref == up.getTaskDescriptor_PerformedPrimarilyBy()) {
            return up.getTaskDescriptor_PerformedPrimarilyByExcluded();
        }
        if (ref == up.getTaskDescriptor_AdditionallyPerformedBy()) {
            return up.getTaskDescriptor_AdditionallyPerformedByExclude();
        }
        if (ref == up.getTaskDescriptor_MandatoryInput()) {
            return up.getTaskDescriptor_MandatoryInputExclude();
        }
        if (ref == up.getTaskDescriptor_OptionalInput()) {
            return up.getTaskDescriptor_OptionalInputExclude();
        }
        if (ref == up.getTaskDescriptor_Output()) {
            return up.getTaskDescriptor_OutputExclude();
        }
        if (ref == up.getTaskDescriptor_SelectedSteps()) {
            return up.getTaskDescriptor_SelectedStepsExclude();
        }
        if (ref == up.getRoleDescriptor_ResponsibleFor()) {
            return up.getRoleDescriptor_ResponsibleForExclude();
        }
        if (ref == up.getWorkProductDescriptor_DeliverableParts()) {
            return up.getWorkProductDescriptor_DeliverablePartsExclude();
        }
        if (ref == up.getBreakdownElement_Checklists() || ref == up.getBreakdownElement_Concepts() || ref == up.getBreakdownElement_Examples() || ref == up.getBreakdownElement_SupportingMaterials() || ref == up.getBreakdownElement_Guidelines() || ref == up.getBreakdownElement_ReusableAssets() || ref == up.getBreakdownElement_Templates() || ref == up.getBreakdownElement_Reports() || ref == up.getBreakdownElement_Toolmentor() || ref == up.getBreakdownElement_Estimationconsiderations() || ref == UmaUtil.MethodElement_UdtList) {
            return up.getDescriptor_GuidanceExclude();
        }
        return null;
    }

    public EReference getLinkedElementFeature(EReference descriptorRef) {
        if (descriptorRef == up.getTaskDescriptor_PerformedPrimarilyBy()) {
            return up.getTask_PerformedBy();
        }
        if (descriptorRef == up.getTaskDescriptor_AdditionallyPerformedBy()) {
            return up.getTask_AdditionallyPerformedBy();
        }
        if (descriptorRef == up.getTaskDescriptor_MandatoryInput()) {
            return up.getTask_MandatoryInput();
        }
        if (descriptorRef == up.getTaskDescriptor_OptionalInput()) {
            return up.getTask_OptionalInput();
        }
        if (descriptorRef == up.getTaskDescriptor_Output()) {
            return up.getTask_Output();
        }
        if (descriptorRef == up.getTaskDescriptor_SelectedSteps()) {
            return up.getTask_Steps();
        }
        if (descriptorRef == up.getRoleDescriptor_ResponsibleFor()) {
            return up.getRole_ResponsibleFor();
        }
        if (descriptorRef == up.getWorkProductDescriptor_DeliverableParts()) {
            return up.getDeliverable_DeliveredWorkProducts();
        }
        return null;
    }

    public boolean isJunitTest() {
        return this.junitTest;
    }

    public void setJunitTest(boolean junitTest) {
        this.junitTest = junitTest;
    }

    public List<EReference> getExcludeRefList(Descriptor des) {
        ArrayList<EReference> list = new ArrayList<EReference>();
        if (des instanceof TaskDescriptor) {
            list.add(up.getTaskDescriptor_PerformedPrimarilyByExcluded());
            list.add(up.getTaskDescriptor_AdditionallyPerformedByExclude());
            list.add(up.getTaskDescriptor_MandatoryInputExclude());
            list.add(up.getTaskDescriptor_OptionalInputExclude());
            list.add(up.getTaskDescriptor_OutputExclude());
        } else if (des instanceof RoleDescriptor) {
            list.add(up.getRoleDescriptor_ResponsibleForExclude());
        } else if (des instanceof WorkProductDescriptor) {
            list.add(up.getWorkProductDescriptor_DeliverablePartsExclude());
        }
        return list;
    }

    public boolean isGuidanceListReference(EReference ref) {
        if (ref.isContainment() || !ref.isMany()) {
            return false;
        }
        if (ref == UmaPackage.eINSTANCE.getDescriptor_GuidanceAdditional() || ref == UmaPackage.eINSTANCE.getDescriptor_GuidanceExclude()) {
            return false;
        }
        if (ref.getEType() instanceof EClass) {
            EObject obj = null;
            try {
                obj = UmaFactory.eINSTANCE.create((EClass)ref.getEType());
            }
            catch (Exception exception) {
                return false;
            }
            return obj instanceof Guidance;
        }
        return false;
    }

    public synchronized Map<EReference, EReference> getGuidanceRefMap(EClass cls) {
        if (cls == up.getTask()) {
            if (taskGuidanceRefMap == null) {
                taskGuidanceRefMap = this.buildGuidanceMap(cls, up.getTaskDescriptor());
            }
            return taskGuidanceRefMap;
        }
        if (cls == up.getRole()) {
            if (roleGuidanceRefMap == null) {
                roleGuidanceRefMap = this.buildGuidanceMap(cls, up.getRoleDescriptor());
            }
            return roleGuidanceRefMap;
        }
        if (up.getWorkProduct().isSuperTypeOf(cls)) {
            if (workproductGuidanceRefMap == null) {
                workproductGuidanceRefMap = this.buildGuidanceMap(up.getWorkProduct(), up.getWorkProductDescriptor());
            }
            return workproductGuidanceRefMap;
        }
        return null;
    }

    private Map<EReference, EReference> buildGuidanceMap(EClass cls, EClass desCls) {
        HashMap<EReference, EReference> resultMap = new HashMap<EReference, EReference>();
        HashMap<EClassifier, EReference> map = new HashMap<EClassifier, EReference>();
        for (EReference ref : desCls.getEAllReferences()) {
            if (!this.isGuidanceListReference(ref)) continue;
            map.put(ref.getEType(), ref);
        }
        for (EReference ref : cls.getEAllReferences()) {
            EReference value;
            if (!this.isGuidanceListReference(ref) || (value = (EReference)map.get(ref.getEType())) == null) continue;
            resultMap.put(ref, value);
        }
        resultMap.put(UmaUtil.MethodElement_UdtList, UmaUtil.MethodElement_UdtList);
        return resultMap;
    }

    public void addOppositeFeature(MethodElement referencing, MethodElement referenced, EStructuralFeature feature) {
        if (referencing == null || referenced == null) {
            return;
        }
        ExtendedReference eRef = TypeDefUtil.getInstance().getAssociatedExtendedReference(feature);
        if (eRef != null) {
            PropUtil.getPropUtil().addOpposite(eRef.getGlobalId(), referencing, referenced);
            return;
        }
        OppositeFeature oppositeFeature = OppositeFeature.getOppositeFeature((EStructuralFeature)feature);
        if (oppositeFeature == null) {
            return;
        }
        MultiResourceEObject mreferenced = (MultiResourceEObject)referenced;
        mreferenced.oppositeAdd(oppositeFeature, (Object)referencing);
    }

    public void removeOppositeFeature(MethodElement referencing, MethodElement referenced, EStructuralFeature feature) {
        if (referencing == null || referenced == null) {
            return;
        }
        ExtendedReference eRef = TypeDefUtil.getInstance().getAssociatedExtendedReference(feature);
        if (eRef != null) {
            PropUtil.getPropUtil().removeOpposite(eRef.getGlobalId(), referencing, referenced);
            return;
        }
        OppositeFeature oppositeFeature = OppositeFeature.getOppositeFeature((EStructuralFeature)feature);
        if (oppositeFeature == null) {
            return;
        }
        MultiResourceEObject mreferenced = (MultiResourceEObject)referenced;
        mreferenced.oppositeRemove(oppositeFeature, (Object)referencing);
    }

    public Set<? extends VariabilityElement> collectVariabilityRelatives(VariabilityElement element) {
        HashSet<VariabilityElement> results = new HashSet<VariabilityElement>();
        this.collectVariabilityRelatives(element, results);
        return results;
    }

    private void collectVariabilityRelatives(VariabilityElement element, Set<VariabilityElement> results) {
        if (element == null || results.contains(element)) {
            return;
        }
        results.add(element);
        VariabilityElement base = element.getVariabilityBasedOnElement();
        if (base != null) {
            this.collectVariabilityRelatives(base, results);
        }
        for (VariabilityElement v : AssociationHelper.getImmediateVarieties((VariabilityElement)element)) {
            this.collectVariabilityRelatives(v, results);
        }
    }

    public IRealizationManager getRealizationManager(MethodConfiguration config) {
        ILibraryEditUtilProvider p = this.getProvider();
        return p == null ? null : p.getRealizationManager(config);
    }

    public void removeAutoSynReferences(Process proc) {
        Set<Descriptor> desSet = LibraryEditUtil.getInstance().collectDescriptors(proc);
        for (Descriptor des : desSet) {
            this.removeAutoSynReferences(des);
        }
    }

    private void removeAutoSynReferences(Descriptor des) {
        if (autoSynReferences == null) {
            autoSynReferences = new HashSet<EReference>();
            autoSynReferences.add(up.getTaskDescriptor_PerformedPrimarilyByExcluded());
            autoSynReferences.add(up.getTaskDescriptor_AdditionallyPerformedByExclude());
            autoSynReferences.add(up.getTaskDescriptor_MandatoryInputExclude());
            autoSynReferences.add(up.getTaskDescriptor_OptionalInputExclude());
            autoSynReferences.add(up.getTaskDescriptor_OutputExclude());
            autoSynReferences.add(up.getRoleDescriptor_ResponsibleForExclude());
            autoSynReferences.add(up.getWorkProductDescriptor_DeliverablePartsExclude());
            autoSynReferences.add(up.getDescriptor_GuidanceExclude());
        }
        boolean oldDeliver = des.eDeliver();
        try {
            des.eSetDeliver(false);
            for (EReference ref : des.eClass().getEAllReferences()) {
                List list;
                if (!autoSynReferences.contains(ref) || (list = (List)des.eGet((EStructuralFeature)ref)) == null || list.isEmpty()) continue;
                list.clear();
            }
            DescriptorPropUtil.getDesciptorPropUtil().clearAllAutoSynProps(des);
        }
        finally {
            des.eSetDeliver(oldDeliver);
        }
    }

    public MethodElement getCalcualtedElement(MethodElement element, MethodConfiguration config) {
        ILibraryEditUtilProvider p = this.getProvider();
        return p == null ? element : p.getCalculatedElement(element, config);
    }

    public boolean inConfig(MethodElement element, MethodConfiguration config) {
        ILibraryEditUtilProvider p = this.getProvider();
        return p == null ? false : p.inConfig(element, config);
    }

    private void collectElements(MethodElement element, CollectElementFilter filter, Set<MethodElement> collected, Set<MethodElement> processed) {
        if (processed.contains(element)) {
            return;
        }
        processed.add(element);
        if (filter.accept(element)) {
            collected.add(element);
        }
        if (filter.skipChildren(element)) {
            return;
        }
        EList refList = element.eClass().getEAllContainments();
        if (refList == null || refList.isEmpty()) {
            return;
        }
        for (EReference ref : refList) {
            if (ref == UmaPackage.eINSTANCE.getDescribableElement_Presentation()) continue;
            Object obj = element.eGet((EStructuralFeature)ref);
            if (obj instanceof MethodElement) {
                this.collectElements((MethodElement)obj, filter, collected, processed);
                continue;
            }
            if (!(obj instanceof List)) continue;
            List list = (List)obj;
            for (Object itemObj : list) {
                if (!(itemObj instanceof MethodElement)) continue;
                this.collectElements((MethodElement)itemObj, filter, collected, processed);
            }
        }
    }

    public Set<? extends MethodElement> getFilteredElements(MethodConfiguration config, CollectElementFilter filter) {
        HashSet<? extends MethodElement> set = new HashSet<MethodElement>();
        for (MethodPlugin plugin : config.getMethodPluginSelection()) {
            set.addAll(this.getElementsUnder((MethodElement)plugin, filter));
        }
        return set;
    }

    public Set<? extends MethodElement> getElementsUnder(MethodElement topElement, CollectElementFilter filter) {
        HashSet<MethodElement> set = new HashSet<MethodElement>();
        this.collectElements(topElement, filter, set, new HashSet<MethodElement>());
        return set;
    }

    public Set<WorkProduct> getAllWorkProducts(MethodElement topElement) {
        CollectElementFilter filter = new CollectElementFilter(){

            public boolean accept(MethodElement element) {
                return element instanceof WorkProduct;
            }

            public boolean skipChildren(MethodElement element) {
                if (element instanceof ProcessPackage) {
                    return true;
                }
                return super.skipChildren(element);
            }
        };
        return this.getElementsUnder(topElement, filter);
    }

    public Set<Practice> getAllPractices(MethodElement topElement) {
        CollectElementFilter filter = new CollectElementFilter(){

            public boolean accept(MethodElement element) {
                return element instanceof Practice;
            }

            public boolean skipChildren(MethodElement element) {
                if (element instanceof ProcessPackage) {
                    return true;
                }
                return super.skipChildren(element);
            }
        };
        return this.getElementsUnder(topElement, filter);
    }

    public Set<? extends DescribableElement> getTypedElements(MethodElement topElement, final EClass type) {
        final boolean processElementType = UmaPackage.eINSTANCE.getProcessElement().isSuperTypeOf(type);
        CollectElementFilter filter = new CollectElementFilter(){

            public boolean accept(MethodElement element) {
                return type.isSuperTypeOf(element.eClass());
            }

            public boolean skipChildren(MethodElement element) {
                if (element instanceof ProcessPackage) {
                    return !processElementType;
                }
                if (element instanceof ContentPackage) {
                    if (processElementType) {
                        return !element.getName().equals("Content") && !(element.eContainer() instanceof MethodPlugin);
                    }
                    return false;
                }
                return super.skipChildren(element);
            }
        };
        return this.getElementsUnder(topElement, filter);
    }

    public Map<UserDefinedTypeMeta, Set<Practice>> getUdtInstanceMap(MethodLibrary lib, Collection<UserDefinedTypeMeta> metas) {
        HashMap<UserDefinedTypeMeta, Set<Practice>> map = new HashMap<UserDefinedTypeMeta, Set<Practice>>();
        if (lib == null || metas == null || metas.isEmpty()) {
            return map;
        }
        HashMap<String, UserDefinedTypeMeta> idMetaMap = new HashMap<String, UserDefinedTypeMeta>();
        for (UserDefinedTypeMeta meta : metas) {
            idMetaMap.put(meta.getId(), meta);
        }
        HashSet<Practice> practices = new HashSet<Practice>();
        for (MethodPlugin plugin : lib.getMethodPlugins()) {
            practices.addAll(this.getAllPractices((MethodElement)plugin));
        }
        PracticePropUtil propUtil = PracticePropUtil.getPracticePropUtil();
        for (Practice practice : practices) {
            UserDefinedTypeMeta oldMeta = propUtil.getUdtMeta(practice);
            if (oldMeta == null) continue;
            UserDefinedTypeMeta meta = (UserDefinedTypeMeta)idMetaMap.get(oldMeta.getId());
            if (meta != null && !meta.same(oldMeta)) {
                this.addToMap(map, practice, meta);
                continue;
            }
            if (meta != null) continue;
            meta = UserDefinedTypeMeta.noneValue;
            this.addToMap(map, practice, meta);
        }
        return map;
    }

    private void addToMap(Map<UserDefinedTypeMeta, Set<Practice>> map, Practice practice, UserDefinedTypeMeta meta) {
        Set<Practice> set = map.get(meta);
        if (set == null) {
            set = new HashSet<Practice>();
            map.put(meta, set);
        }
        set.add(practice);
    }

    public static boolean save(Collection<Resource> resouresToSave) {
        ILibraryPersister.FailSafeMethodLibraryPersister persister = Services.getDefaultLibraryPersister().getFailSafePersister();
        try {
            HashSet<Resource> seens = new HashSet<Resource>();
            for (Resource res : resouresToSave) {
                if (seens.contains(res)) continue;
                persister.save(res);
                seens.add(res);
            }
            persister.commit();
        }
        catch (Exception exception) {
            persister.rollback();
            return false;
        }
        return true;
    }

    public void fixUpDanglingCustomCategories(MethodLibrary library) {
        if (library == null) {
            return;
        }
        for (MethodPlugin plugin : library.getMethodPlugins()) {
            this.fixUpDanglingCustomCategories(plugin);
        }
    }

    public void fixUpDanglingCustomCategories(MethodPlugin plugin) {
        ContentPackage customCategoryPkg = UmaUtil.findContentPackage((MethodPlugin)plugin, (String[])ModelStructure.DEFAULT.customCategoryPath);
        if (customCategoryPkg == null) {
            return;
        }
        CustomCategory rootCC = TngUtil.getRootCustomCategory(plugin);
        if (rootCC == null) {
            return;
        }
        HashSet<CustomCategory> ccSet = new HashSet<CustomCategory>();
        this.addToCCSet(rootCC.getCategorizedElements(), ccSet);
        for (ContentElement element : customCategoryPkg.getContentElements()) {
            if (!(element instanceof CustomCategory)) continue;
            this.addToCCSet(((CustomCategory)element).getCategorizedElements(), ccSet);
        }
        for (ContentElement element : customCategoryPkg.getContentElements()) {
            if (!(element instanceof CustomCategory) || ccSet.contains(element)) continue;
            rootCC.getCategorizedElements().add(element);
        }
    }

    private void addToCCSet(List<DescribableElement> list, Set<CustomCategory> ccSet) {
        for (DescribableElement element : list) {
            if (!(element instanceof CustomCategory)) continue;
            ccSet.add((CustomCategory)element);
        }
    }

    public boolean isContainedBy(MethodElement element, MethodElement container, MethodConfiguration config) {
        if (element == null || container == null) {
            return false;
        }
        if (UmaUtil.isContainedBy((EObject)element, (Object)container)) {
            return true;
        }
        if (config == null) {
            return false;
        }
        EObject parent = element.eContainer();
        while (parent instanceof VariabilityElement) {
            MethodElement parentElement = this.getCalcualtedElement((MethodElement)((VariabilityElement)parent), config);
            if (parentElement == container) {
                return true;
            }
            EObject eObject = parent = parentElement == null ? null : parentElement.eContainer();
        }
        return parent == container;
    }

    public List<MethodElement> calc0nFeatureValue(MethodElement element, EStructuralFeature feature, MethodConfiguration config) {
        return this.getProvider() == null ? null : this.getProvider().calc0nFeatureValue(element, feature, config);
    }

    public List<MethodElement> calc0nFeatureValue(MethodElement element, OppositeFeature feature, MethodConfiguration config) {
        return this.getProvider() == null ? null : this.getProvider().calc0nFeatureValue(element, feature, config);
    }

    public void fixWpStates(Collection<? extends MethodElement> elements, Set<Resource> modifeiedResources) {
        try {
            this.fixWpStates_(elements, modifeiedResources);
        }
        catch (Throwable e) {
            LibraryEditPlugin.getDefault().getLogger().logError(e);
        }
    }

    private void fixWpStates_(Collection<? extends Object> elements, Set<Resource> modifeiedResources) {
        WorkProductPropUtil wpPropUtil = WorkProductPropUtil.getWorkProductPropUtil();
        for (Object object : elements) {
            if (!(object instanceof WorkProduct)) continue;
            WorkProduct wp = (WorkProduct)object;
            wpPropUtil.fixWorkProductStates(wp, modifeiedResources);
        }
        for (Object object : elements) {
            if (!(object instanceof TaskDescriptor) && !(object instanceof Milestone)) continue;
            WorkBreakdownElement cfr_ignored_0 = (WorkBreakdownElement)object;
        }
    }

    public void fixProcssWpStates(Collection<? extends MethodElement> elements, Set<Resource> modifeiedResources) {
        try {
            this.fixProcessWpStates_(elements, modifeiedResources);
        }
        catch (Throwable e) {
            LibraryEditPlugin.getDefault().getLogger().logError(e);
        }
    }

    private void fixProcessWpStates_(Collection<? extends Object> elements, Set<Resource> modifeiedResources) {
        WorkProductPropUtil wpPropUtil = WorkProductPropUtil.getWorkProductPropUtil();
        for (Object object : elements) {
            WorkProductPropUtil.fixProcessWpStates(object, modifeiedResources);
        }
    }

    public void createUserDefinedTypeContextMenuOnGuidanceNode(Collection<Object> newChildDescriptors) {
        this.getProvider().createUserDefinedTypeContextMenuOnGuidanceNode(newChildDescriptors);
    }

    public Collection<UserDefinedTypeMeta> getUserDefinedTypes() {
        return this.getProvider() == null ? null : this.getProvider().getUserDefinedTypes();
    }

    public UserDefinedTypeMeta getUserDefineType(String id) {
        return this.getProvider() == null ? null : this.getProvider().getUserDefineType(id);
    }

    public ModifiedTypeMeta getModifiedType(String id) {
        return this.getProvider() == null ? null : this.getProvider().getModifiedType(id);
    }

    public Collection<ModifiedTypeMeta> getModifiedTypes() {
        return this.getProvider() == null ? null : this.getProvider().getModifiedTypes();
    }

    public MethodPackage getCoreContentPackage(MethodPlugin plugin) {
        String[] path = new String[]{"Content", "CoreContent"};
        MethodPackage pkg = UmaUtil.findMethodPackage((MethodPlugin)plugin, (String[])path);
        return pkg;
    }

    public List<CustomCategory> getRootLevelCustomCategories(MethodPlugin plugin) {
        ArrayList<CustomCategory> list = new ArrayList<CustomCategory>();
        CustomCategory topRoot = TngUtil.getRootCustomCategory(plugin);
        if (topRoot != null) {
            for (DescribableElement element : topRoot.getCategorizedElements()) {
                if (!(element instanceof CustomCategory)) continue;
                list.add((CustomCategory)element);
            }
        }
        return list;
    }

    public String getXmiString(EObject obj) {
        if (obj == null) {
            return "";
        }
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("ENCODING", "ASCII");
        StringResource res = new StringResource(null);
        res.getContents().add((Object)EcoreUtil.copy((EObject)obj));
        try {
            res.save(options);
        }
        catch (Exception e) {
            LibraryEditPlugin.getDefault().getLogger().logError((Throwable)e);
        }
        return res.getString();
    }

    public EObject loadObject(String xmiString) {
        if (xmiString == null || xmiString.length() == 0) {
            return null;
        }
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("ENCODING", "ASCII");
        StringResource res = new StringResource(xmiString);
        try {
            res.load(options);
            return (EObject)res.getContents().get(0);
        }
        catch (Exception e) {
            LibraryEditPlugin.getDefault().getLogger().logError((Throwable)e);
            return null;
        }
    }

    public static class CollectElementFilter {
        public boolean accept(MethodElement element) {
            return true;
        }

        public boolean skipChildren(MethodElement element) {
            if (element instanceof MethodLibrary) {
                return false;
            }
            if (element instanceof MethodPlugin) {
                return false;
            }
            return !(element instanceof MethodPackage);
        }
    }

    public static class CollectElementFilterExtend
    extends CollectElementFilter {
        public boolean accept(MethodElement element) {
            if (element instanceof MethodPlugin) {
                return false;
            }
            if (element instanceof MethodPackage) {
                return false;
            }
            if (element instanceof MethodConfiguration) {
                return false;
            }
            return !(element instanceof MethodLibrary);
        }
    }
}

