/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.epf.library.edit.util.LibraryEditUtil;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.edit.util.model.OrderInfo;
import org.eclipse.epf.uma.ContentCategory;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.VariabilityElement;
import org.eclipse.epf.uma.VariabilityType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManualSort {
    private static Comparator<OrderInfo> orderInfoComp = new Comparator<OrderInfo>(){

        @Override
        public int compare(OrderInfo o1, OrderInfo o2) {
            long t2;
            long t1 = o1.getTimestamp();
            if (t1 < (t2 = o2.getTimestamp())) {
                return -1;
            }
            if (t2 < t1) {
                return 1;
            }
            return 0;
        }
    };

    public List<Object> sort(ContentCategory cc, List<Object> elementList, EStructuralFeature feature, MethodConfiguration config) {
        ArrayList<OrderInfo> orderInfoList = new ArrayList<OrderInfo>();
        Iterator iter = TngUtil.getContributors((VariabilityElement)cc);
        while (iter.hasNext()) {
            OrderInfo orderInfo;
            Object obj = iter.next();
            if (!(obj instanceof ContentCategory)) continue;
            ContentCategory contributor = (ContentCategory)obj;
            if (config != null && !LibraryEditUtil.getInstance().inConfig((MethodElement)contributor, config) || (orderInfo = TngUtil.getOrderInfo((MethodElement)contributor, "content elements")) == null) continue;
            orderInfoList.add(orderInfo);
        }
        if (orderInfoList.size() == 1) {
            return this.sort(elementList, (OrderInfo)orderInfoList.get(0));
        }
        OrderInfo orderInfo = TngUtil.getOrderInfo((MethodElement)cc, "content elements");
        elementList = this.sort(elementList, orderInfo);
        if (orderInfoList.isEmpty()) {
            return elementList;
        }
        Collections.sort(orderInfoList, orderInfoComp);
        SortData sortData = new SortData(cc, elementList, feature);
        for (OrderInfo info : orderInfoList) {
            sortData.processOrderInfo(info);
        }
        return sortData.getSortedList();
    }

    private List<Object> sort(List<Object> elementList, OrderInfo orderInfo) {
        if (orderInfo == null) {
            return elementList;
        }
        HashMap<String, MethodElement> guidMap = new HashMap<String, MethodElement>();
        for (Object obj : elementList) {
            if (!(obj instanceof MethodElement)) continue;
            guidMap.put(((MethodElement)obj).getGuid(), (MethodElement)obj);
        }
        ArrayList<Object> returnList = new ArrayList<Object>();
        for (String guid : orderInfo.getGUIDs()) {
            Object element = guidMap.get(guid);
            if (element == null) continue;
            returnList.add(element);
            guidMap.remove(guid);
        }
        for (Object obj : elementList) {
            if (obj instanceof MethodElement) {
                if (!guidMap.containsKey(((MethodElement)obj).getGuid())) continue;
                returnList.add(obj);
                continue;
            }
            returnList.add(obj);
        }
        return returnList;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SortData {
        private Map<String, MethodElement> guidMap;
        private Set<String> processedGuidSet;
        private LinkedHashMap<String, List<MethodElement>> orderedMap;
        private List<Object> elementList;

        public SortData(ContentCategory cc, List<Object> elementList, EStructuralFeature feature) {
            this.elementList = elementList;
            HashSet<String> baseCategorizedElementGuids = new HashSet<String>();
            Object base = cc;
            while (base != null) {
                this.addToBaseCategorizedElementGuids(feature, (Set<String>)baseCategorizedElementGuids, (ContentCategory)base);
                if (base != cc) {
                    Iterator iter = TngUtil.getContributors((VariabilityElement)base);
                    while (iter.hasNext()) {
                        Object obj = iter.next();
                        if (!(obj instanceof ContentCategory)) continue;
                        ContentCategory contributor = (ContentCategory)obj;
                        this.addToBaseCategorizedElementGuids(feature, baseCategorizedElementGuids, contributor);
                    }
                }
                base = base.getVariabilityType() == VariabilityType.EXTENDS || base.getVariabilityType() == VariabilityType.EXTENDS_REPLACES ? (ContentCategory)base.getVariabilityBasedOnElement() : null;
            }
            this.guidMap = new HashMap<String, MethodElement>();
            this.orderedMap = new LinkedHashMap();
            for (Object obj : elementList) {
                if (!(obj instanceof MethodElement)) continue;
                MethodElement element = (MethodElement)obj;
                String guid = element.getGuid();
                this.guidMap.put(guid, element);
                if (!baseCategorizedElementGuids.contains(guid)) continue;
                ArrayList list = new ArrayList();
                this.orderedMap.put(guid, list);
            }
            this.processedGuidSet = new HashSet<String>();
        }

        private void addToBaseCategorizedElementGuids(EStructuralFeature feature, Set<String> baseCategorizedElementGuids, ContentCategory cc) {
            Object value = cc.eGet(feature);
            if (value instanceof List) {
                for (Object obj : (List)value) {
                    if (!(obj instanceof MethodElement)) continue;
                    baseCategorizedElementGuids.add(((MethodElement)obj).getGuid());
                }
            }
        }

        public void processOrderInfo(OrderInfo orderInfo) {
            ArrayList<MethodElement> addedList = new ArrayList<MethodElement>();
            for (String guid : orderInfo.getGUIDs()) {
                List<MethodElement> list;
                MethodElement element = this.guidMap.get(guid);
                if (element == null) continue;
                boolean processed = this.processedGuidSet.contains(guid);
                if (!processed) {
                    this.processedGuidSet.add(guid);
                    addedList.add(element);
                }
                if ((list = this.orderedMap.get(guid)) == null) continue;
                addedList.addAll(list);
                this.orderedMap.put(guid, addedList);
                addedList = new ArrayList();
            }
        }

        public List<Object> getSortedList() {
            ArrayList<Object> sortedList = new ArrayList<Object>();
            for (Map.Entry<String, List<MethodElement>> entry : this.orderedMap.entrySet()) {
                String guid = entry.getKey();
                List<MethodElement> list = entry.getValue();
                if (list.isEmpty()) {
                    sortedList.add(this.guidMap.get(guid));
                    continue;
                }
                for (MethodElement element : list) {
                    sortedList.add(element);
                }
            }
            for (Object obj : this.elementList) {
                if (obj instanceof MethodElement) {
                    if (this.processedGuidSet.contains(((MethodElement)obj).getGuid())) continue;
                    sortedList.add(obj);
                    continue;
                }
                sortedList.add(obj);
            }
            return sortedList;
        }
    }
}

