/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.util;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.epf.common.serviceability.Logger;
import org.eclipse.epf.common.utils.StrUtil;
import org.eclipse.epf.library.edit.LibraryEditPlugin;
import org.eclipse.epf.library.edit.command.IUserInteractionHandler;
import org.eclipse.epf.library.edit.util.ExtensionManager;

public class Messenger
implements IUserInteractionHandler.IMessenger {
    public static final Messenger INSTANCE = new Messenger();
    private static final String NEW_LINE = System.getProperty("line.separator", "\n");
    private IUserInteractionHandler.IMessenger delegate;
    private Logger logger = LibraryEditPlugin.getDefault().getLogger();

    private Messenger() {
        IUserInteractionHandler uiHandler = ExtensionManager.getDefaultUserInteractionHandler();
        if (uiHandler != null) {
            this.delegate = uiHandler.getMessenger();
        }
    }

    public void showError(String title, String msg) {
        if (this.delegate != null) {
            this.delegate.showError(title, msg);
        } else {
            StringBuffer strBuf = new StringBuffer(title);
            if (!StrUtil.isBlank((String)msg)) {
                strBuf.append(NEW_LINE).append(msg);
            }
            this.logger.logError(strBuf.toString());
        }
    }

    public void showError(String title, String msg, IStatus status) {
        if (this.delegate != null) {
            this.delegate.showError(title, msg, status);
        } else {
            LibraryEditPlugin.getDefault().getLog().log(status);
        }
    }

    public void showError(String title, String msg, String reason, Exception exception) {
        if (this.delegate != null) {
            this.delegate.showError(title, msg, reason, exception);
        } else {
            StringBuffer strBuf = new StringBuffer(title);
            if (!StrUtil.isBlank((String)msg)) {
                strBuf.append(NEW_LINE).append(msg);
            }
            this.logger.logError(strBuf.toString(), (Throwable)exception);
        }
    }

    public void showWarning(String title, String msg) {
        if (this.delegate != null) {
            this.delegate.showWarning(title, msg);
        } else {
            StringBuffer strBuf = new StringBuffer(title);
            if (!StrUtil.isBlank((String)msg)) {
                strBuf.append(NEW_LINE).append(msg);
            }
            this.logger.logWarning(strBuf.toString());
        }
    }

    public void showWarning(String title, String msg, String reason) {
        if (this.delegate != null) {
            this.delegate.showWarning(title, msg, reason);
        } else {
            StringBuffer strBuf = new StringBuffer(title);
            if (!StrUtil.isBlank((String)msg)) {
                strBuf.append(NEW_LINE).append(msg);
            }
            if (!StrUtil.isBlank((String)reason)) {
                strBuf.append(NEW_LINE).append(reason);
            }
            this.logger.logWarning(strBuf.toString());
        }
    }

    public void showInfo(String title, String msg) {
        if (this.delegate != null) {
            this.delegate.showInfo(title, msg);
        } else {
            StringBuffer strBuf = new StringBuffer(title);
            if (!StrUtil.isBlank((String)msg)) {
                strBuf.append(NEW_LINE).append(msg);
            }
            this.logger.logInfo(strBuf.toString());
        }
    }

    public void showError(String title, String msg, String reason, String details, Exception exception) {
        if (this.delegate != null) {
            this.delegate.showInfo(title, msg);
        } else {
            StringBuffer strBuf = new StringBuffer(title);
            if (!StrUtil.isBlank((String)msg)) {
                strBuf.append(NEW_LINE).append(msg);
            }
            if (!StrUtil.isBlank((String)reason)) {
                strBuf.append(NEW_LINE).append(reason);
            }
            if (!StrUtil.isBlank((String)details)) {
                strBuf.append(NEW_LINE).append(details);
            }
            this.logger.logError(strBuf.toString(), (Throwable)exception);
        }
    }
}

