/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.epf.common.utils.XMLUtil;
import org.eclipse.epf.library.edit.LibraryEditPlugin;
import org.eclipse.epf.library.edit.command.IActionManager;
import org.eclipse.epf.library.edit.command.MethodElementSetPropertyCommand;
import org.eclipse.epf.library.edit.meta.TypeDefUtil;
import org.eclipse.epf.library.edit.uma.ExtendReferenceMap;
import org.eclipse.epf.library.edit.uma.MethodElementExt;
import org.eclipse.epf.library.edit.util.LibraryEditUtil;
import org.eclipse.epf.library.edit.util.MethodElementPropertyHelper;
import org.eclipse.epf.library.edit.util.MethodPluginPropUtil;
import org.eclipse.epf.library.edit.util.XmlEditUtil;
import org.eclipse.epf.uma.Constraint;
import org.eclipse.epf.uma.ContentPackage;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodElementProperty;
import org.eclipse.epf.uma.MethodPackage;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.Practice;
import org.eclipse.epf.uma.WorkProduct;
import org.eclipse.epf.uma.ecore.impl.MultiResourceEObject;
import org.eclipse.epf.uma.util.UmaUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodElementPropUtil {
    public static final String infoSeperator = "/";
    public static final String CONSTRAINT_WPStates = "constraint_wpStates";
    public static final String Package_supporting = "pakage_supporting";
    public static final String Me_references = "me_references";
    private static MethodElementPropUtil methodElementPropUtil = new MethodElementPropUtil();
    private IActionManager actionManager;

    public static MethodElementPropUtil getMethodElementPropUtil(IActionManager actionManager) {
        return new MethodElementPropUtil(actionManager);
    }

    public static MethodElementPropUtil getMethodElementPropUtil() {
        return methodElementPropUtil;
    }

    protected MethodElementPropUtil() {
    }

    protected MethodElementPropUtil(IActionManager actionManager) {
        this.actionManager = actionManager;
    }

    public IActionManager getActionManager() {
        return this.actionManager;
    }

    public String getStringValue(MethodElement element, String propName) {
        MethodElementProperty prop = MethodElementPropertyHelper.getProperty(element, propName);
        if (prop == null) {
            return null;
        }
        return prop.getValue();
    }

    public void setStringValue(MethodElement element, String propName, String value) {
        this.setProperty(element, propName, value);
    }

    public boolean isSupporting(ContentPackage pkg) {
        Boolean value = this.getBooleanValue((MethodElement)pkg, Package_supporting);
        return value == null ? false : value;
    }

    public boolean ancestorIsSupporting(ContentPackage pkg) {
        EObject parent = pkg.eContainer();
        while (parent != null) {
            if (parent instanceof MethodPlugin) {
                return ((MethodPlugin)parent).isSupporting();
            }
            if (parent instanceof ContentPackage && this.isSupporting((ContentPackage)parent)) {
                return true;
            }
            parent = parent.eContainer();
        }
        return false;
    }

    public void updatePackageSupportingBits(Collection<? extends MethodPackage> pkgs, boolean supporting) {
        for (MethodPackage methodPackage : pkgs) {
            ContentPackage pkg;
            boolean pkgIsSupporting;
            if (!(methodPackage instanceof ContentPackage) || (pkgIsSupporting = this.isSupporting(pkg = (ContentPackage)methodPackage)) && supporting) continue;
            if (pkgIsSupporting != supporting) {
                this.setBooleanValue((MethodElement)pkg, Package_supporting, supporting);
            }
            this.updatePackageSupportingBits(pkg.getChildPackages(), supporting);
        }
    }

    public void setSupporting(ContentPackage pkg, boolean value) {
        this.setBooleanValue((MethodElement)pkg, Package_supporting, value);
    }

    public Boolean getBooleanValue(MethodElement element, String propName) {
        MethodElementProperty prop = MethodElementPropertyHelper.getProperty(element, propName);
        if (prop == null) {
            return null;
        }
        String value = prop.getValue();
        return Boolean.parseBoolean(value);
    }

    public void setBooleanValue(MethodElement element, String propName, boolean value) {
        String strValue = value ? Boolean.TRUE.toString() : Boolean.FALSE.toString();
        this.setProperty(element, propName, strValue);
    }

    protected Integer getIntValue(MethodElement element, String propName) {
        MethodElementProperty prop = MethodElementPropertyHelper.getProperty(element, propName);
        if (prop == null) {
            return null;
        }
        String value = prop.getValue();
        return Integer.parseInt(value);
    }

    protected void setIntValue(MethodElement element, String propName, int value) {
        String strValue = Integer.toString(value);
        this.setProperty(element, propName, strValue);
    }

    private void setProperty(MethodElement e, String propName, String propValue) {
        if (this.getActionManager() == null) {
            MethodElementPropertyHelper.setProperty(e, propName, propValue);
        } else {
            MethodElementSetPropertyCommand cmd = new MethodElementSetPropertyCommand(e, propName, propValue);
            this.getActionManager().execute(cmd);
        }
    }

    protected void removeProperty(MethodElement e, String propName) {
        MethodElementPropertyHelper.removeProperty(e, propName);
    }

    public MethodElementExt getExtendObject(MethodElement element, boolean create) {
        if (element == null) {
            return null;
        }
        MultiResourceEObject mobj = (MultiResourceEObject)element;
        MultiResourceEObject.ExtendObject obj = mobj.getExtendObject();
        if (create && !(obj instanceof MethodElementExt)) {
            obj = TypeDefUtil.getInstance().createExtendObject(element);
            mobj.setExtendObject(obj);
        }
        return (MethodElementExt)obj;
    }

    public Map<Object, Object> getExtendedPropertyMap(MethodElement element, boolean create) {
        MethodElementExt ext = this.getExtendObject(element, create);
        return ext == null ? null : ext.getExtendedPropertyMap(create);
    }

    public boolean isWorkProductState(MethodElement element) {
        if (!(element instanceof Constraint)) {
            return false;
        }
        Constraint c = (Constraint)element;
        return "wpState".equals(c.getName());
    }

    public void addReferenceInfo(MethodElement owner, MethodElement reference, String propName, String refName) {
        String oldValue = this.getStringValue(owner, propName);
        String newValue = reference.getGuid().concat(infoSeperator).concat(refName);
        if (oldValue != null && oldValue.length() > 0) {
            String[] infos = oldValue.split(infoSeperator);
            int sz = infos.length / 2;
            int i = 0;
            while (i < sz) {
                int i1 = i * 2;
                int i2 = i1 + 1;
                String iGuid = infos[i1];
                String iFeature = infos[i2];
                if (iGuid.equals(reference.getGuid()) && iFeature.equals(refName)) {
                    return;
                }
                ++i;
            }
            newValue = oldValue.concat(infoSeperator).concat(newValue);
        }
        this.setStringValue(owner, propName, newValue);
    }

    public void removeReferenceInfo(MethodElement owner, MethodElement reference, String propName, String refName) {
        String oldValue = this.getStringValue(owner, propName);
        if (oldValue == null || oldValue.length() == 0) {
            return;
        }
        boolean removed = false;
        String newValue = "";
        if (oldValue != null && oldValue.length() > 0) {
            String[] infos = oldValue.split(infoSeperator);
            int sz = infos.length / 2;
            int i = 0;
            while (i < sz) {
                int i1 = i * 2;
                int i2 = i1 + 1;
                String iGuid = infos[i1];
                String iFeature = infos[i2];
                if (iGuid.equals(reference.getGuid()) && iFeature.equals(refName)) {
                    removed = true;
                } else {
                    if (newValue.length() > 0) {
                        newValue = newValue.concat(infoSeperator);
                    }
                    newValue = newValue.concat(iGuid.concat(infoSeperator).concat(iFeature));
                }
                ++i;
            }
        }
        if (removed) {
            this.setStringValue(owner, propName, newValue);
        }
    }

    public List<? extends MethodElement> extractElements(MethodElement propertyOwner, String propName, String refName, Set<? extends MethodElement> validSet) {
        ArrayList<MethodElement> elements = new ArrayList<MethodElement>();
        String value = this.getStringValue(propertyOwner, propName);
        if (value == null || value.length() == 0) {
            return elements;
        }
        String[] infos = value.split(infoSeperator);
        if (infos == null || infos.length == 0) {
            return elements;
        }
        boolean modified = false;
        String newValue = "";
        int sz = infos.length / 2;
        int i = 0;
        while (i < sz) {
            int i1 = i * 2;
            int i2 = i1 + 1;
            String iGuid = infos[i1];
            String iRefName = infos[i2];
            if (refName.equals(iRefName)) {
                MethodElement element = LibraryEditUtil.getInstance().getMethodElement(iGuid);
                if (element != null && validSet.contains(element)) {
                    elements.add(element);
                    if (newValue.length() > 0) {
                        newValue = newValue.concat(infoSeperator);
                    }
                    newValue = newValue.concat(iGuid.concat(infoSeperator).concat(iRefName));
                } else {
                    modified = true;
                }
            } else {
                if (newValue.length() > 0) {
                    newValue = newValue.concat(infoSeperator);
                }
                newValue = newValue.concat(iGuid.concat(infoSeperator).concat(iRefName));
            }
            ++i;
        }
        if (modified) {
            this.setStringValue(propertyOwner, propName, newValue);
        }
        return elements;
    }

    public boolean isTransientElement(MethodElement element) {
        MethodElementExt extObj = this.getExtendObject(element, false);
        return extObj == null ? false : extObj.isTransientElement();
    }

    public void setTransientElement(MethodElement element, boolean transientElement) {
        if (!transientElement && this.getExtendObject(element, false) == null) {
            return;
        }
        MethodElementExt extObj = this.getExtendObject(element, true);
        extObj.setTransientElement(transientElement);
    }

    public void addToAssignedToWps(WorkProduct wp, Constraint state) {
        if (!this.isWorkProductState((MethodElement)state)) {
            return;
        }
        MethodElementExt extObj = this.getExtendObject((MethodElement)state, true);
        if (!(extObj instanceof MethodElementExt.WorkProductStateExt)) {
            return;
        }
        ((MethodElementExt.WorkProductStateExt)extObj).addToAssignedToWps(wp);
    }

    public void removeFromAssignedToWps(WorkProduct wp, Constraint state) {
        MethodElementExt extObj = this.getExtendObject((MethodElement)state, false);
        if (!(extObj instanceof MethodElementExt.WorkProductStateExt)) {
            return;
        }
        ((MethodElementExt.WorkProductStateExt)extObj).removeFromAssignedToWps(wp);
    }

    public List<WorkProduct> getAssignedToWorkProducts(Constraint state) {
        MethodElementExt extObj;
        MethodPlugin plugin = UmaUtil.getMethodPlugin((EObject)state);
        if (plugin != null) {
            MethodPluginPropUtil.getMethodPluginPropUtil().loadWpStates(plugin);
        }
        if (!((extObj = this.getExtendObject((MethodElement)state, false)) instanceof MethodElementExt.WorkProductStateExt)) {
            return Collections.EMPTY_LIST;
        }
        return ((MethodElementExt.WorkProductStateExt)extObj).getAssignedToWorkProducts();
    }

    protected Set<? extends MethodElement> getElements(MethodElement owner, String propName, EClass type) {
        String[] guids;
        HashSet<MethodElement> elements = new HashSet<MethodElement>();
        if (owner == null) {
            return elements;
        }
        String value = this.getStringValue(owner, propName);
        String[] stringArray = guids = value == null || value.trim().length() == 0 ? null : value.split(infoSeperator);
        if (guids == null || guids.length == 0) {
            return elements;
        }
        int i = 0;
        while (i < guids.length) {
            MethodElement element = LibraryEditUtil.getInstance().getMethodElement(guids[i]);
            if (element != null && (type == null || type.isSuperTypeOf(element.eClass()))) {
                elements.add(element);
            }
            ++i;
        }
        return elements;
    }

    protected void setElements(MethodElement owner, String propName, Set<? extends MethodElement> elements, EClass type) {
        if (owner == null) {
            return;
        }
        String value = "";
        ArrayList<String> guidList = new ArrayList<String>();
        if (elements != null) {
            for (MethodElement methodElement : elements) {
                if (methodElement == null || type != null && !type.isSuperTypeOf(methodElement.eClass())) continue;
                guidList.add(methodElement.getGuid());
            }
            Collections.sort(guidList);
            for (String string : guidList) {
                if (value.length() != 0) {
                    value = String.valueOf(value) + infoSeperator;
                }
                value = String.valueOf(value) + string;
            }
        }
        this.setStringValue(owner, propName, value);
    }

    public XmlEditUtil newXmlEditUtil() {
        return new XmlEditUtil(this);
    }

    public void storeReferences(MethodElement element, boolean rollback) throws Exception {
        MeXmlEditUtil meXmlEditUtil = new MeXmlEditUtil(element, this);
        meXmlEditUtil.storeReferences(rollback);
    }

    public String getReferencesXml(MethodElement element, boolean rollback) throws Exception {
        MeXmlEditUtil meXmlEditUtil = new MeXmlEditUtil(element, this);
        return meXmlEditUtil.getReferencesXml(rollback);
    }

    public boolean hasUdtList(MethodElement element) {
        return this.hasReferences(element);
    }

    public boolean hasReferences(MethodElement element) {
        String value = this.getStringValue(element, Me_references);
        return value != null && value.length() > 0;
    }

    public List<Practice> getUdtList(MethodElement element, boolean toModify) {
        List value = (List)this.getReferenceValue(UmaUtil.MethodElement_UdtList.getName(), element, toModify);
        if (value == null) {
            return new ArrayList<Practice>();
        }
        return value;
    }

    public List<MethodElement> getQReferenceListById(MethodElement element, String qualifierId, boolean toModify) {
        String referenceName = qualifierId;
        List value = (List)this.getReferenceValue(referenceName, element, toModify);
        if (value == null) {
            return new ArrayList<MethodElement>();
        }
        return value;
    }

    public void notifyElemetSaved(MethodElement element) {
        ExtendReferenceMap map = this.getCachedExtendReferenceMap(element, false);
        if (map == null) {
            return;
        }
        map.notifyOwnerElementSaved();
    }

    public void addOpposite(String referenceName, MethodElement thisElement, MethodElement otherElement) {
        ExtendReferenceMap map = this.getCachedExtendReferenceMap(thisElement, false);
        if (map == null) {
            return;
        }
        map.addOpposite(referenceName, otherElement);
    }

    public void removeOpposite(String referenceName, MethodElement thisElement, MethodElement otherElement) {
        ExtendReferenceMap map = this.getCachedExtendReferenceMap(thisElement, false);
        if (map == null) {
            return;
        }
        map.removeOpposite(referenceName, otherElement);
    }

    protected Object getReferenceValue(String referenceName, MethodElement element, boolean toModify) {
        MeXmlEditUtil meXmlEditUtil = new MeXmlEditUtil(element, this);
        return meXmlEditUtil.getReferenceValue(referenceName, element, toModify);
    }

    protected ExtendReferenceMap getCachedExtendReferenceMap(MethodElement element, boolean toModify) {
        MethodElementExt extendObject = this.getExtendObject(element, toModify);
        if (extendObject == null) {
            return null;
        }
        return extendObject.getExtendReferenceMap(toModify);
    }

    public ExtendReferenceMap getExtendReferenceMap(MethodElement element, boolean toModify) {
        MeXmlEditUtil meXmlEditUtil = new MeXmlEditUtil(element, this);
        return meXmlEditUtil.getExtendReferenceMap(element, toModify);
    }

    public Object eGet(EObject eobj, EStructuralFeature feature, boolean toModify) {
        return TypeDefUtil.getInstance().eGet(eobj, feature, toModify);
    }

    private static class MeXmlEditUtil
    extends XmlEditUtil {
        private MethodElement element;

        public MeXmlEditUtil(MethodElement element, MethodElementPropUtil propUtil) {
            super(propUtil);
            this.element = element;
        }

        public void storeReferences(boolean rollback) throws Exception {
            if (!this.buildReferencesElement(rollback)) {
                return;
            }
            this.storeToOwner(this.element, MethodElementPropUtil.Me_references);
        }

        public Object getReferenceValue(String referenceName, MethodElement element, boolean toModify) {
            ExtendReferenceMap map = this.getExtendReferenceMap(element, toModify);
            return map == null ? null : map.get(referenceName, toModify);
        }

        public ExtendReferenceMap getExtendReferenceMap(MethodElement element, boolean toModify) {
            ExtendReferenceMap map = this.getPropUtil().getCachedExtendReferenceMap(element, toModify);
            if (map != null && map.isRetrieved() || !this.getPropUtil().hasUdtList(element)) {
                return map;
            }
            String xmlString = this.getPropUtil().getStringValue(element, MethodElementPropUtil.Me_references);
            Element firstElement = null;
            try {
                firstElement = this.loadDocumentAndGetFirstElement(xmlString);
            }
            catch (Exception e) {
                LibraryEditPlugin.getDefault().getLogger().logError((Throwable)e);
                firstElement = null;
            }
            if (firstElement != null) {
                map = this.getPropUtil().getCachedExtendReferenceMap(element, true);
                map.retrieveReferencesFromElement(firstElement);
            }
            return map;
        }

        private boolean buildReferencesElement(boolean rollback) throws Exception {
            ExtendReferenceMap map = this.getExtendReferenceMap(this.element, false);
            if (map == null) {
                return false;
            }
            Element firstElement = this.createFirstElement(MethodElementPropUtil.Me_references);
            map.storeReferencesToElement(firstElement, rollback);
            return true;
        }

        public String getReferencesXml(boolean rollback) throws Exception {
            if (!this.buildReferencesElement(rollback)) {
                return null;
            }
            return XMLUtil.toXmlString((Document)this.getDocument());
        }
    }
}

