/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.util;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.epf.library.edit.util.MethodElementPropertyHelper;
import org.eclipse.epf.library.edit.util.MethodElementPropertyMgr;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodElementProperty;
import org.eclipse.epf.uma.UmaFactory;
import org.eclipse.epf.uma.UmaPackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodElementProperties
extends AdapterImpl {
    private MethodElement element;
    private ListenerList listeners = new ListenerList();
    private Set<String> propNameSet = new LinkedHashSet<String>();
    private Map<String, List<MethodElementProperty>> propertyMap;

    public MethodElementProperties(MethodElement element, String[] propNameArray) {
        this.element = element;
        if (propNameArray != null) {
            int i = 0;
            while (i < propNameArray.length) {
                this.propNameSet.add(propNameArray[i]);
                ++i;
            }
        }
        this.propertyMap = MethodElementPropertyHelper.getPropertyMap(element, this.getPropNameSet());
    }

    protected Set<String> getPropNameSet() {
        return this.propNameSet;
    }

    public boolean propNameRegistered(String propName) {
        return this.getPropNameSet() != null && this.getPropNameSet().contains(propName);
    }

    public void notifyChanged(Notification msg) {
        Object obj = msg.getNotifier();
        if (obj instanceof MethodElementProperty) {
            MethodElementProperty cfr_ignored_0 = (MethodElementProperty)obj;
        } else if (obj == this.element) {
            if (msg.getFeature() != UmaPackage.eINSTANCE.getMethodElement_MethodElementProperty()) {
                return;
            }
        } else {
            return;
        }
    }

    public MethodElementProperty getProperty(String propName) {
        List<MethodElementProperty> propList = this.propertyMap.get(propName);
        return propList == null || propList.isEmpty() ? null : propList.get(0);
    }

    public void setProperty(String propName, String propValue) {
        String oldValue;
        MethodElementProperty prop;
        List<MethodElementProperty> propList = this.propertyMap.get(propName);
        if (propList == null) {
            propList = new ArrayList<MethodElementProperty>();
            this.propertyMap.put(propName, propList);
        }
        MethodElementProperty methodElementProperty = prop = propList.isEmpty() ? null : propList.get(0);
        if (prop == null) {
            prop = UmaFactory.eINSTANCE.createMethodElementProperty();
            prop.setName(propName);
            this.element.getMethodElementProperty().add(prop);
            if (propList.isEmpty()) {
                propList.add(prop);
            }
        }
        if (this.equal(oldValue = prop.getValue(), propValue)) {
            return;
        }
        prop.setValue(propValue);
        this.notifyListeners(new MethodElementPropertyMgr.ChangeEvent(prop, oldValue, propValue));
    }

    public boolean getBooleanValue(String propName) {
        MethodElementProperty prop = this.getProperty(propName);
        if (prop == null) {
            return false;
        }
        prop.getValue();
        return Boolean.TRUE.toString().equals(prop.getValue());
    }

    private boolean equal(Object a, Object b) {
        if (a != null) {
            return a.equals(b);
        }
        return b == null;
    }

    public void addListener(MethodElementPropertyMgr.ChangeEventListener listener) {
        if (this.listeners != null) {
            this.listeners.add((Object)listener);
        }
    }

    public void removeListener(MethodElementPropertyMgr.ChangeEventListener listener) {
        if (this.listeners != null) {
            this.listeners.remove((Object)listener);
        }
    }

    private void notifyListeners(MethodElementPropertyMgr.ChangeEvent event) {
        if (this.listeners != null) {
            Object[] objectArray = this.listeners.getListeners();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                if (o instanceof MethodElementPropertyMgr.ChangeEventListener) {
                    ((MethodElementPropertyMgr.ChangeEventListener)o).notifyChange(event);
                }
                ++n2;
            }
        }
    }

    public void dispose() {
        this.element = null;
        this.listeners = null;
        this.propNameSet = null;
        this.propertyMap = null;
    }
}

