/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.util;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.epf.library.edit.util.MethodElementProperties;
import org.eclipse.epf.library.edit.util.MethodElementPropertyHelper;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodElementProperty;

public class MethodElementPropertyMgr {
    private static MethodElementPropertyMgr instance = new MethodElementPropertyMgr();
    private Map<MethodElement, MethodElementProperties> registeredMap = new HashMap<MethodElement, MethodElementProperties>();
    private ListenerList listeners = new ListenerList();

    private MethodElementPropertyMgr() {
    }

    public static MethodElementPropertyMgr getInstance() {
        return instance;
    }

    public MethodElementProperties register(MethodElement element, String[] propNames) {
        MethodElementProperties props = new MethodElementProperties(element, propNames);
        this.register(element, props);
        return props;
    }

    public void register(MethodElement element, MethodElementProperties props) {
        this.unregister(element);
        this.registeredMap.put(element, props);
    }

    public MethodElementProperties unregister(MethodElement element) {
        MethodElementProperties props = this.registeredMap.remove(element);
        if (props != null) {
            props.dispose();
        }
        return props;
    }

    public MethodElementProperty getProperty(MethodElement e, String propName) {
        MethodElementProperties props = this.registeredMap.get(e);
        if (props != null && props.propNameRegistered(propName)) {
            return props.getProperty(propName);
        }
        return MethodElementPropertyHelper.getProperty(e, propName);
    }

    public void setProperty(MethodElement e, String propName, String propValue) {
        MethodElementProperties props = this.registeredMap.get(e);
        if (props != null && props.propNameRegistered(propName)) {
            props.setProperty(propName, propValue);
        } else {
            MethodElementPropertyHelper.setProperty(e, propName, propValue);
        }
    }

    public void addListener(ChangeEventListener listener) {
        this.listeners.add((Object)listener);
    }

    public void removeListener(ChangeEventListener listener) {
        this.listeners.remove((Object)listener);
    }

    public static class ChangeEvent {
        public String propName;
        public MethodElementProperty propElement;
        public String oldValue;
        public String newValue;

        public ChangeEvent(String propName, String oldValue, String newValue) {
            this.propElement = this.propElement;
            this.oldValue = oldValue;
            this.newValue = newValue;
        }

        public ChangeEvent(MethodElementProperty propElement, String oldValue, String newValue) {
            this(propElement == null ? null : propElement.getName(), oldValue, newValue);
            this.propElement = propElement;
        }
    }

    public static class ChangeEventListener {
        public void notifyChange(ChangeEvent event) {
        }
    }
}

