/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.epf.library.edit.LibraryEditPlugin;
import org.eclipse.epf.library.edit.command.IActionManager;
import org.eclipse.epf.library.edit.uma.MethodElementExt;
import org.eclipse.epf.library.edit.uma.MethodPluginExt;
import org.eclipse.epf.library.edit.util.ConstraintManager;
import org.eclipse.epf.library.edit.util.LibraryEditUtil;
import org.eclipse.epf.library.edit.util.PropUtil;
import org.eclipse.epf.library.edit.util.WorkProductPropUtil;
import org.eclipse.epf.uma.Constraint;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.WorkProduct;
import org.eclipse.epf.uma.util.UmaUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodPluginPropUtil
extends PropUtil {
    public static final String PLUGIN_SynFree = "plugin_synFree";
    public static final String Plugin_customizedConfig = "plugin_customizedConfig";
    public static final String Plugin_customizedParent = "plugin_customizedParent";
    public static final String Plugin_embeddedConfigXmiString = "plugin_embeddedConfigXmiString";
    private static MethodPluginPropUtil methodPluginPropUtil = new MethodPluginPropUtil();

    public static MethodPluginPropUtil getMethodPluginPropUtil() {
        return methodPluginPropUtil;
    }

    public static MethodPluginPropUtil getMethodPluginPropUtil(IActionManager actionManager) {
        return new MethodPluginPropUtil(actionManager);
    }

    protected MethodPluginPropUtil() {
    }

    protected MethodPluginPropUtil(IActionManager actionManager) {
        super(actionManager);
    }

    public void saveEmbeddedConfig(MethodPlugin plugin, MethodConfiguration config) {
        String xmiString = LibraryEditUtil.getInstance().getXmiString((EObject)config);
        this.setStringValue((MethodElement)plugin, Plugin_embeddedConfigXmiString, xmiString);
        MethodPluginExt ext = this.getMethodPluginExt(plugin, true);
        ext.setEmbeddedConfig(config);
    }

    private MethodPluginExt getMethodPluginExt(MethodPlugin plugin, boolean create) {
        MethodElementExt extObj = this.getExtendObject((MethodElement)plugin, create);
        if (!(extObj instanceof MethodPluginExt)) {
            LibraryEditPlugin.getDefault().getLogger().logError("saveEmbeddedConfig, extObj: " + (Object)((Object)extObj));
            return null;
        }
        return (MethodPluginExt)extObj;
    }

    public MethodConfiguration getEmbeddedConfig(MethodPlugin plugin) {
        MethodPluginExt ext = this.getMethodPluginExt(plugin, true);
        if (ext.isEmbeddedConfigLoaded()) {
            return ext.getEmbeddedConfig();
        }
        ext.setEmbeddedConfigLoaded(true);
        MethodConfiguration config = null;
        String xmiString = this.getStringValue((MethodElement)plugin, Plugin_embeddedConfigXmiString);
        EObject obj = LibraryEditUtil.getInstance().loadObject(xmiString);
        if (obj instanceof MethodConfiguration) {
            config = (MethodConfiguration)obj;
        }
        ext.setEmbeddedConfig(config);
        return config;
    }

    public boolean isSynFree(MethodPlugin d) {
        Boolean value = this.getBooleanValue((MethodElement)d, PLUGIN_SynFree);
        return value == null ? false : value;
    }

    public void setSynFree(MethodPlugin d, boolean value) {
        this.setBooleanValue((MethodElement)d, PLUGIN_SynFree, value);
    }

    public MethodPlugin getCustomizedParent(MethodPlugin plugin) {
        MethodElement element = this.getElement((MethodElement)plugin, Plugin_customizedParent);
        return element instanceof MethodPlugin ? (MethodPlugin)element : null;
    }

    public MethodConfiguration getCustomizedConfig(MethodPlugin plugin) {
        MethodElement element = this.getElement((MethodElement)plugin, Plugin_customizedConfig);
        return element instanceof MethodConfiguration ? (MethodConfiguration)element : null;
    }

    public boolean isCustomizePlugin(MethodPlugin plugin) {
        return this.getCustomizedConfig(plugin) != null;
    }

    public Constraint getWorkProductState(MethodPlugin plugin, String stateName, boolean create) {
        return ConstraintManager.getWorkProductState(plugin, stateName, create, this.getActionManager());
    }

    public List<Constraint> getWorkProductStatesInPlugin(MethodPlugin plugin) {
        ArrayList<Constraint> list = new ArrayList<Constraint>();
        for (Constraint state : plugin.getOwnedRules()) {
            if (!state.getName().equals("wpState")) continue;
            list.add(state);
        }
        return list;
    }

    public Constraint removeWorkProductState(MethodPlugin plugin, String stateName) {
        for (Constraint state : plugin.getOwnedRules()) {
            if (!state.getName().equals("wpState") || !state.getBody().equals(stateName)) continue;
            if (this.getActionManager() == null) {
                plugin.getOwnedRules().remove(state);
            }
            this.getActionManager().doAction(4, (EObject)plugin, (EStructuralFeature)UmaPackage.eINSTANCE.getMethodElement_OwnedRules(), state, -1);
            return state;
        }
        return null;
    }

    public List<Constraint> getWorkProductStatesInLibrary(MethodPlugin activePlugin) {
        List<Constraint> resultList = this.getWorkProductStatesInPlugin(activePlugin);
        HashSet<String> stateIDs = new HashSet<String>();
        for (Constraint state : resultList) {
            stateIDs.add(this.getStateId(state));
        }
        MethodLibrary lib = UmaUtil.getMethodLibrary((EObject)activePlugin);
        if (lib == null) {
            return resultList;
        }
        for (MethodPlugin plugin : lib.getMethodPlugins()) {
            List<Constraint> list = this.getWorkProductStatesInPlugin(plugin);
            for (Constraint state : list) {
                String id = this.getStateId(state);
                if (stateIDs.contains(id)) continue;
                stateIDs.add(id);
                resultList.add(state);
            }
        }
        return resultList;
    }

    private String getStateId(Constraint state) {
        return String.valueOf(state.getBody()) + ", " + state.getBriefDescription();
    }

    private boolean isWpStatesLoaded(MethodPlugin plugin) {
        MethodPluginExt ext = (MethodPluginExt)this.getExtendObject((MethodElement)plugin, true);
        return ext.isWpStatesLoaded();
    }

    private void setWpStatesLoaded(MethodPlugin plugin, boolean wpStatesLoaded) {
        MethodPluginExt ext = (MethodPluginExt)this.getExtendObject((MethodElement)plugin, true);
        ext.setWpStatesLoaded(wpStatesLoaded);
    }

    public void loadWpStates(MethodPlugin plugin) {
        if (this.isWpStatesLoaded(plugin)) {
            return;
        }
        WorkProductPropUtil wpPropUtil = WorkProductPropUtil.getWorkProductPropUtil();
        for (WorkProduct wp : LibraryEditUtil.getInstance().getAllWorkProducts((MethodElement)plugin)) {
            wpPropUtil.getWorkProductStates(wp);
        }
        this.setWpStatesLoaded(plugin, true);
    }
}

