/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.epf.uma.ContentPackage;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.NamedElement;
import org.eclipse.epf.uma.Task;
import org.eclipse.epf.uma.WorkProduct;
import org.eclipse.epf.uma.util.AssociationHelper;
import org.eclipse.epf.uma.util.UmaUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Misc {
    private static Map<MethodPlugin, List> map = new HashMap<MethodPlugin, List>();

    public static void getAllWorkProducts(ContentPackage pkg, List list) {
        List elements = pkg.getContentElements();
        int i = 0;
        while (i < elements.size()) {
            Object obj = elements.get(i);
            if (obj instanceof WorkProduct) {
                list.add(obj);
            }
            ++i;
        }
        List packages = pkg.getChildPackages();
        int i2 = 0;
        while (i2 < packages.size()) {
            Object obj = packages.get(i2);
            if (obj instanceof ContentPackage) {
                Misc.getAllWorkProducts((ContentPackage)obj, list);
            }
            ++i2;
        }
    }

    public static List getAllWorkProducts(ContentPackage pkg) {
        ArrayList list = new ArrayList();
        Misc.getAllWorkProducts(pkg, list);
        return list;
    }

    private static void getAllTasks(ContentPackage pkg, List list) {
        List elements = pkg.getContentElements();
        int i = 0;
        while (i < elements.size()) {
            Object obj = elements.get(i);
            if (obj instanceof Task) {
                list.add(obj);
            }
            ++i;
        }
        List packages = pkg.getChildPackages();
        int i2 = 0;
        while (i2 < packages.size()) {
            Object obj = packages.get(i2);
            if (obj instanceof ContentPackage) {
                Misc.getAllTasks((ContentPackage)obj, list);
            }
            ++i2;
        }
    }

    public static List getAllTasks(ContentPackage pkg) {
        ArrayList list = new ArrayList();
        Misc.getAllTasks(pkg, list);
        return list;
    }

    public static List getAllUncategorizedTasks(ContentPackage pkg) {
        ArrayList list = new ArrayList();
        Misc.getAllUncategorizedTasks(pkg, list);
        return list;
    }

    private static void getAllUncategorizedTasks(ContentPackage pkg, List list) {
        List elements = pkg.getContentElements();
        int i = 0;
        while (i < elements.size()) {
            Object obj = elements.get(i);
            if (obj instanceof Task && AssociationHelper.getDisciplines((Task)((Task)obj)).isEmpty()) {
                list.add(obj);
            }
            ++i;
        }
        List packages = pkg.getChildPackages();
        int i2 = 0;
        while (i2 < packages.size()) {
            Object obj = packages.get(i2);
            if (obj instanceof ContentPackage) {
                Misc.getAllUncategorizedTasks((ContentPackage)obj, list);
            }
            ++i2;
        }
    }

    public static String[] getPathRelativeToPlugin(NamedElement e) {
        MethodPlugin plugin = UmaUtil.getMethodPlugin((EObject)e);
        ArrayList<String> list = new ArrayList<String>();
        list.add(String.valueOf(e.getName()));
        e = (NamedElement)e.eContainer();
        while (e != null && e != plugin) {
            list.add(0, String.valueOf(e.getName()));
            e = (NamedElement)e.eContainer();
        }
        String[] path = new String[list.size()];
        list.toArray(path);
        return path;
    }

    public static Collection<NamedElement> getObjectTreeRelativeToPlugin(NamedElement e) {
        MethodPlugin plugin = UmaUtil.getMethodPlugin((EObject)e);
        ArrayList<NamedElement> list = new ArrayList<NamedElement>();
        list.add(e);
        e = (NamedElement)e.eContainer();
        while (e != null && e != plugin) {
            list.add(0, e);
            e = (NamedElement)e.eContainer();
        }
        return list;
    }

    public static String getPathRelativeToLibrary(NamedElement e) {
        if (e == null) {
            return "";
        }
        MethodPlugin plugin = UmaUtil.getMethodPlugin((EObject)e);
        if (plugin == null) {
            return e.getName();
        }
        StringBuffer path = new StringBuffer(e.getName());
        String[] arr = Misc.getPathRelativeToPlugin(e);
        int i = 0;
        while (i < arr.length) {
            path.append('/').append(arr[i]);
            ++i;
        }
        return path.toString();
    }

    public static void clearCachedMap() {
        map.clear();
    }

    public static List getAllBase1(MethodPlugin plugin) {
        ArrayList list = map.get(plugin);
        if (list == null) {
            list = new ArrayList();
            Misc.getAllBase(plugin, list, new HashSet<MethodPlugin>());
            map.put(plugin, list);
        }
        return list;
    }

    public static List getAllBase(MethodPlugin plugin) {
        ArrayList list = new ArrayList();
        Misc.getAllBase(plugin, list, new HashSet<MethodPlugin>());
        return list;
    }

    public static void getAllBase(MethodPlugin plugin, List list, Set<MethodPlugin> inListSet) {
        if (plugin == null) {
            return;
        }
        for (MethodPlugin base : plugin.getBases()) {
            if (base == plugin || inListSet.contains(base)) continue;
            list.add(base);
            inListSet.add(base);
            Misc.getAllBase(base, list, inListSet);
        }
    }

    public static boolean isBaseOf(MethodPlugin base, MethodPlugin plugin, Map<String, Boolean> resultCacheMap) {
        if (resultCacheMap == null) {
            return Misc.isBaseOf_(base, plugin, resultCacheMap);
        }
        String key = String.valueOf(base.getGuid()) + plugin.getGuid();
        Boolean value = resultCacheMap.get(key);
        if (value != null) {
            return value;
        }
        boolean b = Misc.isBaseOf_(base, plugin, resultCacheMap);
        resultCacheMap.put(key, b);
        return b;
    }

    private static boolean isBaseOf_(MethodPlugin base, MethodPlugin plugin, Map<String, Boolean> resultCacheMap) {
        if (plugin == null) {
            System.out.println();
        }
        List bases = plugin.getBases();
        int size = bases.size();
        int i = 0;
        while (i < size) {
            if (base == bases.get(i)) {
                return true;
            }
            ++i;
        }
        i = 0;
        while (i < size) {
            if (Misc.isBaseOf(base, (MethodPlugin)bases.get(i), resultCacheMap)) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

