/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.epf.library.edit.LibraryEditPlugin;
import org.eclipse.epf.library.edit.command.IActionManager;
import org.eclipse.epf.library.edit.uma.ExtendReferenceMap;
import org.eclipse.epf.library.edit.uma.MethodElementExt;
import org.eclipse.epf.library.edit.util.LibraryEditUtil;
import org.eclipse.epf.library.edit.util.MethodElementPropUtil;
import org.eclipse.epf.library.edit.util.PropUtil;
import org.eclipse.epf.library.edit.util.XmlEditUtil;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.Practice;
import org.eclipse.epf.uma.ecore.IUserDefinedTypeMeta;
import org.eclipse.epf.uma.util.UserDefinedTypeMeta;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PracticePropUtil
extends PropUtil {
    public static final String Practice_UtdData = "Practice_utdData";
    private static PracticePropUtil practicePropUtil = new PracticePropUtil();

    public static PracticePropUtil getPracticePropUtil() {
        return practicePropUtil;
    }

    public static PracticePropUtil getPracticePropUtil(IActionManager actionManager) {
        return new PracticePropUtil(actionManager);
    }

    protected PracticePropUtil() {
    }

    protected PracticePropUtil(IActionManager actionManager) {
        super(actionManager);
    }

    public void storeUtdData(Practice practice, UserDefinedTypeMeta meta) throws Exception {
        PracticeXmlEditUtil xmlEditUtil = new PracticeXmlEditUtil(practice, this);
        xmlEditUtil.storeUtdData(meta);
        MethodElementExt extendObject = this.getExtendObject((MethodElement)practice, true);
        if (extendObject != null) {
            extendObject.setUserDefinedTypeMeta((IUserDefinedTypeMeta)meta);
        }
    }

    public UserDefinedTypeMeta getUdtMeta(Practice practice) {
        try {
            return this.getUtdData(practice);
        }
        catch (Exception e) {
            LibraryEditPlugin.getDefault().getLogger().logError((Throwable)e);
            return null;
        }
    }

    public UserDefinedTypeMeta getUtdData(Practice practice) throws Exception {
        MethodElementExt extendObject = this.getExtendObject((MethodElement)practice, true);
        if (extendObject != null && extendObject.getUserDefinedTypeMeta() instanceof UserDefinedTypeMeta) {
            UserDefinedTypeMeta meta = (UserDefinedTypeMeta)extendObject.getUserDefinedTypeMeta();
            return meta == UserDefinedTypeMeta.noneValue ? null : meta;
        }
        UserDefinedTypeMeta meta = new UserDefinedTypeMeta();
        PracticeXmlEditUtil xmlEditUtil = new PracticeXmlEditUtil(practice, this);
        xmlEditUtil.retrieveUtdData(meta);
        if (extendObject == null) {
            return meta.getId() == null ? null : meta;
        }
        if (meta.getId() == null) {
            meta = UserDefinedTypeMeta.noneValue;
        } else {
            UserDefinedTypeMeta globalMeta = LibraryEditUtil.getInstance().getUserDefineType(meta.getId());
            if (meta.same(globalMeta)) {
                meta = globalMeta;
            }
        }
        extendObject.setUserDefinedTypeMeta((IUserDefinedTypeMeta)meta);
        return meta == UserDefinedTypeMeta.noneValue ? null : meta;
    }

    public boolean isUdtType(MethodElement element) {
        if (element instanceof Practice) {
            return this.getUdtMeta((Practice)element) != null;
        }
        return false;
    }

    public boolean isUdtType(MethodElement element, String typeId) {
        UserDefinedTypeMeta meta;
        if (typeId != null && element instanceof Practice && (meta = this.getUdtMeta((Practice)element)) != null) {
            return typeId.equals(meta.getRteNameMap().get("typeId"));
        }
        return false;
    }

    public List<MethodElement> getUdtReferencingList(Practice practice) {
        String ofeature = ExtendReferenceMap.getOppositeName(ExtendReferenceMap.UdtList);
        List list = (List)this.getReferenceValue(ofeature, (MethodElement)practice, false);
        return list == null ? new ArrayList() : list;
    }

    private static class PracticeXmlEditUtil
    extends XmlEditUtil {
        private Practice practice;
        public static final String _id = "id";

        public PracticeXmlEditUtil(Practice practice, MethodElementPropUtil propUtil) {
            super(propUtil);
            this.practice = practice;
        }

        public void storeUtdData(UserDefinedTypeMeta meta) throws Exception {
            if (this.practice == null) {
                return;
            }
            Map map = meta.getRteNameMap();
            Element firstElement = this.createFirstElement(PracticePropUtil.Practice_UtdData);
            firstElement.setAttribute(_id, meta.getId());
            String[] stringArray = UserDefinedTypeMeta.rteNames;
            int n = UserDefinedTypeMeta.rteNames.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                String value = (String)map.get(name);
                if (value != null && value.trim().length() > 0) {
                    firstElement.setAttribute(name, value.trim());
                }
                ++n2;
            }
            this.storeToOwner((MethodElement)this.practice, PracticePropUtil.Practice_UtdData);
        }

        public void retrieveUtdData(UserDefinedTypeMeta meta) throws Exception {
            Map map = meta.getRteNameMap();
            String xmlString = this.getPropUtil().getStringValue((MethodElement)this.practice, PracticePropUtil.Practice_UtdData);
            if (xmlString == null || xmlString.trim().length() == 0) {
                return;
            }
            Element firstElement = this.loadDocumentAndGetFirstElement(xmlString);
            if (firstElement == null) {
                return;
            }
            String value = firstElement.getAttribute(_id);
            if (value != null && value.length() > 0) {
                meta.setId(value);
            }
            String[] stringArray = UserDefinedTypeMeta.rteNames;
            int n = UserDefinedTypeMeta.rteNames.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                if (name.equals("icon") || name.equals("shapeIcon")) {
                    UserDefinedTypeMeta globalMeta = LibraryEditUtil.getInstance().getUserDefineType(meta.getId());
                    if (globalMeta != null) {
                        value = (String)globalMeta.getRteNameMap().get(name);
                    }
                } else {
                    value = firstElement.getAttribute(name);
                }
                if (value != null && value.length() > 0) {
                    map.put(name, value);
                }
                ++n2;
            }
        }
    }
}

