/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.util;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.epf.library.edit.LibraryEditResources;
import org.eclipse.epf.library.edit.uma.ScopeFactory;
import org.eclipse.epf.library.edit.util.LibraryEditUtil;
import org.eclipse.epf.uma.ContentElement;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.Process;
import org.eclipse.epf.uma.ProcessElement;
import org.eclipse.epf.uma.util.Scope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessScopeUtil {
    private static ProcessScopeUtil instance = new ProcessScopeUtil();
    private Scope libraryScope = ScopeFactory.getInstance().newLibraryScope();
    private Scope pluginScope = ScopeFactory.getInstance().newProcessScope(LibraryEditResources.scope_PluginsName);
    private Set<Scope> scopeInEditdSet = new HashSet<Scope>();
    public static final int ScopeType_Config = 0;
    public static final int ScopeType_Process = 1;
    public static final int ScopeType_Library = 2;
    public static final int ScopeType_Plugins = 3;
    private int scopeType = 0;

    public static ProcessScopeUtil getInstance() {
        return instance;
    }

    public void setElemementSelectionScopeType(int type) {
        this.scopeType = type;
    }

    public int getElemementSelectionScopeType() {
        return this.scopeType;
    }

    public Scope loadScope(Process proc) {
        if (proc == null) {
            return null;
        }
        if (!this.isConfigFree(proc)) {
            return null;
        }
        Scope scope = this.getScope(proc);
        if (scope != null) {
            this.updateScope(proc);
            return scope;
        }
        scope = ScopeFactory.getInstance().newProcessScope(null);
        this.addReferenceToScope(scope, (MethodElement)proc, new HashSet<MethodElement>());
        boolean oldB = proc.eDeliver();
        try {
            if (oldB) {
                proc.eSetDeliver(false);
            }
            proc.setDefaultContext((MethodConfiguration)scope);
            proc.getValidContext().add(scope);
        }
        finally {
            if (oldB) {
                proc.eSetDeliver(true);
            }
        }
        return scope;
    }

    public void updateScope(Process proc) {
        Scope scope = this.getScope(proc);
        if (scope == null) {
            return;
        }
        scope.clearAll();
        this.addReferenceToScope(scope, (MethodElement)proc, new HashSet<MethodElement>());
    }

    public void addReferenceToScope(Scope scope, MethodElement element, Set<MethodElement> handledReferenceSet) {
        if (handledReferenceSet.contains(element)) {
            return;
        }
        handledReferenceSet.add(element);
        scope.addToScope(element);
        if (!(element instanceof ContentElement) && !(element instanceof ProcessElement)) {
            return;
        }
        for (EStructuralFeature f : element.eClass().getEAllStructuralFeatures()) {
            List list;
            Object value;
            EReference feature;
            if (!(f instanceof EReference) || (feature = (EReference)f).isContainer() || feature.isContainment() || (value = element.eGet((EStructuralFeature)feature)) == null) continue;
            if (value instanceof MethodElement) {
                this.addReferenceToScope(scope, (MethodElement)value, handledReferenceSet);
                continue;
            }
            if (!(value instanceof List) || (list = (List)value).size() <= 0 || !(list.get(0) instanceof MethodElement)) continue;
            int i = 0;
            while (i < list.size()) {
                this.addReferenceToScope(scope, (MethodElement)list.get(i), handledReferenceSet);
                ++i;
            }
        }
    }

    public Scope getScope(Process proc) {
        if (proc == null || !(proc.getDefaultContext() instanceof Scope)) {
            return null;
        }
        Scope scope = (Scope)proc.getDefaultContext();
        return scope;
    }

    public Scope getLibraryScope() {
        MethodLibrary lib = LibraryEditUtil.getInstance().getCurrentMethodLibrary();
        if (lib != null) {
            boolean same;
            List newPlugins = lib.getMethodPlugins();
            List oldPlugins = this.libraryScope.getMethodPluginSelection();
            boolean bl = same = newPlugins.size() == oldPlugins.size();
            if (same) {
                int i = 0;
                while (i < newPlugins.size()) {
                    if (newPlugins.get(i) != oldPlugins.get(i)) {
                        same = false;
                        break;
                    }
                    ++i;
                }
            }
            if (!same) {
                oldPlugins.clear();
                oldPlugins.addAll(newPlugins);
            }
            this.libraryScope.setName(lib.getName());
        }
        return this.libraryScope;
    }

    public Scope getPluginScope() {
        return this.pluginScope;
    }

    public void beginProcessEdit(Scope scope) {
        this.scopeInEditdSet.add(scope);
        this.scopeInEditdSet.add(this.libraryScope);
        this.scopeInEditdSet.add(this.pluginScope);
    }

    public void endProcessEdit(Scope scope) {
        this.scopeInEditdSet.remove(scope);
        this.scopeInEditdSet.remove(this.libraryScope);
        this.scopeInEditdSet.remove(this.pluginScope);
    }

    public Set<Scope> getScopeInEditdSet() {
        return this.scopeInEditdSet;
    }

    public boolean isConfigFree(Process process) {
        if (this.getScope(process) != null) {
            return true;
        }
        if (process.getDefaultContext() == null && process.getValidContext().isEmpty()) {
            return true;
        }
        if (!process.getValidContext().isEmpty()) {
            return process.getValidContext().get(0) instanceof Scope;
        }
        return false;
    }
}

