/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.util;

import com.ibm.icu.text.MessageFormat;
import com.ibm.icu.util.StringTokenizer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.NotificationImpl;
import org.eclipse.emf.common.util.AbstractTreeIterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.AdapterFactoryTreeIterator;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.IWrapperItemProvider;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.emf.edit.provider.WrapperItemProvider;
import org.eclipse.epf.common.utils.StrUtil;
import org.eclipse.epf.library.edit.IConfigurationApplicator;
import org.eclipse.epf.library.edit.IConfigurator;
import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.library.edit.LibraryEditPlugin;
import org.eclipse.epf.library.edit.LibraryEditResources;
import org.eclipse.epf.library.edit.Providers;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.command.IActionManager;
import org.eclipse.epf.library.edit.meta.TypeDefUtil;
import org.eclipse.epf.library.edit.process.ActivityWrapperItemProvider;
import org.eclipse.epf.library.edit.process.BSActivityItemProvider;
import org.eclipse.epf.library.edit.process.BreakdownElementWrapperItemProvider;
import org.eclipse.epf.library.edit.process.ComposedBreakdownElementWrapperItemProvider;
import org.eclipse.epf.library.edit.process.DescribableElementWrapperItemProvider;
import org.eclipse.epf.library.edit.process.IBSItemProvider;
import org.eclipse.epf.library.edit.process.IBreakdownElementWrapperItemProviderFactory;
import org.eclipse.epf.library.edit.process.RoleDescriptorWrapperItemProvider;
import org.eclipse.epf.library.edit.process.TaskDescriptorWrapperItemProvider;
import org.eclipse.epf.library.edit.process.WorkProductDescriptorWrapperItemProvider;
import org.eclipse.epf.library.edit.process.command.BSDropCommand;
import org.eclipse.epf.library.edit.process.command.CopyHelper;
import org.eclipse.epf.library.edit.process.command.ProcessCommandUtil;
import org.eclipse.epf.library.edit.process.command.ProcessDeepCopyCommand;
import org.eclipse.epf.library.edit.process.command.WBSDropCommand;
import org.eclipse.epf.library.edit.process.internal.BreakdownElementWrapperItemProviderFactory;
import org.eclipse.epf.library.edit.realization.IRealizationManager;
import org.eclipse.epf.library.edit.ui.UserInteractionHelper;
import org.eclipse.epf.library.edit.util.ActivityHandler;
import org.eclipse.epf.library.edit.util.ConfigurableComposedAdapterFactory;
import org.eclipse.epf.library.edit.util.DescriptorPropUtil;
import org.eclipse.epf.library.edit.util.ExposedAdapterFactory;
import org.eclipse.epf.library.edit.util.LibraryEditUtil;
import org.eclipse.epf.library.edit.util.MethodElementPropertyHelper;
import org.eclipse.epf.library.edit.util.ModelStructure;
import org.eclipse.epf.library.edit.util.PredecessorList;
import org.eclipse.epf.library.edit.util.PropUtil;
import org.eclipse.epf.library.edit.util.Suppression;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.edit.validation.NameChecker;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.Artifact;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.CompositeRole;
import org.eclipse.epf.uma.ContentPackage;
import org.eclipse.epf.uma.Deliverable;
import org.eclipse.epf.uma.Descriptor;
import org.eclipse.epf.uma.Guidance;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodElementProperty;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.Milestone;
import org.eclipse.epf.uma.Process;
import org.eclipse.epf.uma.ProcessComponent;
import org.eclipse.epf.uma.ProcessPackage;
import org.eclipse.epf.uma.Role;
import org.eclipse.epf.uma.RoleDescriptor;
import org.eclipse.epf.uma.Section;
import org.eclipse.epf.uma.Step;
import org.eclipse.epf.uma.Task;
import org.eclipse.epf.uma.TaskDescriptor;
import org.eclipse.epf.uma.TeamProfile;
import org.eclipse.epf.uma.UmaFactory;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.VariabilityElement;
import org.eclipse.epf.uma.VariabilityType;
import org.eclipse.epf.uma.WorkBreakdownElement;
import org.eclipse.epf.uma.WorkOrder;
import org.eclipse.epf.uma.WorkProduct;
import org.eclipse.epf.uma.WorkProductDescriptor;
import org.eclipse.epf.uma.provider.UmaEditPlugin;
import org.eclipse.epf.uma.util.AssociationHelper;
import org.eclipse.epf.uma.util.ExtendedReference;
import org.eclipse.epf.uma.util.ModifiedTypeMeta;
import org.eclipse.epf.uma.util.Scope;
import org.eclipse.epf.uma.util.UmaUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ProcessUtil {
    private static Collection<EClass> OBSEclasses = null;
    private static Collection<EClass> WBSEclasses = null;
    private static Collection<EClass> PBSEclasses = null;
    private static Collection<VariabilityType> extendAndLocalContributionVariabilityTypes = null;
    public static boolean processDeepcopyDiagarm = false;

    public static boolean isSynFree() {
        boolean synFree = LibraryEditUtil.getInstance().isSynFree();
        return synFree;
    }

    private static Collection<VariabilityType> getExtendAndLocalContributionVariabilityTypes() {
        if (extendAndLocalContributionVariabilityTypes == null) {
            extendAndLocalContributionVariabilityTypes = new ArrayList<VariabilityType>();
            extendAndLocalContributionVariabilityTypes.add(VariabilityType.EXTENDS);
            extendAndLocalContributionVariabilityTypes.add(VariabilityType.LOCAL_CONTRIBUTION);
        }
        return extendAndLocalContributionVariabilityTypes;
    }

    public static String checkBreakdownElementName(AdapterFactory adapterFactory, BreakdownElement e, String name, Suppression suppression) {
        return NameChecker.checkName(adapterFactory, e, (EStructuralFeature)UmaPackage.eINSTANCE.getNamedElement_Name(), name, suppression);
    }

    public static String checkBreakdownElementName(AdapterFactory adapterFactory, BreakdownElement e, String name, Suppression suppression, boolean ignoreSuppressed) {
        return NameChecker.checkName(adapterFactory, e, (EStructuralFeature)UmaPackage.eINSTANCE.getNamedElement_Name(), name, suppression, ignoreSuppressed);
    }

    public static String checkBreakdownElementPresentationName(AdapterFactory adapterFactory, BreakdownElement e, String name, Suppression suppression) {
        if ((name == null || name.length() == 0) && ProcessUtil.isExtendingOrLocallyContributing(e)) {
            BreakdownElement base = (BreakdownElement)((VariabilityElement)e).getVariabilityBasedOnElement();
            name = ProcessUtil.getPresentationName(base);
        }
        return NameChecker.checkName(adapterFactory, e, (EStructuralFeature)UmaPackage.eINSTANCE.getMethodElement_PresentationName(), name, suppression);
    }

    public static String checkBreakdownElementPresentationName(AdapterFactory adapterFactory, BreakdownElement e, String name, Suppression suppression, boolean ignoreSuppressed) {
        return NameChecker.checkName(adapterFactory, e, (EStructuralFeature)UmaPackage.eINSTANCE.getMethodElement_PresentationName(), name, suppression, ignoreSuppressed);
    }

    public static Object getRootProcess(AdapterFactory adapterFactory, ItemProviderAdapter adapter, Object obj) {
        Object parent = adapter.getParent(obj);
        adapter = (ItemProviderAdapter)adapterFactory.adapt(parent, ITreeItemContentProvider.class);
        if (parent == null) {
            return obj;
        }
        return ProcessUtil.getRootProcess(adapterFactory, adapter, parent);
    }

    public static Collection<EClass> getWBSEclasses() {
        if (WBSEclasses == null) {
            WBSEclasses = new HashSet<EClass>();
            WBSEclasses.add(UmaPackage.eINSTANCE.getTaskDescriptor());
            WBSEclasses.add(UmaPackage.eINSTANCE.getActivity());
            WBSEclasses.add(UmaPackage.eINSTANCE.getMilestone());
        }
        return WBSEclasses;
    }

    public static Collection<EClass> getOBSEclasses() {
        if (OBSEclasses == null) {
            OBSEclasses = new HashSet<EClass>();
            OBSEclasses.add(UmaPackage.eINSTANCE.getRoleDescriptor());
            OBSEclasses.add(UmaPackage.eINSTANCE.getActivity());
            OBSEclasses.add(UmaPackage.eINSTANCE.getMilestone());
            OBSEclasses.add(UmaPackage.eINSTANCE.getTeamProfile());
            OBSEclasses.add(UmaPackage.eINSTANCE.getCompositeRole());
        }
        return OBSEclasses;
    }

    public static Collection<EClass> getPBSEclasses() {
        if (PBSEclasses == null) {
            PBSEclasses = new HashSet<EClass>();
            PBSEclasses.add(UmaPackage.eINSTANCE.getWorkProductDescriptor());
            PBSEclasses.add(UmaPackage.eINSTANCE.getActivity());
            PBSEclasses.add(UmaPackage.eINSTANCE.getMilestone());
        }
        return PBSEclasses;
    }

    public static boolean isFirstElement(AdapterFactory adapterFactory, ItemProviderAdapter itemProvider, Object obj) {
        Object parent = itemProvider.getParent(obj);
        if (parent instanceof TeamProfile) {
            return true;
        }
        LinkedList siblings = ProcessUtil.getSiblings(adapterFactory, itemProvider, obj);
        if (siblings != null && !siblings.isEmpty()) {
            return siblings.getFirst() == obj;
        }
        return true;
    }

    public static LinkedList getSiblings(AdapterFactory adapterFactory, ItemProviderAdapter itemProvider, Object obj) {
        Object parent = itemProvider.getParent(obj);
        if (parent == null) {
            return null;
        }
        ITreeItemContentProvider parentItemProvider = (ITreeItemContentProvider)adapterFactory.adapt(parent, ITreeItemContentProvider.class);
        if (parentItemProvider != null) {
            return new LinkedList(parentItemProvider.getChildren(parent));
        }
        return null;
    }

    public static boolean isLastElement(AdapterFactory adapterFactory, ItemProviderAdapter itemProvider, Object obj) {
        Object parent = itemProvider.getParent(obj);
        if (parent instanceof TeamProfile) {
            return true;
        }
        LinkedList siblings = ProcessUtil.getSiblings(adapterFactory, itemProvider, obj);
        if (siblings != null && !siblings.isEmpty()) {
            return siblings.getLast() == obj;
        }
        return true;
    }

    public static List getAffectedElements(Notification notification, IFilter filter) {
        ArrayList<Object> affectedElements = new ArrayList<Object>();
        switch (notification.getEventType()) {
            case 3: {
                Object obj = notification.getNewValue();
                if (filter != null && !filter.accept(obj)) break;
                affectedElements.add(obj);
                break;
            }
            case 5: {
                for (Object element : (Collection)notification.getNewValue()) {
                    if (filter != null && !filter.accept(element)) continue;
                    affectedElements.add(element);
                }
                break;
            }
            case 4: {
                Object obj = notification.getOldValue();
                if (filter != null && !filter.accept(obj)) break;
                affectedElements.add(obj);
                break;
            }
            case 6: {
                for (Object element : (Collection)notification.getOldValue()) {
                    if (filter != null && !filter.accept(element)) continue;
                    affectedElements.add(element);
                }
                break;
            }
            case 7: {
                Object obj = notification.getNewValue();
                if (obj instanceof Collection) {
                    for (Object element : (Collection)obj) {
                        if (filter != null && !filter.accept(element)) continue;
                        affectedElements.add(element);
                    }
                    break;
                }
                if (filter != null && !filter.accept(obj)) break;
                affectedElements.add(obj);
            }
        }
        return affectedElements;
    }

    public static boolean isRefreshRequired(Notification notification, IFilter filter) {
        switch (notification.getEventType()) {
            case 1: 
            case 3: {
                Object obj = notification.getNewValue();
                if (filter != null && !filter.accept(obj)) break;
                return true;
            }
            case 5: {
                for (Object element : (Collection)notification.getNewValue()) {
                    if (filter != null && !filter.accept(element)) continue;
                    return true;
                }
                break;
            }
            case 4: {
                Object obj = notification.getOldValue();
                if (filter != null && !filter.accept(obj)) break;
                return true;
            }
            case 6: {
                for (Object element : (Collection)notification.getOldValue()) {
                    if (filter != null && !filter.accept(element)) continue;
                    return true;
                }
                break;
            }
            case 7: {
                Object obj = notification.getNewValue();
                if (obj instanceof Collection) {
                    for (Object element : (Collection)obj) {
                        if (filter != null && !filter.accept(element)) continue;
                        return true;
                    }
                    break;
                }
                if (filter != null && !filter.accept(obj)) break;
                return true;
            }
        }
        return false;
    }

    public static void addToContainer(BreakdownElement e, ItemProviderAdapter itemProvider) {
        ProcessUtil.addToContainer(e, itemProvider, true);
    }

    public static void addToContainer(BreakdownElement e, ItemProviderAdapter itemProvider, boolean move) {
        EObject container;
        ProcessPackage pkg = null;
        Object parent = itemProvider.getParent((Object)e);
        if (parent instanceof EObject && (container = ((EObject)parent).eContainer()) instanceof ProcessPackage) {
            pkg = (ProcessPackage)container;
        }
        if (pkg == null) {
            return;
        }
        if (e instanceof Activity) {
            ProcessPackage oldPkg;
            Activity act = (Activity)e;
            if (act.eContainer() == null) {
                ProcessPackage newPkg = UmaFactory.eINSTANCE.createProcessPackage();
                newPkg.setName(act.getName());
                pkg.getChildPackages().add(newPkg);
                newPkg.getProcessElements().add(e);
            } else if (move && (oldPkg = (ProcessPackage)act.eContainer()).eContainer() != pkg) {
                pkg.getChildPackages().add(oldPkg);
            }
        } else if (e.eContainer() == null) {
            pkg.getProcessElements().add(e);
        } else if (move && e.eContainer() != pkg) {
            pkg.getProcessElements().add(e);
        }
    }

    public static void setParent(Object child, Object parent, AdapterFactory adapterFactory) {
        Object adapter = adapterFactory.adapt(child, ITreeItemContentProvider.class);
        if (adapter instanceof IBSItemProvider) {
            ((IBSItemProvider)adapter).setParent(parent);
        }
    }

    public static RoleDescriptor createRoleDescriptor(Role role) {
        return ProcessUtil.createRoleDescriptor(role, false);
    }

    public static RoleDescriptor createRoleDescriptor(Role role, boolean isDynamic) {
        RoleDescriptor roleDesc = UmaFactory.eINSTANCE.createRoleDescriptor();
        roleDesc.setRole(role);
        String presentationName = role.getPresentationName();
        roleDesc.setName(role.getName());
        roleDesc.setPresentationName(StrUtil.isBlank((String)presentationName) ? role.getName() : presentationName);
        if (ProcessUtil.isSynFree() && isDynamic) {
            DescriptorPropUtil.getDesciptorPropUtil().setCreatedByReference((Descriptor)roleDesc, true);
        }
        return roleDesc;
    }

    public static WorkProductDescriptor createWorkProductDescriptor(WorkProduct wp) {
        return ProcessUtil.createWorkProductDescriptor(wp, false);
    }

    public static WorkProductDescriptor createWorkProductDescriptor(WorkProduct wp, boolean isDynamic) {
        WorkProductDescriptor wpDesc = UmaFactory.eINSTANCE.createWorkProductDescriptor();
        wpDesc.setWorkProduct(wp);
        wpDesc.setName(wp.getName());
        wpDesc.setPresentationName(StrUtil.isBlank((String)wp.getPresentationName()) ? wp.getName() : wp.getPresentationName());
        if (ProcessUtil.isSynFree() && isDynamic) {
            DescriptorPropUtil.getDesciptorPropUtil().setCreatedByReference((Descriptor)wpDesc, true);
        }
        return wpDesc;
    }

    public static boolean refreshNeeded(AdapterFactory adapterFactory, BSActivityItemProvider itemProvider) {
        return UserInteractionHelper.getUIHelper().refreshNeeded(adapterFactory, itemProvider);
    }

    public static void refreshPredeccessorLists(AdapterFactory factory, Process proc) {
        List<PredecessorList.DepthLevelItemProvider> list = PredecessorList.createItemProviderList(proc, factory);
        for (PredecessorList.DepthLevelItemProvider ip : list) {
            PredecessorList predList;
            Object itemProvider = ip.getItemProvider();
            if (!(itemProvider instanceof IBSItemProvider) || (predList = ((IBSItemProvider)itemProvider).getPredecessors()) == null) continue;
            predList.refresh(list);
        }
    }

    public static void updateIDs(AdapterFactory factory, Process proc) {
        AdapterFactoryTreeIterator<Object> iter = new AdapterFactoryTreeIterator<Object>(factory, (Object)proc){
            private static final long serialVersionUID = 1L;

            protected Iterator<Object> getChildren(Object o) {
                Object e = TngUtil.unwrap(o);
                if (e instanceof Descriptor || e instanceof Milestone) {
                    return Collections.emptyList().iterator();
                }
                return super.getChildren(o);
            }
        };
        int id = 0;
        while (iter.hasNext()) {
            IBSItemProvider itemProvider;
            Object obj = iter.next();
            Object adapter = factory.adapt(obj, ITreeItemContentProvider.class);
            if (!(adapter instanceof IBSItemProvider) || (itemProvider = (IBSItemProvider)adapter) == null || !(TngUtil.unwrap(obj) instanceof WorkBreakdownElement)) continue;
            itemProvider.setId(id++);
        }
    }

    public static void refreshViewer(AdapterFactory factory, Process proc) {
        UserInteractionHelper.getUIHelper().refreshViewer(factory, proc);
    }

    public static void refreshIDsInViewers(ExposedAdapterFactory adapterFactory) {
        UserInteractionHelper.getUIHelper().refreshIDsInViewer(adapterFactory);
    }

    public static void refreshAllViewers(ExposedAdapterFactory adapterFactory) {
        UserInteractionHelper.getUIHelper().refreshAllViewers(adapterFactory);
    }

    public static String checkPredecessorList(WorkBreakdownElement e, List<Integer> predIdList, AdapterFactory adapterFactory, Object process, List<Object> predecessors) {
        ArrayList beList = new ArrayList();
        ArrayList<Object> allElements = new ArrayList<Object>();
        AdapterFactoryTreeIterator iter = new AdapterFactoryTreeIterator(adapterFactory, process);
        while (iter.hasNext()) {
            Object obj = iter.next();
            IBSItemProvider itemProvider = (IBSItemProvider)adapterFactory.adapt(obj, ITreeItemContentProvider.class);
            Integer id = new Integer(itemProvider.getId());
            Object element = TngUtil.unwrap(obj);
            allElements.add(element);
            if (!predIdList.contains(id)) continue;
            beList.add(obj);
        }
        int size = beList.size();
        int i = 0;
        while (i < size) {
            Object obj = TngUtil.unwrap(beList.get(i));
            if (obj instanceof WorkBreakdownElement) {
                WorkBreakdownElement pred = (WorkBreakdownElement)obj;
                if (ProcessUtil.checkCircular(e, pred, allElements)) {
                    return LibraryEditResources.util_ProcessUtil_err_same_breakdown_element;
                }
                if (TngUtil.isSubelementOf(pred, e, adapterFactory)) {
                    return LibraryEditResources.util_ProcessUtil_err_same_sub_element;
                }
                if (TngUtil.isSuperElementOf(pred, e, adapterFactory)) {
                    return LibraryEditResources.util_ProcessUtil_err_child_element;
                }
            } else {
                return LibraryEditResources.util_ProcessUtil_err_wrong_element;
            }
            ++i;
        }
        if (predecessors != null) {
            predecessors.addAll(beList);
        }
        return null;
    }

    public static boolean checkCircular(WorkBreakdownElement successor, WorkBreakdownElement predecessor, List list) {
        if (successor == predecessor) {
            return predecessor.getIsRepeatable() == false;
        }
        for (WorkOrder element : predecessor.getLinkToPredecessor()) {
            WorkBreakdownElement pred = element.getPred();
            if (pred == predecessor || !list.contains(pred) || !ProcessUtil.checkCircular(successor, pred, list)) continue;
            return true;
        }
        return false;
    }

    public static void getAllPredecessorList(WorkBreakdownElement predecessor, List list, List predList) {
        if (!predList.contains(predecessor)) {
            predList.add(predecessor);
        }
        for (WorkOrder element : predecessor.getLinkToPredecessor()) {
            WorkBreakdownElement pred = element.getPred();
            if (pred == predecessor || !list.contains(pred) || predList.contains(pred)) continue;
            predList.add(pred);
            ProcessUtil.getAllPredecessorList(pred, list, predList);
        }
    }

    public static String checkPredecessorList(WorkBreakdownElement e, String predList, AdapterFactory adapterFactory, Object topAct, List<Object> predecessors) {
        ArrayList<Integer> idList = new ArrayList<Integer>();
        StringTokenizer tokens = new StringTokenizer(predList, ",");
        while (tokens.hasMoreTokens()) {
            Integer id;
            String token = tokens.nextToken().trim();
            try {
                id = new Integer(token);
            }
            catch (NumberFormatException numberFormatException) {
                return LibraryEditResources.invalidPredecessorError_msg;
            }
            idList.add(id);
        }
        return ProcessUtil.checkPredecessorList(e, idList, adapterFactory, topAct, predecessors);
    }

    public static void addToDefaultConfiguration(Process proc, EObject e, Set addedObjects) {
        MethodConfiguration config = proc.getDefaultContext();
        if (e instanceof Task) {
            ProcessUtil.addTaskToDefaultConfiguration(proc, (Task)e, addedObjects, true);
        } else if (e instanceof WorkProduct) {
            WorkProduct wp = (WorkProduct)e;
            ProcessUtil.addWPToDefaultConfiguration(proc, wp, addedObjects);
            List tasks = ProcessUtil.getTasksForWorkProduct(wp, config);
            if (tasks != null) {
                Iterator iter = tasks.iterator();
                while (iter.hasNext()) {
                    ProcessUtil.addTaskToDefaultConfiguration(proc, (Task)iter.next(), addedObjects, false);
                }
            }
        } else if (e instanceof Role) {
            Role role = (Role)e;
            ProcessUtil.addRoleToDefaultConfiguration(proc, role, addedObjects);
        } else if (e instanceof Activity) {
            ProcessUtil.addActivityToDefaultConfiguration(proc, (Activity)e, addedObjects);
        } else if (e instanceof Guidance) {
            TngUtil.addToConfiguration(config, (EObject)((Guidance)e), addedObjects);
        }
    }

    private static void addActivityToDefaultConfiguration(Process proc, Activity activity, Set addedObjects) {
        MethodConfiguration config = proc.getDefaultContext();
        TngUtil.addTo(config, (EObject)UmaUtil.getProcessComponent((MethodElement)activity), addedObjects);
        for (Object e : activity.getBreakdownElements()) {
            if (e instanceof Descriptor) {
                MethodElement o = ProcessUtil.getAssociatedElement((Descriptor)e);
                if (o == null) continue;
                ProcessUtil.addToDefaultConfiguration(proc, (EObject)o, addedObjects);
                continue;
            }
            if (!(e instanceof Activity)) continue;
            ProcessUtil.addActivityToDefaultConfiguration(proc, (Activity)e, addedObjects);
        }
        Activity base = (Activity)activity.getVariabilityBasedOnElement();
        while (base != null) {
            ProcessUtil.addActivityToDefaultConfiguration(proc, base, addedObjects);
            base = (Activity)base.getVariabilityBasedOnElement();
        }
    }

    private static void addTaskToDefaultConfiguration(Process proc, Task task, Set addedObjects, boolean includeWorkProducts) {
        MethodConfiguration config = proc.getDefaultContext();
        TngUtil.addToConfiguration(config, (EObject)task, addedObjects);
        ArrayList dependencies = new ArrayList();
        dependencies.addAll(task.getAdditionallyPerformedBy());
        dependencies.addAll(task.getPerformedBy());
        for (EObject eObject : dependencies) {
            TngUtil.addToConfiguration(config, eObject, addedObjects);
        }
        if (includeWorkProducts) {
            dependencies.clear();
            dependencies.addAll(task.getOptionalInput());
            dependencies.addAll(task.getOutput());
            dependencies.addAll(task.getMandatoryInput());
            for (EObject eObject : dependencies) {
                ProcessUtil.addWPToDefaultConfiguration(proc, (WorkProduct)eObject, addedObjects);
            }
        }
        for (Section step : task.getSteps()) {
            VariabilityElement base = step.getVariabilityBasedOnElement();
            if (base == null) continue;
            TngUtil.addToConfiguration(config, (EObject)base, addedObjects);
        }
    }

    private static void addRoleToDefaultConfiguration(Process proc, Role role, Set addedObjects) {
        MethodConfiguration config = proc.getDefaultContext();
        TngUtil.addToConfiguration(config, (EObject)role, addedObjects);
        ArrayList dependencies = new ArrayList();
        dependencies.addAll(role.getModifies());
        dependencies.addAll(role.getResponsibleFor());
        Iterator iter = dependencies.iterator();
        while (iter.hasNext()) {
            ProcessUtil.addWPToDefaultConfiguration(proc, (WorkProduct)iter.next(), addedObjects);
        }
    }

    private static void addWPToDefaultConfiguration(Process proc, WorkProduct wp, Set addedObjects) {
        MethodConfiguration config = proc.getDefaultContext();
        TngUtil.addToConfiguration(config, (EObject)wp, addedObjects);
        if (wp instanceof Deliverable) {
            Iterator iter = ((Deliverable)wp).getDeliveredWorkProducts().iterator();
            while (iter.hasNext()) {
                TngUtil.addToConfiguration(config, (EObject)iter.next(), addedObjects);
            }
        }
    }

    public static void updateTaskDescriptorSteps(Activity activity, TaskDescriptor taskDesc) {
        if (taskDesc == null) {
            return;
        }
        Task task = taskDesc.getTask();
        IConfigurationApplicator configApplicator = Providers.getConfigurationApplicator();
        MethodConfiguration config = TngUtil.getOwningProcess((BreakdownElement)activity).getDefaultContext();
        List steps = (List)configApplicator.getReference((VariabilityElement)task, UmaPackage.eINSTANCE.getTask_Steps(), config);
        for (Step step : steps) {
            if (taskDesc.getSelectedSteps().contains(step)) continue;
            taskDesc.getSelectedSteps().add(step);
        }
    }

    public static MethodElement getAssociatedElement(Descriptor descriptor) {
        if (descriptor instanceof RoleDescriptor) {
            return ((RoleDescriptor)descriptor).getRole();
        }
        if (descriptor instanceof TaskDescriptor) {
            return ((TaskDescriptor)descriptor).getTask();
        }
        if (descriptor instanceof WorkProductDescriptor) {
            return ((WorkProductDescriptor)descriptor).getWorkProduct();
        }
        return null;
    }

    public static EReference getLinkReference(Descriptor descriptor) {
        if (descriptor instanceof RoleDescriptor) {
            return UmaPackage.eINSTANCE.getRoleDescriptor_Role();
        }
        if (descriptor instanceof TaskDescriptor) {
            return UmaPackage.eINSTANCE.getTaskDescriptor_Task();
        }
        if (descriptor instanceof WorkProductDescriptor) {
            return UmaPackage.eINSTANCE.getWorkProductDescriptor_WorkProduct();
        }
        return null;
    }

    public static void disposeWrappers(Collection children) {
        if (children == null) {
            return;
        }
        for (Object element : children) {
            if (!(element instanceof IWrapperItemProvider)) continue;
            ((IWrapperItemProvider)element).dispose();
        }
    }

    public static List getTasksForWorkProduct(WorkProduct wp, MethodConfiguration config) {
        IConfigurationApplicator configApplicator = Providers.getConfigurationApplicator();
        List tasks = (List)configApplicator.getReference((MethodElement)wp, AssociationHelper.WorkProduct_OutputFrom_Tasks, config);
        return tasks;
    }

    public static List getWorkProductsForRole(Role role, MethodConfiguration config) {
        IConfigurationApplicator configApplicator = Providers.getConfigurationApplicator();
        List wps = (List)configApplicator.getReference((VariabilityElement)role, UmaPackage.eINSTANCE.getRole_ResponsibleFor(), config);
        return wps;
    }

    public static List getAllWorkProducts(MethodPlugin plugin) {
        ContentPackage coreContentPkg = UmaUtil.findContentPackage((MethodPlugin)plugin, (String[])ModelStructure.DEFAULT.coreContentPath);
        AbstractTreeIterator iter = new AbstractTreeIterator(coreContentPkg, false){
            private static final long serialVersionUID = 3833752066324837937L;

            protected Iterator getChildren(Object object) {
                if (!(object instanceof ContentPackage)) {
                    return Collections.EMPTY_LIST.iterator();
                }
                ContentPackage pkg = (ContentPackage)object;
                ArrayList children = new ArrayList();
                for (Object element : pkg.getChildPackages()) {
                    if (!(element instanceof ContentPackage)) continue;
                    children.add(element);
                }
                for (Object element : pkg.getContentElements()) {
                    if (!(element instanceof WorkProduct) || TngUtil.isContributor((VariabilityElement)element)) continue;
                    children.add(element);
                }
                return children.iterator();
            }
        };
        ArrayList methodElements = new ArrayList();
        while (iter.hasNext()) {
            Object e = iter.next();
            if (!(e instanceof WorkProduct)) continue;
            methodElements.add(e);
        }
        return methodElements;
    }

    public static List getAllTasks(MethodPlugin plugin) {
        ContentPackage coreContentPkg = UmaUtil.findContentPackage((MethodPlugin)plugin, (String[])ModelStructure.DEFAULT.coreContentPath);
        AbstractTreeIterator iter = new AbstractTreeIterator(coreContentPkg, false){
            private static final long serialVersionUID = 3833752066324837937L;

            protected Iterator getChildren(Object object) {
                if (!(object instanceof ContentPackage)) {
                    return Collections.EMPTY_LIST.iterator();
                }
                ContentPackage pkg = (ContentPackage)object;
                ArrayList children = new ArrayList();
                for (Object element : pkg.getChildPackages()) {
                    if (!(element instanceof ContentPackage)) continue;
                    children.add(element);
                }
                for (Object element : pkg.getContentElements()) {
                    if (!(element instanceof Task) || TngUtil.isContributor((VariabilityElement)element)) continue;
                    children.add(element);
                }
                return children.iterator();
            }
        };
        ArrayList tasks = new ArrayList();
        while (iter.hasNext()) {
            Object e = iter.next();
            if (!(e instanceof Task)) continue;
            tasks.add(e);
        }
        return tasks;
    }

    public static boolean isExtendingOrLocallyContributing(BreakdownElement e) {
        return TngUtil.isGeneralizer(e, ProcessUtil.getExtendAndLocalContributionVariabilityTypes());
    }

    public static String getPresentationName(BreakdownElement e) {
        if ((e.getPresentationName() == null || e.getPresentationName().length() == 0) && ProcessUtil.isExtendingOrLocallyContributing(e)) {
            BreakdownElement base = (BreakdownElement)((VariabilityElement)e).getVariabilityBasedOnElement();
            return ProcessUtil.getPresentationName(base);
        }
        return e.getPresentationName();
    }

    public static String getLabelWithPath(BreakdownElement e) {
        StringBuffer path = new StringBuffer(e.getName());
        Process proc = TngUtil.getOwningProcess(e);
        if (proc != null) {
            path.append(", ");
            MethodPlugin plugin = UmaUtil.getMethodPlugin((EObject)proc);
            if (plugin != null) {
                path.append(plugin.getName());
            }
            if (e != proc) {
                path.append('/').append(proc.getName());
            }
        }
        return path.toString();
    }

    public static void getModelInfo(BreakdownElement e, Object adapter, StringBuffer modelInfo) {
        if (e instanceof VariabilityElement) {
            VariabilityElement ve = (VariabilityElement)e;
            VariabilityElement base = ve.getVariabilityBasedOnElement();
            if (base != null) {
                VariabilityType type = ve.getVariabilityType();
                if (modelInfo.length() > 0) {
                    modelInfo.append("; ");
                }
                String pattern = null;
                if (type == VariabilityType.CONTRIBUTES) {
                    pattern = LibraryEditResources.util_ProcessUtil_contributesto;
                } else if (type == VariabilityType.LOCAL_CONTRIBUTION) {
                    pattern = LibraryEditResources.util_ProcessUtil_localContributesto;
                } else if (type == VariabilityType.EXTENDS) {
                    pattern = LibraryEditResources.process_extends;
                } else if (type == VariabilityType.REPLACES) {
                    pattern = LibraryEditResources.process_replaces;
                } else if (type == VariabilityType.LOCAL_REPLACEMENT) {
                    pattern = LibraryEditResources.process_localReplaces;
                }
                if (pattern != null) {
                    String path = ProcessUtil.getLabelWithPath((BreakdownElement)base);
                    modelInfo.append(MessageFormat.format((String)pattern, (Object[])new Object[]{path}));
                    ProcessUtil.getModelInfo((BreakdownElement)base, adapter, modelInfo);
                }
            }
        } else if (adapter instanceof BreakdownElementWrapperItemProvider) {
            BreakdownElementWrapperItemProvider wrapper = (BreakdownElementWrapperItemProvider)adapter;
            wrapper.getOwner();
            if (wrapper.getFeature() != null) {
                modelInfo.append(TngUtil.getFeatureText(wrapper.getFeature()));
            } else if (wrapper instanceof WorkProductDescriptorWrapperItemProvider) {
                ProcessUtil.getWPDModelInfo(modelInfo, wrapper, wrapper);
            }
        }
    }

    public static String getColumnName(String property) {
        if ("id".equals(property)) {
            return "id";
        }
        if ("name".equals(property)) {
            return "name";
        }
        if ("presentation_name".equals(property)) {
            return "presentation_name";
        }
        if ("predecessors".equals(property)) {
            return "predecessors";
        }
        if ("is_event_driven".equals(property)) {
            return "is_event_driven";
        }
        if ("is_ongoing".equals(property)) {
            return "is_ongoing";
        }
        if ("is_repeatable".equals(property)) {
            return "is_repeatable";
        }
        if ("prefix".equals(property)) {
            return "prefix";
        }
        if ("model_info".equals(property)) {
            return "model_info";
        }
        if ("type".equals(property)) {
            return "type";
        }
        if ("teams".equals(property)) {
            return "teams";
        }
        if ("entry_state".equals(property)) {
            return "entry_state";
        }
        if ("exit_state".equals(property)) {
            return "exit_state";
        }
        if ("deliverable".equals(property)) {
            return "deliverable";
        }
        if ("is_optional".equals(property)) {
            return "is_optional";
        }
        if ("is_planned".equals(property)) {
            return "is_planned";
        }
        if ("has_multiple_occurrences".equals(property)) {
            return "has_multiple_occurrences";
        }
        return null;
    }

    public static String getAttribute(Object object, String property, Object adapter) {
        WorkProductDescriptor wpd;
        BreakdownElement e = (BreakdownElement)TngUtil.unwrap(object);
        if (property == "id") {
            if (e instanceof WorkBreakdownElement && adapter instanceof IBSItemProvider) {
                return String.valueOf(((IBSItemProvider)adapter).getId());
            }
        } else if (property == "name") {
            if (adapter instanceof IItemLabelProvider) {
                return ((IItemLabelProvider)adapter).getText((Object)e);
            }
        } else {
            if (property == "presentation_name") {
                return ProcessUtil.getPresentationName(e);
            }
            if (property == "predecessors") {
                if (adapter instanceof IBSItemProvider) {
                    return ((IBSItemProvider)adapter).getPredecessors().toString();
                }
            } else if (property == "is_event_driven") {
                if (e instanceof WorkBreakdownElement) {
                    return String.valueOf(((WorkBreakdownElement)e).getIsEventDriven());
                }
            } else if (property == "is_ongoing") {
                if (e instanceof WorkBreakdownElement) {
                    return String.valueOf(((WorkBreakdownElement)e).getIsOngoing());
                }
            } else if (property == "is_repeatable") {
                if (e instanceof WorkBreakdownElement) {
                    return String.valueOf(((WorkBreakdownElement)e).getIsRepeatable());
                }
            } else {
                if (property == "prefix") {
                    return e.getPrefix();
                }
                if (property == "model_info") {
                    StringBuffer modelInfo = new StringBuffer();
                    ProcessUtil.getModelInfo(e, adapter, modelInfo);
                    return modelInfo.toString();
                }
                if (property == "type") {
                    WorkProduct wp;
                    String typeName = null;
                    if (e instanceof WorkProductDescriptor && (wp = ((WorkProductDescriptor)e).getWorkProduct()) != null) {
                        typeName = String.valueOf(wp.eClass().getName()) + "Descriptor";
                    }
                    if (typeName == null && e instanceof EObject) {
                        typeName = e.eClass().getName();
                    }
                    if (typeName != null) {
                        return UmaEditPlugin.INSTANCE.getString("_UI_" + typeName + "_type");
                    }
                } else if (property == "teams") {
                    if (e instanceof TeamProfile) {
                        return TngUtil.getPresentationName(((TeamProfile)e).getSuperTeam());
                    }
                    if (e instanceof RoleDescriptor && adapter instanceof ITreeItemContentProvider) {
                        AdapterFactory adapterFactory = null;
                        if (adapter instanceof BreakdownElementWrapperItemProvider) {
                            adapterFactory = ((BreakdownElementWrapperItemProvider)adapter).getAdapterFactory();
                        } else if (adapter instanceof ItemProviderAdapter) {
                            adapterFactory = ((ItemProviderAdapter)adapter).getAdapterFactory();
                        }
                        return ProcessUtil.getTeamListString(ProcessUtil.getTeamProfiles(object, (ITreeItemContentProvider)adapter, adapterFactory));
                    }
                }
            }
        }
        if (property == "entry_state") {
            if (e instanceof WorkProductDescriptor) {
                wpd = (WorkProductDescriptor)e;
                return TngUtil.checkNull(wpd.getActivityEntryState());
            }
        } else if (property == "exit_state") {
            if (e instanceof WorkProductDescriptor) {
                wpd = (WorkProductDescriptor)e;
                return TngUtil.checkNull(wpd.getActivityExitState());
            }
        } else if (property == "deliverable") {
            if (e instanceof WorkProductDescriptor) {
                List deliverables = AssociationHelper.getDeliverableDescriptors((WorkProductDescriptor)((WorkProductDescriptor)e));
                if (deliverables.isEmpty()) {
                    return "";
                }
                StringBuffer strBuf = new StringBuffer();
                int max = deliverables.size() - 1;
                int i = 0;
                while (i < max) {
                    strBuf.append(TngUtil.getPresentationName(deliverables.get(i))).append(',');
                    ++i;
                }
                strBuf.append(TngUtil.getPresentationName(deliverables.get(max)));
                return strBuf.toString();
            }
        } else {
            if (property == "is_optional") {
                return String.valueOf(e.getIsOptional());
            }
            if (property == "is_planned") {
                return String.valueOf(e.getIsPlanned());
            }
            if (property == "has_multiple_occurrences") {
                return String.valueOf(e.getHasMultipleOccurrences());
            }
        }
        return "";
    }

    public static Object getParentActivityOfTeam(BreakdownElement brElement) {
        ComposedAdapterFactory adapterFactory = TngAdapterFactory.INSTANCE.getOBS_ComposedAdapterFactory();
        ItemProviderAdapter adapter = (ItemProviderAdapter)adapterFactory.adapt((Notifier)brElement, ITreeItemContentProvider.class);
        Object parent = adapter.getParent((Object)brElement);
        while (!(parent instanceof Activity)) {
            brElement = (BreakdownElement)parent;
            adapter = (ItemProviderAdapter)adapterFactory.adapt((Notifier)brElement, ITreeItemContentProvider.class);
            parent = adapter.getParent((Object)brElement);
        }
        return parent;
    }

    public static void getRoleDescriptor(AdapterFactory adapterFactory, Activity parent, List roleDescList, List roles) {
        ItemProviderAdapter adapter = (ItemProviderAdapter)adapterFactory.adapt((Notifier)parent, ITreeItemContentProvider.class);
        Collection o = adapter.getChildren((Object)parent);
        if (o instanceof List) {
            List children = (List)o;
            for (Object obj : children) {
                RoleDescriptor roleDesc;
                if (obj instanceof Activity) {
                    ProcessUtil.getRoleDescriptor(adapterFactory, (Activity)obj, roleDescList, roles);
                }
                if (!(obj instanceof RoleDescriptor) || (roleDesc = (RoleDescriptor)obj).getRole() == null || !roles.contains(roleDesc.getRole())) continue;
                roleDescList.add(obj);
            }
        }
    }

    private static String getTeamListString(List teamProfiles) {
        if (teamProfiles.isEmpty()) {
            return "";
        }
        StringBuffer strBuf = new StringBuffer();
        int max = teamProfiles.size() - 1;
        int i = 0;
        while (i < max) {
            strBuf.append(TngUtil.getPresentationName(teamProfiles.get(i))).append(',');
            ++i;
        }
        strBuf.append(TngUtil.getPresentationName(teamProfiles.get(max)));
        return strBuf.toString();
    }

    public static void setAttribute(WorkBreakdownElement e, String prop, String txt) {
        if (prop == "name") {
            e.setName(txt);
        } else if (prop == "prefix") {
            e.setPrefix(txt);
        } else if (prop == "is_event_driven") {
            e.setIsEventDriven(Boolean.valueOf(txt));
        } else if (prop == "is_ongoing") {
            e.setIsOngoing(Boolean.valueOf(txt));
        } else if (prop == "is_repeatable") {
            e.setIsRepeatable(Boolean.valueOf(txt));
        }
    }

    public static void setAttribute(IActionManager actionMgr, BreakdownElement e, String prop, String txt) {
        if (prop == "name") {
            actionMgr.doAction(1, (EObject)e, (EStructuralFeature)UmaPackage.eINSTANCE.getNamedElement_Name(), txt, -1);
        } else if (prop == "prefix") {
            actionMgr.doAction(1, (EObject)e, (EStructuralFeature)UmaPackage.eINSTANCE.getBreakdownElement_Prefix(), txt, -1);
        } else if (prop == "is_event_driven") {
            actionMgr.doAction(1, (EObject)e, (EStructuralFeature)UmaPackage.eINSTANCE.getWorkBreakdownElement_IsEventDriven(), Boolean.valueOf(txt), -1);
        } else if (prop == "is_ongoing") {
            actionMgr.doAction(1, (EObject)e, (EStructuralFeature)UmaPackage.eINSTANCE.getWorkBreakdownElement_IsOngoing(), Boolean.valueOf(txt), -1);
        } else if (prop == "is_repeatable") {
            actionMgr.doAction(1, (EObject)e, (EStructuralFeature)UmaPackage.eINSTANCE.getWorkBreakdownElement_IsRepeatable(), Boolean.valueOf(txt), -1);
        } else if (prop == "presentation_name") {
            actionMgr.doAction(1, (EObject)e, (EStructuralFeature)UmaPackage.eINSTANCE.getMethodElement_PresentationName(), txt, -1);
        } else if (prop == "is_optional") {
            actionMgr.doAction(1, (EObject)e, (EStructuralFeature)UmaPackage.eINSTANCE.getBreakdownElement_IsOptional(), Boolean.valueOf(txt), -1);
        } else if (prop == "is_planned") {
            actionMgr.doAction(1, (EObject)e, (EStructuralFeature)UmaPackage.eINSTANCE.getBreakdownElement_IsPlanned(), Boolean.valueOf(txt), -1);
        } else if (prop == "has_multiple_occurrences") {
            actionMgr.doAction(1, (EObject)e, (EStructuralFeature)UmaPackage.eINSTANCE.getBreakdownElement_HasMultipleOccurrences(), Boolean.valueOf(txt), -1);
        } else if (e instanceof WorkProductDescriptor) {
            if (prop == "entry_state") {
                actionMgr.doAction(1, (EObject)e, (EStructuralFeature)UmaPackage.eINSTANCE.getWorkProductDescriptor_ActivityEntryState(), txt, -1);
            } else if (prop == "exit_state") {
                actionMgr.doAction(1, (EObject)e, (EStructuralFeature)UmaPackage.eINSTANCE.getWorkProductDescriptor_ActivityExitState(), txt, -1);
            }
        }
    }

    public static Activity generalize(Activity base, VariabilityType type) {
        Activity act = (Activity)UmaFactory.eINSTANCE.create(base.eClass());
        act.setName(base.getName());
        if (type == VariabilityType.LOCAL_REPLACEMENT) {
            String presentationName = ProcessUtil.getPresentationName((BreakdownElement)base);
            act.setPresentationName(StrUtil.isBlank((String)presentationName) ? base.getName() : presentationName);
        }
        act.setVariabilityBasedOnElement((VariabilityElement)base);
        act.setVariabilityType(type);
        if (type == VariabilityType.EXTENDS) {
            for (EAttribute attribute : base.eClass().getEAllAttributes()) {
                if (attribute.getEAttributeType().getInstanceClass() != Boolean.class) continue;
                act.eSet((EStructuralFeature)attribute, base.eGet((EStructuralFeature)attribute));
            }
        }
        ArrayList<MethodElement> workOrders = new ArrayList<MethodElement>();
        Iterator iter = new ArrayList(base.getLinkToPredecessor()).iterator();
        while (iter.hasNext()) {
            workOrders.add(TngUtil.copy((MethodElement)((WorkOrder)iter.next())));
        }
        act.getLinkToPredecessor().addAll(workOrders);
        return act;
    }

    public static List getElementsInScope(AdapterFactory adapterFactory, BreakdownElement element, Class type, List items) {
        Object currentParent;
        ITreeItemContentProvider itemProvider = (ITreeItemContentProvider)adapterFactory.adapt((Notifier)element, ITreeItemContentProvider.class);
        if (element instanceof Activity) {
            List children = ((Activity)element).getBreakdownElements();
            for (Object obj : children) {
                if (!type.isInstance(obj) || items.contains(obj)) continue;
                items.add(obj);
            }
        }
        if ((currentParent = itemProvider.getParent((Object)element)) != null) {
            ProcessUtil.getElementsInScope(adapterFactory, (BreakdownElement)currentParent, type, items);
        }
        return items;
    }

    public static List getRoles(List roleDescList) {
        ArrayList<Role> roleList = new ArrayList<Role>();
        if (roleDescList != null) {
            for (Object obj : roleDescList) {
                if (!(obj instanceof RoleDescriptor)) continue;
                Role role = ((RoleDescriptor)obj).getRole();
                roleList.add(role);
            }
        }
        return roleList;
    }

    public static List getAssociatedElementList(List descriptorList) {
        ArrayList<MethodElement> elementList = new ArrayList<MethodElement>();
        if (descriptorList != null) {
            for (Object obj : descriptorList) {
                if (!(obj instanceof Descriptor)) continue;
                MethodElement element = ProcessUtil.getAssociatedElement((Descriptor)obj);
                elementList.add(element);
            }
        }
        return elementList;
    }

    public static BreakdownElement getTopBreakdownElement(ProcessComponent pc) {
        Process be = pc.getProcess();
        if (be == null) {
            return null;
        }
        Adapter adapter = TngAdapterFactory.INSTANCE.getWBS_ComposedAdapterFactory().adapt((Notifier)be, ITreeItemContentProvider.class);
        if (!(adapter instanceof IBSItemProvider)) {
            return be;
        }
        IBSItemProvider itemProvider = (IBSItemProvider)adapter;
        if (itemProvider.getTopItem() == null) {
            itemProvider.setTopItem(be);
            itemProvider = (IBSItemProvider)TngAdapterFactory.INSTANCE.getOBS_ComposedAdapterFactory().adapt((Notifier)be, ITreeItemContentProvider.class);
            itemProvider.setTopItem(be);
            itemProvider = (IBSItemProvider)TngAdapterFactory.INSTANCE.getPBS_ComposedAdapterFactory().adapt((Notifier)be, ITreeItemContentProvider.class);
            itemProvider.setTopItem(be);
            itemProvider = (IBSItemProvider)TngAdapterFactory.INSTANCE.getProcessComposedAdapterFactory().adapt((Notifier)be, ITreeItemContentProvider.class);
            itemProvider.setTopItem(be);
        }
        ProcessUtil.updateIDs((EObject)be, (Object)be);
        return be;
    }

    private static void updateIDs(EObject topAct, Object newObj) {
        AdapterFactoryTreeIterator iter;
        Process proc;
        boolean updateWholeProcess;
        ItemProviderAdapter adapter = (ItemProviderAdapter)TngAdapterFactory.INSTANCE.getWBS_ComposedAdapterFactory().adapt((Notifier)topAct, ITreeItemContentProvider.class);
        AdapterFactory factory = TngUtil.getBestAdapterFactory(adapter.getAdapterFactory());
        boolean bl = updateWholeProcess = topAct == newObj && topAct instanceof Process;
        if (updateWholeProcess) {
            proc = (Process)topAct;
            ProcessUtil.updateIDs(factory, proc);
            ProcessUtil.refreshViewer(factory, proc);
        } else {
            iter = new AdapterFactoryTreeIterator(factory, (Object)topAct);
            ProcessUtil.updateIDs(factory, iter, newObj);
        }
        adapter = (ItemProviderAdapter)TngAdapterFactory.INSTANCE.getProcessComposedAdapterFactory().adapt((Notifier)topAct, ITreeItemContentProvider.class);
        factory = TngUtil.getBestAdapterFactory(adapter.getAdapterFactory());
        if (updateWholeProcess) {
            proc = (Process)topAct;
            ProcessUtil.updateIDs(factory, proc);
            ProcessUtil.refreshViewer(factory, proc);
        } else {
            iter = new AdapterFactoryTreeIterator(factory, (Object)topAct);
            ProcessUtil.updateIDs(factory, iter, newObj);
        }
    }

    public static void updateIDs(AdapterFactory factory, AdapterFactoryTreeIterator iter, Object newObj) {
        Object obj;
        int id = 0;
        HashMap<Object, IBSItemProvider> changeMap = new HashMap<Object, IBSItemProvider>();
        while (iter.hasNext()) {
            obj = iter.next();
            IBSItemProvider itemProvider = (IBSItemProvider)factory.adapt(obj, ITreeItemContentProvider.class);
            itemProvider.setId(id++);
            changeMap.put(obj, itemProvider);
        }
        for (Map.Entry entry : changeMap.entrySet()) {
            IChangeNotifier adapter = (IChangeNotifier)entry.getValue();
            obj = entry.getKey();
            adapter.fireNotifyChanged((Notification)new ViewerNotification((Notification)new NotificationImpl(1, obj, obj), obj, false, true));
        }
    }

    public static boolean checkDescriptorReferences(Descriptor descriptor, Descriptor obj) {
        Set<Descriptor> descriptors = descriptor != null ? Collections.singleton(descriptor) : Collections.EMPTY_SET;
        return ProcessUtil.checkDescriptorReferences(descriptors, obj);
    }

    public static boolean checkDescriptorReferences(Collection descriptors, Descriptor obj) {
        boolean referencesExists;
        block3: {
            block4: {
                referencesExists = false;
                if (!(obj instanceof RoleDescriptor)) break block4;
                RoleDescriptor refObject = (RoleDescriptor)obj;
                ArrayList list = new ArrayList();
                list.addAll(AssociationHelper.getAssistedTaskDescriptors((RoleDescriptor)refObject));
                list.addAll(AssociationHelper.getAdditionalTaskDescriptors((RoleDescriptor)refObject));
                list.addAll(AssociationHelper.getPrimaryTaskDescriptors((RoleDescriptor)refObject));
                list.addAll(AssociationHelper.getTeamProfiles((RoleDescriptor)refObject));
                for (Object refItorObject : list) {
                    if ((!(refItorObject instanceof Descriptor) || descriptors.contains(refItorObject)) && !(refItorObject instanceof TeamProfile)) continue;
                    referencesExists = true;
                    break block3;
                }
                break block3;
            }
            if (obj instanceof WorkProductDescriptor) {
                return ProcessUtil.checkWorkProductDescriptorReferences(descriptors, (WorkProductDescriptor)obj, false, -1);
            }
            if (!(obj instanceof TaskDescriptor)) break block3;
            TaskDescriptor refObject = (TaskDescriptor)obj;
            ArrayList list = new ArrayList();
            list.addAll(refObject.getAdditionallyPerformedBy());
            list.addAll(refObject.getAssistedBy());
            list.addAll(refObject.getExternalInput());
            list.addAll(refObject.getMandatoryInput());
            list.addAll(refObject.getOptionalInput());
            list.addAll(refObject.getOutput());
            list.addAll(refObject.getPerformedPrimarilyBy());
            for (Object refItorObject : list) {
                if (!(refItorObject instanceof Descriptor) || descriptors.contains(refItorObject)) continue;
                referencesExists = true;
                break;
            }
        }
        return referencesExists;
    }

    public static boolean checkWorkProductDescriptorReferences(Collection descriptors, WorkProductDescriptor refObject, boolean removeRelation, int featureID) {
        ArrayList<WorkProductDescriptor> allObjects = new ArrayList<WorkProductDescriptor>();
        allObjects.add(refObject);
        Activity parentActivity = UmaUtil.getParentActivity((BreakdownElement)refObject);
        if (refObject.getWorkProduct() instanceof Artifact) {
            List containedArtifacts = ((Artifact)refObject.getWorkProduct()).getContainedArtifacts();
            List containedWpDescList = ProcessUtil.getWpDescForArtifacts(containedArtifacts, parentActivity);
            ArrayList<Artifact> containerArtifacts = new ArrayList<Artifact>();
            Artifact artifact = ((Artifact)refObject.getWorkProduct()).getContainerArtifact();
            while (artifact != null) {
                containerArtifacts.add(artifact);
                artifact = artifact.getContainerArtifact();
            }
            List containerWpDescList = ProcessUtil.getWpDescForArtifacts(containerArtifacts, parentActivity);
            allObjects.addAll(containedWpDescList);
            allObjects.addAll(containerWpDescList);
        }
        int i = 0;
        while (i < allObjects.size()) {
            WorkProductDescriptor wpObj = (WorkProductDescriptor)allObjects.get(i);
            ArrayList list = new ArrayList();
            list.addAll(wpObj.getImpactedBy());
            list.addAll(wpObj.getImpacts());
            list.addAll(AssociationHelper.getResponsibleRoleDescriptors((WorkProductDescriptor)wpObj));
            list.addAll(wpObj.getDeliverableParts());
            ArrayList inputList = new ArrayList();
            inputList.addAll(AssociationHelper.getExternalInputTo((WorkProductDescriptor)wpObj));
            inputList.addAll(AssociationHelper.getMandatoryInputTo((WorkProductDescriptor)wpObj));
            inputList.addAll(AssociationHelper.getOptionalInputTo((WorkProductDescriptor)wpObj));
            List outputList = AssociationHelper.getOutputFrom((WorkProductDescriptor)wpObj);
            if (removeRelation) {
                switch (featureID) {
                    case 41: 
                    case 42: 
                    case 43: {
                        if (!outputList.containsAll(descriptors)) break;
                        return true;
                    }
                    case 44: {
                        if (!inputList.containsAll(descriptors)) break;
                        return true;
                    }
                }
            }
            list.addAll(inputList);
            list.addAll(outputList);
            for (Object refItorObject : list) {
                if (!(refItorObject instanceof Descriptor) || descriptors.contains(refItorObject)) continue;
                return true;
            }
            ++i;
        }
        return false;
    }

    public static List getWpDescForArtifacts(List artifacts, Activity parentActivity) {
        ArrayList<WorkProductDescriptor> wpDescList = new ArrayList<WorkProductDescriptor>();
        int i = 0;
        while (i < artifacts.size()) {
            Artifact artifact = (Artifact)artifacts.get(i);
            if (parentActivity != null) {
                List brElements = parentActivity.getBreakdownElements();
                for (Object brObj : brElements) {
                    WorkProductDescriptor wpDesc;
                    if (!(brObj instanceof WorkProductDescriptor) || !((wpDesc = (WorkProductDescriptor)brObj).getWorkProduct() instanceof Artifact) || !wpDesc.getWorkProduct().equals(artifact)) continue;
                    wpDescList.add(wpDesc);
                }
            }
            ++i;
        }
        return wpDescList;
    }

    public static CompositeRole createCompositeRole(CompositeRole obj) {
        CompositeRole compRole = UmaFactory.eINSTANCE.createCompositeRole();
        compRole.getAggregatedRoles().addAll(obj.getAggregatedRoles());
        String presentationName = obj.getPresentationName();
        compRole.setName(obj.getName());
        compRole.setPresentationName(StrUtil.isBlank((String)presentationName) ? obj.getName() : presentationName);
        return compRole;
    }

    public static void addTaskToActivity(Task task, Activity act) {
        WBSDropCommand cmd = new WBSDropCommand(act, Collections.singletonList(task));
        BSDropCommand.IExecutor executor = cmd.getExecutor();
        if (executor.preExecute()) {
            executor.doExcecute();
        }
    }

    public static boolean hasProcessNotOfType(ProcessPackage pkg, EClass processType) {
        Process proc;
        if (pkg instanceof ProcessComponent && (proc = ((ProcessComponent)pkg).getProcess()) != null && !processType.isInstance((Object)proc)) {
            return true;
        }
        for (Object childPkg : pkg.getChildPackages()) {
            Process proc2;
            if (!(childPkg instanceof ProcessComponent ? (proc2 = ((ProcessComponent)childPkg).getProcess()) != null && !processType.isInstance((Object)proc2) : childPkg instanceof ProcessPackage && ProcessUtil.hasProcessNotOfType((ProcessPackage)childPkg, processType))) continue;
            return true;
        }
        return false;
    }

    public static Object findRoleDescriptor(TeamProfile team, RoleDescriptor roleDesc) {
        List teamRoles = team.getTeamRoles();
        for (Object itorObject : teamRoles) {
            Role itorObjRole;
            Role objRole;
            List secondObjectAggRoles;
            List firstObjectAggRoles;
            if (!(roleDesc instanceof CompositeRole ? itorObject instanceof CompositeRole && (firstObjectAggRoles = ((CompositeRole)roleDesc).getAggregatedRoles()).equals(secondObjectAggRoles = ((CompositeRole)itorObject).getAggregatedRoles()) : roleDesc instanceof RoleDescriptor && itorObject instanceof RoleDescriptor && !(itorObject instanceof CompositeRole) && (objRole = roleDesc.getRole()).equals(itorObjRole = ((RoleDescriptor)itorObject).getRole()))) continue;
            return itorObject;
        }
        return null;
    }

    public static Map toColumnIndexToNameMap(String colNames) {
        HashMap<Integer, String> columnIndexToNameMap = new HashMap<Integer, String>();
        StringTokenizer tokens = new StringTokenizer(colNames, ",");
        int id = 0;
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken();
            columnIndexToNameMap.put(new Integer(id), ProcessUtil.getColumnID(token));
            ++id;
        }
        return columnIndexToNameMap;
    }

    private static String getColumnID(String colName) {
        int i = 0;
        while (i < IBSItemProvider.COLUMNS.length) {
            String col = IBSItemProvider.COLUMNS[i];
            if (col.equals(colName)) {
                return col;
            }
            ++i;
        }
        return null;
    }

    public static void removePredecessors(AdapterFactory factory, Process proc, List removedElements) {
        HashSet elements = new HashSet(removedElements);
        AdapterFactoryTreeIterator iter = new AdapterFactoryTreeIterator(factory, (Object)proc);
        while (iter.hasNext()) {
            Object obj = iter.next();
            IBSItemProvider itemProvider = (IBSItemProvider)factory.adapt(obj, ITreeItemContentProvider.class);
            if (itemProvider == null || !(TngUtil.unwrap(obj) instanceof WorkBreakdownElement)) continue;
            Iterator iterator = itemProvider.getPredecessors().iterator();
            while (iterator.hasNext()) {
                Object e = TngUtil.unwrap(iterator.next());
                if (e instanceof ItemProviderAdapter) {
                    e = ((ItemProviderAdapter)e).getTarget();
                }
                if (!elements.contains(e)) continue;
                iterator.remove();
            }
        }
    }

    private static void addToActivity(Activity act, BreakdownElement be, Object[] prevAndNext) {
        int id;
        Object next = prevAndNext[1];
        boolean added = false;
        if (next != null && (id = act.getBreakdownElements().indexOf(next)) != -1) {
            act.getBreakdownElements().add(id, be);
            added = true;
        }
        if (!added) {
            Object prev = prevAndNext[0];
            if (prev != null) {
                int id2 = act.getBreakdownElements().indexOf(prev);
                if (id2 != -1) {
                    act.getBreakdownElements().add(id2 + 1, be);
                } else {
                    act.getBreakdownElements().add(be);
                }
            } else {
                act.getBreakdownElements().add(be);
            }
        }
    }

    public static Activity contributeToActivity(BreakdownElementWrapperItemProvider adapter, List createdActivities) {
        Object parent = adapter.getParent(null);
        Object[] prevAndNext = ProcessUtil.getPreviousAndNext(adapter);
        if (parent instanceof BreakdownElementWrapperItemProvider) {
            parent = ProcessUtil.contributeToActivity((BreakdownElementWrapperItemProvider)parent, createdActivities);
        }
        Activity act = ProcessUtil.generialize(adapter, VariabilityType.LOCAL_CONTRIBUTION, prevAndNext);
        Activity parentAct = (Activity)parent;
        ProcessUtil.addToActivity(parentAct, (BreakdownElement)act, prevAndNext);
        try {
            ProcessUtil.copySuppressions(adapter, act);
        }
        catch (Throwable e) {
            LibraryEditPlugin.getDefault().getLogger().logError(e);
        }
        createdActivities.add(act);
        return act;
    }

    private static void copySuppressions(BreakdownElementWrapperItemProvider adapterForBaseAct, Activity contributerAct) {
        Suppression sup;
        IBreakdownElementWrapperItemProviderFactory factory = BreakdownElementWrapperItemProviderFactory.INSTANCE;
        BreakdownElementWrapperItemProvider newAdapter = (BreakdownElementWrapperItemProvider)factory.createWrapper(contributerAct, adapterForBaseAct.getOwner(), adapterForBaseAct.getAdapterFactory());
        HashMap<BreakdownElement, BreakdownElementWrapperItemProvider> newElementProviderMap = new HashMap<BreakdownElement, BreakdownElementWrapperItemProvider>();
        for (Object newItem : newAdapter.getChildren(null)) {
            Object unwrapped;
            if (!(newItem instanceof BreakdownElementWrapperItemProvider) || !((unwrapped = TngUtil.unwrap(newItem)) instanceof BreakdownElement)) continue;
            newElementProviderMap.put((BreakdownElement)unwrapped, (BreakdownElementWrapperItemProvider)newItem);
        }
        Object top = adapterForBaseAct.getTopItem();
        Process process = top instanceof Process ? (Process)top : null;
        Suppression suppression = sup = process == null ? null : Suppression.getSuppression(process);
        if (sup == null) {
            return;
        }
        ArrayList<BreakdownElementWrapperItemProvider> toSuppressList = new ArrayList<BreakdownElementWrapperItemProvider>();
        ArrayList<BreakdownElementWrapperItemProvider> toRevealList = new ArrayList<BreakdownElementWrapperItemProvider>();
        for (Object oldItem : adapterForBaseAct.getChildren(null)) {
            boolean newSup;
            BreakdownElementWrapperItemProvider oldProvider;
            boolean oldSup;
            BreakdownElementWrapperItemProvider newProvider;
            Object unwrapped;
            if (!(oldItem instanceof BreakdownElementWrapperItemProvider) || !((unwrapped = TngUtil.unwrap(oldItem)) instanceof BreakdownElement) || (newProvider = (BreakdownElementWrapperItemProvider)newElementProviderMap.get(unwrapped)) == null || (oldSup = sup.isSuppressed(oldProvider = (BreakdownElementWrapperItemProvider)oldItem)) == (newSup = sup.isSuppressed(newProvider))) continue;
            if (oldSup) {
                toSuppressList.add(newProvider);
                continue;
            }
            toRevealList.add(newProvider);
        }
        if (!toSuppressList.isEmpty()) {
            sup.suppress(toSuppressList);
        }
        if (!toRevealList.isEmpty()) {
            sup.reveal(toRevealList);
        }
    }

    public static void replaceActivityLocally(BreakdownElementWrapperItemProvider adapter, List createdActivities) {
        Object parent = adapter.getParent(null);
        Object[] prevAndNext = ProcessUtil.getPreviousAndNext(adapter);
        if (parent instanceof BreakdownElementWrapperItemProvider) {
            parent = ProcessUtil.contributeToActivity((BreakdownElementWrapperItemProvider)parent, createdActivities);
        }
        Activity act = ProcessUtil.generialize(adapter, VariabilityType.LOCAL_REPLACEMENT, prevAndNext);
        Activity parentAct = (Activity)parent;
        ProcessUtil.addToActivity(parentAct, (BreakdownElement)act, prevAndNext);
        createdActivities.add(act);
    }

    static Object[] getPreviousAndNext(BreakdownElementWrapperItemProvider adapter) {
        Object parent = adapter.getParent(null);
        AdapterFactory adapterFactory = TngUtil.getBestAdapterFactory(adapter.getAdapterFactory());
        ITreeItemContentProvider itemProvider = (ITreeItemContentProvider)adapterFactory.adapt(parent, ITreeItemContentProvider.class);
        List children = (List)itemProvider.getChildren(parent);
        int id = children.indexOf(adapter) + 1;
        Object next = null;
        if (id < children.size()) {
            next = children.get(id);
        }
        Object prev = null;
        if ((id -= 2) > -1) {
            prev = children.get(id);
        }
        Object[] prevAndNext = new Object[]{prev, next};
        return prevAndNext;
    }

    static Activity generialize(BreakdownElementWrapperItemProvider adapter, VariabilityType type, Object[] prevAndNext) {
        Object prev;
        AdapterFactory adapterFactory = TngUtil.getBestAdapterFactory(adapter.getAdapterFactory());
        Activity act = ProcessUtil.generalize((Activity)TngUtil.unwrap(adapter), type);
        Object next = prevAndNext[1];
        if (next != null) {
            act.setPresentedAfter((BreakdownElement)TngUtil.unwrap(next));
            if (next instanceof BreakdownElement) {
                ((BreakdownElement)next).setPresentedBefore((BreakdownElement)act);
            }
        }
        if ((prev = prevAndNext[0]) != null) {
            act.setPresentedBefore((BreakdownElement)TngUtil.unwrap(prev));
            if (prev instanceof BreakdownElement) {
                ((BreakdownElement)prev).setPresentedAfter((BreakdownElement)act);
            }
        }
        IBSItemProvider bsItemProvider = (IBSItemProvider)adapterFactory.adapt((Notifier)act, ITreeItemContentProvider.class);
        bsItemProvider.setExpanded(adapter.isExpanded());
        return act;
    }

    public static Process getImmediateBaseProcess(BreakdownElementWrapperItemProvider itemProvider) {
        Activity inheritor = ProcessUtil.getInheritor(itemProvider);
        if (inheritor != null) {
            return TngUtil.getOwningProcess((BreakdownElement)inheritor.getVariabilityBasedOnElement());
        }
        return null;
    }

    public static Activity getInheritor(BreakdownElementWrapperItemProvider itemProvider) {
        if (itemProvider.isReadOnly()) {
            Object parent = itemProvider.getParent(itemProvider);
            while (parent != null) {
                if (parent instanceof BreakdownElementWrapperItemProvider) {
                    parent = ((BreakdownElementWrapperItemProvider)parent).getParent(parent);
                    continue;
                }
                return (Activity)parent;
            }
        }
        return null;
    }

    public static List getParentList(Object from, BreakdownElementWrapperItemProvider wrapper) {
        return ProcessUtil.getParentList(wrapper, from, wrapper.getAdapterFactory());
    }

    public static LinkedList<String> getGuidList(BreakdownElementWrapperItemProvider wrapper) {
        LinkedList<String> guidList = new LinkedList<String>();
        List parentList = ProcessUtil.getParentList(null, wrapper);
        if (!parentList.isEmpty()) {
            for (MethodElement e : parentList) {
                if (e instanceof TaskDescriptor || e instanceof RoleDescriptor) continue;
                guidList.add(e.getGuid());
            }
        }
        MethodElement e = (MethodElement)TngUtil.unwrap(wrapper);
        guidList.add(e.getGuid());
        return guidList;
    }

    public static LinkedList<String> getGuidList(Activity start, Activity activity) {
        LinkedList<String> guidList = new LinkedList<String>();
        Activity parent = activity;
        while (parent != null && (start == null || parent != start)) {
            guidList.addFirst(parent.getGuid());
            parent = parent.getSuperActivities();
        }
        return guidList;
    }

    public static List<String> getGuidList(Object activityOrWrapper) {
        if (activityOrWrapper instanceof BreakdownElementWrapperItemProvider) {
            return ProcessUtil.getGuidList((BreakdownElementWrapperItemProvider)activityOrWrapper);
        }
        if (activityOrWrapper instanceof Activity) {
            return ProcessUtil.getGuidList(null, (Activity)activityOrWrapper);
        }
        return null;
    }

    public static String toGuidPath(List<String> guidList) {
        StringBuffer path = new StringBuffer();
        for (String guid : guidList) {
            path.append('/').append(guid);
        }
        return path.toString();
    }

    public static List getParentList(Object object, Object from, AdapterFactory adapterFactory) {
        ArrayList<MethodElement> parentList = new ArrayList<MethodElement>();
        ITreeItemContentProvider itemProvider = (ITreeItemContentProvider)adapterFactory.adapt(object, ITreeItemContentProvider.class);
        Object parent = itemProvider.getParent(object);
        while (parent != from && parent != null) {
            ItemProviderAdapter adapter;
            MethodElement e;
            Object obj = TngUtil.unwrap(parent);
            if (obj instanceof MethodElement) {
                e = (MethodElement)obj;
                adapter = parent instanceof ITreeItemContentProvider ? (ITreeItemContentProvider)parent : (ITreeItemContentProvider)adapterFactory.adapt(parent, ITreeItemContentProvider.class);
                parent = ProcessUtil.isTopProcess(e) ? null : adapter.getParent(parent);
            } else {
                adapter = (ItemProviderAdapter)obj;
                e = (MethodElement)adapter.getTarget();
                parent = adapter.getParent(parent);
            }
            parentList.add(0, e);
        }
        return parentList;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List getWrappers(BreakdownElementWrapperItemProvider wrapper, AdapterFactory[] adapterFactories) {
        rolledUpItemProviders = new ArrayList<IBSItemProvider>();
        try {
            rootAdapterFactory = TngUtil.getBestAdapterFactory(wrapper.getAdapterFactory());
            proc = wrapper.getTopItem();
            objects = new ArrayList<Object>(ProcessUtil.getParentList(proc, wrapper));
            wrappers = new ArrayList<Object>();
            i = 0;
            while (i < adapterFactories.length) {
                adapterFactory = adapterFactories[i];
                if (adapterFactory == rootAdapterFactory) {
                    wrappers.add(wrapper);
                } else {
                    e = TngUtil.unwrap(wrapper);
                    objects.add(e);
                    object = proc;
                    block4: for (E var12_12 : objects) {
                        adapter = (ITreeItemContentProvider)adapterFactory.adapt(object, ITreeItemContentProvider.class);
                        be = TngUtil.unwrap(object);
                        if (be instanceof Activity) {
                            if (adapter instanceof BSActivityItemProvider) {
                                itemProvider = (BSActivityItemProvider)adapter;
                                if (itemProvider.isRolledUp()) {
                                    itemProvider.basicSetRolledUp(false);
                                    rolledUpItemProviders.add(itemProvider);
                                }
                            } else if (adapter instanceof IBSItemProvider && (itemProvider = (IBSItemProvider)adapter).isRolledUp()) {
                                itemProvider.setRolledUp(false);
                                rolledUpItemProviders.add(itemProvider);
                            }
                        }
                        for (E child : adapter.getChildren(object)) {
                            if (var12_12 != TngUtil.unwrap(child)) continue;
                            object = child;
                            continue block4;
                        }
                    }
                    if (object instanceof BreakdownElementWrapperItemProvider == false) throw new RuntimeException("Could not find wrapper for " + e + " using adapter factory " + adapterFactory);
                    wrappers.add(object);
                }
                ++i;
            }
            var18_17 = wrappers;
            return var18_17;
        }
        finally {
            if (rolledUpItemProviders.isEmpty() != false) return var18_17;
            iter = rolledUpItemProviders.iterator();
            ** while (iter.hasNext())
        }
lbl-1000:
        // 1 sources

        {
            ((BSActivityItemProvider)iter.next()).basicSetRolledUp(true);
            continue;
        }
lbl51:
        // 1 sources

        return var18_17;
    }

    public static void getWPDModelInfo(StringBuffer modelInfo, Object object, Object itemProvider) {
        Object element = TngUtil.unwrap(object);
        if (element instanceof WorkProductDescriptor) {
            WorkProductDescriptor wpd = (WorkProductDescriptor)element;
            if (itemProvider instanceof ITreeItemContentProvider) {
                AdapterFactory adapterFactory = null;
                if (itemProvider instanceof ItemProviderAdapter) {
                    adapterFactory = ((ItemProviderAdapter)itemProvider).getAdapterFactory();
                } else if (itemProvider instanceof BreakdownElementWrapperItemProvider) {
                    adapterFactory = ((BreakdownElementWrapperItemProvider)itemProvider).getAdapterFactory();
                }
                if (adapterFactory != null) {
                    Object parentDescriptor = null;
                    ITreeItemContentProvider adapter = (ITreeItemContentProvider)itemProvider;
                    Object parent = adapter.getParent(object);
                    while (parent != null) {
                        Object e = TngUtil.unwrap(parent);
                        if (e instanceof TaskDescriptor) {
                            parentDescriptor = e;
                            break;
                        }
                        if (e instanceof Activity) break;
                        adapter = (ITreeItemContentProvider)adapterFactory.adapt(parent, ITreeItemContentProvider.class);
                        parent = adapter.getParent(parent);
                    }
                    if (parentDescriptor != null) {
                        ModifiedTypeMeta meta;
                        ArrayList<EReference> features = new ArrayList<EReference>();
                        if (AssociationHelper.getMandatoryInputTo((WorkProductDescriptor)wpd).contains(parentDescriptor)) {
                            features.add(UmaPackage.eINSTANCE.getTaskDescriptor_MandatoryInput());
                        }
                        if (AssociationHelper.getOptionalInputTo((WorkProductDescriptor)wpd).contains(parentDescriptor)) {
                            features.add(UmaPackage.eINSTANCE.getTaskDescriptor_OptionalInput());
                        }
                        if (AssociationHelper.getOutputFrom((WorkProductDescriptor)wpd).contains(parentDescriptor)) {
                            features.add(UmaPackage.eINSTANCE.getTaskDescriptor_Output());
                        }
                        if ((meta = TypeDefUtil.getMdtMeta(UmaPackage.eINSTANCE.getTask())) != null) {
                            TaskDescriptor td = (TaskDescriptor)parentDescriptor;
                            for (ExtendedReference eRef : meta.getReferences()) {
                                List<MethodElement> list;
                                if (!"workproducts".equals(eRef.getContributeTo()) || !(list = PropUtil.getPropUtil().getExtendedReferenceList((MethodElement)td, eRef, false)).contains(wpd)) continue;
                                features.add(eRef.getReference());
                            }
                        }
                        if (!features.isEmpty()) {
                            if (modelInfo.toString().length() > 0) {
                                modelInfo.append(",");
                            }
                            int i = 0;
                            while (i < features.size()) {
                                EStructuralFeature feature = (EStructuralFeature)features.get(i);
                                modelInfo.append(TngUtil.getFeatureText(feature));
                                if (i < features.size() - 1) {
                                    modelInfo.append(",");
                                }
                                ++i;
                            }
                        }
                        return;
                    }
                }
            }
            ProcessUtil.getModelInfoForWorkProductDescriptor(modelInfo, wpd);
        }
    }

    private static void getModelInfoForWorkProductDescriptor(StringBuffer modelInfo, WorkProductDescriptor object) {
        ModifiedTypeMeta meta;
        String comma = ",";
        if (!AssociationHelper.getMandatoryInputTo((WorkProductDescriptor)object).isEmpty()) {
            if (modelInfo.toString().length() > 0) {
                modelInfo.append(comma);
            }
            modelInfo.append(UmaEditPlugin.INSTANCE.getString("_UI_TaskDescriptor_mandatoryInput_feature"));
        }
        if (!AssociationHelper.getOptionalInputTo((WorkProductDescriptor)object).isEmpty()) {
            if (modelInfo.toString().length() > 0) {
                modelInfo.append(comma);
            }
            modelInfo.append(UmaEditPlugin.INSTANCE.getString("_UI_TaskDescriptor_optionalInput_feature"));
        }
        if (!AssociationHelper.getOutputFrom((WorkProductDescriptor)object).isEmpty()) {
            if (modelInfo.toString().length() > 0) {
                modelInfo.append(comma);
            }
            modelInfo.append(UmaEditPlugin.INSTANCE.getString("_UI_TaskDescriptor_output_feature"));
        }
        if ((meta = TypeDefUtil.getMdtMeta(UmaPackage.eINSTANCE.getTask())) != null) {
            for (ExtendedReference eRef : meta.getReferences()) {
                List<MethodElement> list;
                if (!"workproducts".equals(eRef.getContributeTo()) || (list = PropUtil.getPropUtil().getReferencingList((MethodElement)object, eRef)) == null || list.isEmpty()) continue;
                if (modelInfo.toString().length() > 0) {
                    modelInfo.append(comma);
                }
                modelInfo.append(eRef.getName());
            }
        }
    }

    public static Collection getDuplicateDescriptorsAfterReveal(Collection elementsToReveal) {
        ArrayList<Object> duplicates = new ArrayList<Object>();
        for (Object element : elementsToReveal) {
            Descriptor desc;
            MethodElement e;
            if (!(element instanceof Descriptor) || (e = ProcessUtil.getAssociatedElement(desc = (Descriptor)element)) == null) continue;
            Activity act = UmaUtil.getParentActivity((BreakdownElement)desc);
            MethodConfiguration config = TngUtil.getOwningProcess((BreakdownElement)act).getDefaultContext();
            e = (MethodElement)Providers.getConfigurationApplicator().resolve(e, config);
            Object duplicate = ProcessCommandUtil.getDescriptor((Object)e, act, config);
            if (duplicate == null || duplicates.contains(duplicate)) continue;
            duplicates.add(duplicate);
        }
        return duplicates;
    }

    public static Collection<Descriptor> getDuplicateDescriptorsAfterSuppress(Collection elementsToSuppress) {
        ArrayList<Descriptor> duplicates = new ArrayList<Descriptor>();
        for (Object item : elementsToSuppress) {
            Descriptor desc;
            MethodElement e;
            if (!(item instanceof Descriptor) || (e = ProcessUtil.getAssociatedElement(desc = (Descriptor)item)) == null) continue;
            Activity act = UmaUtil.getParentActivity((BreakdownElement)desc);
            for (BreakdownElement element : act.getBreakdownElements()) {
                MethodElement linkedElement;
                if (element == desc || !(element instanceof Descriptor) || !element.getSuppressed().booleanValue() || (linkedElement = ProcessUtil.getAssociatedElement((Descriptor)element)) != e) continue;
                duplicates.add((Descriptor)element);
            }
        }
        return duplicates;
    }

    public static boolean isInherited(Object object) {
        return object instanceof DescribableElementWrapperItemProvider && ((DescribableElementWrapperItemProvider)object).isInherited();
    }

    public static boolean hasInherited(Activity activity) {
        AbstractTreeIterator iter = new AbstractTreeIterator(activity){
            private static final long serialVersionUID = 0L;

            protected Iterator getChildren(Object object) {
                if (object instanceof Activity) {
                    return ((Activity)object).getBreakdownElements().iterator();
                }
                return Collections.EMPTY_LIST.iterator();
            }
        };
        while (iter.hasNext()) {
            VariabilityType type;
            Activity act;
            VariabilityElement ve;
            Object o = iter.next();
            if (!(o instanceof Activity) || (ve = (act = (Activity)o).getVariabilityBasedOnElement()) == null || (type = act.getVariabilityType()) != VariabilityType.EXTENDS && type != VariabilityType.LOCAL_CONTRIBUTION) continue;
            return true;
        }
        return false;
    }

    public static boolean isContributed(Object object) {
        return object instanceof BreakdownElementWrapperItemProvider && ((BreakdownElementWrapperItemProvider)object).isContributed();
    }

    public static void getAllSubTeams(TeamProfile team, List teams) {
        teams.add(team);
        List subTeams = team.getSubTeam();
        for (TeamProfile subTeam : subTeams) {
            ProcessUtil.getAllSubTeams(subTeam, teams);
        }
    }

    private static List getTeamProfiles(Object object, ITreeItemContentProvider adapter, AdapterFactory adapterFactory) {
        RoleDescriptor roleDesc = (RoleDescriptor)TngUtil.unwrap(object);
        ArrayList teams = new ArrayList(AssociationHelper.getTeamProfiles((RoleDescriptor)roleDesc));
        HashSet visibleTeams = new HashSet();
        Object parent = adapter.getParent(object);
        while (parent != null) {
            adapter = (ITreeItemContentProvider)adapterFactory.adapt(parent, ITreeItemContentProvider.class);
            Iterator iter = adapter.getChildren(parent).iterator();
            while (iter.hasNext()) {
                Object e = TngUtil.unwrap(iter.next());
                if (!(e instanceof TeamProfile)) continue;
                ArrayList activityTeams = new ArrayList();
                ProcessUtil.getAllSubTeams((TeamProfile)e, activityTeams);
                for (Object o : activityTeams) {
                    if (!(o instanceof TeamProfile) || !((TeamProfile)o).getTeamRoles().contains(roleDesc)) continue;
                    visibleTeams.add(o);
                }
            }
            Object newParent = adapter.getParent(parent);
            if (newParent == null && parent instanceof Activity) {
                newParent = UmaUtil.getParentActivity((BreakdownElement)((Activity)parent));
            }
            parent = newParent;
        }
        Iterator iter = teams.iterator();
        while (iter.hasNext()) {
            Object team = iter.next();
            if (visibleTeams.contains(team)) continue;
            iter.remove();
        }
        return teams;
    }

    public static List getTeamProfiles(RoleDescriptorWrapperItemProvider roleDescWrapper) {
        return ProcessUtil.getTeamProfiles(roleDescWrapper, (ITreeItemContentProvider)roleDescWrapper, roleDescWrapper.getAdapterFactory());
    }

    public static List getTeamProfiles(RoleDescriptor roleDesc, AdapterFactory adapterFactory) {
        ITreeItemContentProvider adapter = (ITreeItemContentProvider)adapterFactory.adapt((Notifier)roleDesc, ITreeItemContentProvider.class);
        return ProcessUtil.getTeamProfiles(roleDesc, adapter, adapterFactory);
    }

    public static void getChildElements(Activity act, Class type, Collection collection) {
        int i = act.getBreakdownElements().size() - 1;
        while (i > -1) {
            Object element = act.getBreakdownElements().get(i);
            if (type.isInstance(element)) {
                collection.add(element);
            }
            if (element instanceof Activity) {
                ProcessUtil.getChildElements((Activity)element, type, collection);
            }
            --i;
        }
    }

    public static IFilter getFilter(AdapterFactory adapterFactory) {
        AdapterFactory rootAdapterFactory = TngUtil.getBestAdapterFactory(adapterFactory);
        if (rootAdapterFactory instanceof ConfigurableComposedAdapterFactory) {
            return ((ConfigurableComposedAdapterFactory)rootAdapterFactory).getFilter();
        }
        return null;
    }

    public static List getContainedArtifacts(Artifact artifact, AdapterFactory adapterFactory) {
        MethodConfiguration config = null;
        IFilter filter = ProcessUtil.getFilter(adapterFactory);
        if (filter instanceof IConfigurator) {
            config = ((IConfigurator)filter).getMethodConfiguration();
        }
        if (config == null) {
            return artifact.getContainedArtifacts();
        }
        return (List)Providers.getConfigurationApplicator().getReference((VariabilityElement)artifact, UmaPackage.eINSTANCE.getArtifact_ContainedArtifacts(), config);
    }

    public static List getContainedArtifactsDescriptors(WorkProductDescriptor artifactDesc, List artifactDescriptors) {
        if (artifactDescriptors.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        Artifact artifact = (Artifact)artifactDesc.getWorkProduct();
        ArrayList<WorkProductDescriptor> containedDescriptors = new ArrayList<WorkProductDescriptor>();
        int i = artifactDescriptors.size() - 1;
        while (i > -1) {
            EObject container;
            WorkProductDescriptor wpd = (WorkProductDescriptor)artifactDescriptors.get(i);
            WorkProduct a = wpd.getWorkProduct();
            if (a != null && ((container = a.eContainer()) == artifact || container instanceof Artifact && TngUtil.isContributorOf(artifact, (VariabilityElement)((Artifact)container)))) {
                containedDescriptors.add(wpd);
            }
            --i;
        }
        return containedDescriptors;
    }

    public static boolean isContainedBy(WorkProductDescriptor parent, WorkProductDescriptor child, List artifactDescList) {
        return UmaUtil.isContainedBy((EObject)child.getWorkProduct(), (Object)parent.getWorkProduct());
    }

    public static List removeSubartifactsFromChildren(MethodConfiguration config, Collection children, boolean unwrap) {
        ArrayList<WorkProduct> artifactList = new ArrayList<WorkProduct>();
        for (Object child : children) {
            WorkProduct wp;
            if (unwrap) {
                child = TngUtil.unwrap(child);
            }
            if (!(child instanceof WorkProductDescriptor) || !((wp = ((WorkProductDescriptor)child).getWorkProduct()) instanceof Artifact)) continue;
            artifactList.add(wp);
        }
        HashSet<Artifact> topMostArtifacts = new HashSet<Artifact>();
        Artifact candidate = null;
        boolean found = false;
        while (!artifactList.isEmpty()) {
            if (!found) {
                candidate = (Artifact)artifactList.get(0);
                artifactList.remove(0);
            }
            Iterator iter = artifactList.iterator();
            while (iter.hasNext()) {
                Artifact artifact = (Artifact)iter.next();
                found = false;
                if (LibraryEditUtil.getInstance().isContainedBy((MethodElement)artifact, (MethodElement)candidate, config)) {
                    iter.remove();
                    continue;
                }
                if (!LibraryEditUtil.getInstance().isContainedBy((MethodElement)candidate, (MethodElement)artifact, config)) continue;
                iter.remove();
                candidate = artifact;
                found = true;
                break;
            }
            if (!found || artifactList.isEmpty()) {
                topMostArtifacts.add(candidate);
                continue;
            }
            if (!artifactList.isEmpty()) continue;
            topMostArtifacts.add(candidate);
        }
        ArrayList result = new ArrayList();
        for (Object child : children) {
            Object e = unwrap ? TngUtil.unwrap(child) : child;
            boolean selected = false;
            if (e instanceof WorkProductDescriptor) {
                WorkProductDescriptor wpd = (WorkProductDescriptor)e;
                WorkProduct wp = wpd.getWorkProduct();
                if (!(wp instanceof Artifact)) {
                    selected = true;
                } else if (topMostArtifacts.contains(wp)) {
                    selected = true;
                }
            } else {
                selected = true;
            }
            if (!selected) continue;
            result.add(child);
        }
        return result;
    }

    public static List removeSubartifactsFromChildren(Collection children, boolean unwrap, AdapterFactory adapterFactory) {
        IFilter filter;
        ArrayList artifactDescList = new ArrayList();
        for (Object child : children) {
            WorkProduct wp;
            if (unwrap) {
                child = TngUtil.unwrap(child);
            }
            if (!(child instanceof WorkProductDescriptor) || !((wp = ((WorkProductDescriptor)child).getWorkProduct()) instanceof Artifact)) continue;
            artifactDescList.add(child);
        }
        if (artifactDescList.isEmpty()) {
            if (children instanceof List) {
                return (List)children;
            }
            return new ArrayList(children);
        }
        MethodConfiguration config = null;
        if (adapterFactory != null && (filter = ProcessUtil.getFilter(adapterFactory)) instanceof IConfigurator) {
            config = ((IConfigurator)filter).getMethodConfiguration();
        }
        HashSet<WorkProductDescriptor> topMostArtifactDescList = new HashSet<WorkProductDescriptor>();
        new ArrayList(artifactDescList);
        WorkProductDescriptor candidate = null;
        boolean found = false;
        while (!artifactDescList.isEmpty()) {
            if (!found) {
                candidate = (WorkProductDescriptor)artifactDescList.get(0);
                artifactDescList.remove(0);
            }
            Iterator iter = artifactDescList.iterator();
            while (iter.hasNext()) {
                WorkProductDescriptor artifactDesc = (WorkProductDescriptor)iter.next();
                found = false;
                if (LibraryEditUtil.getInstance().isContainedBy((MethodElement)artifactDesc.getWorkProduct(), (MethodElement)candidate.getWorkProduct(), config)) {
                    iter.remove();
                    continue;
                }
                if (!LibraryEditUtil.getInstance().isContainedBy((MethodElement)artifactDesc.getWorkProduct(), (MethodElement)candidate.getWorkProduct(), config)) continue;
                iter.remove();
                candidate = artifactDesc;
                found = true;
                break;
            }
            if (!found || artifactDescList.isEmpty()) {
                topMostArtifactDescList.add(candidate);
                continue;
            }
            if (!artifactDescList.isEmpty()) continue;
            topMostArtifactDescList.add(candidate);
        }
        ArrayList result = new ArrayList();
        for (Object child : children) {
            Object e = unwrap ? TngUtil.unwrap(child) : child;
            boolean selected = false;
            if (e instanceof WorkProductDescriptor) {
                WorkProductDescriptor wpd = (WorkProductDescriptor)e;
                WorkProduct wp = wpd.getWorkProduct();
                if (!(wp instanceof Artifact)) {
                    selected = true;
                } else if (topMostArtifactDescList.contains(wpd)) {
                    selected = true;
                }
            } else {
                selected = true;
            }
            if (!selected) continue;
            result.add(child);
        }
        return result;
    }

    public static Activity findActivity(ProcessPackage procPackage) {
        if (procPackage instanceof ProcessComponent) {
            return ((ProcessComponent)procPackage).getProcess();
        }
        for (Object element : procPackage.getProcessElements()) {
            if (!(element instanceof Activity)) continue;
            return (Activity)element;
        }
        return null;
    }

    public static void fixBreakdonwElementOrderRecursively(Activity act) {
        AbstractTreeIterator iter = new AbstractTreeIterator(act){
            private static final long serialVersionUID = 3368261685663354478L;

            protected Iterator getChildren(Object object) {
                ArrayList activities = new ArrayList();
                for (Object element : ((Activity)object).getBreakdownElements()) {
                    if (!(element instanceof Activity)) continue;
                    activities.add(element);
                }
                return activities.iterator();
            }
        };
        while (iter.hasNext()) {
            ProcessUtil.fixBreakdownElementOrder((Activity)iter.next());
        }
    }

    public static void fixBreakdownElementOrder(Activity activity) {
        EList list = (EList)activity.getBreakdownElements();
        for (BreakdownElement e : new ArrayList(list)) {
            int succId;
            BreakdownElement succ = e.getPresentedAfter();
            if (succ == null || succ == e || (succId = list.indexOf((Object)succ)) == -1) continue;
            int id = list.indexOf((Object)e);
            if (id != succId - 1) {
                if (id < succId) {
                    list.move(succId - 1, id);
                } else {
                    list.move(id, succId);
                }
            }
            e.setPresentedAfter(null);
        }
    }

    public static void initializeItemProviderPath(Activity activity, AdapterFactory adapterFactory) {
        ITreeItemContentProvider ip = (ITreeItemContentProvider)adapterFactory.adapt((Notifier)activity, ITreeItemContentProvider.class);
        IBSItemProvider bsIp = (IBSItemProvider)ip;
        Object top = bsIp.getTopItem();
        if (!(top instanceof Process) || !(((EObject)top).eContainer() instanceof ProcessComponent)) {
            ArrayList<Activity> actPath = new ArrayList<Activity>();
            activity = activity.getSuperActivities();
            while (activity != null) {
                actPath.add(0, activity);
                activity = activity.getSuperActivities();
            }
            for (Object e : actPath) {
                ip = (ITreeItemContentProvider)adapterFactory.adapt(e, ITreeItemContentProvider.class);
                ip.getChildren(e);
            }
        }
    }

    public static boolean hasContributorOrReplacer(Activity activity) {
        AbstractTreeIterator iter = new AbstractTreeIterator(activity){
            private static final long serialVersionUID = 0L;

            protected Iterator getChildren(Object object) {
                if (object instanceof Activity) {
                    ArrayList children = new ArrayList();
                    for (Object element : ((Activity)object).getBreakdownElements()) {
                        if (!(element instanceof VariabilityElement)) continue;
                        children.add(element);
                    }
                    return children.iterator();
                }
                return Collections.EMPTY_LIST.iterator();
            }
        };
        while (iter.hasNext()) {
            VariabilityElement ve = (VariabilityElement)iter.next();
            VariabilityElement base = ve.getVariabilityBasedOnElement();
            VariabilityType vType = ve.getVariabilityType();
            if (base == null || vType != VariabilityType.CONTRIBUTES && vType != VariabilityType.REPLACES) continue;
            return true;
        }
        return false;
    }

    public static boolean isTopProcess(Object target) {
        return target instanceof Process && ((Process)target).eContainer() instanceof ProcessComponent;
    }

    public static WorkProductDescriptor getWorkProductDescriptor(Collection elements, WorkProduct wp) {
        for (Object e : elements) {
            WorkProductDescriptor wpd;
            if (!(e instanceof WorkProductDescriptor) || (wpd = (WorkProductDescriptor)e).getWorkProduct() != wp) continue;
            return wpd;
        }
        return null;
    }

    public static TaskDescriptor getTaskDescriptor(Collection elements, Task task) {
        for (Object e : elements) {
            TaskDescriptor td;
            if (!(e instanceof TaskDescriptor) || (td = (TaskDescriptor)e).getTask() != task) continue;
            return td;
        }
        return null;
    }

    public static WorkBreakdownElement getOwner(WorkOrder workOrder) {
        return AssociationHelper.getSuccessor((WorkOrder)workOrder);
    }

    public static ComposedBreakdownElementWrapperItemProvider getComposedWrapper(Object object) {
        while (!(object instanceof ComposedBreakdownElementWrapperItemProvider) && object instanceof IWrapperItemProvider) {
            object = ((IWrapperItemProvider)object).getValue();
        }
        if (object instanceof ComposedBreakdownElementWrapperItemProvider) {
            return (ComposedBreakdownElementWrapperItemProvider)object;
        }
        return null;
    }

    public static final String getColumnDisplayName(String columnId) {
        try {
            return LibraryEditPlugin.INSTANCE.getString("BS_Column_" + columnId);
        }
        catch (MissingResourceException missingResourceException) {
            return columnId;
        }
    }

    public static List getTaskDescriptors(List selection) {
        ArrayList taskDescriptors = new ArrayList();
        ExposedAdapterFactory adapterFactory = (ExposedAdapterFactory)TngAdapterFactory.INSTANCE.getWBS_ComposedAdapterFactory();
        for (Object itorObj : selection) {
            if (itorObj instanceof Activity || itorObj instanceof ActivityWrapperItemProvider) {
                ProcessUtil.getTaskDescriptors((AdapterFactory)adapterFactory, itorObj, taskDescriptors);
            }
            if (!(itorObj instanceof TaskDescriptor) && !(itorObj instanceof TaskDescriptorWrapperItemProvider) || taskDescriptors.contains(itorObj)) continue;
            taskDescriptors.add(itorObj);
        }
        return taskDescriptors;
    }

    private static void getTaskDescriptors(AdapterFactory adapterFactory, Object act, List taskDescriptors) {
        Collection list = null;
        if (act instanceof Activity) {
            ItemProviderAdapter adapter = (ItemProviderAdapter)adapterFactory.adapt(act, ITreeItemContentProvider.class);
            list = adapter.getChildren(act);
        } else if (act instanceof ActivityWrapperItemProvider) {
            list = ((WrapperItemProvider)act).getChildren(act);
        }
        if (list != null && list instanceof List) {
            List children = (List)list;
            for (Object obj : children) {
                if (obj instanceof Activity || obj instanceof ActivityWrapperItemProvider) {
                    ProcessUtil.getTaskDescriptors(adapterFactory, obj, taskDescriptors);
                }
                if (!(obj instanceof TaskDescriptor) && !(obj instanceof TaskDescriptorWrapperItemProvider) || taskDescriptors.contains(obj)) continue;
                taskDescriptors.add(obj);
            }
        }
    }

    public static boolean isRolledUpDescriptor(Object o, AdapterFactory adapterFactory) {
        ITreeItemContentProvider adapter;
        Object parent;
        if (adapterFactory != null && TngUtil.unwrap(o) instanceof Descriptor && TngUtil.unwrap(parent = (adapter = (ITreeItemContentProvider)adapterFactory.adapt(o, ITreeItemContentProvider.class)).getParent(o)) instanceof Activity) {
            Object parentAdapter = adapterFactory.adapt(parent, ITreeItemContentProvider.class);
            return parentAdapter instanceof IBSItemProvider && ((IBSItemProvider)parentAdapter).isRolledUp();
        }
        return false;
    }

    public static Process deepCopy(IProgressMonitor monitor, Process process, String newProcessName, MethodConfiguration deepCopyConfig, ProcessPackage targetPackage, CopyHelper copyHelper, IConfigurator configurator, boolean handleAutoSyn) {
        if (handleAutoSyn) {
            if (deepCopyConfig instanceof Scope) {
                MethodConfiguration tempConfig = UmaFactory.eINSTANCE.createMethodConfiguration();
                for (MethodPlugin plugin : deepCopyConfig.getMethodPluginSelection()) {
                    tempConfig.getMethodPluginSelection().add(plugin);
                    tempConfig.getMethodPackageSelection().addAll(UmaUtil.getAllMethodPackages((MethodPlugin)plugin));
                }
                deepCopyConfig = tempConfig;
                configurator.setMethodConfiguration(deepCopyConfig);
            }
            IRealizationManager mgr = LibraryEditUtil.getInstance().getRealizationManager(deepCopyConfig);
            mgr.updateProcessModel(process);
        }
        Process proc = ProcessUtil.deepCopy_(monitor, process, newProcessName, deepCopyConfig, targetPackage, copyHelper, configurator, handleAutoSyn);
        return proc;
    }

    private static Process deepCopy_(IProgressMonitor monitor, Process process, String newProcessName, MethodConfiguration deepCopyConfig, ProcessPackage targetPackage, CopyHelper copyHelper, IConfigurator configurator, boolean handleAutoSyn) {
        if (targetPackage == null) {
            targetPackage = (ProcessPackage)process.eContainer().eContainer();
        }
        Process newProcess = null;
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        ProcessDeepCopyCommand cmd = new ProcessDeepCopyCommand(process, newProcessName, copyHelper, deepCopyConfig, targetPackage, monitor, configurator);
        try {
            cmd.execute();
            Collection<?> result = cmd.getResult();
            if (!result.isEmpty()) {
                newProcess = (Process)result.toArray()[0];
                ProcessUtil.fixBreakdonwElementOrderRecursively((Activity)newProcess);
                cmd.copySuppressionStates();
            }
        }
        finally {
            cmd.dispose();
        }
        ActivityHandler.fixGuidReferences((Map<? extends Object, ? extends Object>)((Object)copyHelper));
        return newProcess;
    }

    public static boolean accept(Activity act, IFilter processFilter, boolean checkOwningProcess) {
        if (processFilter == null) {
            return true;
        }
        Activity base = (Activity)act.getVariabilityBasedOnElement();
        VariabilityType type = act.getVariabilityType();
        if (base == null) {
            if (checkOwningProcess) {
                return processFilter.accept(TngUtil.getOwningProcess((BreakdownElement)act));
            }
            return true;
        }
        if (type == VariabilityType.EXTENDS || type == VariabilityType.LOCAL_CONTRIBUTION || type == VariabilityType.LOCAL_REPLACEMENT) {
            boolean ret;
            do {
                ret = processFilter.accept(TngUtil.getOwningProcess((BreakdownElement)base));
                type = base.getVariabilityType();
                base = (Activity)base.getVariabilityBasedOnElement();
            } while (ret && base != null && (type == VariabilityType.EXTENDS || type == VariabilityType.LOCAL_CONTRIBUTION || type == VariabilityType.LOCAL_REPLACEMENT));
            return ret;
        }
        return true;
    }

    public static Process getProcess(Activity activity) {
        ProcessComponent procComp = UmaUtil.getProcessComponent((MethodElement)activity);
        if (procComp != null) {
            Process proc = procComp.getProcess();
            return proc;
        }
        return null;
    }

    public static Process getProcessForBreakdownElement(BreakdownElement breakdownElement) {
        if (breakdownElement instanceof Activity) {
            return ProcessUtil.getProcess((Activity)breakdownElement);
        }
        Activity superAct = breakdownElement.getSuperActivities();
        return superAct == null ? null : ProcessUtil.getProcess(superAct);
    }

    public static WorkOrder findWorkOrder(Activity parent, WorkBreakdownElement inheritedChild, WorkBreakdownElement predecessor) {
        ProcessPackage pkg = (ProcessPackage)parent.eContainer();
        for (Object element : pkg.getProcessElements()) {
            MethodElementProperty prop;
            WorkOrder workOrder;
            if (!(element instanceof WorkOrder) || (workOrder = (WorkOrder)element).getPred() != predecessor || (prop = MethodElementPropertyHelper.getProperty((MethodElement)workOrder, "successor")) == null || !inheritedChild.getGuid().equals(prop.getValue())) continue;
            return workOrder;
        }
        return null;
    }

    public static WorkOrder createDefaultWorkOrderForInheritedChild(Activity parent, WorkBreakdownElement inheritedChild, WorkBreakdownElement predecessor) {
        WorkOrder workOrder = UmaFactory.eINSTANCE.createWorkOrder();
        workOrder.setPred(predecessor);
        MethodElementPropertyHelper.setProperty((MethodElement)workOrder, "successor", inheritedChild.getGuid());
        return workOrder;
    }

    public static boolean isCustomWorkOrder(WorkOrder object) {
        return MethodElementPropertyHelper.getProperty((MethodElement)object, "successor") != null;
    }

    public static boolean isCustomWorkOrderOf(WorkOrder wo, WorkBreakdownElement e) {
        MethodElementProperty prop = MethodElementPropertyHelper.getProperty((MethodElement)wo, "successor");
        return prop != null && e.getGuid().equals(prop.getValue());
    }

    public static boolean isProcessDeepcopyDiagarm() {
        return processDeepcopyDiagarm;
    }

    public static void setProcessDeepcopyDiagarm(boolean processDeepcopyDiagarm) {
        ProcessUtil.processDeepcopyDiagarm = processDeepcopyDiagarm;
    }
}

