/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.command.Command;
import org.eclipse.epf.library.edit.command.IActionManager;
import org.eclipse.epf.library.edit.command.MethodElementSetPropertyCommand;
import org.eclipse.epf.library.edit.meta.ReferenceTable;
import org.eclipse.epf.library.edit.uma.ExtendReferenceMap;
import org.eclipse.epf.library.edit.uma.MethodElementExt;
import org.eclipse.epf.library.edit.util.LibraryEditUtil;
import org.eclipse.epf.library.edit.util.MethodElementPropUtil;
import org.eclipse.epf.library.edit.util.PracticePropUtil;
import org.eclipse.epf.library.edit.util.XmlEditUtil;
import org.eclipse.epf.uma.ContentDescription;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.Practice;
import org.eclipse.epf.uma.VariabilityElement;
import org.eclipse.epf.uma.VariabilityType;
import org.eclipse.epf.uma.util.ExtendedAttribute;
import org.eclipse.epf.uma.util.ExtendedReference;
import org.eclipse.epf.uma.util.ExtendedTable;
import org.eclipse.epf.uma.util.ModifiedTypeMeta;
import org.eclipse.epf.uma.util.UmaUtil;
import org.eclipse.epf.uma.util.UserDefinedTypeMeta;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropUtil
extends MethodElementPropUtil {
    public static final String Me_mdtData = "me_mdtData";
    public static final String Me_customize = "me_customize";
    public static final String Me_edited = "me_edited";
    public static final String Me_attribute_ = "me_attribute_";
    public static final String Me_table_ = "me_table_";
    public static final String Me_linkedElement = "me_linkedElement";
    public static final String me_ContibutionOrder = "me_ContributionOrder";
    public static final String Pkg_loadCheck = "pkg_loadCheck";
    private static PropUtil propUtil = new PropUtil();
    private static String umaTypeScope = "org.eclipse.epf.uma.";

    public static PropUtil getPropUtil(IActionManager actionManager) {
        return new PropUtil(actionManager);
    }

    public static PropUtil getPropUtil() {
        return propUtil;
    }

    protected PropUtil() {
    }

    protected PropUtil(IActionManager actionManager) {
        super(actionManager);
    }

    public String getContributionOrder(MethodElement element) {
        String value = this.getStringValue(element, me_ContibutionOrder);
        return value == null ? null : value.trim();
    }

    public void setContributionOrder(MethodElement element, String value) {
        this.setStringValue(element, me_ContibutionOrder, value);
    }

    public MethodElement getLinkedElement(MethodElement element) {
        return this.getElement(element, Me_linkedElement);
    }

    public void setLinkedElement(MethodElement element, MethodElement value) {
        this.setElement(element, Me_linkedElement, value);
    }

    public ReferenceTable retrieveExtendedTable(MethodElement element, ExtendedTable tableMeta) {
        if (tableMeta == null) {
            return null;
        }
        String value = this.getStringValue(element, Me_table_ + tableMeta.getGlobalId());
        ReferenceTable table = new ReferenceTable(element, tableMeta, value);
        return table;
    }

    public ReferenceTable getReferenceTable(MethodElement element, ExtendedTable tableMeta, boolean modified) {
        ExtendReferenceMap map = this.getExtendReferenceMap(element, modified);
        return map == null ? null : map.getReferenceTable(tableMeta);
    }

    public void setReferenceTableProp(ReferenceTable table) {
        this.setStringValue(table.getElement(), Me_table_ + table.getMeta().getGlobalId(), table.getGuidListString());
    }

    public String getExtendedAttribute(ContentDescription content, ExtendedAttribute att) {
        String value = this.getStringValue((MethodElement)content, Me_attribute_ + att.getGlobalId());
        return value;
    }

    public void setExtendedAttribute(ContentDescription content, ExtendedAttribute att, String value) {
        this.setStringValue((MethodElement)content, Me_attribute_ + att.getGlobalId(), value);
    }

    public static Command getSetExtendedAttributeCommand(ContentDescription content, ExtendedAttribute att, String value) {
        return new MethodElementSetPropertyCommand((MethodElement)content, Me_attribute_ + att.getGlobalId(), value);
    }

    public boolean isCustomize(MethodElement element) {
        Boolean value = this.getBooleanValue(element, Me_customize);
        return value == null ? false : value;
    }

    public void setCustomize(MethodElement element, boolean b) {
        this.setBooleanValue(element, Me_customize, b);
    }

    public MethodElement getCustomizeParent(MethodElement element) {
        if (!(element instanceof VariabilityElement)) {
            return null;
        }
        VariabilityElement v = (VariabilityElement)element;
        if (v.getVariabilityType() != VariabilityType.EXTENDS_REPLACES) {
            return null;
        }
        if (!this.isCustomize(element)) {
            return null;
        }
        return v.getVariabilityBasedOnElement();
    }

    public boolean isEdited(MethodElement element) {
        Boolean value = this.getBooleanValue(element, Me_edited);
        return value == null ? false : value;
    }

    public void setEdited(MethodElement element, boolean b) {
        this.setBooleanValue(element, Me_edited, b);
    }

    public List<MethodElement> getExtendedReferenceList(MethodElement element, ExtendedReference meta, boolean toModify) {
        List value = (List)this.getReferenceValue(meta.getGlobalId(), element, toModify);
        if (value == null) {
            return new ArrayList<MethodElement>();
        }
        if (!toModify) {
            return UmaUtil.filterOutUnresolved((List)value);
        }
        return value;
    }

    public ModifiedTypeMeta getGlobalMdtMeta(MethodElement element) {
        Practice practice;
        PracticePropUtil practicePropUtil;
        UserDefinedTypeMeta udtMeta;
        if (element == null) {
            return null;
        }
        String id = String.valueOf(umaTypeScope) + element.eClass().getName();
        if (element instanceof Practice && (udtMeta = (practicePropUtil = PracticePropUtil.getPracticePropUtil()).getUdtMeta(practice = (Practice)element)) != null) {
            id = udtMeta.getTypeId();
        }
        ModifiedTypeMeta meta = LibraryEditUtil.getInstance().getModifiedType(id);
        return meta;
    }

    public void addOpposite(ExtendedReference reference, MethodElement thisElement, MethodElement otherElement) {
        ExtendReferenceMap map = this.getCachedExtendReferenceMap(thisElement, false);
        if (map == null) {
            return;
        }
        map.addOpposite(reference, otherElement);
    }

    public void removeOpposite(ExtendedReference reference, MethodElement thisElement, MethodElement otherElement) {
        ExtendReferenceMap map = this.getCachedExtendReferenceMap(thisElement, false);
        if (map == null) {
            return;
        }
        map.removeOpposite(reference, otherElement);
    }

    public MethodElement getElement(MethodElement ownerElement, String propName) {
        if (ownerElement == null) {
            return null;
        }
        String guid = this.getStringValue(ownerElement, propName);
        MethodElement element = LibraryEditUtil.getInstance().getMethodElement(guid);
        if (!UmaUtil.isInLibrary((MethodElement)element)) {
            return null;
        }
        return element;
    }

    public void setElement(MethodElement ownerElement, String propName, MethodElement element) {
        String guid = element == null ? "" : element.getGuid();
        this.setStringValue(ownerElement, propName, guid);
    }

    public List<MethodElement> getReferencingList(MethodElement element, ExtendedReference ref) {
        return this.getReferencingList(element, ref, false);
    }

    public List<MethodElement> getReferencingList(MethodElement element, ExtendedReference ref, boolean modified) {
        String ofeature = ExtendReferenceMap.getOppositeName(ref.getGlobalId());
        List list = (List)this.getReferenceValue(ofeature, element, modified);
        return list == null ? new ArrayList() : list;
    }

    public Set<MethodElement> getExtendedReferencingSet(MethodElement element) {
        ExtendReferenceMap map = this.getCachedExtendReferenceMap(element, false);
        return map == null ? Collections.EMPTY_SET : map.getExtendedReferencingSet(element);
    }

    public boolean isExcludedFromPublish(MethodElement element) {
        MethodElementExt extObj = this.getExtendObject(element, false);
        return extObj == null ? MethodElementExt.excludedFromPublishDefault(element) : extObj.isExcludedFromPublish();
    }

    public void setExcludedFromPublish(MethodElement element, boolean excludedFromPublish) {
        if (excludedFromPublish == MethodElementExt.excludedFromPublishDefault(element) && this.getExtendObject(element, false) == null) {
            return;
        }
        MethodElementExt extObj = this.getExtendObject(element, true);
        extObj.setExcludedFromPublish(excludedFromPublish);
    }

    private static class PropXmlEditUtil
    extends XmlEditUtil {
        private MethodElement element;
        public static final String _id = "id";

        public PropXmlEditUtil(MethodElement element, MethodElementPropUtil propUtil) {
            super(propUtil);
            this.element = element;
        }
    }
}

