/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.util;

import com.ibm.icu.util.StringTokenizer;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandWrapper;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.AbstractTreeIterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.MoveCommand;
import org.eclipse.emf.edit.command.PasteFromClipboardCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.provider.AttributeValueWrapperItemProvider;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.FeatureMapEntryWrapperItemProvider;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.IWrapperItemProvider;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.epf.common.utils.NetUtil;
import org.eclipse.epf.common.utils.StrUtil;
import org.eclipse.epf.library.edit.FeatureValueWrapperItemProvider;
import org.eclipse.epf.library.edit.IDefaultNameSetter;
import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.library.edit.IGroupContainer;
import org.eclipse.epf.library.edit.LibraryEditPlugin;
import org.eclipse.epf.library.edit.LibraryEditResources;
import org.eclipse.epf.library.edit.PresentationContext;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.category.CustomCategoryItemProvider;
import org.eclipse.epf.library.edit.category.StandardCategoriesItemProvider;
import org.eclipse.epf.library.edit.command.IActionManager;
import org.eclipse.epf.library.edit.command.IResourceAwareCommand;
import org.eclipse.epf.library.edit.element.ContentPackageItemProvider;
import org.eclipse.epf.library.edit.internal.IListenerProvider;
import org.eclipse.epf.library.edit.meta.TypeDefUtil;
import org.eclipse.epf.library.edit.navigator.ContentItemProvider;
import org.eclipse.epf.library.edit.navigator.MethodPluginItemProvider;
import org.eclipse.epf.library.edit.process.BreakdownElementWrapperItemProvider;
import org.eclipse.epf.library.edit.process.command.MoveDownCommand;
import org.eclipse.epf.library.edit.process.command.MoveUpCommand;
import org.eclipse.epf.library.edit.util.ConfigurationUtil;
import org.eclipse.epf.library.edit.util.ExtensionManager;
import org.eclipse.epf.library.edit.util.ILibraryInspector;
import org.eclipse.epf.library.edit.util.LibraryEditConstants;
import org.eclipse.epf.library.edit.util.MethodElementUtil;
import org.eclipse.epf.library.edit.util.Misc;
import org.eclipse.epf.library.edit.util.ModelStructure;
import org.eclipse.epf.library.edit.util.PracticePropUtil;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.library.edit.util.Suppression;
import org.eclipse.epf.library.edit.util.model.OrderInfo;
import org.eclipse.epf.library.edit.util.model.OrderInfoCollection;
import org.eclipse.epf.library.edit.util.model.util.StringResource;
import org.eclipse.epf.library.edit.validation.DependencyChecker;
import org.eclipse.epf.library.edit.validation.NameChecker;
import org.eclipse.epf.library.edit.validation.UniqueNameHandler;
import org.eclipse.epf.services.IAccessController;
import org.eclipse.epf.services.IFileBasedLibraryPersister;
import org.eclipse.epf.services.Services;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.CapabilityPattern;
import org.eclipse.epf.uma.ContentCategory;
import org.eclipse.epf.uma.ContentDescription;
import org.eclipse.epf.uma.ContentElement;
import org.eclipse.epf.uma.ContentPackage;
import org.eclipse.epf.uma.CustomCategory;
import org.eclipse.epf.uma.DeliveryProcess;
import org.eclipse.epf.uma.DescribableElement;
import org.eclipse.epf.uma.Discipline;
import org.eclipse.epf.uma.Domain;
import org.eclipse.epf.uma.Example;
import org.eclipse.epf.uma.Guidance;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodElementProperty;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.MethodPackage;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.NamedElement;
import org.eclipse.epf.uma.Practice;
import org.eclipse.epf.uma.Process;
import org.eclipse.epf.uma.ProcessComponent;
import org.eclipse.epf.uma.ProcessPackage;
import org.eclipse.epf.uma.ProcessPlanningTemplate;
import org.eclipse.epf.uma.ReusableAsset;
import org.eclipse.epf.uma.Role;
import org.eclipse.epf.uma.RoleDescriptor;
import org.eclipse.epf.uma.RoleSet;
import org.eclipse.epf.uma.Task;
import org.eclipse.epf.uma.Template;
import org.eclipse.epf.uma.Tool;
import org.eclipse.epf.uma.UmaFactory;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.VariabilityElement;
import org.eclipse.epf.uma.VariabilityType;
import org.eclipse.epf.uma.Whitepaper;
import org.eclipse.epf.uma.WorkBreakdownElement;
import org.eclipse.epf.uma.WorkOrder;
import org.eclipse.epf.uma.WorkProduct;
import org.eclipse.epf.uma.WorkProductDescriptor;
import org.eclipse.epf.uma.WorkProductType;
import org.eclipse.epf.uma.ecore.impl.MultiResourceEObject;
import org.eclipse.epf.uma.ecore.util.OppositeFeature;
import org.eclipse.epf.uma.provider.MethodElementItemProvider;
import org.eclipse.epf.uma.provider.UmaEditPlugin;
import org.eclipse.epf.uma.provider.UmaItemProviderAdapterFactory;
import org.eclipse.epf.uma.util.AssociationHelper;
import org.eclipse.epf.uma.util.ExtendedReference;
import org.eclipse.epf.uma.util.MessageException;
import org.eclipse.epf.uma.util.UmaResources;
import org.eclipse.epf.uma.util.UmaUtil;
import org.eclipse.epf.uma.util.UserDefinedTypeMeta;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TngUtil {
    public static final UmaItemProviderAdapterFactory umaItemProviderAdapterFactory = new UmaItemProviderAdapterFactory();
    public static final boolean DEBUG = LibraryEditPlugin.getPlugin().isDebugging();
    public static final String GUIDANCE_FILESTRING_SEPARATOR = "|";
    private static final String GUIDANCE_FILESTRING_SEPARATOR_SPLITTER = "\\|";
    public static final String COMMA_SEPARATOR = ",";
    private static final String COMMA_SEPARATOR_SPLITTER = "\\,";
    public static final String PUBLISH_CATEGORY_PROPERTY = "PUBLISH_CATEGORY";

    public static void removeAdapters(EObject eObj, Class cls) {
        Iterator adapters = eObj.eAdapters().iterator();
        while (adapters.hasNext()) {
            Adapter adapter = (Adapter)adapters.next();
            if (!cls.isInstance(adapter)) continue;
            adapters.remove();
        }
    }

    public static Object getAdapter(EObject eObj, Class cls) {
        for (Adapter adapter : eObj.eAdapters()) {
            if (!cls.isInstance(adapter)) continue;
            return adapter;
        }
        return null;
    }

    public static Adapter adapt(AdapterFactory factory, Notifier notifier, Object type, Class viewType) {
        for (Adapter adapter : notifier.eAdapters()) {
            if (!adapter.isAdapterForType(type) || !viewType.isInstance(adapter)) continue;
            return adapter;
        }
        return factory.adaptNew(notifier, type);
    }

    public static boolean isValidFileName(String name) {
        if (StrUtil.isBlank((String)name)) {
            return false;
        }
        return name.indexOf(47) == -1 && name.indexOf(92) == -1 && name.indexOf(58) == -1 && name.indexOf(42) == -1 && name.indexOf(63) == -1 && name.indexOf(34) == -1 && name.indexOf(60) == -1 && name.indexOf(62) == -1 && name.indexOf(124) == -1 && name.indexOf(59) == -1 && name.indexOf(91) == -1 && name.indexOf(93) == -1 && name.indexOf(35) == -1;
    }

    public static boolean isValidPluginName(String name) {
        if (!TngUtil.isValidFileName(name)) {
            return false;
        }
        return name.indexOf(37) == -1 && name.indexOf(35) == -1 && name.indexOf(39) == -1;
    }

    public static String checkName(NamedElement e, String name, Collection eClasses) {
        return TngUtil.checkName(e.eContainer(), e, name, TngUtil.getTypeText((EObject)e), eClasses);
    }

    public static String checkName(EObject parent, NamedElement e, String name, String elementTypeText, Collection eClasses) {
        String msg = TngUtil.checkElementName(name, elementTypeText);
        if (msg != null) {
            return msg;
        }
        if (parent == null) {
            return null;
        }
        EList children = parent.eContents();
        int i = 0;
        while (i < children.size()) {
            NamedElement child = (NamedElement)children.get(i);
            if (child != e && TngUtil.isEClassInstanceOf(eClasses, child) && name.equalsIgnoreCase(child.getName())) {
                return NLS.bind((String)LibraryEditResources.duplicateElementNameError_msg, (Object)name);
            }
            ++i;
        }
        return null;
    }

    public static String checkName(EObject parent, NamedElement e, String name, String elementTypeText, IFilter childFilter) {
        String msg = TngUtil.checkElementName(name, elementTypeText);
        if (msg != null) {
            return msg;
        }
        if (parent == null) {
            return null;
        }
        EList children = parent.eContents();
        int i = 0;
        while (i < children.size()) {
            NamedElement child = (NamedElement)children.get(i);
            if (child != e && childFilter.accept(child) && name.equalsIgnoreCase(child.getName())) {
                return NLS.bind((String)LibraryEditResources.duplicateElementNameError_msg, (Object)name);
            }
            ++i;
        }
        return null;
    }

    public static String checkName(File dir, Collection siblings, NamedElement e, String name, String elementTypeText, boolean isDir) {
        boolean b;
        String msg = TngUtil.checkElementName(name, elementTypeText);
        if (msg != null) {
            return msg;
        }
        String fileName = name;
        if (!isDir) {
            fileName = String.valueOf(fileName) + ((IFileBasedLibraryPersister)Services.getDefaultLibraryPersister()).getFileExtension((Object)e);
        }
        File file = new File(dir, fileName);
        File currentFile = null;
        if (e != null && e.eResource() != null) {
            currentFile = new File(e.eResource().getURI().toFileString());
            if (isDir) {
                currentFile = currentFile.getParentFile();
            }
        }
        if ((b = file.exists()) && !file.equals(currentFile)) {
            msg = NLS.bind((String)LibraryEditResources.duplicateElementNameError_msg, (Object)name);
            return msg;
        }
        for (NamedElement child : siblings) {
            if (child == e || !name.equalsIgnoreCase(child.getName())) continue;
            return NLS.bind((String)LibraryEditResources.duplicateElementNameError_msg, (Object)name);
        }
        return null;
    }

    public static String checkElementName(String name, String elementTypeText) {
        if (name == null || name.trim().length() == 0) {
            return NLS.bind((String)LibraryEditResources.emptyElementNameError_msg, (Object)StrUtil.toLower((String)elementTypeText));
        }
        if (name.startsWith(" ")) {
            return NLS.bind((String)LibraryEditResources.invalidElementNameError1_msg, (Object)name);
        }
        if (name.endsWith(".")) {
            return NLS.bind((String)LibraryEditResources.invalidElementNameError2_msg, (Object)name);
        }
        if (!TngUtil.isValidFileName(name)) {
            return NLS.bind((String)LibraryEditResources.invalidElementNameError3_msg, (Object)name);
        }
        return null;
    }

    public static String checkPluginName(String name) {
        String error = TngUtil.checkElementName(name, TngUtil.getTypeText("MethodPlugin"));
        if (error != null) {
            return error;
        }
        if (!TngUtil.isValidPluginName(name)) {
            return NLS.bind((String)LibraryEditResources.invalidPluginNameError_msg, (Object)name);
        }
        return null;
    }

    public static String checkActivityName(AdapterFactory adapterFactory, Object object, String name, Suppression suppression) {
        if (!(object instanceof Activity)) {
            return null;
        }
        return NameChecker.checkName(adapterFactory, (BreakdownElement)object, Activity.class, (EStructuralFeature)UmaPackage.eINSTANCE.getNamedElement_Name(), name, suppression);
    }

    public static String checkWBSActivityPresentationName(Object act, String name, Suppression suppression) {
        if (!(act instanceof Activity)) {
            return null;
        }
        return NameChecker.checkName((AdapterFactory)TngAdapterFactory.INSTANCE.getWBS_ComposedAdapterFactory(), (BreakdownElement)act, Activity.class, (EStructuralFeature)UmaPackage.eINSTANCE.getMethodElement_PresentationName(), name, suppression);
    }

    public static String checkWorkBreakdownElementPresentationName(Object e, String name, Suppression suppression) {
        if (!(e instanceof WorkBreakdownElement)) {
            return null;
        }
        return NameChecker.checkName((AdapterFactory)TngAdapterFactory.INSTANCE.getWBS_ComposedAdapterFactory(), (BreakdownElement)e, WorkBreakdownElement.class, (EStructuralFeature)UmaPackage.eINSTANCE.getMethodElement_PresentationName(), name, suppression);
    }

    public static String checkWorkProductDescriptorPresentationName(Object e, String name, Suppression suppression) {
        if (!(e instanceof WorkProductDescriptor)) {
            return null;
        }
        return NameChecker.checkName((AdapterFactory)TngAdapterFactory.INSTANCE.getPBS_ComposedAdapterFactory(), (BreakdownElement)e, WorkProductDescriptor.class, (EStructuralFeature)UmaPackage.eINSTANCE.getMethodElement_PresentationName(), name, suppression);
    }

    public static String checkRoleDescriptorPresentationName(Object e, String name, Suppression suppression) {
        if (!(e instanceof RoleDescriptor)) {
            return null;
        }
        return NameChecker.checkName((AdapterFactory)TngAdapterFactory.INSTANCE.getOBS_ComposedAdapterFactory(), (BreakdownElement)e, RoleDescriptor.class, (EStructuralFeature)UmaPackage.eINSTANCE.getMethodElement_PresentationName(), name, suppression);
    }

    public static boolean isEClassInstanceOf(Collection eClasses, Object obj) {
        for (EClass eClass : eClasses) {
            if (!eClass.isInstance(obj)) continue;
            return true;
        }
        return false;
    }

    public static boolean isInstanceOf(Collection classes, Object obj) {
        for (Class clazz : classes) {
            if (!clazz.isInstance(obj)) continue;
            return true;
        }
        return false;
    }

    public static AdapterFactory getBestAdapterFactory(AdapterFactory adapterFactory) {
        if (adapterFactory instanceof ComposeableAdapterFactory) {
            return ((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory();
        }
        return adapterFactory;
    }

    public static String getLabel(Object object) {
        return TngUtil.getLabel(object, "");
    }

    public static String getLabel(Object object, String alternativeLabel) {
        EObject eObj;
        if (object instanceof ContentDescription) {
            return TngUtil.getLabel(((ContentDescription)object).eContainer(), alternativeLabel);
        }
        if (object instanceof EObject && (eObj = (EObject)object).eIsProxy()) {
            String path = null;
            try {
                URI uri = eObj.eResource().getResourceSet().getURIConverter().normalize(((InternalEObject)eObj).eProxyURI());
                path = uri.isFile() ? uri.toFileString() : uri.toString();
            }
            catch (Exception exception) {}
            path = path != null ? MessageFormat.format(" ''{0}''", path) : "";
            return NLS.bind((String)LibraryEditResources.unresolved_text, (Object)path);
        }
        String label = null;
        boolean showPresentationNames = PresentationContext.INSTANCE.isShowPresentationNames();
        if (showPresentationNames && object instanceof ProcessComponent) {
            label = ((ProcessComponent)object).getProcess().getPresentationName();
        } else if (showPresentationNames && object instanceof MethodElement) {
            label = ((MethodElement)object).getPresentationName();
        }
        if (label == null || label.trim().length() == 0) {
            label = ((NamedElement)object).getName();
        }
        return label == null || label.trim().length() == 0 ? alternativeLabel : label;
    }

    public static String getLabel(VariabilityElement object, String alternativeLabel, boolean preferBase) {
        String label = TngUtil.getLabel(object, alternativeLabel);
        if (preferBase && object.getVariabilityBasedOnElement() != null) {
            VariabilityType type = object.getVariabilityType();
            String variabilityTxt = null;
            if (type == VariabilityType.CONTRIBUTES) {
                variabilityTxt = LibraryEditResources.contributesTo_text;
            } else if (type == VariabilityType.LOCAL_CONTRIBUTION) {
                variabilityTxt = LibraryEditResources.localContributesTo_text;
            } else if (type == VariabilityType.EXTENDS) {
                variabilityTxt = LibraryEditResources.extends_text;
            } else if (type == VariabilityType.REPLACES) {
                variabilityTxt = LibraryEditResources.replaces_text;
            } else if (type == VariabilityType.LOCAL_REPLACEMENT) {
                variabilityTxt = LibraryEditResources.localReplaces_text;
            } else if (type == VariabilityType.EXTENDS_REPLACES) {
                variabilityTxt = LibraryEditResources.extends_replaces_text;
            }
            if (variabilityTxt != null) {
                MethodPlugin basePlugin = UmaUtil.getMethodPlugin((EObject)object.getVariabilityBasedOnElement());
                label = basePlugin != null ? NLS.bind((String)LibraryEditResources.Util_labelpath_variabilitywithplugin_info, (Object[])new String[]{label, variabilityTxt, TngUtil.getLabel(object.getVariabilityBasedOnElement(), alternativeLabel), basePlugin.getName()}) : NLS.bind((String)LibraryEditResources.Util_labelpath_variability_info, (Object[])new String[]{label, variabilityTxt, TngUtil.getLabel(object.getVariabilityBasedOnElement(), alternativeLabel)});
            }
        }
        return label;
    }

    public static void initializeProcessComponent(ProcessComponent component, EClass type) {
        Process proc = component.getProcess();
        if (proc == null) {
            proc = (Process)UmaFactory.eINSTANCE.create(type);
            component.setProcess(proc);
        }
    }

    public static BreakdownElement getParent(BreakdownElement be) {
        return null;
    }

    public static String checkNull(String str) {
        return str == null ? "" : str;
    }

    public static boolean descriptorExists(Role role, List roleDescriptorList) {
        int i = roleDescriptorList.size() - 1;
        while (i > -1) {
            RoleDescriptor roleDesc = (RoleDescriptor)roleDescriptorList.get(i);
            if (roleDesc.getRole() == role) {
                return true;
            }
            --i;
        }
        return false;
    }

    public static MethodElement copy(MethodElement element) {
        EcoreUtil.Copier copier = new EcoreUtil.Copier(){
            private static final long serialVersionUID = 3257846576033904691L;

            protected void copyReference(EReference eReference, EObject eObject, EObject copyEObject) {
                if (eObject.eIsSet((EStructuralFeature)eReference)) {
                    boolean copiedTargetRequired;
                    OppositeFeature oppositeFeature = OppositeFeature.getOppositeFeature((EStructuralFeature)eReference);
                    boolean bl = copiedTargetRequired = eReference.getEOpposite() != null || oppositeFeature != null && !oppositeFeature.isMany();
                    if (eReference.isMany()) {
                        List source = (List)eObject.eGet((EStructuralFeature)eReference);
                        InternalEList target = (InternalEList)copyEObject.eGet(this.getTarget((EStructuralFeature)eReference));
                        if (source.isEmpty()) {
                            target.clear();
                        } else {
                            int index = 0;
                            for (Object referencedEObject : source) {
                                Object copyReferencedEObject = this.get(referencedEObject);
                                if (copyReferencedEObject == null) {
                                    if (copiedTargetRequired) continue;
                                    target.addUnique(index, referencedEObject);
                                    ++index;
                                    continue;
                                }
                                if (copiedTargetRequired) {
                                    int position = target.indexOf(copyReferencedEObject);
                                    if (position == -1) {
                                        target.addUnique(index, copyReferencedEObject);
                                    } else if (index != position) {
                                        target.move(index, copyReferencedEObject);
                                    }
                                } else {
                                    target.addUnique(index, copyReferencedEObject);
                                }
                                ++index;
                            }
                        }
                    } else {
                        Object referencedEObject = eObject.eGet((EStructuralFeature)eReference);
                        if (referencedEObject == null) {
                            copyEObject.eSet(this.getTarget((EStructuralFeature)eReference), null);
                        } else {
                            Object copyReferencedEObject = this.get(referencedEObject);
                            if (copyReferencedEObject == null) {
                                if (!copiedTargetRequired) {
                                    copyEObject.eSet(this.getTarget((EStructuralFeature)eReference), referencedEObject);
                                }
                            } else {
                                copyEObject.eSet(this.getTarget((EStructuralFeature)eReference), copyReferencedEObject);
                            }
                        }
                    }
                }
            }
        };
        MethodElement copy = (MethodElement)copier.copy((EObject)element);
        copier.copyReferences();
        copy.setGuid(null);
        TreeIterator iter = copy.eAllContents();
        while (iter.hasNext()) {
            Object e = iter.next();
            if (!(e instanceof MethodElement)) continue;
            ((MethodElement)e).setGuid(null);
        }
        return copy;
    }

    public static VariabilityElement getBase(VariabilityElement c) {
        while (c.getVariabilityBasedOnElement() != null) {
            c = c.getVariabilityBasedOnElement();
        }
        return c;
    }

    public static ContentCategory findInherited(Collection inheritedList, ContentCategory category) {
        for (ContentCategory element : inheritedList) {
            if (element.getVariabilityBasedOnElement() == null || element.getVariabilityBasedOnElement() != category && element.getVariabilityBasedOnElement() != category.getVariabilityBasedOnElement()) continue;
            return element;
        }
        return null;
    }

    public static ContentCategory removeInherited(List inheritedList, ContentCategory category) {
        Iterator iter = inheritedList.iterator();
        while (iter.hasNext()) {
            ContentCategory element = (ContentCategory)iter.next();
            if (element.getVariabilityBasedOnElement() != category) continue;
            iter.remove();
            return element;
        }
        return null;
    }

    public static ContentItemProvider getContentItemProvider(MethodPlugin plugin) {
        MethodPluginItemProvider methodPluginItemProvider = (MethodPluginItemProvider)TngUtil.getAdapter((EObject)plugin, MethodPluginItemProvider.class);
        methodPluginItemProvider.getChildren(plugin);
        IGroupContainer groupContainer = (IGroupContainer)TngUtil.getAdapter((EObject)plugin, IGroupContainer.class);
        if (groupContainer != null) {
            return (ContentItemProvider)groupContainer.getGroupItemProvider(LibraryEditPlugin.INSTANCE.getString("_UI_Content_group"));
        }
        return null;
    }

    public static StandardCategoriesItemProvider getStandardCategoriesItemProvider(MethodPlugin plugin) {
        ContentItemProvider contentItemProvider = TngUtil.getContentItemProvider(plugin);
        contentItemProvider.getChildren(contentItemProvider);
        if (contentItemProvider != null) {
            return (StandardCategoriesItemProvider)contentItemProvider.getGroupItemProvider(LibraryEditPlugin.INSTANCE.getString("_UI_Standard_Categories_group"));
        }
        return null;
    }

    public static Object getDisciplineCategoriesItemProvider(MethodPlugin model) {
        StandardCategoriesItemProvider standardCategoriesItemProvider = TngUtil.getStandardCategoriesItemProvider(model);
        standardCategoriesItemProvider.getChildren(standardCategoriesItemProvider);
        if (standardCategoriesItemProvider != null) {
            return standardCategoriesItemProvider.getGroupItemProvider(LibraryEditPlugin.INSTANCE.getString("_UI_Disciplines_group"));
        }
        return null;
    }

    public static Object getDomainsItemProvider(MethodPlugin model) {
        StandardCategoriesItemProvider standardCategoriesItemProvider = TngUtil.getStandardCategoriesItemProvider(model);
        standardCategoriesItemProvider.getChildren(standardCategoriesItemProvider);
        if (standardCategoriesItemProvider != null) {
            return standardCategoriesItemProvider.getGroupItemProvider(LibraryEditPlugin.INSTANCE.getString("_UI_Domains_group"));
        }
        return null;
    }

    public static Object getWorkProductTypesItemProvider(MethodPlugin model) {
        StandardCategoriesItemProvider standardCategoriesItemProvider = TngUtil.getStandardCategoriesItemProvider(model);
        standardCategoriesItemProvider.getChildren(standardCategoriesItemProvider);
        if (standardCategoriesItemProvider != null) {
            return standardCategoriesItemProvider.getGroupItemProvider(LibraryEditPlugin.INSTANCE.getString("_UI_WorkProductTypes_group"));
        }
        return null;
    }

    public static Object getRoleSetsItemProvider(MethodPlugin model) {
        StandardCategoriesItemProvider standardCategoriesItemProvider = TngUtil.getStandardCategoriesItemProvider(model);
        standardCategoriesItemProvider.getChildren(standardCategoriesItemProvider);
        if (standardCategoriesItemProvider != null) {
            return standardCategoriesItemProvider.getGroupItemProvider(LibraryEditPlugin.INSTANCE.getString("_UI_Role_Sets_group"));
        }
        return null;
    }

    public static Object getToolsItemProvider(MethodPlugin model) {
        StandardCategoriesItemProvider standardCategoriesItemProvider = TngUtil.getStandardCategoriesItemProvider(model);
        standardCategoriesItemProvider.getChildren(standardCategoriesItemProvider);
        if (standardCategoriesItemProvider != null) {
            return standardCategoriesItemProvider.getGroupItemProvider(LibraryEditPlugin.INSTANCE.getString("_UI_Tools_group"));
        }
        return null;
    }

    public static String getNextAvailableName(List<? extends MethodElement> elements, String baseName) {
        if (TngUtil.isNameTaken(elements, null, baseName)) {
            int i = 2;
            while (true) {
                String name;
                if (!TngUtil.isNameTaken(elements, null, name = String.valueOf(baseName) + '_' + i)) {
                    return name;
                }
                ++i;
            }
        }
        return baseName;
    }

    public static void setDefaultName(List<? extends MethodElement> siblings, MethodElement e, String baseName) {
        if (e.getName() != null && e.getName().trim().length() > 0) {
            return;
        }
        if (!TngUtil.isNameTaken(siblings, e, baseName)) {
            e.setName(baseName);
            TngUtil.setPresentationName(e, baseName);
            return;
        }
        int i = 2;
        while (true) {
            String name;
            if (!TngUtil.isNameTaken(siblings, e, name = String.valueOf(baseName) + '_' + i)) {
                e.setName(name);
                TngUtil.setPresentationName(e, name);
                return;
            }
            ++i;
        }
    }

    public static void setDefaultName(CustomCategory parent, CustomCategory cc, String baseName) {
        ContentPackage pkg;
        MethodPlugin plugin = UmaUtil.getMethodPlugin((EObject)parent);
        ContentPackage contentPackage = pkg = plugin == null ? null : UmaUtil.findContentPackage((MethodPlugin)plugin, (String[])ModelStructure.DEFAULT.customCategoryPath);
        if (pkg == null) {
            TngUtil.setDefaultName(parent.getCategorizedElements(), (MethodElement)cc, baseName);
            return;
        }
        UniqueNameHandler handler = new UniqueNameHandler();
        handler.registerNames(pkg.getContentElements());
        String name = handler.getUniqueName(baseName);
        cc.setName(name);
        cc.setPresentationName(name);
    }

    private static void setPresentationName(MethodElement e, String baseName) {
        if (e instanceof DescribableElement) {
            DescribableElement de = (DescribableElement)e;
            StringBuffer presNameBuf = new StringBuffer();
            StringTokenizer st = new StringTokenizer(baseName, "_");
            while (st.hasMoreTokens()) {
                String aWord = st.nextToken();
                presNameBuf.append(String.valueOf(aWord.substring(0, 1).toUpperCase()) + aWord.substring(1) + " ");
            }
            de.setPresentationName(presNameBuf.toString().trim());
        }
    }

    private static boolean isNameTaken(List<? extends MethodElement> siblings, MethodElement e, String name) {
        int i = siblings.size() - 1;
        while (i > -1) {
            MethodElement sibling = siblings.get(i);
            if (sibling != e && name.equalsIgnoreCase(sibling.getName())) {
                return true;
            }
            --i;
        }
        return false;
    }

    public static List extract(Collection collection, Class cls) {
        ArrayList list = new ArrayList();
        for (Object element : collection) {
            if (!cls.isInstance(element)) continue;
            list.add(element);
        }
        return list;
    }

    public static <T> List<T> extractType(Collection<? extends Object> collection, Class<T> cls) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (Object object : collection) {
            if (!cls.isInstance(object)) continue;
            list.add(object);
        }
        return list;
    }

    public static void setDefaultName(IDefaultNameSetter defaultNameSetter, Notification msg) {
        int featureId;
        if (defaultNameSetter.getInterestedFeatureOwnerClass() != null && (featureId = msg.getFeatureID(defaultNameSetter.getInterestedFeatureOwnerClass())) == defaultNameSetter.getInterestedFeatureID()) {
            switch (msg.getEventType()) {
                case 3: {
                    defaultNameSetter.setDefaultName(msg.getNewValue());
                    break;
                }
                case 5: {
                    Iterator iter = ((Collection)msg.getNewValue()).iterator();
                    while (iter.hasNext()) {
                        defaultNameSetter.setDefaultName(iter.next());
                    }
                    break;
                }
            }
        }
    }

    public static void addExtendedChildren(ContentCategory baseCategory, MethodConfiguration methodConf, Collection children, String[] categoryPkgPath) {
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        MethodPlugin basePlugin = UmaUtil.getMethodPlugin((EObject)baseCategory);
        for (MethodPlugin plugin : methodConf.getMethodPluginSelection()) {
            ContentCategory category;
            ContentPackage categoryPkg;
            if (!Misc.isBaseOf(basePlugin, plugin, map) || (categoryPkg = UmaUtil.findContentPackage((MethodPlugin)plugin, (String[])categoryPkgPath)) == null || !methodConf.getMethodPackageSelection().contains(categoryPkg) || (category = TngUtil.findInherited(categoryPkg.getContentElements(), baseCategory)) == null) continue;
            ItemProviderAdapter adapter = (ItemProviderAdapter)TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory().adapt((Notifier)category, ITreeItemContentProvider.class);
            if (adapter == null) {
                System.err.println("DisciplineGroupingItemProvider.addExtendedChildren(): could not find adapter for " + category);
            }
            for (Object child : adapter.getChildren((Object)category)) {
                ContentElement element = null;
                if (child instanceof ContentElement) {
                    element = (ContentElement)child;
                }
                if (element == null || element.getVariabilityBasedOnElement() != null) continue;
                children.add(child);
            }
            TngUtil.addExtendedChildren(category, methodConf, children, categoryPkgPath);
        }
    }

    public static void addAllTo(List allChildren, List newChildren) {
        ArrayList<Object> list = new ArrayList<Object>();
        while (!newChildren.isEmpty()) {
            int id;
            BreakdownElement child = (BreakdownElement)newChildren.remove(0);
            list.clear();
            list.add(child);
            BreakdownElement last = null;
            BreakdownElement next = child.getPresentedAfter();
            while (next != null) {
                last = next;
                id = TngUtil.indexOfNextElement(newChildren, next);
                if (id == -1) break;
                list.add(newChildren.remove(id));
                next = next.getPresentedAfter();
            }
            if (last != null) {
                id = TngUtil.indexOfNextElement(allChildren, last);
                if (id == -1) {
                    allChildren.addAll(list);
                    continue;
                }
                allChildren.addAll(id, list);
                continue;
            }
            allChildren.add(child);
        }
    }

    public static void addTo(List allChildren, BreakdownElement child, Object owner, AdapterFactory adapterFactory) {
        BreakdownElement next = child.getPresentedAfter();
        int id = next == null ? -1 : TngUtil.indexOfNextElement(allChildren, next);
        if (id == -1) {
            allChildren.add(child);
        } else {
            allChildren.add(id, child);
        }
    }

    private static int indexOfNextElement(List mixedList, BreakdownElement presentedAfter) {
        int size = mixedList.size();
        int i = 0;
        while (i < size) {
            Object o = TngUtil.unwrap(mixedList.get(i));
            if (o == presentedAfter || o instanceof VariabilityElement && ((VariabilityElement)o).getVariabilityBasedOnElement() == presentedAfter) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static List getAvailableBaseProcesses(MethodPlugin plugin, List processClasses) {
        ArrayList<Process> processes = new ArrayList<Process>();
        List allBasePlugins = Misc.getAllBase(plugin);
        allBasePlugins.add(0, plugin);
        for (MethodPlugin basePlugin : allBasePlugins) {
            Collection packages = TngUtil.getRootProcessPackages(basePlugin, processClasses);
            for (ProcessPackage pkg : packages) {
                for (Object childPkg : pkg.getChildPackages()) {
                    Process proc;
                    if (!(childPkg instanceof ProcessComponent) || !TngUtil.isInstanceOf(processClasses, proc = ((ProcessComponent)childPkg).getProcess())) continue;
                    processes.add(proc);
                }
            }
        }
        return processes;
    }

    private static String[] getRootProcessPackagePath(Class procClass) {
        if (procClass == DeliveryProcess.class) {
            return ModelStructure.DEFAULT.deliveryProcessPath;
        }
        if (procClass == CapabilityPattern.class) {
            return ModelStructure.DEFAULT.capabilityPatternPath;
        }
        if (procClass == ProcessPlanningTemplate.class) {
            return ModelStructure.DEFAULT.processPlanningTemplatePath;
        }
        return null;
    }

    private static Collection getRootProcessPackages(MethodPlugin plugin, Collection procClasses) {
        ArrayList<MethodPackage> packages = new ArrayList<MethodPackage>();
        for (Class clazz : procClasses) {
            MethodPackage pkg;
            String[] path = TngUtil.getRootProcessPackagePath(clazz);
            if (path == null || !((pkg = UmaUtil.findMethodPackage((MethodPlugin)plugin, (String[])path)) instanceof ProcessPackage)) continue;
            packages.add(pkg);
        }
        return packages;
    }

    public static boolean hasCategories(MethodPlugin plugin) {
        List<ContentPackage> conPacks = TngUtil.getContentCategoryPackages(plugin);
        for (ContentPackage conPack : conPacks) {
            for (Object o : conPack.getContentElements()) {
                if (!(o instanceof ContentCategory)) continue;
                return true;
            }
        }
        return false;
    }

    public static List<Process> getAllProcesses(MethodPlugin plugin) {
        ArrayList<Process> processes = new ArrayList<Process>();
        for (MethodPackage pkg : plugin.getMethodPackages()) {
            TngUtil._iteratePackageForProcesses(pkg, processes);
        }
        return processes;
    }

    public static List<Process> getAllProcesses(MethodPackage pkg) {
        ArrayList<Process> processes = new ArrayList<Process>();
        TngUtil._iteratePackageForProcesses(pkg, processes);
        return processes;
    }

    private static void _iteratePackageForProcesses(MethodPackage pkg, List processes) {
        Process p;
        if (pkg instanceof ProcessComponent && (p = ((ProcessComponent)pkg).getProcess()) != null && !processes.contains(p)) {
            processes.add(p);
        }
        Iterator it = pkg.getChildPackages().iterator();
        while (it.hasNext()) {
            TngUtil._iteratePackageForProcesses((MethodPackage)it.next(), processes);
        }
    }

    public static boolean isSubelementOf(Object parent, Object e, AdapterFactory adapterFactory) {
        if (parent == e) {
            return false;
        }
        ITreeItemContentProvider adapter = (ITreeItemContentProvider)adapterFactory.adapt(parent, ITreeItemContentProvider.class);
        for (Object element : adapter.getChildren(parent)) {
            if (element == e) {
                return true;
            }
            if (!TngUtil.isSubelementOf(element, e, adapterFactory)) continue;
            return true;
        }
        return false;
    }

    public static boolean isSuperElementOf(Object child, Object e, AdapterFactory adapterFactory) {
        if (child == e) {
            return false;
        }
        ITreeItemContentProvider adapter = (ITreeItemContentProvider)adapterFactory.adapt(e, ITreeItemContentProvider.class);
        for (Object element : adapter.getChildren(e)) {
            if (element == child) {
                return true;
            }
            if (!TngUtil.isSuperElementOf(child, element, adapterFactory)) continue;
            return true;
        }
        return false;
    }

    public static Object unwrap(Object obj) {
        if (obj instanceof IWrapperItemProvider) {
            while ((obj = ((IWrapperItemProvider)obj).getValue()) instanceof IWrapperItemProvider) {
            }
        } else if (obj instanceof CommandWrapper) {
            while ((obj = ((CommandWrapper)obj).getCommand()) instanceof CommandWrapper) {
            }
        }
        return obj;
    }

    public static MethodElement getWrappedElement(Object obj) {
        if (obj instanceof MethodElement) {
            return (MethodElement)obj;
        }
        if ((obj = TngUtil.unwrap(obj)) instanceof MethodElement) {
            return (MethodElement)obj;
        }
        return null;
    }

    public static boolean isWrapped(Object obj) {
        return obj instanceof IWrapperItemProvider || obj instanceof CommandWrapper;
    }

    public static Command unwrap(Command cmd) {
        while (cmd instanceof CommandWrapper) {
            cmd = ((CommandWrapper)cmd).getCommand();
        }
        return cmd;
    }

    public static boolean isBase(List<?> elements, Object base, Set<VariabilityType> variabilityTypes) {
        for (Object element : elements) {
            VariabilityElement ve;
            if (!(element instanceof VariabilityElement) || base != (ve = (VariabilityElement)element).getVariabilityBasedOnElement() || variabilityTypes != null && !variabilityTypes.contains(ve.getVariabilityType())) continue;
            return true;
        }
        return false;
    }

    public static String getPresentationName(Object e) {
        return TngUtil.getPresentationName(e, null);
    }

    public static String getPresentationName(Object e, PresentationNameHelper helper) {
        if (e instanceof ContentDescription) {
            e = ((ContentDescription)e).eContainer();
        }
        if (e == null) {
            return "";
        }
        String name = null;
        if (e instanceof MethodElement && StrUtil.isBlank((String)(name = ((MethodElement)e).getPresentationName()))) {
            if (helper != null) {
                name = helper.getPresentationName((MethodElement)e);
            }
            if (helper == null || StrUtil.isBlank((String)name)) {
                name = ((MethodElement)e).getName();
            }
        }
        return name;
    }

    public static Process getOwningProcess(BreakdownElement e) {
        EObject container = e.eContainer();
        while (container != null && !(container instanceof ProcessComponent)) {
            container = container.eContainer();
        }
        if (container != null) {
            return ((ProcessComponent)container).getProcess();
        }
        return null;
    }

    public static Process getOwningProcess(BreakdownElementWrapperItemProvider wrapper) {
        Process proc;
        Object top = wrapper.getTopItem();
        if (top instanceof Process && (proc = (Process)top).eContainer() instanceof ProcessComponent) {
            return proc;
        }
        return null;
    }

    public static Process getOwningProcess(Object object) {
        if (object instanceof BreakdownElement) {
            return TngUtil.getOwningProcess((BreakdownElement)object);
        }
        if (object instanceof BreakdownElementWrapperItemProvider) {
            return TngUtil.getOwningProcess((BreakdownElementWrapperItemProvider)object);
        }
        return null;
    }

    public static boolean canReference(MethodElement source, MethodElement target) {
        MethodPlugin targetPlugin = UmaUtil.getMethodPlugin((EObject)target);
        MethodPlugin sourcePlugin = UmaUtil.getMethodPlugin((EObject)source);
        if (sourcePlugin == targetPlugin) {
            return true;
        }
        return Misc.isBaseOf(targetPlugin, sourcePlugin, new HashMap<String, Boolean>());
    }

    public static OrderInfo getOrderInfo(MethodElement e, String orderInfoName) {
        StringResource res;
        block5: {
            String str = e.getOrderingGuide();
            if (str == null || str.length() == 0) {
                return null;
            }
            res = new StringResource(str);
            res.load(null);
            if (!res.getContents().isEmpty()) break block5;
            return null;
        }
        try {
            OrderInfoCollection orderInfos = (OrderInfoCollection)res.getContents().get(0);
            for (OrderInfo orderInfo : orderInfos.getOrderInfos()) {
                if (!orderInfoName.equalsIgnoreCase(orderInfo.getName())) continue;
                return orderInfo;
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        return null;
    }

    public static void refreshContributors(IChangeNotifier notifier, Notification notification, boolean contentRefresh, boolean labelUpdate) {
        Iterator iter = TngUtil.getContributors((VariabilityElement)notification.getNotifier());
        while (iter.hasNext()) {
            Object element = iter.next();
            notifier.fireNotifyChanged((Notification)new ViewerNotification(notification, element, contentRefresh, labelUpdate));
        }
    }

    public static void refreshPluginExtenders(IChangeNotifier notifier, Notification notification, boolean contentRefresh, boolean labelUpdate) {
        Object obj = notification.getNotifier();
        if (obj instanceof MethodPlugin) {
            for (Object element : AssociationHelper.getPluginDirectExtensions((MethodPlugin)((MethodPlugin)obj))) {
                notifier.fireNotifyChanged((Notification)new ViewerNotification(notification, element, contentRefresh, labelUpdate));
            }
        }
    }

    public static boolean hasContributor(VariabilityElement e) {
        return TngUtil.hasGeneralizer(e, Collections.singleton(VariabilityType.CONTRIBUTES));
    }

    public static boolean hasGeneralizer(VariabilityElement e, Collection variabilityTypes) {
        for (VariabilityElement element : AssociationHelper.getImmediateVarieties((VariabilityElement)e)) {
            if (!variabilityTypes.contains(element.getVariabilityType())) continue;
            return true;
        }
        return false;
    }

    public static Iterator getImmediateVarieties(VariabilityElement elem, VariabilityType type) {
        ArrayList<VariabilityElement> selectedVes = new ArrayList<VariabilityElement>();
        List allVes = AssociationHelper.getImmediateVarieties((VariabilityElement)elem);
        int i = 0;
        while (i < allVes.size()) {
            VariabilityElement ve = (VariabilityElement)allVes.get(i);
            if (type == ve.getVariabilityType()) {
                selectedVes.add(ve);
            }
            ++i;
        }
        return selectedVes.iterator();
    }

    public static Iterator getGeneralizers(VariabilityElement e, final VariabilityType type) {
        return new AbstractTreeIterator(e, false){
            private static final long serialVersionUID = 3978145439449298483L;

            protected Iterator getChildren(Object object) {
                ArrayList<VariabilityElement> children = new ArrayList<VariabilityElement>();
                for (VariabilityElement element : AssociationHelper.getImmediateVarieties((VariabilityElement)((VariabilityElement)object))) {
                    if (type != null && element.getVariabilityType() != type) continue;
                    children.add(element);
                }
                return children.iterator();
            }
        };
    }

    public static Iterator getGeneralizers(VariabilityElement e) {
        return TngUtil.getGeneralizers(e, null);
    }

    public static Iterator getContributors(VariabilityElement e) {
        return TngUtil.getGeneralizers(e, VariabilityType.CONTRIBUTES);
    }

    public static ItemProviderAdapter getAdapter(MethodPlugin plugin, String[] path) {
        IGroupContainer groups = (IGroupContainer)TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory().adapt((Notifier)plugin, ITreeItemContentProvider.class);
        int i = 0;
        while (i < path.length - 1) {
            if ((groups = (IGroupContainer)groups.getGroupItemProvider(path[i])) == null) {
                return null;
            }
            ++i;
        }
        return (ItemProviderAdapter)groups.getGroupItemProvider(path[i]);
    }

    private static void refreshAdapter(MethodPlugin plugin, String[] path, Notification msg) {
        if (plugin == null) {
            return;
        }
        ItemProviderAdapter adapter = TngUtil.getAdapter(plugin, path);
        if (adapter != null) {
            adapter.fireNotifyChanged((Notification)new ViewerNotification(msg, (Object)adapter, true, false));
        }
    }

    public static void refreshAdapter(String[] path, Notification notification) {
        EObject eObj = null;
        switch (notification.getEventType()) {
            case 3: {
                eObj = (EObject)notification.getNewValue();
                break;
            }
            case 5: {
                eObj = (EObject)new ArrayList((Collection)notification.getNewValue()).get(0);
                break;
            }
            case 4: {
                eObj = (EObject)notification.getOldValue();
                break;
            }
            case 6: {
                eObj = (EObject)new ArrayList((Collection)notification.getOldValue()).get(0);
            }
        }
        if (eObj != null) {
            MethodPlugin plugin = UmaUtil.getMethodPlugin((EObject)eObj);
            TngUtil.refreshAdapter(plugin, path, notification);
        }
    }

    public static void refreshUncategorizedTasksItemProvider(MethodPlugin plugin, Notification msg) {
        TngUtil.refreshAdapter(plugin, LibraryEditConstants.UNCATEGORIZED_TASKS_PATH, msg);
    }

    public static void refreshDomainUncategorizedWorkProductsItemProvider(MethodPlugin plugin, Notification msg) {
        TngUtil.refreshAdapter(plugin, LibraryEditConstants.UNCATEGORIZED_DOMAIN_WORKPRODUCTS_PATH, msg);
    }

    public static void refreshWorkProductTypeUncategorized(MethodPlugin plugin, Notification msg) {
        TngUtil.refreshAdapter(plugin, LibraryEditConstants.UNCATEGORIZED_WORKPRODUCTTYPE_WORKPRODUCTS_PATH, msg);
    }

    public static void refreshUncategorizedWorkProductsItemProviders(MethodPlugin plugin, Notification msg) {
        TngUtil.refreshDomainUncategorizedWorkProductsItemProvider(plugin, msg);
        TngUtil.refreshWorkProductTypeUncategorized(plugin, msg);
    }

    public static void refreshUncategorizedRolesItemProvider(MethodPlugin plugin, Notification msg) {
        TngUtil.refreshAdapter(plugin, LibraryEditConstants.UNCATEGORIZED_ROLES_PATH, msg);
    }

    public static void refreshUncategorizedToolMentorsItemProvider(MethodPlugin plugin, Notification msg) {
        TngUtil.refreshAdapter(plugin, LibraryEditConstants.UNCATEGORIZED_TOOLMENTORS_PATH, msg);
    }

    public static Object createWrapper(AdapterFactory adapterFactory, EObject object, EStructuralFeature feature, Object value, int index) {
        if (FeatureMapUtil.isFeatureMap((EStructuralFeature)feature)) {
            value = new FeatureMapEntryWrapperItemProvider((FeatureMap.Entry)value, object, (EAttribute)feature, index, adapterFactory, null);
        } else if (feature instanceof EAttribute) {
            value = new AttributeValueWrapperItemProvider(value, object, (EAttribute)feature, index, adapterFactory, null);
        } else if (!((EReference)feature).isContainment()) {
            value = new FeatureValueWrapperItemProvider(feature, value, object, adapterFactory);
        }
        return value;
    }

    public static Object getNavigatorParentItemProvider(Guidance guidance) {
        EObject container = guidance.eContainer();
        if (!(container instanceof ContentPackage)) {
            return null;
        }
        ContentPackageItemProvider itemProvider = (ContentPackageItemProvider)TngUtil.getAdapter(container, ContentPackageItemProvider.class);
        return itemProvider != null ? itemProvider.getGuidances() : null;
    }

    public static Object getNavigatorParentItemProvider(WorkProduct object) {
        EObject contentPkg = object.eContainer();
        if (contentPkg == null) {
            return null;
        }
        ContentPackageItemProvider itemProvider = (ContentPackageItemProvider)TngUtil.getAdapter(contentPkg, ContentPackageItemProvider.class);
        return itemProvider != null ? itemProvider.getWorkProducts() : null;
    }

    public static Object getImage(Object object) {
        Object image = TngUtil.getCustomNodeIcon(object);
        if (image != null) {
            return image;
        }
        if (object instanceof Practice && PracticePropUtil.getPracticePropUtil().isUdtType((MethodElement)((Practice)object))) {
            URL url = TngUtil.getImageForUdt2((Practice)object);
            if (url != null) {
                return url;
            }
            return UmaEditPlugin.INSTANCE.getImage("full/obj16/UdtNode");
        }
        Object adapter = null;
        try {
            adapter = umaItemProviderAdapterFactory.adapt(object, ITreeItemContentProvider.class);
            if (adapter instanceof IItemLabelProvider) {
                Object object2 = ((IItemLabelProvider)adapter).getImage(object);
                return object2;
            }
        }
        finally {
            if (adapter != object && adapter instanceof IDisposable) {
                ((IDisposable)adapter).dispose();
            }
        }
        return null;
    }

    public static ImageDescriptor getImageForUdt(Practice prac) {
        String imageUrl;
        block3: {
            try {
                UserDefinedTypeMeta udtMeta = PracticePropUtil.getPracticePropUtil().getUtdData(prac);
                imageUrl = (String)udtMeta.getRteNameMap().get("icon");
                if (imageUrl != null) break block3;
                return null;
            }
            catch (Exception e) {
                LibraryEditPlugin.getDefault().getLogger().logError((Throwable)e);
                return null;
            }
        }
        return ImageDescriptor.createFromURL((URL)new URL(imageUrl));
    }

    public static URL getImageForUdt2(Practice prac) {
        String imageUrl;
        block3: {
            try {
                UserDefinedTypeMeta udtMeta = PracticePropUtil.getPracticePropUtil().getUtdData(prac);
                imageUrl = (String)udtMeta.getRteNameMap().get("icon");
                if (imageUrl != null) break block3;
                return null;
            }
            catch (Exception e) {
                LibraryEditPlugin.getDefault().getLogger().logError((Throwable)e);
                return null;
            }
        }
        return new URL(imageUrl);
    }

    private static String getTypeNameForUdt(Practice prac) {
        try {
            UserDefinedTypeMeta udtMeta = PracticePropUtil.getPracticePropUtil().getUtdData(prac);
            return (String)udtMeta.getRteNameMap().get("typeName");
        }
        catch (Exception e) {
            LibraryEditPlugin.getDefault().getLogger().logError((Throwable)e);
            return null;
        }
    }

    public static Object getColumnImage(Object object, String colName) {
        if (colName == "presentation_name") {
            return TngUtil.getImage(object);
        }
        return null;
    }

    public static void moveUp(Activity activity, Object elementObj, Collection eClasses, IActionManager actionMgr) {
        MoveUpCommand cmd = new MoveUpCommand(activity, elementObj, eClasses);
        actionMgr.execute(cmd);
    }

    public static void moveDown(Activity activity, Object elementObj, Collection eClasses, IActionManager actionMgr) {
        MoveDownCommand cmd = new MoveDownCommand(activity, elementObj, eClasses);
        actionMgr.execute(cmd);
    }

    public static CustomCategory createRootCustomCategory(ContentPackage customCategoryPkg) {
        CustomCategory rootCustomCategory = UmaFactory.eINSTANCE.createCustomCategory();
        rootCustomCategory.setName(LibraryEditPlugin.INSTANCE.getString("_UI_Custom_Categories_group"));
        ContentPackage hiddenPkg = UmaUtil.findContentPackage((List)customCategoryPkg.getChildPackages(), (String)"Hidden");
        if (hiddenPkg == null) {
            hiddenPkg = UmaFactory.eINSTANCE.createContentPackage();
            hiddenPkg.setName("Hidden");
            customCategoryPkg.getChildPackages().add(hiddenPkg);
        }
        hiddenPkg.getContentElements().add(rootCustomCategory);
        return rootCustomCategory;
    }

    public static Set<CustomCategory> getAllCustomCategories(MethodPlugin plugin) {
        HashSet<CustomCategory> set = new HashSet<CustomCategory>();
        ContentPackage customCategoryPkg = UmaUtil.findContentPackage((MethodPlugin)plugin, (String[])ModelStructure.DEFAULT.customCategoryPath);
        if (customCategoryPkg != null) {
            for (ContentElement element : customCategoryPkg.getContentElements()) {
                if (!(element instanceof CustomCategory)) continue;
                set.add((CustomCategory)element);
            }
        }
        return set;
    }

    public static CustomCategory getRootCustomCategory(MethodPlugin plugin) {
        ContentPackage customCategoryPkg = UmaUtil.findContentPackage((MethodPlugin)plugin, (String[])ModelStructure.DEFAULT.customCategoryPath);
        if (customCategoryPkg == null) {
            return null;
        }
        ContentPackage hiddenPkg = UmaUtil.findContentPackage((List)customCategoryPkg.getChildPackages(), (String)"Hidden");
        if (hiddenPkg != null && !hiddenPkg.getContentElements().isEmpty()) {
            return (CustomCategory)hiddenPkg.getContentElements().get(0);
        }
        CustomCategory root = TngUtil.createRootCustomCategory(customCategoryPkg);
        for (Object element : customCategoryPkg.getContentElements()) {
            if (!(element instanceof CustomCategory)) continue;
            root.getCategorizedElements().add((DescribableElement)element);
        }
        return root;
    }

    public static boolean isRootCustomCategory(CustomCategory category) {
        EObject pkg = category.eContainer();
        return pkg instanceof ContentPackage && "Hidden".equals(((ContentPackage)pkg).getName());
    }

    public static boolean isRootCutomCategoryPackage(MethodPackage pkg) {
        return pkg instanceof ContentPackage && "Hidden".equals(pkg.getName());
    }

    public static void saveContainerResource(EObject element, IFileBasedLibraryPersister persister) {
        Resource resource;
        if (element.eContainer() != null && (resource = element.eContainer().eResource()) != null && resource.isModified()) {
            try {
                persister.save(resource);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static ContentCategory findContributor(ContentPackage categoryPkg, ContentCategory baseCategory) {
        for (ContentCategory cat : categoryPkg.getContentElements()) {
            if (cat.getVariabilityBasedOnElement() != baseCategory) continue;
            return cat;
        }
        return null;
    }

    public static boolean isEmpty(ContentCategory category) {
        if (!category.getConceptsAndPapers().isEmpty() || !category.getSupportingMaterials().isEmpty()) {
            return false;
        }
        if (category instanceof Discipline) {
            return ((Discipline)category).getTasks().isEmpty();
        }
        if (category instanceof Domain) {
            return ((Domain)category).getWorkProducts().isEmpty();
        }
        if (category instanceof RoleSet) {
            return ((RoleSet)category).getRoles().isEmpty();
        }
        if (category instanceof Tool) {
            return ((Tool)category).getToolMentors().isEmpty();
        }
        if (category instanceof WorkProductType) {
            return ((WorkProductType)category).getWorkProducts().isEmpty();
        }
        if (category instanceof CustomCategory) {
            CustomCategory userDefinedCategory = (CustomCategory)category;
            return userDefinedCategory.getCategorizedElements().isEmpty();
        }
        throw new IllegalArgumentException("Unknown category: " + category);
    }

    private static void addToPackage(WorkOrder order, BreakdownElement e) {
        EObject container = e.eContainer();
        if (container != null) {
            ((ProcessPackage)container).getProcessElements().add(order);
        }
    }

    private static void removeFromPackage(WorkOrder order, BreakdownElement e) {
        EObject container = e.eContainer();
        if (container instanceof ProcessPackage) {
            ((ProcessPackage)container).getProcessElements().remove(order);
        }
    }

    public static boolean handlePredecessorListChange(ItemProviderAdapter adapter, Notification notification) {
        if (notification.getNotifier() instanceof WorkBreakdownElement) {
            switch (notification.getFeatureID(WorkBreakdownElement.class)) {
                case 34: {
                    switch (notification.getEventType()) {
                        case 3: {
                            TngUtil.addToPackage((WorkOrder)notification.getNewValue(), (BreakdownElement)notification.getNotifier());
                            break;
                        }
                        case 5: {
                            Iterator iter = ((Collection)notification.getNewValue()).iterator();
                            while (iter.hasNext()) {
                                TngUtil.addToPackage((WorkOrder)iter.next(), (BreakdownElement)notification.getNotifier());
                            }
                            break;
                        }
                        case 4: {
                            TngUtil.removeFromPackage((WorkOrder)notification.getOldValue(), (BreakdownElement)notification.getNotifier());
                            break;
                        }
                        case 6: {
                            Iterator iter = ((Collection)notification.getOldValue()).iterator();
                            while (iter.hasNext()) {
                                TngUtil.removeFromPackage((WorkOrder)iter.next(), (BreakdownElement)notification.getNotifier());
                            }
                            break;
                        }
                    }
                    adapter.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), false, true));
                    return true;
                }
            }
        }
        return false;
    }

    public static List<ContentPackage> getGlobalPackages(MethodPlugin plugin) {
        ArrayList<ContentPackage> packages = new ArrayList<ContentPackage>();
        String[][] categoryPaths = ModelStructure.DEFAULT.getCategoryPaths();
        int i = 0;
        while (i < categoryPaths.length) {
            String[] path = categoryPaths[i];
            ContentPackage categoryPkg = UmaUtil.findContentPackage((MethodPlugin)plugin, (String[])path);
            if (categoryPkg != null) {
                packages.add(categoryPkg);
            }
            ++i;
        }
        return packages;
    }

    public static List<ContentPackage> getContentCategoryPackages(MethodPlugin plugin) {
        return TngUtil.getGlobalPackages(plugin);
    }

    public static List getAllSystemPackages(MethodPlugin plugin) {
        ContentPackage hiddenPkg;
        ArrayList<Object> packages = new ArrayList<Object>();
        String[][] paths = ModelStructure.DEFAULT.getAllSystemPaths();
        int i = 0;
        while (i < paths.length) {
            String[] path = paths[i];
            MethodPackage pkg = UmaUtil.findMethodPackage((MethodPlugin)plugin, (String[])path);
            if (pkg != null && !packages.contains(pkg)) {
                packages.add(pkg);
                EObject o = pkg.eContainer();
                while (o instanceof MethodPackage && !packages.contains(o)) {
                    packages.add(o);
                    o = o.eContainer();
                }
            }
            ++i;
        }
        ContentPackage customCategoryPkg = UmaUtil.findContentPackage((MethodPlugin)plugin, (String[])ModelStructure.DEFAULT.customCategoryPath);
        if (customCategoryPkg != null && (hiddenPkg = UmaUtil.findContentPackage((List)customCategoryPkg.getChildPackages(), (String)"Hidden")) != null) {
            packages.add(hiddenPkg);
        }
        return packages;
    }

    public static boolean isPredefined(MethodElement e) {
        if (e instanceof CustomCategory && TngUtil.isRootCustomCategory((CustomCategory)e)) {
            return true;
        }
        String path = ModelStructure.toFilePath(Misc.getPathRelativeToPlugin((NamedElement)e));
        for (String predefinePath : ModelStructure.ALL_PREDEFINED_PATHS) {
            if (!predefinePath.startsWith(path)) continue;
            return true;
        }
        return false;
    }

    public static MethodPackage getMethodPackage(EObject e) {
        while (!(e instanceof MethodPackage) && e != null) {
            e = e.eContainer();
        }
        return (MethodPackage)e;
    }

    public static MethodPackage getParentMethodPackage(EObject e) {
        EObject eobj = e;
        while (eobj != null) {
            if ((eobj = eobj.eContainer()) == null) {
                return null;
            }
            if (!(eobj instanceof MethodPackage)) continue;
            return (MethodPackage)eobj;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static void validateMethodConfiguration(IActionManager actionMgr, MethodConfiguration config) {
        ArrayList<void> plugins = new ArrayList<void>(config.getMethodPluginSelection());
        ArrayList pkgSels = new ArrayList(config.getMethodPackageSelection());
        ArrayList<MethodPlugin> pluginsToAdd = new ArrayList<MethodPlugin>();
        ArrayList<Object> packagesToAdd = new ArrayList<Object>();
        for (MethodPackage pkg : new ArrayList(pkgSels)) {
            void var8_8;
            EObject eObject = pkg.eContainer();
            while ((var8_8 instanceof MethodPackage || var8_8 instanceof MethodPlugin) && !pkgSels.contains(var8_8) && !plugins.contains(var8_8)) {
                if (var8_8 instanceof MethodPlugin) {
                    plugins.add(var8_8);
                    pluginsToAdd.add((MethodPlugin)var8_8);
                } else {
                    pkgSels.add(var8_8);
                    packagesToAdd.add((MethodPackage)var8_8);
                }
                EObject eObject2 = var8_8.eContainer();
            }
            if (!(pkg instanceof ProcessComponent)) continue;
            ArrayList oldPkgSels = new ArrayList(pkgSels);
            TngUtil.getAllChildPackages(pkg, pkgSels);
            pkgSels.removeAll(oldPkgSels);
            packagesToAdd.addAll(pkgSels);
        }
        ConfigurationUtil.addCollToMethodPluginList(actionMgr, config, pluginsToAdd);
        ConfigurationUtil.addCollToMethodPackageList(actionMgr, config, packagesToAdd);
        pkgSels = new ArrayList(config.getMethodPackageSelection());
        ArrayList<MethodPackage> sysPackagesToAdd = new ArrayList<MethodPackage>();
        for (MethodPlugin methodPlugin : plugins) {
            List pkgs = TngUtil.getAllSystemPackages(methodPlugin);
            for (Object pkg : pkgs) {
                if (pkgSels.contains(pkg) || !(pkg instanceof ContentPackage)) continue;
                pkgSels.add(pkg);
                sysPackagesToAdd.add((MethodPackage)pkg);
            }
        }
        ConfigurationUtil.addCollToMethodPackageList(actionMgr, config, sysPackagesToAdd);
    }

    private static void getAllChildPackages(MethodPackage pkg, List result) {
        List pkgs = pkg.getChildPackages();
        for (Object p : pkgs) {
            if (result.contains(p)) continue;
            result.add(p);
        }
        Iterator it = pkgs.iterator();
        while (it.hasNext()) {
            TngUtil.getAllChildPackages((MethodPackage)it.next(), result);
        }
    }

    public static boolean addTo(MethodConfiguration config, EObject object, Set addedObjects) {
        MethodPackage pkg = TngUtil.getMethodPackage(object);
        if (pkg != null && !config.getMethodPackageSelection().contains(pkg)) {
            config.getMethodPackageSelection().add(pkg);
            addedObjects.add(pkg);
            MethodPlugin plugin = UmaUtil.getMethodPlugin((EObject)pkg);
            if (!config.getMethodPluginSelection().contains(plugin)) {
                config.getMethodPluginSelection().add(plugin);
                addedObjects.add(plugin);
                TngUtil.validateMethodConfiguration(null, config);
            }
            return true;
        }
        return false;
    }

    public static boolean addToConfiguration(MethodConfiguration config, EObject object, Set addedObjects) {
        int size = addedObjects.size();
        TngUtil.addTo(config, object, addedObjects);
        if (object instanceof VariabilityElement) {
            VariabilityElement c = ((VariabilityElement)object).getVariabilityBasedOnElement();
            while (c != null) {
                TngUtil.addTo(config, (EObject)c, addedObjects);
                c = c.getVariabilityBasedOnElement();
            }
        }
        return addedObjects.size() > size;
    }

    public static IStatus checkEdit(EObject eObj, Object context) {
        if (((InternalEObject)eObj).eProxyURI() != null) {
            String location;
            URI containerURI;
            EObject proxy = eObj;
            String uri = ((InternalEObject)proxy).eProxyURI().toString();
            URI uRI = containerURI = proxy.eContainer() != null ? proxy.eContainer().eResource().getURI() : null;
            if (containerURI != null) {
                String string = location = containerURI != null && containerURI.isFile() ? containerURI.toFileString() : "";
                if (location.length() != 0) {
                    location = MessageFormat.format(" in ''{0}''", location);
                }
            } else {
                location = "";
            }
            String msg = MessageFormat.format(LibraryEditResources.unresolvedObjectError_reason, proxy.eClass().getName(), uri, location);
            return new Status(4, LibraryEditPlugin.INSTANCE.getSymbolicName(), 0, msg, null);
        }
        IAccessController ac = Services.getAccessController();
        if (ac == null) {
            return Status.OK_STATUS;
        }
        return ac.checkModify(Collections.singletonList(eObj), context);
    }

    public static void checkModify(EObject e) {
        IStatus status;
        IAccessController ac = Services.getAccessController();
        if (ac != null && !(status = ac.checkModify(Collections.singletonList(e), null)).isOK()) {
            String msg = UmaUtil.getMessage((IStatus)status);
            if (msg == null) {
                Object obj = e.eResource().getURI().isFile() ? e.eResource().getURI().toFileString() : e;
                msg = MessageFormat.format(UmaResources.err_cannotModify0, obj);
            }
            throw new MessageException(msg);
        }
    }

    public static String getMessage(IStatus status) {
        String msg = status.getMessage();
        if (status.isMultiStatus()) {
            StringBuffer strBuf = new StringBuffer(msg);
            IStatus[] statuses = status.getChildren();
            int i = 0;
            while (i < statuses.length) {
                strBuf.append('\n').append(statuses[i].getMessage());
                ++i;
            }
            msg = strBuf.toString();
        }
        if (msg == null || msg.length() == 0) {
            msg = LibraryEditResources.util_tngutil_cannot_edit_resource;
        }
        return msg;
    }

    public static boolean isContributor(VariabilityElement e) {
        return e.getVariabilityBasedOnElement() != null && e.getVariabilityType() == VariabilityType.CONTRIBUTES;
    }

    public static boolean isReplacer(VariabilityElement e) {
        return e.getVariabilityBasedOnElement() != null && e.getVariabilityType() == VariabilityType.REPLACES;
    }

    public static boolean isContributorOrReplacer(VariabilityElement e) {
        VariabilityElement base = e.getVariabilityBasedOnElement();
        VariabilityType type = e.getVariabilityType();
        return base != null && (type == VariabilityType.CONTRIBUTES || type == VariabilityType.REPLACES);
    }

    public static boolean isGeneralizer(Object obj, Collection types) {
        if (!(obj instanceof VariabilityElement)) {
            return false;
        }
        VariabilityElement ve = (VariabilityElement)obj;
        if (ve.getVariabilityBasedOnElement() == null) {
            return false;
        }
        if (types == null) {
            return true;
        }
        return types.contains(ve.getVariabilityType());
    }

    public static String getTypeText(String typeKey) {
        try {
            return UmaEditPlugin.INSTANCE.getString("_UI_" + typeKey + "_type");
        }
        catch (MissingResourceException missingResourceException) {
            return UmaEditPlugin.INSTANCE.getString("_UI_Unknown_type");
        }
    }

    public static String getTypeText(EObject element) {
        String typeName;
        if (element instanceof Practice && PracticePropUtil.getPracticePropUtil().isUdtType((MethodElement)((Practice)element)) && (typeName = TngUtil.getTypeNameForUdt((Practice)element)) != null) {
            return typeName;
        }
        return TngUtil.getTypeText(element.eClass());
    }

    public static String getTypeText(EClass type) {
        return TngUtil.getTypeText(type.getName());
    }

    public static String getFeatureText(Object feature) {
        if (feature instanceof EStructuralFeature) {
            return TngUtil.getFeatureText((EStructuralFeature)feature);
        }
        return "Unknown";
    }

    public static boolean isLocked(EObject object) {
        MethodPlugin plugin = UmaUtil.getMethodPlugin((EObject)object);
        if (plugin == null) {
            return false;
        }
        return plugin.getUserChangeable() == false;
    }

    public static boolean checkExist(Collection wrappers, Object e) {
        Iterator iterator = wrappers.iterator();
        while (iterator.hasNext()) {
            Object element = TngUtil.unwrap(iterator.next());
            if (element != e) continue;
            return true;
        }
        return false;
    }

    public static int getIndexOf(List list, Object e) {
        int size = list.size();
        int i = 0;
        while (i < size) {
            Object element = TngUtil.unwrap(list.get(i));
            if (element == e) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static EStructuralFeature getContainingFeature(Object object, AdapterFactory adapterFactory) {
        ITreeItemContentProvider adapter = (ITreeItemContentProvider)adapterFactory.adapt(object, ITreeItemContentProvider.class);
        if (adapter == null) {
            return null;
        }
        Object parent = adapter.getParent(object);
        if (!(parent instanceof EObject)) {
            return null;
        }
        adapter = (ITreeItemContentProvider)adapterFactory.adapt(parent, ITreeItemContentProvider.class);
        if (adapter instanceof MethodElementItemProvider) {
            EObject parentEObj = (EObject)parent;
            for (EStructuralFeature f : ((MethodElementItemProvider)adapter).getChildrenFeatures(parent)) {
                if (!(f.isMany() ? ((Collection)parentEObj.eGet(f)).contains(object) : parentEObj.eGet(f) == object)) continue;
                return f;
            }
        }
        return null;
    }

    public static String getFeatureText(EStructuralFeature feature) {
        String featureKey;
        switch (feature.getFeatureID()) {
            case 40: {
                return LibraryEditResources.assists_text;
            }
        }
        ExtendedReference eRef = TypeDefUtil.getInstance().getAssociatedExtendedReference(feature);
        if (eRef != null) {
            return eRef.getName();
        }
        if (feature instanceof EStructuralFeature) {
            EStructuralFeature eFeature = feature;
            featureKey = String.valueOf(eFeature.getEContainingClass().getName()) + "_" + eFeature.getName();
        } else {
            featureKey = LibraryEditResources.unknown_text;
        }
        return UmaEditPlugin.INSTANCE.getString("_UI_" + featureKey + "_feature");
    }

    public static File getLibraryRootPath(EObject element) {
        EObject parent = element;
        while (parent != null && !(parent instanceof MethodLibrary)) {
            parent = parent.eContainer();
        }
        if (parent != null && parent.eResource() != null) {
            URI uri = parent.eResource().getURI();
            String path = uri.toFileString();
            File f = new File(path);
            return f.getParentFile();
        }
        return null;
    }

    public static java.net.URI getFullPathURI(EObject o, java.net.URI uri) {
        if (uri == null) {
            return uri;
        }
        try {
            URL url = uri.toURL();
            if (url != null) {
                return uri;
            }
        }
        catch (Exception exception) {}
        File f = TngUtil.getLibraryRootPath(o);
        if (f != null) {
            return new File(f, NetUtil.decodedFileUrl((String)uri.toString())).toURI();
        }
        return uri;
    }

    public static Object getCustomNodeIcon(Object object) {
        java.net.URI imgUri;
        Object image;
        if (object instanceof DescribableElement && ((DescribableElement)object).getNodeicon() != null && (image = LibraryEditPlugin.INSTANCE.getSharedImage(imgUri = TngUtil.getFullPathofNodeorShapeIconURI((EObject)((DescribableElement)object), ((DescribableElement)object).getNodeicon()))) != null) {
            return image;
        }
        return null;
    }

    public static java.net.URI getFullPathofNodeorShapeIconURI(EObject o, java.net.URI uri) {
        if (uri == null) {
            return uri;
        }
        try {
            URL url = uri.toURL();
            if (url != null) {
                return uri;
            }
        }
        catch (Exception exception) {}
        MethodPlugin plugin = UmaUtil.getMethodPlugin((EObject)o);
        if (plugin != null && UmaUtil.hasDirectResource((EObject)plugin)) {
            File f = TngUtil.getLibraryRootPath(o);
            String path = uri.getPath();
            if (f != null && path.indexOf(String.valueOf(plugin.getName()) + "/") == 0) {
                return new File(f, NetUtil.decodedFileUrl((String)uri.toString())).toURI();
            }
            IFileBasedLibraryPersister persister = (IFileBasedLibraryPersister)Services.getLibraryPersister((String)"xmi");
            File pluginDir = persister.getFile(plugin.eResource()).getParentFile();
            return new File(pluginDir, NetUtil.decodedFileUrl((String)uri.toString())).toURI();
        }
        return null;
    }

    public static String toStackTraceString(Throwable e) {
        StringWriter strWriter = new StringWriter();
        e.printStackTrace(new PrintWriter(strWriter));
        return strWriter.toString();
    }

    public static String getLabelWithPath(Object object) {
        if (object instanceof BreakdownElement) {
            return ProcessUtil.getLabelWithPath((BreakdownElement)object);
        }
        if (object instanceof ContentDescription) {
            return TngUtil.getLabelWithPath(((ContentDescription)object).eContainer());
        }
        if (object instanceof MethodElement) {
            MethodElement me = (MethodElement)object;
            Collection<NamedElement> itemPath = Misc.getObjectTreeRelativeToPlugin((NamedElement)me);
            StringBuffer path = new StringBuffer(TngUtil.getLabel(object, me.getGuid()));
            if (MethodElementUtil.getMethodModel(object) != null) {
                path.append(", ").append(MethodElementUtil.getMethodModel(object).getName());
                for (NamedElement e : itemPath) {
                    String s = String.valueOf(e.getName());
                    if ("CoreContent".equals(s) || "Content".equalsIgnoreCase(s) || ((NamedElement)object).equals(e)) continue;
                    path.append('/').append(s);
                }
            }
            return path.toString();
        }
        return "";
    }

    public static EObject getOwner(Command command) {
        Object o;
        command = TngUtil.unwrap(command);
        EObject owner = null;
        if (command instanceof AddCommand) {
            owner = ((AddCommand)command).getOwner();
        } else if (command instanceof RemoveCommand) {
            owner = ((RemoveCommand)command).getOwner();
        } else if (command instanceof SetCommand) {
            owner = ((SetCommand)command).getOwner();
        } else if (command instanceof MoveCommand) {
            owner = ((MoveCommand)command).getOwner();
        } else if (command instanceof PasteFromClipboardCommand && (o = ((PasteFromClipboardCommand)command).getOwner()) instanceof EObject) {
            owner = (EObject)o;
        }
        return owner;
    }

    public static Set<Resource> getModifiedResources(Command cmd) {
        HashSet<Resource> modifiedResources = new HashSet<Resource>();
        TngUtil.collectModifiedResources(cmd, modifiedResources);
        return modifiedResources;
    }

    public static void collectModifiedResources(Command command, Set<Resource> modifiedResources) {
        if (command instanceof IResourceAwareCommand) {
            modifiedResources.addAll(((IResourceAwareCommand)command).getModifiedResources());
        } else if (command instanceof CompoundCommand) {
            List commandList = ((CompoundCommand)command).getCommandList();
            Iterator iter = commandList.iterator();
            while (iter.hasNext()) {
                TngUtil.collectModifiedResources((Command)iter.next(), modifiedResources);
            }
        } else {
            Resource resource;
            EObject modified = TngUtil.getOwner(command);
            if (modified != null && (resource = modified.eResource()) != null) {
                modifiedResources.add(resource);
            }
        }
    }

    public static List convertGuidanceAttachmentsToList(String attachmentString) {
        ArrayList<String> attachments = new ArrayList<String>();
        if (attachmentString == null) {
            attachmentString = "";
        }
        String[] files = attachmentString.split(GUIDANCE_FILESTRING_SEPARATOR_SPLITTER);
        int i = 0;
        while (i < files.length) {
            if (files[i].trim().length() > 0) {
                attachments.add(files[i]);
            }
            ++i;
        }
        return attachments;
    }

    public static String convertGuidanceAttachmentsToString(List attachmentList) {
        String attachmentString = "";
        int i = 0;
        for (String attachment : attachmentList) {
            if (i++ > 0) {
                attachmentString = attachmentString.concat(GUIDANCE_FILESTRING_SEPARATOR);
            }
            attachmentString = attachmentString.concat(attachment);
        }
        return attachmentString;
    }

    public static List<String> convertStringsToList(String string) {
        ArrayList<String> strList = new ArrayList<String>();
        if (string == null) {
            string = "";
        }
        String[] strings = string.split(COMMA_SEPARATOR_SPLITTER);
        int i = 0;
        while (i < strings.length) {
            if (strings[i].trim().length() > 0) {
                strList.add(strings[i].trim());
            }
            ++i;
        }
        return strList;
    }

    public static List<String> convertStringsToList(String string, String seperator) {
        ArrayList<String> strList = new ArrayList<String>();
        if (string == null) {
            string = "";
        }
        String[] strings = string.split(seperator);
        int i = 0;
        while (i < strings.length) {
            if (strings[i].trim().length() > 0) {
                strList.add(strings[i].trim());
            }
            ++i;
        }
        return strList;
    }

    public static String convertListToString(List<String> strList) {
        String string = "";
        int i = 0;
        if (strList != null) {
            for (String aString : strList) {
                if (i++ > 0) {
                    string = string.concat(COMMA_SEPARATOR);
                }
                string = string.concat(aString);
            }
        }
        return string;
    }

    public static boolean isAllowedAttachments(MethodElement e) {
        if (e == null) {
            return false;
        }
        if (e instanceof Example) {
            return true;
        }
        if (e instanceof ReusableAsset) {
            return true;
        }
        if (e instanceof Template) {
            return true;
        }
        return e instanceof Whitepaper;
    }

    public static boolean contains(Collection elements, Object e) {
        for (Object element : elements) {
            if (element != e && e != TngUtil.unwrap(element)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAncessorOf(CustomCategory cc, DescribableElement e) {
        return DependencyChecker.isAncessorOf(cc, e);
    }

    public static void refreshParentIfNameChanged(Notification notification, ItemProviderAdapter adapter) {
        block8: {
            block7: {
                if (!(notification.getNotifier() instanceof ContentElement)) break block7;
                switch (notification.getFeatureID(DescribableElement.class)) {
                    case 0: {
                        if (PresentationContext.INSTANCE.isShowPresentationNames()) {
                            return;
                        }
                        break block8;
                    }
                    case 2: {
                        if (!PresentationContext.INSTANCE.isShowPresentationNames()) {
                            return;
                        }
                        break block8;
                    }
                    default: {
                        return;
                    }
                }
            }
            if (notification.getFeatureID(NamedElement.class) != 0) {
                return;
            }
        }
        adapter.fireNotifyChanged((Notification)new ViewerNotification(notification, adapter.getParent(notification.getNotifier()), true, false));
    }

    public static boolean isContributorOf(Object base, VariabilityElement e) {
        VariabilityElement ve = e;
        while (ve != null && ve.getVariabilityType() == VariabilityType.CONTRIBUTES && ve.getVariabilityBasedOnElement() != null) {
            if (ve.getVariabilityBasedOnElement() == base) {
                return true;
            }
            ve = ve.getVariabilityBasedOnElement();
        }
        return false;
    }

    public static void getConfigurationsToUpdate(MethodPackage parent, MethodPackage pkg, Collection configsToUpdate) {
        Object configs = ((MultiResourceEObject)parent).getOppositeFeatureValue(AssociationHelper.MethodPackage_MethodConfigurations);
        if (configs instanceof List) {
            for (MethodConfiguration config : (List)configs) {
                List pkgs = config.getMethodPackageSelection();
                if (pkgs.contains(pkg)) continue;
                configsToUpdate.add(config);
            }
        }
    }

    public static boolean canEstimate(Object o) {
        return o instanceof Task || o instanceof WorkBreakdownElement;
    }

    public static void debugShowAll() {
        ILibraryInspector inspector = TngUtil.getLibraryInspector();
        if (inspector != null) {
            inspector.showAllContents();
        }
    }

    public static void debugShowAll(MethodLibrary lib) {
        ILibraryInspector inspector = TngUtil.getLibraryInspector();
        if (inspector != null) {
            inspector.showAllContents(lib);
        }
    }

    public static ILibraryInspector getLibraryInspector() {
        return (ILibraryInspector)ExtensionManager.getExtension("org.eclipse.epf.library.edit", "libraryInspector");
    }

    public static boolean isInPluginWithLessThanOneSuperCustomCategory(CustomCategory cc, MethodPlugin plugin) {
        if (UmaUtil.getMethodPlugin((EObject)cc) != plugin) {
            return false;
        }
        List list = AssociationHelper.getCustomCategories((DescribableElement)cc);
        int count = 0;
        Iterator iter = list.iterator();
        while (iter.hasNext() && count < 2) {
            CustomCategory cat = (CustomCategory)iter.next();
            if (UmaUtil.getMethodPlugin((EObject)cat) != plugin) continue;
            ++count;
        }
        return count < 2;
    }

    public static boolean isUnderCustomCategoryTree(IWrapperItemProvider wrapper) {
        Object owner;
        do {
            if (!(TngUtil.unwrap(owner = wrapper.getOwner()) instanceof CustomCategory)) continue;
            return true;
        } while ((wrapper = owner instanceof IWrapperItemProvider ? (IWrapperItemProvider)owner : null) != null);
        return false;
    }

    public static Collection getExclusiveSubCustomCategories(CustomCategory cc) {
        ArrayList collection = new ArrayList();
        TngUtil.collectExclusiveSubCustomCategories(collection, cc, UmaUtil.getMethodPlugin((EObject)cc));
        return collection;
    }

    private static void collectExclusiveSubCustomCategories(Collection collection, CustomCategory cc, MethodPlugin plugin) {
        for (Object e : cc.getCategorizedElements()) {
            CustomCategory sub;
            if (!(e instanceof CustomCategory) || !TngUtil.isInPluginWithLessThanOneSuperCustomCategory(sub = (CustomCategory)e, plugin)) continue;
            collection.add(e);
            TngUtil.collectExclusiveSubCustomCategories(collection, sub, plugin);
        }
    }

    public static Object getAdapterByType(Notifier notifier, Object type) {
        for (Adapter adapter : notifier.eAdapters()) {
            if (!adapter.isAdapterForType(type)) continue;
            return adapter;
        }
        return null;
    }

    public static Map removeReferences(MethodElement element) {
        return TngUtil.removeReferences(element, false);
    }

    public static Map removeReferences(MethodElement element, boolean checkModify) {
        HashMap<EObject, ArrayList<EStructuralFeature>> objectFeaturesMap = new HashMap<EObject, ArrayList<EStructuralFeature>>();
        MultiResourceEObject eObj = (MultiResourceEObject)element;
        if (eObj.basicGetOppositeFeatureMap() == null) {
            return objectFeaturesMap;
        }
        for (Map.Entry entry : eObj.getOppositeFeatureMap().entrySet()) {
            ArrayList<EStructuralFeature> features;
            EObject obj;
            ArrayList<EStructuralFeature> features2;
            OppositeFeature oppositeFeature = (OppositeFeature)entry.getKey();
            EStructuralFeature feature = oppositeFeature.getTargetFeature();
            if (feature.isMany()) {
                if (oppositeFeature.isMany()) {
                    for (EObject obj2 : new ArrayList((Collection)eObj.getOppositeFeatureValue(oppositeFeature))) {
                        if (checkModify) {
                            TngUtil.checkModify(obj2);
                        }
                        ((List)obj2.eGet(feature)).remove(element);
                        features2 = (List)objectFeaturesMap.get(obj2);
                        if (features2 == null) {
                            features2 = new ArrayList();
                            objectFeaturesMap.put(obj2, features2);
                        }
                        features2.add(feature);
                    }
                    continue;
                }
                obj = (EObject)eObj.getOppositeFeatureValue(oppositeFeature);
                if (obj == null) continue;
                if (checkModify) {
                    TngUtil.checkModify(obj);
                }
                ((List)obj.eGet(feature)).remove(element);
                features = (List)objectFeaturesMap.get(obj);
                if (features == null) {
                    features = new ArrayList();
                    objectFeaturesMap.put(obj, features);
                }
                features.add(feature);
                continue;
            }
            if (oppositeFeature.isMany()) {
                for (EObject obj2 : new ArrayList((Collection)eObj.getOppositeFeatureValue(oppositeFeature))) {
                    if (checkModify) {
                        TngUtil.checkModify(obj2);
                    }
                    obj2.eSet(feature, null);
                    features2 = (ArrayList<EStructuralFeature>)objectFeaturesMap.get(obj2);
                    if (features2 == null) {
                        features2 = new ArrayList<EStructuralFeature>();
                        objectFeaturesMap.put(obj2, features2);
                    }
                    features2.add(feature);
                }
                continue;
            }
            obj = (EObject)eObj.getOppositeFeatureValue(oppositeFeature);
            if (obj == null) continue;
            if (checkModify) {
                TngUtil.checkModify(obj);
            }
            obj.eSet(feature, null);
            features = (ArrayList<EStructuralFeature>)objectFeaturesMap.get(obj);
            if (features == null) {
                features = new ArrayList<EStructuralFeature>();
                objectFeaturesMap.put(obj, features);
            }
            features.add(feature);
        }
        return objectFeaturesMap;
    }

    public static MethodElementProperty getPublishCategoryProperty(MethodElement element) {
        List props = element.getMethodElementProperty();
        if (props == null || props.size() == 0) {
            return null;
        }
        for (MethodElementProperty prop : props) {
            if (!PUBLISH_CATEGORY_PROPERTY.equals(prop.getName())) continue;
            return prop;
        }
        return null;
    }

    public static List<INotifyChangedListener> getNotifyChangedListeners(AdapterFactory adapterFactory, Object obj) {
        Object adapter = adapterFactory.adapt(obj, ITreeItemContentProvider.class);
        if (adapter instanceof IListenerProvider) {
            return ((IListenerProvider)adapter).getNotifyChangedListeners();
        }
        return Collections.emptyList();
    }

    public static Collection<?> getWrappers(AdapterFactory adapterFactory, Object obj) {
        HashSet<INotifyChangedListener> wrappers = new HashSet<INotifyChangedListener>();
        for (INotifyChangedListener listener : TngUtil.getNotifyChangedListeners(adapterFactory, obj)) {
            if (!(listener instanceof IWrapperItemProvider) || TngUtil.unwrap(listener) != obj) continue;
            wrappers.add(listener);
        }
        return wrappers;
    }

    public static FeatureValueWrapperItemProvider getWrapper(Collection wrappers, Object value) {
        if (wrappers == null) {
            return null;
        }
        for (Object listener : wrappers) {
            if (!(listener instanceof FeatureValueWrapperItemProvider) || TngUtil.unwrap(listener) != value) continue;
            return (FeatureValueWrapperItemProvider)listener;
        }
        return null;
    }

    public static Object getFeatureValueWrapperItemProviderForCC(AdapterFactory adapterFactory, CustomCategory cc) {
        CustomCategoryItemProvider adapter = (CustomCategoryItemProvider)adapterFactory.adapt((Notifier)cc, ITreeItemContentProvider.class);
        for (INotifyChangedListener listener : adapter.getNotifyChangedListeners()) {
            if (!(listener instanceof FeatureValueWrapperItemProvider) || TngUtil.unwrap(listener) != cc) continue;
            return (FeatureValueWrapperItemProvider)listener;
        }
        return cc;
    }

    public static class PresentationNameHelper {
        public String getPresentationName(MethodElement element) {
            return element.getPresentationName();
        }
    }
}

