/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.epf.library.edit.command.IActionManager;
import org.eclipse.epf.library.edit.util.ConstraintManager;
import org.eclipse.epf.library.edit.util.LibraryEditUtil;
import org.eclipse.epf.library.edit.util.MethodElementPropUtil;
import org.eclipse.epf.library.edit.util.MethodPluginPropUtil;
import org.eclipse.epf.library.edit.util.PropUtil;
import org.eclipse.epf.uma.Constraint;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.Milestone;
import org.eclipse.epf.uma.TaskDescriptor;
import org.eclipse.epf.uma.VariabilityElement;
import org.eclipse.epf.uma.WorkBreakdownElement;
import org.eclipse.epf.uma.WorkProduct;
import org.eclipse.epf.uma.WorkProductDescriptor;
import org.eclipse.epf.uma.util.UmaUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkProductPropUtil
extends PropUtil {
    public static final String WORKPRODUCT_States = "Workproduct_states";
    private static WorkProductPropUtil workProductPropUtil = new WorkProductPropUtil();

    public static WorkProductPropUtil getWorkProductPropUtil() {
        return workProductPropUtil;
    }

    public static WorkProductPropUtil getWorkProductPropUtil(IActionManager actionManager) {
        return new WorkProductPropUtil(actionManager);
    }

    protected WorkProductPropUtil() {
    }

    protected WorkProductPropUtil(IActionManager actionManager) {
        super(actionManager);
    }

    public Set<Constraint> getAllStates(WorkProduct wp) {
        Set<? extends VariabilityElement> wpSet = LibraryEditUtil.getInstance().collectVariabilityRelatives((VariabilityElement)wp);
        HashSet<Constraint> stateSet = new HashSet<Constraint>();
        for (WorkProduct workProduct : wpSet) {
            List<Constraint> stateList = this.getWorkProductStates(workProduct);
            stateSet.addAll(stateList);
        }
        return stateSet;
    }

    private Constraint getState(WorkProduct wp, String stateName, boolean create) {
        return ConstraintManager.getWorkProductState(wp, stateName, create, this.getActionManager());
    }

    public String getStateName(Constraint state) {
        if (state != null && state.getName().equals("wpState")) {
            return state.getBody();
        }
        return null;
    }

    public List<Constraint> getWorkProductStates(WorkProduct wp) {
        ArrayList<Constraint> list = new ArrayList<Constraint>();
        String propValue = this.getStringValue((MethodElement)wp, WORKPRODUCT_States);
        if (propValue == null) {
            return list;
        }
        String[] guidList = propValue.split("/");
        if (guidList == null || guidList.length == 0) {
            return list;
        }
        MethodPlugin plugin = UmaUtil.getMethodPlugin((EObject)wp);
        if (plugin == null) {
            return list;
        }
        HashSet<Constraint> statesInPlugin = new HashSet<Constraint>();
        List<Constraint> stateListInPlugin = MethodPluginPropUtil.getMethodPluginPropUtil().getWorkProductStatesInPlugin(plugin);
        if (stateListInPlugin.isEmpty()) {
            return list;
        }
        statesInPlugin.addAll(stateListInPlugin);
        boolean modified = false;
        String newValue = "";
        String[] stringArray = guidList;
        int n = guidList.length;
        int n2 = 0;
        while (n2 < n) {
            String guid = stringArray[n2];
            MethodElement element = LibraryEditUtil.getInstance().getMethodElement(guid);
            if (element instanceof Constraint && statesInPlugin.contains(element)) {
                Constraint c = (Constraint)element;
                if (c.getName().equals("wpState")) {
                    list.add(c);
                    MethodElementPropUtil.getMethodElementPropUtil().addToAssignedToWps(wp, c);
                }
                if (newValue.length() > 0) {
                    newValue = newValue.concat("/");
                }
                newValue = newValue.concat(c.getGuid());
            } else {
                modified = true;
            }
            ++n2;
        }
        if (modified) {
            this.setStringValue((MethodElement)wp, WORKPRODUCT_States, newValue);
        }
        return list;
    }

    public void addWorkProductState(WorkProduct wp, Constraint srcState) {
        Constraint tgtState = this.addWorkProductState_(wp, srcState);
        MethodElementPropUtil.getMethodElementPropUtil().addToAssignedToWps(wp, tgtState);
    }

    private Constraint addWorkProductState_(WorkProduct wp, Constraint srcState) {
        String[] guidList;
        String stateName = srcState.getBody();
        String oldValue = this.getStringValue((MethodElement)wp, WORKPRODUCT_States);
        if (oldValue == null || oldValue.trim().length() == 0) {
            Constraint state = this.getState(wp, stateName, true);
            this.copyDescription(srcState, state);
            this.setStringValue((MethodElement)wp, WORKPRODUCT_States, state.getGuid());
            return state;
        }
        String[] stringArray = guidList = oldValue.split("/");
        int n = guidList.length;
        int n2 = 0;
        while (n2 < n) {
            Constraint c;
            String guid = stringArray[n2];
            MethodElement element = LibraryEditUtil.getInstance().getMethodElement(guid);
            if (element instanceof Constraint && (c = (Constraint)element).getName().equals("wpState") && c.getBody().equals(stateName)) {
                return c;
            }
            ++n2;
        }
        Constraint state = this.getState(wp, stateName, true);
        this.copyDescription(srcState, state);
        String newValue = oldValue.concat("/").concat(state.getGuid());
        this.setStringValue((MethodElement)wp, WORKPRODUCT_States, newValue);
        return state;
    }

    private void copyDescription(Constraint srcState, Constraint tgtState) {
        if (tgtState == srcState) {
            return;
        }
        tgtState.setBriefDescription(srcState.getBriefDescription());
    }

    public void removeWorkProductState(WorkProduct wp, String stateName) {
        Constraint state = this.removeWorkProductState_(wp, stateName);
        if (state != null) {
            MethodElementPropUtil.getMethodElementPropUtil().removeFromAssignedToWps(wp, state);
        }
    }

    private Constraint removeWorkProductState_(WorkProduct wp, String stateName) {
        String[] guidList;
        String oldValue = this.getStringValue((MethodElement)wp, WORKPRODUCT_States);
        if (oldValue == null || oldValue.trim().length() == 0) {
            return null;
        }
        Constraint state = null;
        boolean modified = false;
        String newValue = "";
        String[] stringArray = guidList = oldValue.split("/");
        int n = guidList.length;
        int n2 = 0;
        while (n2 < n) {
            Constraint c;
            String guid = stringArray[n2];
            MethodElement element = LibraryEditUtil.getInstance().getMethodElement(guid);
            if (element instanceof Constraint && (c = (Constraint)element).getName().equals("wpState")) {
                if (c.getBody().equals(stateName)) {
                    state = c;
                    modified = true;
                } else {
                    if (newValue.length() > 0) {
                        newValue = newValue.concat("/");
                    }
                    newValue = newValue.concat(c.getGuid());
                }
            }
            ++n2;
        }
        if (modified) {
            this.setStringValue((MethodElement)wp, WORKPRODUCT_States, newValue);
        }
        return state;
    }

    public void fixWorkProductStates(WorkProduct wp, Set<Resource> modifeiedResources) {
        String propValue = this.getStringValue((MethodElement)wp, WORKPRODUCT_States);
        if (propValue == null) {
            return;
        }
        String[] guidList = propValue.split("/");
        if (guidList == null || guidList.length == 0) {
            return;
        }
        MethodPlugin plugin = UmaUtil.getMethodPlugin((EObject)wp);
        if (plugin == null) {
            return;
        }
        HashSet<Constraint> statesInPlugin = new HashSet<Constraint>();
        List<Constraint> stateListInPlugin = MethodPluginPropUtil.getMethodPluginPropUtil().getWorkProductStatesInPlugin(plugin);
        statesInPlugin.addAll(stateListInPlugin);
        boolean modified = false;
        String newValue = "";
        String[] stringArray = guidList;
        int n = guidList.length;
        int n2 = 0;
        while (n2 < n) {
            String guid = stringArray[n2];
            MethodElement element = LibraryEditUtil.getInstance().getMethodElement(guid);
            if (element instanceof Constraint) {
                Constraint c = (Constraint)element;
                if (statesInPlugin.contains(element)) {
                    if (c.getName().equals("wpState")) {
                        MethodElementPropUtil.getMethodElementPropUtil().addToAssignedToWps(wp, c);
                    }
                    if (newValue.length() > 0) {
                        newValue = newValue.concat("/");
                    }
                    newValue = newValue.concat(c.getGuid());
                } else {
                    Constraint copyState = MethodPluginPropUtil.getMethodPluginPropUtil().getWorkProductState(plugin, c.getBody(), false);
                    if (copyState == null) {
                        copyState = MethodPluginPropUtil.getMethodPluginPropUtil().getWorkProductState(plugin, c.getBody(), true);
                        copyState.setBriefDescription(c.getBriefDescription());
                    }
                    if (newValue.length() > 0) {
                        newValue = newValue.concat("/");
                    }
                    newValue = newValue.concat(copyState.getGuid());
                    modified = true;
                }
            } else {
                modified = true;
            }
            ++n2;
        }
        if (modified) {
            this.setStringValue((MethodElement)wp, WORKPRODUCT_States, newValue);
            if (wp.eResource() != null) {
                modifeiedResources.add(wp.eResource());
            }
            if (plugin.eResource() != null) {
                modifeiedResources.add(plugin.eResource());
            }
        }
    }

    public static void fixProcessWpStates(Object element, Set<Resource> modifeiedResources) {
        if (!(element instanceof TaskDescriptor) && !(element instanceof Milestone)) {
            return;
        }
        WorkBreakdownElement wbe = (WorkBreakdownElement)element;
        for (Constraint constraint : wbe.getOwnedRules()) {
            MethodElement e;
            if (!constraint.getName().equals("wpStates") || !((e = LibraryEditUtil.getInstance().getMethodElement(constraint.getBody())) instanceof WorkProductDescriptor)) continue;
            WorkProductPropUtil.fixProcessWorkProductStates(constraint, (WorkProductDescriptor)e, modifeiedResources);
        }
    }

    private static void fixProcessWorkProductStates(Constraint propertyOwner, WorkProductDescriptor wpd, Set<Resource> modifeiedResources) {
        if (propertyOwner == null || wpd == null || wpd.getWorkProduct() == null) {
            return;
        }
        WorkProduct wp = wpd.getWorkProduct();
        String propName = "constraint_wpStates";
        MethodElementPropUtil methodElementPropUtil = MethodElementPropUtil.getMethodElementPropUtil();
        String value = methodElementPropUtil.getStringValue((MethodElement)propertyOwner, propName);
        if (value == null || value.length() == 0) {
            return;
        }
        String[] infos = value.split("/");
        if (infos == null || infos.length == 0) {
            return;
        }
        MethodPlugin plugin = UmaUtil.getMethodPlugin((EObject)wp);
        if (plugin == null) {
            return;
        }
        boolean modified = false;
        String newValue = "";
        int sz = infos.length / 2;
        int i = 0;
        while (i < sz) {
            int i1 = i * 2;
            int i2 = i1 + 1;
            String iGuid = infos[i1];
            String iRefName = infos[i2];
            MethodElement element = LibraryEditUtil.getInstance().getMethodElement(iGuid);
            if (element instanceof Constraint) {
                Constraint c = (Constraint)element;
                Constraint copyState = MethodPluginPropUtil.getMethodPluginPropUtil().getWorkProductState(plugin, c.getBody(), false);
                if (copyState != null) {
                    if (copyState != c) {
                        iGuid = copyState.getGuid();
                        modified = true;
                    }
                    if (newValue.length() > 0) {
                        newValue = newValue.concat("/");
                    }
                    newValue = newValue.concat(iGuid.concat("/").concat(iRefName));
                } else {
                    modified = true;
                }
            } else {
                modified = true;
            }
            ++i;
        }
        if (modified) {
            methodElementPropUtil.setStringValue((MethodElement)propertyOwner, propName, newValue);
            if (propertyOwner.eResource() != null) {
                modifeiedResources.add(propertyOwner.eResource());
            }
        }
    }
}

