/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.util;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.provider.DelegatingWrapperItemProvider;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IWrapperItemProvider;

public class WrapperManager
implements IDisposable {
    private HashMap valueToWrapperMap;
    private AdapterFactory adapterFactory;

    public WrapperManager(AdapterFactory adapterFactory) {
        this.adapterFactory = adapterFactory;
    }

    public Object getWrapper(Object value) {
        if (this.valueToWrapperMap != null) {
            return this.valueToWrapperMap.get(value);
        }
        return null;
    }

    public Collection getWrappers() {
        if (this.valueToWrapperMap != null) {
            return this.valueToWrapperMap.values();
        }
        return Collections.EMPTY_LIST;
    }

    protected IWrapperItemProvider createWrapper(Object value, Object owner, AdapterFactory adapterFactory) {
        return new DelegatingWrapperItemProvider(value, owner, null, -1, adapterFactory);
    }

    public void update(Collection delegateValues) {
        IWrapperItemProvider wrapper;
        Set oldDelegateValues;
        boolean changed = false;
        Set set = oldDelegateValues = delegateValues != null ? new HashSet(delegateValues) : Collections.EMPTY_SET;
        if (this.valueToWrapperMap == null && !delegateValues.isEmpty()) {
            this.valueToWrapperMap = new HashMap();
        }
        for (Object child : delegateValues) {
            if (!this.valueToWrapperMap.containsKey(child)) {
                wrapper = this.createWrapper(child, this, this.adapterFactory);
                this.valueToWrapperMap.put(child, wrapper);
                changed = true;
            }
            oldDelegateValues.remove(child);
        }
        if (!oldDelegateValues.isEmpty()) {
            changed = true;
            for (Object child : oldDelegateValues) {
                wrapper = (IWrapperItemProvider)this.valueToWrapperMap.remove(child);
                if (wrapper == null) continue;
                wrapper.dispose();
            }
        }
        if (changed) {
            int index = 0;
            Iterator i = delegateValues.iterator();
            while (i.hasNext()) {
                ((IWrapperItemProvider)this.valueToWrapperMap.get(i.next())).setIndex(index);
                ++index;
            }
        }
    }

    public void dispose() {
        if (this.valueToWrapperMap != null) {
            Iterator i = this.valueToWrapperMap.values().iterator();
            while (i.hasNext()) {
                ((IDisposable)i.next()).dispose();
            }
            this.valueToWrapperMap.clear();
            this.valueToWrapperMap = null;
        }
    }
}

