/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.util;

import java.util.Collection;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.epf.common.utils.XMLUtil;
import org.eclipse.epf.library.edit.util.LibraryEditUtil;
import org.eclipse.epf.library.edit.util.MethodElementPropUtil;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.util.MeList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlEditUtil {
    private MethodElementPropUtil propUtil;
    private Document doc;
    public static UnresolvedGuidHandler uHandler = new UnresolvedGuidHandler();

    public MethodElementPropUtil getPropUtil() {
        return this.propUtil;
    }

    public XmlEditUtil(MethodElementPropUtil propUtil) {
        this.propUtil = propUtil;
    }

    protected Document getDocument() throws Exception {
        if (this.doc == null) {
            this.doc = XMLUtil.createDocument();
        }
        return this.doc;
    }

    protected Element loadDocumentAndGetFirstElement(String xmlString) throws Exception {
        if (xmlString == null) {
            return null;
        }
        this.doc = XMLUtil.loadXml((String)xmlString);
        Node node = this.doc.getFirstChild();
        return node instanceof Element ? (Element)node : null;
    }

    protected Element createFirstElement(String name) throws Exception {
        Element element = this.getDocument().createElement(name);
        this.getDocument().appendChild(element);
        return element;
    }

    protected void storeToOwner(MethodElement owner, String propName) throws Exception {
        String value = XMLUtil.toXmlString((Document)this.doc);
        this.propUtil.setStringValue(owner, propName, value);
    }

    public static String convertToGuidsString(Collection<? extends MethodElement> elements) {
        String value = "";
        if (elements == null || elements.isEmpty()) {
            return value;
        }
        for (MethodElement methodElement : elements) {
            if (value.length() > 0) {
                value = String.valueOf(value) + "/";
            }
            value = String.valueOf(value) + methodElement.getGuid();
        }
        return value;
    }

    public static MeList convertToMethodElements(String guidsString, EClass type) {
        return XmlEditUtil.convertToMethodElements(guidsString, type, uHandler);
    }

    public static MeList convertToMethodElements(String guidsString, EClass type, UnresolvedGuidHandler uHandler) {
        return XmlEditUtil.convertToMethodElements(guidsString, type, uHandler, null);
    }

    public static MeList convertToMethodElements(String guidsString, EClass type, UnresolvedGuidHandler uHandler, Set<MethodElement> validSet) {
        MeList list = new MeList();
        if (guidsString == null || guidsString.length() == 0) {
            return list;
        }
        String[] guids = guidsString.split("/");
        if (guids == null || guids.length == 0) {
            return list;
        }
        boolean hasUnresolved = false;
        String[] stringArray = guids;
        int n = guids.length;
        int n2 = 0;
        while (n2 < n) {
            String guid = stringArray[n2];
            MethodElement element = LibraryEditUtil.getInstance().getMethodElement(guid);
            if (element == null && uHandler != null && (element = uHandler.getElement(guid)) != null) {
                hasUnresolved = true;
            }
            if (element != null && (type == null || type.isSuperTypeOf(element.eClass())) && (validSet == null || validSet.contains(element))) {
                list.add((Object)element);
            }
            ++n2;
        }
        if (hasUnresolved) {
            list.setHasUnresolved(true);
        }
        return list;
    }

    protected Integer getIntValue(Element element, String attName) {
        String value = element.getAttribute(attName);
        if (value == null || value.length() == 0) {
            return null;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected void addClonedElement(Element parent, Element elementToClone) throws Exception {
        if (elementToClone == null) {
            return;
        }
        Node node = XMLUtil.cloneNode((Node)elementToClone, (Document)this.getDocument());
        parent.appendChild(node);
    }

    public static class UnresolvedGuidHandler {
        public MethodElement getElement(String guid) {
            return null;
        }

        public boolean hasUnresolvedElement() {
            return false;
        }
    }
}

