/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.validation;

import org.eclipse.epf.library.edit.validation.DependencyInfoMgr;
import org.eclipse.epf.library.edit.validation.IDependencyInfo;
import org.eclipse.epf.uma.VariabilityElement;

public class CircularDependencyCheck {
    private DependencyInfoMgr depInfoMgr;
    private IDependencyInfo veInfo;
    private boolean move = false;

    public CircularDependencyCheck(DependencyInfoMgr mgr, VariabilityElement ve, boolean filter, boolean move) {
        this.depInfoMgr = mgr;
        this.veInfo = this.depInfoMgr.registerVariabilityElement(ve, filter, false);
        this.move = move;
    }

    protected DependencyInfoMgr getDepInfoMgr() {
        return this.depInfoMgr;
    }

    protected IDependencyInfo getVeInfo() {
        return this.veInfo;
    }

    public boolean accept(Object obj) {
        if (this.reachable(obj, true, true)) {
            return false;
        }
        if (this.move) {
            IDependencyInfo info;
            if (!(obj instanceof VariabilityElement)) {
                return true;
            }
            VariabilityElement objVeBase = ((VariabilityElement)obj).getVariabilityBasedOnElement();
            if (objVeBase != null && (info = this.depInfoMgr.registerVariabilityElement(objVeBase, false, false)).reachableBy(this.veInfo)) {
                return false;
            }
        }
        return true;
    }

    private boolean reachable(Object obj, boolean checkReachableByObj, boolean checkReachableToObj) {
        if (!(obj instanceof VariabilityElement)) {
            return false;
        }
        VariabilityElement ve = (VariabilityElement)this.veInfo.getElement();
        if (ve == obj) {
            return true;
        }
        IDependencyInfo objVeInfo = this.depInfoMgr.registerVariabilityElement((VariabilityElement)obj, false, this.move);
        if (checkReachableByObj && this.veInfo.reachableBy(objVeInfo)) {
            return true;
        }
        return checkReachableToObj && objVeInfo.reachableBy(this.veInfo);
    }

    public boolean reachableBy(Object obj) {
        return this.reachable(obj, true, false);
    }

    public boolean reachableTo(Object obj) {
        return this.reachable(obj, false, true);
    }
}

