/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.validation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.epf.common.utils.ProfilingUtil;
import org.eclipse.epf.library.edit.LibraryEditPlugin;
import org.eclipse.epf.library.edit.LibraryEditResources;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.edit.validation.IDependencyInfo;
import org.eclipse.epf.library.edit.validation.Tracer;
import org.eclipse.epf.library.edit.validation.UpwardReachableInfo;
import org.eclipse.epf.library.edit.validation.ValidationStatus;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.Artifact;
import org.eclipse.epf.uma.CustomCategory;
import org.eclipse.epf.uma.Deliverable;
import org.eclipse.epf.uma.Domain;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.Practice;
import org.eclipse.epf.uma.VariabilityElement;
import org.eclipse.epf.uma.VariabilityType;

public class DependencyInfoMgr {
    private static boolean profiling = false;
    private static boolean debug = false;
    private MethodLibrary lib;
    private Map reachableInfoMap;
    private Map replacerMap;
    private Map processed;
    private MethodElement filterElement;
    private MethodElement moveElement;
    private List circularList;
    private boolean dndBit = false;

    public DependencyInfoMgr(MethodLibrary lib) {
        this.lib = lib;
    }

    public void logCircularDependency(Stack trace) {
        if (this.circularList == null) {
            this.circularList = new ArrayList();
        }
        this.circularList.addAll(trace);
    }

    private List getAndClearCircularList() {
        List ret = this.circularList;
        this.circularList = null;
        return ret;
    }

    public boolean isFilterElement(MethodElement elem) {
        return this.filterElement == elem;
    }

    public boolean isMoveElement(MethodElement elem) {
        return this.moveElement == elem;
    }

    private void log(String msg) {
        LibraryEditPlugin.INSTANCE.log(msg);
    }

    public IStatus checkCircularDependnecy(VariabilityElement ve) {
        if (debug) {
            System.out.println("LD> ve: " + TngUtil.getLabelWithPath(ve));
        }
        IDependencyInfo info = this.registerVariabilityElement(ve, false, false, true);
        List cirList = this.getAndClearCircularList();
        boolean loop = cirList != null && !cirList.isEmpty();
        boolean replacingAncestor = info.inheritAncestor(VariabilityType.REPLACES);
        boolean actInherentingAncestor = this.getActInerentingAncestor(ve);
        MultiStatus multiStatus = new MultiStatus("org.eclipse.epf.library.edit", 0, "", null);
        if (loop) {
            this.log("Error> Circular dependency detected: ");
            int i = 0;
            while (i < cirList.size()) {
                IDependencyInfo loopInfo = (IDependencyInfo)cirList.get(i);
                MethodElement elem = loopInfo.getElement();
                this.log("Error> " + i + ": " + TngUtil.getLabelWithPath(elem));
                ++i;
            }
            multiStatus.add((IStatus)new ValidationStatus(4, 0, this.genErrorMsg(cirList), ve, null));
        }
        if (replacingAncestor) {
            MethodElement elem = info.getElement();
            this.log("Error> " + TngUtil.getLabelWithPath(elem) + " is replacing an ancestor.");
            multiStatus.add((IStatus)new ValidationStatus(4, 0, LibraryEditResources.replacing_ancestor_error_msg, ve, null));
        }
        if (actInherentingAncestor) {
            info.getElement();
            multiStatus.add((IStatus)new ValidationStatus(4, 0, LibraryEditResources.circular_dependency_error_msg, ve, null));
        }
        return multiStatus;
    }

    private boolean getActInerentingAncestor(VariabilityElement ve) {
        Activity base;
        if (ve instanceof Activity && (base = (Activity)ve.getVariabilityBasedOnElement()) != null) {
            Activity act = ((Activity)ve).getSuperActivities();
            while (act != null) {
                if (act == base) {
                    return true;
                }
                act = act.getSuperActivities();
            }
        }
        return false;
    }

    private String genErrorMsg(List cirList) {
        String msg = LibraryEditResources.variability_element_circular_loop_error_msg;
        int i = 0;
        while (i < cirList.size()) {
            IDependencyInfo loopInfo = (IDependencyInfo)cirList.get(i);
            MethodElement elem = loopInfo.getElement();
            if (i > 0) {
                msg = String.valueOf(msg) + ": ";
            }
            msg = String.valueOf(msg) + TngUtil.getLabelWithPath(elem);
            ++i;
        }
        return msg;
    }

    public IDependencyInfo registerVariabilityElement(VariabilityElement ve, boolean isFilterElement, boolean isMoveElement) {
        return this.registerVariabilityElement(ve, isFilterElement, isMoveElement, false);
    }

    private IDependencyInfo registerVariabilityElement(VariabilityElement ve, boolean isFilterElement, boolean isMoveElement, boolean checkCircular) {
        IDependencyInfo info;
        if (isFilterElement) {
            this.filterElement = ve;
        }
        if (isMoveElement) {
            this.moveElement = ve;
        }
        if ((info = this.getProcessedInfo((MethodElement)ve)) == null) {
            info = this.newDependencyInfo(this, (MethodElement)ve);
        }
        if (!info.isComplete()) {
            info.build(checkCircular);
        }
        return info;
    }

    protected boolean processed(MethodElement element) {
        return this.processed != null && this.processed.containsKey(element.getGuid());
    }

    protected IDependencyInfo getProcessedInfo(MethodElement element) {
        return this.processed == null ? null : (IDependencyInfo)this.processed.get(element.getGuid());
    }

    protected void addToProcessed(IDependencyInfo info) {
        if (this.processed == null) {
            this.processed = new HashMap();
        }
        this.processed.put(info.getElement().getGuid(), info);
    }

    protected void addToReplacerMap(IDependencyInfo replacerInfo) {
        if (this.replacerMap == null) {
            this.replacerMap = new HashMap();
        }
        this.replacerMap.put(replacerInfo.getElement().getGuid(), replacerInfo);
    }

    private IDependencyInfo addToReachableInfoMap(MethodElement elem) {
        IDependencyInfo info;
        if (this.reachableInfoMap == null) {
            this.reachableInfoMap = new HashMap();
        }
        if ((info = (IDependencyInfo)this.reachableInfoMap.get(elem.getGuid())) == null) {
            info = this.newDependencyInfo(this, elem);
            this.reachableInfoMap.put(elem.getGuid(), info);
        }
        return info;
    }

    public boolean hasCircularDependency() {
        this.buildReachableInfoMap();
        boolean replacingAcestor = false;
        if (this.replacerMap != null) {
            for (UpwardReachableInfo info : this.replacerMap.values()) {
                if (!info.inheritAncestor(VariabilityType.REPLACES)) continue;
                replacingAcestor = true;
            }
        }
        if (debug && this.circularList != null) {
            System.out.println("LD> Circular loops detected: ");
            for (Stack stack : this.circularList) {
                int i = 0;
                while (i < stack.size()) {
                    System.out.println("LD> " + i + ": " + stack.get(i));
                    ++i;
                }
            }
        }
        return replacingAcestor || this.numCircularDependency() > 0;
    }

    private int numCircularDependency() {
        return this.circularList == null ? 0 : this.circularList.size();
    }

    protected IDependencyInfo newDependencyInfo(DependencyInfoMgr mgr, MethodElement elem) {
        return new UpwardReachableInfo(this, elem);
    }

    private void buildReachableInfoMap() {
        long usedMem0 = 0L;
        Runtime rt = Runtime.getRuntime();
        if (profiling) {
            TreeIterator it = this.lib.eAllContents();
            while (it.hasNext()) {
                it.next();
            }
            ProfilingUtil.fullGC();
            usedMem0 = rt.totalMemory() - rt.freeMemory();
        }
        this.buildReachableInfoMap_();
        if (profiling) {
            ProfilingUtil.fullGC();
            System.out.println("LD> usedMem0: " + usedMem0 / 1000L + " k bytes");
            long usedMem1 = rt.totalMemory() - rt.freeMemory();
            System.out.println("LD> usedMem1: " + usedMem1 / 1000L + " k bytes");
            System.out.println("LD> diffMem: " + (usedMem1 - usedMem0) / 1000L + " k bytes");
        }
    }

    private void buildReachableInfoMap_() {
        this.reachableInfoMap = new HashMap();
        List plugins = this.lib.getMethodPlugins();
        int i = 0;
        while (i < plugins.size()) {
            MethodPlugin plugin = (MethodPlugin)plugins.get(i);
            TreeIterator it = plugin.eAllContents();
            while (it.hasNext()) {
                Object obj = it.next();
                if (!DependencyInfoMgr.VeToCheck(obj)) continue;
                this.addToReachableInfoMap((MethodElement)obj);
            }
            ++i;
        }
        for (IDependencyInfo info : this.reachableInfoMap.values()) {
            if (this.processed(info.getElement())) continue;
            info.build(true);
        }
    }

    public static boolean VeToCheck(Object obj) {
        return obj instanceof Domain || obj instanceof CustomCategory || obj instanceof Artifact || obj instanceof Practice || obj instanceof Deliverable || obj instanceof Activity;
    }

    public CheckResult checkCircularDependnecy(Tracer tracer) {
        long usedMem0 = 0L;
        Runtime rt = Runtime.getRuntime();
        if (profiling) {
            TreeIterator it = this.lib.eAllContents();
            while (it.hasNext()) {
                it.next();
            }
            ProfilingUtil.fullGC();
            usedMem0 = rt.totalMemory() - rt.freeMemory();
        }
        CheckResult result = this.checkCircularDependnecy_(tracer);
        if (profiling) {
            ProfilingUtil.fullGC();
            System.out.println("LD> usedMem0: " + usedMem0 / 1000L + " k bytes");
            long usedMem1 = rt.totalMemory() - rt.freeMemory();
            System.out.println("LD> usedMem1: " + usedMem1 / 1000L + " k bytes");
            System.out.println("LD> diffMem: " + (usedMem1 - usedMem0) / 1000L + " k bytes");
        }
        return result;
    }

    private CheckResult checkCircularDependnecy_(Tracer tracer) {
        CheckResult result = new CheckResult();
        HashSet seen = new HashSet();
        List plugins = this.lib.getMethodPlugins();
        for (MethodPlugin plugin : plugins) {
            TreeIterator iit = plugin.eAllContents();
            while (iit.hasNext()) {
                Object obj = iit.next();
                if (seen.contains(obj)) continue;
                seen.add(obj);
                if (!DependencyInfoMgr.VeToCheck(obj)) continue;
                IDependencyInfo info = this.registerVariabilityElement((VariabilityElement)obj, false, false, true);
                List cirList = this.getAndClearCircularList();
                boolean loop = cirList != null && !cirList.isEmpty();
                boolean replacingAncestor = info.inheritAncestor(VariabilityType.REPLACES);
                if (loop) {
                    tracer.trace("Error> Circular dependency detected: ");
                    int i = 0;
                    while (i < cirList.size()) {
                        IDependencyInfo loopInfo = (IDependencyInfo)cirList.get(i);
                        MethodElement elem = loopInfo.getElement();
                        tracer.trace("Error> " + i + ": " + TngUtil.getLabelWithPath(elem));
                        ++i;
                    }
                    result.circularList.add(cirList);
                }
                if (!replacingAncestor) continue;
                MethodElement elem = info.getElement();
                tracer.trace("Error> " + TngUtil.getLabelWithPath(elem) + " is replacing an ancestor.");
                result.replacingAncestorList.add(info);
            }
        }
        return result;
    }

    protected boolean isDndElement(MethodElement elem) {
        return this.dndBit && this.moveElement == elem;
    }

    protected void setDndBit(boolean b) {
        this.dndBit = b;
    }

    public static class CheckResult {
        public List circularList = new ArrayList();
        public List replacingAncestorList = new ArrayList();

        public int getErrorCount() {
            return this.circularList.size() + this.replacingAncestorList.size();
        }

        public int getCircularElementCount() {
            int count = this.replacingAncestorList.size();
            int i = 0;
            while (i < this.circularList.size()) {
                List list = (List)this.circularList.get(i);
                int sz = list == null ? 0 : list.size();
                count += sz;
                ++i;
            }
            return count;
        }
    }
}

