/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.validation;

import java.util.Collection;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.provider.AdapterFactoryTreeIterator;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.epf.common.utils.StrUtil;
import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.library.edit.LibraryEditResources;
import org.eclipse.epf.library.edit.process.BSActivityItemProvider;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.library.edit.util.Suppression;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.edit.validation.INameProvider;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.CapabilityPattern;
import org.eclipse.epf.uma.DescribableElement;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.NamedElement;
import org.eclipse.epf.uma.Role;
import org.eclipse.epf.uma.RoleDescriptor;
import org.eclipse.epf.uma.TaskDescriptor;
import org.eclipse.epf.uma.TeamProfile;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.VariabilityElement;
import org.eclipse.epf.uma.VariabilityType;
import org.eclipse.epf.uma.WorkProductDescriptor;
import org.eclipse.osgi.util.NLS;

public final class NameChecker {
    private static final String ELEMENT_TEXT = LibraryEditResources.element_text;
    private static final INameProvider presentationNameProvider = new INameProvider(){

        public String getName(Object object) {
            if (object instanceof BreakdownElement) {
                return ProcessUtil.getPresentationName((BreakdownElement)object);
            }
            if (object instanceof DescribableElement) {
                return ((DescribableElement)object).getPresentationName();
            }
            return null;
        }
    };

    private static String checkName(AdapterFactory adapterFactory, Object parent, Object e, final Class type, INameProvider nameProvider, String newName, Suppression suppresion, boolean ignoreSuppressed) {
        IFilter childFilter = new IFilter(){

            public boolean accept(Object obj) {
                return type.isInstance(obj);
            }
        };
        return NameChecker.checkName(adapterFactory, parent, e, childFilter, nameProvider, newName, suppresion, ignoreSuppressed);
    }

    private static String checkName(AdapterFactory adapterFactory, Object parent, Object e, IFilter childFilter, EStructuralFeature nameFeature, String newName, Suppression suppression, boolean ignoreSuppressed) {
        return NameChecker.checkName(adapterFactory, parent, e, childFilter, NameChecker.createNameProvider(nameFeature), newName, suppression, ignoreSuppressed);
    }

    private static String checkName(AdapterFactory adapterFactory, Object parent, Object e, IFilter childFilter, INameProvider nameProvider, String newName, Suppression suppression, boolean ignoreSuppressed) {
        Collection children;
        if (ignoreSuppressed && suppression != null && suppression.isSuppressed(e)) {
            return null;
        }
        ITreeItemContentProvider adapter = (ITreeItemContentProvider)adapterFactory.adapt(parent, ITreeItemContentProvider.class);
        boolean wasRolledUp = false;
        BSActivityItemProvider bsItemProvider = null;
        if (adapter instanceof BSActivityItemProvider) {
            bsItemProvider = (BSActivityItemProvider)adapter;
            wasRolledUp = bsItemProvider.isRolledUp();
        }
        try {
            if (wasRolledUp) {
                bsItemProvider.setRolledUp(false);
            }
            children = adapter.getChildren(parent);
        }
        finally {
            if (wasRolledUp) {
                bsItemProvider.basicSetRolledUp(wasRolledUp);
            }
        }
        if (e instanceof BreakdownElement) {
            return null;
        }
        for (Object item : children) {
            String name;
            Object child = TngUtil.unwrap(item);
            if (child == e || !childFilter.accept(child) || !(name = nameProvider.getName(child)).equalsIgnoreCase(newName)) continue;
            return NLS.bind((String)LibraryEditResources.duplicateElementNameError_msg, (Object)name);
        }
        return null;
    }

    private static INameProvider createNameProvider(final EStructuralFeature nameFeature) {
        if (nameFeature == UmaPackage.eINSTANCE.getMethodElement_PresentationName()) {
            return presentationNameProvider;
        }
        return new INameProvider(){

            public String getName(Object object) {
                if (object instanceof EObject) {
                    return (String)((EObject)object).eGet(nameFeature);
                }
                return null;
            }
        };
    }

    public static String checkName(AdapterFactory adapterFactory, BreakdownElement e, Class type, EStructuralFeature nameFeature, String newName, Suppression suppression) {
        return NameChecker.checkName(adapterFactory, null, e, type, nameFeature, newName, suppression, false);
    }

    public static String checkName(AdapterFactory adapterFactory, Object parent, final BreakdownElement e, Class type, EStructuralFeature nameFeature, String newName, Suppression suppression, boolean ignoreSuppressed) {
        ITreeItemContentProvider itemProvider;
        String msg = NameChecker.checkEmpty(e, newName);
        if (msg != null) {
            return msg;
        }
        if (type == null) {
            type = NameChecker.chooseType(e);
        }
        if (parent == null && (parent = (itemProvider = (ITreeItemContentProvider)adapterFactory.adapt((Notifier)e, ITreeItemContentProvider.class)).getParent((Object)e)) == null) {
            return null;
        }
        msg = NameChecker.checkName(adapterFactory, parent, (Object)e, type, NameChecker.createNameProvider(nameFeature), newName, suppression, ignoreSuppressed);
        if (msg != null) {
            return msg;
        }
        IFilter childFilter = null;
        if (e instanceof TeamProfile) {
            childFilter = new IFilter(){

                public boolean accept(Object obj) {
                    return e instanceof TeamProfile;
                }
            };
        }
        if (childFilter != null) {
            return NameChecker.checkNameInScope(adapterFactory, parent, e, nameFeature, newName, childFilter, suppression, ignoreSuppressed);
        }
        return null;
    }

    private static String checkEmpty(Object e, String newName) {
        if (e instanceof Activity && ProcessUtil.isExtendingOrLocallyContributing((BreakdownElement)e)) {
            return null;
        }
        String elementType = e instanceof NamedElement ? TngUtil.getTypeText((EObject)((NamedElement)e)) : ELEMENT_TEXT;
        if (newName == null || newName.trim().length() == 0) {
            return NLS.bind((String)LibraryEditResources.emptyElementNameError_msg, (Object)StrUtil.toLower((String)elementType));
        }
        return null;
    }

    private static Class chooseType(BreakdownElement e) {
        if (e instanceof Activity) {
            return Activity.class;
        }
        if (e instanceof TaskDescriptor) {
            return TaskDescriptor.class;
        }
        if (e instanceof RoleDescriptor) {
            return RoleDescriptor.class;
        }
        if (e instanceof WorkProductDescriptor) {
            return WorkProductDescriptor.class;
        }
        return e.getClass();
    }

    private static String checkNameInScope(AdapterFactory adapterFactory, Object currentParent, BreakdownElement e, EStructuralFeature feature, String name, IFilter childFilter, Suppression suppression, boolean ignoreSuppressed) {
        Object parent = currentParent;
        while (parent != null) {
            String msg = NameChecker.checkName(adapterFactory, parent, (Object)e, childFilter, feature, name, suppression, ignoreSuppressed);
            if (msg != null) {
                return msg;
            }
            ITreeItemContentProvider itemProvider = (ITreeItemContentProvider)adapterFactory.adapt(parent, ITreeItemContentProvider.class);
            parent = itemProvider.getParent(parent);
        }
        if (currentParent != null) {
            AdapterFactoryTreeIterator iter = new AdapterFactoryTreeIterator(adapterFactory, currentParent, false);
            while (iter.hasNext()) {
                String childName;
                Object child = TngUtil.unwrap(iter.next());
                if (child == e || !childFilter.accept(child) || !name.equalsIgnoreCase(childName = (String)((EObject)child).eGet(feature))) continue;
                return NLS.bind((String)LibraryEditResources.duplicateElementNameError_msg, (Object)name);
            }
        }
        return null;
    }

    public static String checkName(AdapterFactory adapterFactory, BreakdownElement e, EStructuralFeature feature, String name, Suppression suppression) {
        return NameChecker.checkName(adapterFactory, e, feature, name, suppression, false);
    }

    public static String checkName(AdapterFactory adapterFactory, BreakdownElement e, EStructuralFeature feature, String name, Suppression suppression, boolean ignoreSuppressed) {
        return NameChecker.checkName(adapterFactory, null, e, null, feature, name, suppression, ignoreSuppressed);
    }

    public static boolean canHaveEmptyPresentationName(DescribableElement e) {
        if (e instanceof VariabilityElement) {
            VariabilityType vType = ((VariabilityElement)e).getVariabilityType();
            return vType == VariabilityType.EXTENDS || vType == VariabilityType.CONTRIBUTES || vType == VariabilityType.LOCAL_CONTRIBUTION;
        }
        return false;
    }

    public static boolean checkFilePathLength(MethodElement parentElementWithResource, MethodElement element, String name, int maxLength, String[] filePathName) {
        Resource res = parentElementWithResource.eResource();
        URI uri = res.getURI();
        if (filePathName != null) {
            int cfr_ignored_0 = filePathName.length;
        }
        int parentResLen = uri.toFileString().length();
        int localGroupLen = 20;
        if (parentElementWithResource instanceof MethodLibrary) {
            localGroupLen = 0;
        } else if (element instanceof Role) {
            localGroupLen = 5;
        } else if (element instanceof CapabilityPattern) {
            localGroupLen = 18;
        }
        int totalLen = parentResLen + localGroupLen + name.length();
        return totalLen <= maxLength;
    }
}

