/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.validation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.epf.common.utils.ProfilingUtil;
import org.eclipse.epf.library.edit.LibraryEditPlugin;
import org.eclipse.epf.library.edit.LibraryEditResources;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.edit.validation.PluginDepInfo;
import org.eclipse.epf.library.edit.validation.Tracer;
import org.eclipse.epf.library.edit.validation.ValidationStatus;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.MethodPlugin;

public class PluginDependencyInfoMgr {
    private static boolean profiling = false;
    private static boolean debug = false;
    private MethodLibrary lib;
    private Map processed;
    private List circularList;

    public PluginDependencyInfoMgr(MethodLibrary lib) {
        this.lib = lib;
    }

    public void logCircularDependency(Stack trace) {
        if (this.circularList == null) {
            this.circularList = new ArrayList();
        }
        this.circularList.addAll(trace);
    }

    private List getAndClearCircularList() {
        List ret = this.circularList;
        this.circularList = null;
        return ret;
    }

    private void log(String msg) {
        LibraryEditPlugin.INSTANCE.log(msg);
    }

    private PluginDepInfo registerPlugin(MethodPlugin plugin, boolean checkCircular) {
        PluginDepInfo info = this.getProcessedInfo(plugin);
        if (info == null) {
            info = new PluginDepInfo(this, plugin);
        }
        if (!info.isComplete()) {
            info.build(checkCircular);
        }
        return info;
    }

    public IStatus checkCircularDependnecy(MethodPlugin plugin) {
        boolean loop;
        if (debug) {
            System.out.println("LD> plugin: " + TngUtil.getLabelWithPath(plugin));
        }
        this.registerPlugin(plugin, true);
        List cirList = this.getAndClearCircularList();
        boolean bl = loop = cirList != null && !cirList.isEmpty();
        if (loop) {
            this.log("Error> Circular dependency detected: ");
            int i = 0;
            while (i < cirList.size()) {
                PluginDepInfo loopInfo = (PluginDepInfo)cirList.get(i);
                MethodPlugin elem = loopInfo.getPlugin();
                this.log("Error> " + i + ": " + TngUtil.getLabelWithPath(elem));
                ++i;
            }
            this.log("");
            return new ValidationStatus(4, 0, this.genErrorMsg(cirList), plugin, null);
        }
        return Status.OK_STATUS;
    }

    private String genErrorMsg(List cirList) {
        String msg = LibraryEditResources.variability_element_circular_loop_error_msg;
        int i = 0;
        while (i < cirList.size()) {
            PluginDepInfo loopInfo = (PluginDepInfo)cirList.get(i);
            MethodPlugin elem = loopInfo.getPlugin();
            if (i > 0) {
                msg = String.valueOf(msg) + ": ";
            }
            msg = String.valueOf(msg) + TngUtil.getLabelWithPath(elem);
            ++i;
        }
        return msg;
    }

    protected boolean processed(MethodPlugin plugin) {
        return this.processed != null && this.processed.containsKey(plugin.getGuid());
    }

    protected PluginDepInfo getProcessedInfo(MethodPlugin plugin) {
        return this.processed == null ? null : (PluginDepInfo)this.processed.get(plugin.getGuid());
    }

    protected void addToProcessed(PluginDepInfo info) {
        if (this.processed == null) {
            this.processed = new HashMap();
        }
        this.processed.put(info.getPlugin().getGuid(), info);
    }

    public CheckResult checkCircularDependnecy(Tracer tracer, boolean accumErrors) {
        if (tracer == null) {
            tracer = new Tracer(){

                public void trace(String line) {
                }
            };
        }
        long usedMem0 = 0L;
        Runtime rt = Runtime.getRuntime();
        if (profiling) {
            TreeIterator it = this.lib.eAllContents();
            while (it.hasNext()) {
                it.next();
            }
            ProfilingUtil.fullGC();
            usedMem0 = rt.totalMemory() - rt.freeMemory();
        }
        CheckResult result = this.checkCircularDependnecy_(tracer, accumErrors);
        if (profiling) {
            ProfilingUtil.fullGC();
            System.out.println("LD> usedMem0: " + usedMem0 / 1000L + " k bytes");
            long usedMem1 = rt.totalMemory() - rt.freeMemory();
            System.out.println("LD> usedMem1: " + usedMem1 / 1000L + " k bytes");
            System.out.println("LD> diffMem: " + (usedMem1 - usedMem0) / 1000L + " k bytes");
        }
        return result;
    }

    private CheckResult checkCircularDependnecy_(Tracer tracer, boolean accumErrors) {
        CheckResult result = new CheckResult();
        List plugins = this.lib.getMethodPlugins();
        for (MethodPlugin plugin : plugins) {
            boolean loop;
            this.registerPlugin(plugin, true);
            List cirList = this.getAndClearCircularList();
            boolean bl = loop = cirList != null && !cirList.isEmpty();
            if (!loop) continue;
            tracer.trace("Error> Circular dependency detected: ");
            int i = 0;
            while (i < cirList.size()) {
                PluginDepInfo loopInfo = (PluginDepInfo)cirList.get(i);
                MethodPlugin elem = loopInfo.getPlugin();
                tracer.trace("Error> " + i + ": " + TngUtil.getLabelWithPath(elem));
                ++i;
            }
            result.circularList.add(cirList);
            if (accumErrors) continue;
            return result;
        }
        return result;
    }

    public static class CheckResult {
        public List circularList = new ArrayList();

        public int getErrorCount() {
            return this.circularList.size();
        }
    }
}

