/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.validation;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.epf.uma.MethodElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UniqueNameHandler {
    private Set<String> names = new HashSet<String>();

    public void registerNames(Collection<? extends MethodElement> elements) {
        if (elements == null) {
            return;
        }
        for (MethodElement methodElement : elements) {
            this.register(methodElement.getName());
        }
    }

    public void registerPresentationNames(Collection<? extends MethodElement> elements) {
        if (elements == null) {
            return;
        }
        for (MethodElement methodElement : elements) {
            this.register(methodElement.getPresentationName());
        }
    }

    public void register(String name) {
        this.names.add(name.toUpperCase());
    }

    public String getUniqueName(String oldName) {
        String name = oldName;
        int i = 0;
        while (this.names.contains(name.toUpperCase())) {
            name = String.valueOf(oldName) + "_" + ++i;
        }
        return name;
    }

    public void ensureUnique(MethodElement element) {
        String name = this.getUniqueName(element.getName());
        if (!name.equals(element.getName())) {
            element.setName(name);
        }
        this.register(name);
    }
}

