/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.validation.internal;

import java.io.File;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.library.edit.LibraryEditResources;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.edit.validation.NameChecker;
import org.eclipse.epf.library.edit.validation.internal.UniquenessValidator;
import org.eclipse.epf.services.IFileBasedLibraryPersister;
import org.eclipse.epf.services.Services;
import org.eclipse.epf.uma.ContentDescription;
import org.eclipse.epf.uma.ContentElement;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.Section;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.util.ContentDescriptionFactory;
import org.eclipse.epf.uma.util.UmaUtil;
import org.eclipse.osgi.util.NLS;

public class ContentElementNameValidator
extends UniquenessValidator {
    public ContentElementNameValidator(EObject container, ContentElement e, IFilter childFilter) {
        super(container, (EStructuralFeature)UmaPackage.eINSTANCE.getContentPackage_ContentElements(), childFilter, (EObject)e, (EStructuralFeature)UmaPackage.eINSTANCE.getNamedElement_Name());
    }

    public ContentElementNameValidator(EObject parent, EStructuralFeature containingFeature, ContentElement e, IFilter childFilter) {
        super(parent, containingFeature, childFilter, (EObject)e, (EStructuralFeature)UmaPackage.eINSTANCE.getNamedElement_Name());
    }

    public String isValid(String newText) {
        URI uri;
        Integer max;
        MethodPlugin plugin;
        ContentElement e = (ContentElement)this.object;
        if (e instanceof Section) {
            return newText;
        }
        String msg = TngUtil.checkElementName(newText, TngUtil.getTypeText((EObject)e));
        if (msg != null) {
            return msg;
        }
        if (this.container != null && !NameChecker.checkFilePathLength((MethodElement)(plugin = UmaUtil.getMethodPlugin((EObject)this.container)), (MethodElement)e, newText, max = new Integer(255), null)) {
            msg = NLS.bind((String)LibraryEditResources.filePathNameTooLong_msg, (Object[])new Object[]{max});
            return msg;
        }
        if (this.container != null && ContentDescriptionFactory.hasPresentation((MethodElement)e) && (plugin = UmaUtil.getMethodPlugin((EObject)this.container)) == UmaUtil.getMethodPlugin((EObject)e) && (uri = plugin.eResource().getURI()).isFile()) {
            File pluginDir = new File(uri.toFileString()).getParentFile();
            IFileBasedLibraryPersister persister = (IFileBasedLibraryPersister)Services.getLibraryPersister((String)"xmi");
            String folderPath = persister.getFolderRelativePath((MethodElement)e);
            String dir = new StringBuffer(pluginDir.getAbsolutePath()).append(File.separator).append(folderPath).toString();
            String fileName = String.valueOf(newText) + persister.getFileExtension((Object)e);
            File file = new File(dir, fileName);
            File currentFile = null;
            ContentDescription content = e.getPresentation();
            currentFile = content.eResource() != null ? new File(content.eResource().getURI().toFileString()) : file;
            if (file.exists() && !newText.equals(e.getName()) && !file.equals(currentFile)) {
                return NLS.bind((String)LibraryEditResources.duplicateContentFileError_msg, (Object)file);
            }
        }
        return super.isValid(newText);
    }
}

