/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.validation.internal;

import java.io.File;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.epf.library.edit.LibraryEditResources;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.edit.validation.AbstractStringValidator;
import org.eclipse.epf.library.edit.validation.NameChecker;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.NamedElement;
import org.eclipse.osgi.util.NLS;

public class MethodPluginNameValidator
extends AbstractStringValidator {
    private MethodLibrary lib;
    private MethodPlugin plugin;

    public MethodPluginNameValidator(MethodLibrary lib, MethodPlugin plugin) {
        this.lib = lib;
        this.plugin = plugin;
    }

    public String isValid(String newText) {
        String msg = TngUtil.checkPluginName(newText);
        if (msg != null) {
            return msg;
        }
        Integer max = new Integer(255);
        if (!NameChecker.checkFilePathLength((MethodElement)this.lib, (MethodElement)this.plugin, newText, max, null)) {
            msg = NLS.bind((String)LibraryEditResources.filePathNameTooLong_msg, (Object[])new Object[]{max});
            return msg;
        }
        File dir = new File(this.lib.eResource().getURI().toFileString()).getParentFile();
        String elementTypeText = this.plugin != null ? TngUtil.getTypeText((EObject)this.plugin) : TngUtil.getTypeText("MethodPlugin");
        return TngUtil.checkName(dir, this.lib.getMethodPlugins(), (NamedElement)this.plugin, newText, elementTypeText, true);
    }
}

