/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.validation.internal;

import java.io.File;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.epf.common.utils.StrUtil;
import org.eclipse.epf.library.edit.LibraryEditResources;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.edit.validation.AbstractStringValidator;
import org.eclipse.epf.library.edit.validation.NameChecker;
import org.eclipse.epf.services.IFileBasedLibraryPersister;
import org.eclipse.epf.services.Services;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.NamedElement;
import org.eclipse.epf.uma.ProcessComponent;
import org.eclipse.epf.uma.ProcessPackage;
import org.eclipse.epf.uma.util.UmaUtil;
import org.eclipse.osgi.util.NLS;

public class ProcessComponentNameValidator
extends AbstractStringValidator {
    private ProcessPackage parent;
    private ProcessComponent procComp;

    public ProcessComponentNameValidator(ProcessPackage parent, ProcessComponent procComp) {
        this.parent = parent;
        this.procComp = procComp;
    }

    public String isValid(String newText) {
        Integer max;
        String relativePath = ((IFileBasedLibraryPersister)Services.getLibraryPersister((String)"xmi")).getFolderRelativePath((MethodElement)this.procComp);
        MethodPlugin plugin = UmaUtil.getMethodPlugin((EObject)this.parent);
        if (!NameChecker.checkFilePathLength((MethodElement)plugin, (MethodElement)this.procComp, newText, max = new Integer(255), null)) {
            String msg = NLS.bind((String)LibraryEditResources.filePathNameTooLong_msg, (Object[])new Object[]{max});
            return msg;
        }
        File dir = new File(String.valueOf(new File(plugin.eResource().getURI().toFileString()).getParent()) + File.separator + relativePath);
        if (!newText.equals(StrUtil.makeValidFileName((String)newText))) {
            return NLS.bind((String)LibraryEditResources.invalidElementNameError3_msg, (Object)newText);
        }
        return TngUtil.checkName(dir, this.parent.getChildPackages(), (NamedElement)this.procComp, newText, TngUtil.getTypeText((EObject)this.procComp), true);
    }
}

