/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.validation.internal;

import java.util.Collection;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.epf.common.utils.StrUtil;
import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.library.edit.LibraryEditPlugin;
import org.eclipse.epf.library.edit.LibraryEditResources;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.edit.validation.IValidator;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.osgi.util.NLS;

public class UniquenessValidator
implements IValidator {
    protected EObject object;
    private EStructuralFeature feature;
    private String featureName;
    private EStructuralFeature containingFeature;
    private IFilter childFilter;
    protected EObject container;

    public UniquenessValidator(EObject container, EStructuralFeature containingFeature, IFilter childFilter, EObject obj, EStructuralFeature feature) {
        this(container, containingFeature, childFilter, obj, feature, StrUtil.toLower((String)TngUtil.getFeatureText(feature)));
    }

    public UniquenessValidator(EObject container, EStructuralFeature containingFeature, IFilter childFilter, EObject obj, EStructuralFeature feature, String featureName) {
        this.container = container;
        this.object = obj;
        this.containingFeature = containingFeature;
        this.childFilter = childFilter;
        this.feature = feature;
        this.featureName = featureName;
    }

    void setChildFilter(IFilter childFilter) {
        this.childFilter = childFilter;
    }

    public String isValid(String newText) {
        if (this.container == null) {
            return null;
        }
        if (StrUtil.isBlank((String)(newText = newText.trim()))) {
            if (this.object instanceof EObject && this.feature == UmaPackage.eINSTANCE.getNamedElement_Name()) {
                return NLS.bind((String)LibraryEditResources.emptyElementNameError_msg, (Object)TngUtil.getTypeText(this.object));
            }
            return NLS.bind((String)LibraryEditResources.emptyElementNameError_msg, (Object)this.featureName);
        }
        Object children = this.containingFeature == null ? this.container.eContents() : (Collection)this.container.eGet(this.containingFeature);
        for (Object child : children) {
            String name;
            if (child == this.object || !this.childFilter.accept(child) || !(name = (String)((EObject)child).eGet(this.feature)).equalsIgnoreCase(newText)) continue;
            return NLS.bind((String)LibraryEditResources.duplicateElementNameError_msg, (Object)newText);
        }
        return null;
    }

    public IStatus isValid(Object value) {
        if (this.container == null) {
            return Status.OK_STATUS;
        }
        Object children = this.containingFeature == null ? this.container.eContents() : (Collection)this.container.eGet(this.containingFeature);
        for (Object child : children) {
            String o;
            if (child == this.object || !this.childFilter.accept(child) || !(o = (String)((EObject)child).eGet(this.feature)).equals(value)) continue;
            return new Status(4, LibraryEditPlugin.getDefault().getId(), 0, NLS.bind((String)LibraryEditResources.duplicateFeatureValue, (Object[])new Object[]{TngUtil.getLabel(this.container), this.featureName}), null);
        }
        return Status.OK_STATUS;
    }

    public EObject getEObject() {
        return this.object;
    }
}

