/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.validation.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.epf.common.utils.StrUtil;
import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.library.edit.LibraryEditPlugin;
import org.eclipse.epf.library.edit.util.Suppression;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.edit.validation.AbstractStringValidator;
import org.eclipse.epf.library.edit.validation.IValidator;
import org.eclipse.epf.library.edit.validation.IValidatorFactory;
import org.eclipse.epf.library.edit.validation.NameChecker;
import org.eclipse.epf.library.edit.validation.internal.ContentElementNameValidator;
import org.eclipse.epf.library.edit.validation.internal.DoNothingValidator;
import org.eclipse.epf.library.edit.validation.internal.MethodConfigurationNameValidator;
import org.eclipse.epf.library.edit.validation.internal.MethodPluginNameValidator;
import org.eclipse.epf.library.edit.validation.internal.ProcessComponentNameValidator;
import org.eclipse.epf.library.edit.validation.internal.UniquenessValidator;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.ContentElement;
import org.eclipse.epf.uma.ContentPackage;
import org.eclipse.epf.uma.CustomCategory;
import org.eclipse.epf.uma.DescribableElement;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.MethodPackage;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.NamedElement;
import org.eclipse.epf.uma.Process;
import org.eclipse.epf.uma.ProcessComponent;
import org.eclipse.epf.uma.ProcessPackage;
import org.eclipse.epf.uma.UmaPackage;
import org.osgi.framework.Bundle;

public class ValidatorFactory
implements IValidatorFactory {
    private static List contributedValidatorFactories;
    private static IValidatorFactory instance;
    public static final IFilter nonFilter;

    static {
        nonFilter = new IFilter(){

            public boolean accept(Object obj) {
                return true;
            }
        };
    }

    public IValidator createNameValidator(Object parent, ContentElement e) {
        if (parent instanceof CustomCategory && e instanceof CustomCategory) {
            return new ContentElementNameValidator((EObject)parent, (EStructuralFeature)UmaPackage.eINSTANCE.getCustomCategory_CategorizedElements(), e, new TypeFilter((EObject)e));
        }
        EObject container = null;
        if (parent instanceof EObject) {
            container = (EObject)parent;
        }
        return new ContentElementNameValidator(container, e, new TypeFilter((EObject)e));
    }

    public IValidator createPresentationNameValidator(Object parent, DescribableElement e) {
        if (parent instanceof EObject) {
            Object[] arr = ValidatorFactory.getChildReferenceAndFilter(parent, e);
            EReference reference = (EReference)arr[0];
            IFilter childFilter = (IFilter)arr[1];
            if (reference != null) {
                if (childFilter == null) {
                    childFilter = new TypeFilter((EObject)e);
                }
                return new UniquenessValidator((EObject)parent, (EStructuralFeature)reference, childFilter, (EObject)e, (EStructuralFeature)UmaPackage.eINSTANCE.getMethodElement_PresentationName()){

                    public String isValid(String newText) {
                        if (StrUtil.isBlank((String)newText) && NameChecker.canHaveEmptyPresentationName((DescribableElement)this.object)) {
                            return null;
                        }
                        return super.isValid(newText);
                    }
                };
            }
        }
        return DoNothingValidator.INSTANCE;
    }

    private static Object[] getChildReferenceAndFilter(Object parent, Object child) {
        EReference reference = null;
        IFilter childFilter = null;
        if (child instanceof ContentElement) {
            if (parent instanceof CustomCategory && child instanceof CustomCategory) {
                reference = UmaPackage.Literals.CUSTOM_CATEGORY__CATEGORIZED_ELEMENTS;
                childFilter = new TypeFilter(UmaPackage.Literals.CUSTOM_CATEGORY);
            } else if (parent instanceof ContentPackage) {
                reference = UmaPackage.Literals.CONTENT_PACKAGE__CONTENT_ELEMENTS;
            }
        } else if (child instanceof MethodPackage && parent instanceof MethodPackage) {
            reference = UmaPackage.Literals.METHOD_PACKAGE__CHILD_PACKAGES;
        } else if (parent instanceof MethodLibrary) {
            if (child instanceof MethodPlugin) {
                reference = UmaPackage.Literals.METHOD_LIBRARY__METHOD_PLUGINS;
                childFilter = nonFilter;
            } else if (child instanceof MethodConfiguration) {
                reference = UmaPackage.Literals.METHOD_LIBRARY__PREDEFINED_CONFIGURATIONS;
                childFilter = nonFilter;
            }
        }
        return new Object[]{reference, childFilter};
    }

    public IValidator createNameValidator(Object parent, NamedElement e) {
        EAttribute feature = UmaPackage.Literals.NAMED_ELEMENT__NAME;
        Object[] arr = ValidatorFactory.getChildReferenceAndFilter(parent, e);
        EReference reference = (EReference)arr[0];
        IFilter childFilter = (IFilter)arr[1];
        if (reference != null) {
            return this.createValidator((EObject)parent, reference, childFilter, (EObject)e, (EStructuralFeature)feature);
        }
        if (e instanceof MethodConfiguration && parent instanceof MethodLibrary) {
            return new MethodConfigurationNameValidator((MethodLibrary)parent, (MethodConfiguration)e);
        }
        return DoNothingValidator.INSTANCE;
    }

    public IValidator createNameValidator(Object parent, NamedElement e, EClass newType) {
        EAttribute feature = UmaPackage.Literals.NAMED_ELEMENT__NAME;
        Object[] arr = ValidatorFactory.getChildReferenceAndFilter(parent, e);
        EReference reference = (EReference)arr[0];
        TypeFilter childFilter = new TypeFilter(newType);
        if (reference != null) {
            return this.createValidator((EObject)parent, reference, childFilter, (EObject)e, (EStructuralFeature)feature);
        }
        return DoNothingValidator.INSTANCE;
    }

    public IValidator createNameValidator(NamedElement e, AdapterFactory adapterFactory) {
        EStructuralFeature containingFeature = TngUtil.getContainingFeature(e, adapterFactory);
        if (containingFeature != null) {
            EObject parent = (EObject)((ITreeItemContentProvider)adapterFactory.adapt((Notifier)e, ITreeItemContentProvider.class)).getParent((Object)e);
            if (e instanceof ContentElement) {
                return new ContentElementNameValidator(parent, containingFeature, (ContentElement)e, new TypeFilter((EObject)e));
            }
            if (e instanceof ProcessComponent && parent instanceof ProcessPackage) {
                return new ProcessComponentNameValidator((ProcessPackage)parent, (ProcessComponent)e);
            }
            if (e instanceof MethodPlugin && parent instanceof MethodLibrary) {
                return new MethodPluginNameValidator((MethodLibrary)parent, (MethodPlugin)e);
            }
            if (e instanceof MethodConfiguration && parent instanceof MethodLibrary) {
                return new MethodConfigurationNameValidator((MethodLibrary)parent, (MethodConfiguration)e);
            }
            return new UniquenessValidator(parent, containingFeature, new TypeFilter((EObject)e), (EObject)e, (EStructuralFeature)UmaPackage.eINSTANCE.getNamedElement_Name());
        }
        return this.createNameValidator((Object)e.eContainer(), e);
    }

    public IValidator createValidator(EObject parent, EReference reference, EClass eClass, EObject object, EStructuralFeature feature) {
        TypeFilter childFilter = eClass != null ? new TypeFilter(eClass) : null;
        return this.createValidator(parent, reference, childFilter, object, feature);
    }

    public static IValidatorFactory createValidatorFactory() {
        if (contributedValidatorFactories != null) {
            contributedValidatorFactories = new ArrayList();
            IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
            IExtensionPoint extensionPoint = extensionRegistry.getExtensionPoint(LibraryEditPlugin.getDefault().getId(), "validationSupport");
            if (extensionPoint != null) {
                IExtension[] extensions = extensionPoint.getExtensions();
                int i = 0;
                while (i < extensions.length) {
                    IExtension extension = extensions[i];
                    String pluginId = extension.getNamespaceIdentifier();
                    Bundle bundle = Platform.getBundle((String)pluginId);
                    IConfigurationElement[] configElements = extension.getConfigurationElements();
                    int j = 0;
                    while (j < configElements.length) {
                        IConfigurationElement configElement = configElements[j];
                        try {
                            String className = configElement.getAttribute("class");
                            if (className != null) {
                                Object ext = bundle.loadClass(className).newInstance();
                                boolean replace = new Boolean(configElement.getAttribute("replace"));
                                if (replace) {
                                    contributedValidatorFactories.clear();
                                    instance = (IValidatorFactory)ext;
                                } else if (instance == null) {
                                    contributedValidatorFactories.add(ext);
                                }
                            }
                        }
                        catch (Exception e) {
                            LibraryEditPlugin.INSTANCE.log(e);
                        }
                        ++j;
                    }
                    ++i;
                }
            }
        }
        if (instance == null) {
            instance = new ValidatorFactory();
        }
        return instance;
    }

    public IValidator createValidator(final Object parent, EClass eClass, EObject object, final EStructuralFeature feature, final AdapterFactory adapterFactory) {
        if (object instanceof BreakdownElement && (feature == UmaPackage.Literals.NAMED_ELEMENT__NAME || feature == UmaPackage.Literals.METHOD_ELEMENT__PRESENTATION_NAME)) {
            final BreakdownElement be = (BreakdownElement)object;
            Process proc = TngUtil.getOwningProcess(parent);
            if (proc != null) {
                final Suppression supp = Suppression.getSuppression(proc);
                return new AbstractStringValidator(){

                    public String isValid(String newText) {
                        return NameChecker.checkName(adapterFactory, parent, be, null, feature, newText, supp, true);
                    }
                };
            }
        }
        return DoNothingValidator.INSTANCE;
    }

    private static IFilter getFilter(IFilter filter, EObject eObject) {
        return filter != null ? filter : (eObject != null ? new TypeFilter(eObject) : nonFilter);
    }

    public IValidator createValidator(EObject parent, EReference reference, IFilter childFilter, EObject object, EStructuralFeature feature) {
        if (feature == UmaPackage.Literals.NAMED_ELEMENT__NAME) {
            UniquenessValidator validator = null;
            if (object instanceof ContentElement) {
                if (reference == UmaPackage.eINSTANCE.getContentPackage_ContentElements() || reference == UmaPackage.Literals.CUSTOM_CATEGORY__CATEGORIZED_ELEMENTS && object instanceof CustomCategory) {
                    validator = new ContentElementNameValidator(parent, (EStructuralFeature)reference, (ContentElement)object, ValidatorFactory.getFilter(childFilter, object));
                } else if (reference == UmaPackage.Literals.DISCIPLINE_GROUPING__DISCIPLINES || reference == UmaPackage.Literals.ROLE_SET_GROUPING__ROLE_SETS) {
                    validator = new UniquenessValidator(parent.eContainer(), (EStructuralFeature)UmaPackage.eINSTANCE.getContentPackage_ContentElements(), ValidatorFactory.getFilter(childFilter, object), object, feature);
                } else if (reference == UmaPackage.Literals.ARTIFACT__CONTAINED_ARTIFACTS || reference == UmaPackage.Literals.DISCIPLINE__SUBDISCIPLINE || reference == UmaPackage.Literals.PRACTICE__SUB_PRACTICES || reference == UmaPackage.Literals.DOMAIN__SUBDOMAINS) {
                    validator = new ContentElementNameValidator(parent, (EStructuralFeature)reference, (ContentElement)object, ValidatorFactory.getFilter(childFilter, object));
                }
            } else {
                if (object instanceof ProcessComponent && parent instanceof ProcessPackage && reference == UmaPackage.eINSTANCE.getMethodPackage_ChildPackages()) {
                    ProcessPackage pkg = (ProcessPackage)parent;
                    if (pkg.eResource().getURI().isFile()) {
                        return new ProcessComponentNameValidator((ProcessPackage)parent, (ProcessComponent)object);
                    }
                    return new UniquenessValidator(parent, (EStructuralFeature)reference, ValidatorFactory.getFilter(childFilter, object), object, feature);
                }
                if (parent instanceof MethodLibrary) {
                    MethodLibrary lib = (MethodLibrary)parent;
                    if (reference == UmaPackage.Literals.METHOD_LIBRARY__METHOD_PLUGINS) {
                        if (lib.eResource().getURI().isFile()) {
                            return new MethodPluginNameValidator(lib, (MethodPlugin)object);
                        }
                        return new UniquenessValidator((EObject)lib, (EStructuralFeature)UmaPackage.Literals.METHOD_LIBRARY__METHOD_PLUGINS, nonFilter, object, (EStructuralFeature)UmaPackage.eINSTANCE.getNamedElement_Name());
                    }
                    if (reference == UmaPackage.Literals.METHOD_LIBRARY__PREDEFINED_CONFIGURATIONS) {
                        if (lib.eResource().getURI().isFile()) {
                            return new MethodConfigurationNameValidator(lib, (MethodConfiguration)object);
                        }
                        return new UniquenessValidator((EObject)lib, (EStructuralFeature)UmaPackage.Literals.METHOD_LIBRARY__PREDEFINED_CONFIGURATIONS, nonFilter, object, (EStructuralFeature)UmaPackage.eINSTANCE.getNamedElement_Name());
                    }
                } else {
                    validator = new UniquenessValidator(parent, (EStructuralFeature)reference, ValidatorFactory.getFilter(childFilter, object), object, feature);
                }
            }
            return validator;
        }
        if (feature == UmaPackage.Literals.METHOD_ELEMENT__PRESENTATION_NAME) {
            return this.createPresentationNameValidator(parent, (DescribableElement)object);
        }
        return DoNothingValidator.INSTANCE;
    }

    public static class TypeFilter
    implements IFilter {
        private int classID;
        private EClass eClass;

        public TypeFilter(EObject obj) {
            this.classID = obj.eClass().getClassifierID();
        }

        public TypeFilter(EClass eClass) {
            this.eClass = eClass;
        }

        public boolean accept(Object obj) {
            if (this.eClass != null) {
                return this.eClass.isInstance(obj);
            }
            return obj instanceof EObject && this.classID == ((EObject)obj).eClass().getClassifierID();
        }
    }
}

