/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.persistence.util;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.epf.common.CommonPlugin;
import org.eclipse.epf.persistence.UnnormalizedURIException;

public class ExtendedResourceSet
extends ResourceSetImpl {
    public static final int URI_TYPE_UNKNOWN = 0;
    public static final int URI_TYPE_LOCAL = 1;
    public static final int URI_TYPE_EXTERNAL = 2;
    protected List<ResourceSet> referencedResourceSets = new ArrayList<ResourceSet>();

    protected int getURIType(URI uri) {
        return 0;
    }

    public boolean add(ResourceSet referencedResourceSet) {
        if (!this.referencedResourceSets.contains(referencedResourceSet)) {
            return this.referencedResourceSets.add(referencedResourceSet);
        }
        return false;
    }

    public EObject getEObject(URI uri, boolean loadOnDemand) {
        EObject object = null;
        UnnormalizedURIException ex = null;
        int uriType = this.getURIType(uri);
        if (uriType == 0 || uriType == 1) {
            try {
                object = super.getEObject(uri, loadOnDemand);
            }
            catch (UnnormalizedURIException e) {
                ex = e;
            }
            if (object != null) {
                return object;
            }
        }
        if (uriType == 0 || uriType == 2) {
            for (ResourceSet resourceSet : this.referencedResourceSets) {
                try {
                    object = resourceSet.getEObject(uri, loadOnDemand);
                    if (object == null) continue;
                    return object;
                }
                catch (UnnormalizedURIException e) {
                    ex = e;
                }
            }
        }
        if (ex != null) {
            throw ex;
        }
        return object;
    }

    public void dispose() {
        for (Resource resource : this.getResources()) {
            try {
                resource.unload();
            }
            catch (Exception e) {
                CommonPlugin.getDefault().getLogger().logError((Throwable)e);
            }
        }
        this.referencedResourceSets.clear();
    }
}

