/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.persistence;

import java.io.File;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.epf.common.utils.FileUtil;
import org.eclipse.epf.persistence.FileManager;
import org.eclipse.epf.persistence.MultiFileIOException;
import org.eclipse.epf.persistence.MultiFileSaveUtil;
import org.eclipse.epf.persistence.MultiFileXMIResourceImpl;
import org.eclipse.epf.persistence.util.PersistenceResources;
import org.eclipse.osgi.util.NLS;

public class FailSafePersistenceHelper {
    private URI finalURI;
    private URI oldURI;
    private String currentTxID;
    private Resource resource;
    private URI tempURI;
    private String id;
    private String backupFile;
    private URIConverter converter;
    private boolean commitEmptyResource;

    public FailSafePersistenceHelper(Resource resource, String id) {
        this.resource = resource;
        this.id = id;
        this.converter = resource.getResourceSet() != null ? resource.getResourceSet().getURIConverter() : null;
    }

    public void setCommitEmptyResource(boolean commitEmptyResource) {
        this.commitEmptyResource = commitEmptyResource;
    }

    public URI setTempURI(String txID) {
        if (this.finalURI == null) {
            this.finalURI = this.oldURI = this.resource.getURI();
            this.currentTxID = txID;
            this.tempURI = this.createTempURI();
            this.resource.setURI(this.tempURI);
        }
        return this.tempURI;
    }

    private URI createTempURI() {
        return URI.createFileURI((String)new StringBuffer(MultiFileXMIResourceImpl.getTempDir()).append(File.separator).append(this.currentTxID).append("new").append(this.id).toString());
    }

    public String getBackupFilePath() {
        String backupFile = new StringBuffer(MultiFileXMIResourceImpl.getTempDir()).append(File.separator).append(this.currentTxID).append("old").append(this.id).toString();
        return backupFile;
    }

    private String toFileString(URI uri) {
        return FileManager.toFileString(uri, this.converter);
    }

    public void commit() {
        if (this.finalURI != null && (this.commitEmptyResource || !this.resource.getContents().isEmpty())) {
            boolean wasMove;
            File finalFile = new File(this.toFileString(this.finalURI));
            boolean bl = wasMove = !this.oldURI.equals((Object)this.finalURI);
            if (!wasMove) {
                String backup = this.getBackupFilePath();
                File bakFile = new File(backup);
                if (bakFile.exists()) {
                    bakFile.delete();
                }
                if (finalFile.exists()) {
                    if (FileUtil.moveFile((File)finalFile, (File)bakFile)) {
                        this.backupFile = backup;
                    } else {
                        String msg = NLS.bind((String)PersistenceResources.renameError_msg, (Object)finalFile, (Object)backup);
                        throw new MultiFileIOException(msg);
                    }
                }
            }
            File currentFile = new File(wasMove ? this.toFileString(this.oldURI) : this.toFileString(this.resource.getURI()));
            boolean success = false;
            success = wasMove ? MultiFileSaveUtil.move(this.resource, currentFile, finalFile) : FileUtil.moveFile((File)currentFile, (File)finalFile);
            if (!success) {
                String msg = NLS.bind((String)PersistenceResources.renameError_msg, (Object)currentFile, (Object)finalFile);
                throw new MultiFileIOException(msg);
            }
            if (wasMove) {
                this.didMove();
            }
        }
    }

    protected void didMove() {
    }

    public void deleteBackup() {
        block3: {
            if (this.backupFile != null) {
                try {
                    new File(this.backupFile).delete();
                    this.backupFile = null;
                }
                catch (Throwable e) {
                    CommonPlugin.INSTANCE.log((Object)e);
                    if (!MultiFileSaveUtil.DEBUG) break block3;
                    e.printStackTrace();
                }
            }
        }
    }

    public boolean hasTempURI() {
        if (this.currentTxID != null) {
            return this.createTempURI().equals((Object)this.resource.getURI());
        }
        return false;
    }

    public URI getFinalURI() {
        if (this.finalURI != null) {
            return this.finalURI;
        }
        return this.resource.getURI();
    }

    public boolean restore() {
        File src = null;
        File dest = null;
        boolean moved = false;
        if (this.backupFile != null) {
            src = new File(this.backupFile);
            dest = new File(this.toFileString(this.getFinalURI()));
        } else {
            boolean bl = moved = this.oldURI != null && !this.oldURI.equals((Object)this.finalURI);
            if (moved) {
                File file = new File(this.toFileString(this.getFinalURI()));
                dest = new File(this.toFileString(this.oldURI));
                boolean bl2 = moved = file.exists() && !dest.exists();
                if (moved) {
                    src = file;
                }
            }
        }
        if (src != null) {
            boolean success;
            if (dest.exists()) {
                FileUtil.moveFile((File)dest, (File)new File(this.toFileString(this.resource.getURI())));
            }
            if (!(success = moved ? MultiFileSaveUtil.move(this.resource, src, dest) : FileUtil.moveFile((File)src, (File)dest))) {
                throw new MultiFileIOException(NLS.bind((String)PersistenceResources.restoreResourceError_msg, (Object)this));
            }
            return true;
        }
        return false;
    }

    public void txFinished(boolean successful) {
        if (successful) {
            this.resource.setURI(this.finalURI);
            this.resource.setModified(false);
            FileManager.getInstance().refresh(this.resource);
        } else {
            this.restoreURI();
        }
        this.currentTxID = null;
        this.finalURI = null;
    }

    private void restoreURI() {
        if (this.oldURI != null) {
            this.resource.setURI(this.oldURI);
        }
    }
}

