/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.persistence.migration;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.impl.BasicResourceHandler;
import org.eclipse.emf.ecore.xml.type.AnyType;

public abstract class MigrationResourceHandler
extends BasicResourceHandler {
    private static final boolean DEBUG = true;

    public void postLoad(XMLResource resource, InputStream inputStream, Map options) {
        if (!resource.getEObjectToExtensionMap().isEmpty()) {
            System.out.println("MigrationResourceHandler.postLoad(): " + resource.getURI());
            System.out.println("---- Start unknown features ----");
            for (Map.Entry entry : resource.getEObjectToExtensionMap().entrySet()) {
                if (!(entry.getKey() instanceof EObject)) continue;
                this.handleUnknownData((EObject)entry.getKey(), (AnyType)entry.getValue());
            }
            System.out.println("---- End unknown features ----");
        }
    }

    public static String getText(AnyType value) {
        block3: {
            if (value != null) break block3;
            return null;
        }
        FeatureMap.Entry entry = (FeatureMap.Entry)value.getMixed().get(0);
        return (String)entry.getValue();
    }

    protected static EAttribute getEAttribute(EClass eClass, String name) {
        for (EAttribute attrib : eClass.getEAllAttributes()) {
            if (!attrib.getName().equals(name)) continue;
            return attrib;
        }
        return null;
    }

    public static void setValue(EObject eObject, EStructuralFeature feature, Object value) {
        if (!feature.isMany()) {
            eObject.eSet(feature, value);
        } else {
            Collection values = (Collection)eObject.eGet(feature);
            if (value instanceof Collection) {
                values.addAll((Collection)value);
            } else {
                values.add(value);
            }
        }
    }

    protected abstract boolean handleUnknownFeature(EObject var1, EStructuralFeature var2, Object var3);

    private void handleUnknownFeatures(EObject owner, FeatureMap featureMap) {
        Iterator iter = featureMap.iterator();
        while (iter.hasNext()) {
            FeatureMap.Entry entry = (FeatureMap.Entry)iter.next();
            EStructuralFeature f = entry.getEStructuralFeature();
            if (!this.handleUnknownFeature(owner, f, entry.getValue())) continue;
            iter.remove();
        }
    }

    protected void handleUnknownData(EObject e, AnyType unknownData) {
        this.handleUnknownFeatures(e, unknownData.getMixed());
        this.handleUnknownFeatures(e, unknownData.getAnyAttribute());
    }

    public static Object getSingleValue(FeatureMap featureMap, String featureName) {
        for (FeatureMap.Entry entry : featureMap) {
            if (!entry.getEStructuralFeature().getName().equals(featureName)) continue;
            return entry.getValue();
        }
        return null;
    }

    protected static Collection getValue(FeatureMap featureMap, String featureName) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (FeatureMap.Entry entry : featureMap) {
            if (!entry.getEStructuralFeature().getName().equals(featureName)) continue;
            list.add(entry.getValue());
        }
        return list;
    }
}

