/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.persistence.migration.internal;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.xml.type.AnyType;
import org.eclipse.epf.persistence.MultiFileResourceSetImpl;
import org.eclipse.epf.persistence.migration.UMA2UMAResourceHandler;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.ContentDescription;
import org.eclipse.epf.uma.ContentPackage;
import org.eclipse.epf.uma.DescribableElement;
import org.eclipse.epf.uma.ProcessElement;
import org.eclipse.epf.uma.ProcessPackage;
import org.eclipse.epf.uma.UmaFactory;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.WorkBreakdownElement;
import org.eclipse.epf.uma.WorkOrder;
import org.eclipse.epf.uma.WorkOrderType;

public class UMA2UMAResourceHandler0
extends UMA2UMAResourceHandler {
    private Set procMovedFeatureNames;
    private Map guidToPresentationMap = new HashMap();
    private Set classNamesToSavePresentationURI;

    public UMA2UMAResourceHandler0() {
        this.procMovedFeatureNames = new HashSet<String>(Arrays.asList("purpose", "keyConsiderations", "alternatives", "howtoStaff", "usageGuidance", "externalId", "scope", "usageNotes", "scale", "projectCharacteristics", "riskLevel", "estimatingTechnique", "projectMemberExpertise", "typeOfContract", "techniques", "mainDescription"));
    }

    protected EStructuralFeature getNewFeature(EObject owner, String featureName) {
        ContentDescription content;
        EAttribute attrib;
        if ("presentationName".equals(featureName) && owner instanceof ContentDescription) {
            return UmaPackage.eINSTANCE.getMethodElement_PresentationName();
        }
        if (this.procMovedFeatureNames.contains(featureName) && owner instanceof ProcessElement && (attrib = UMA2UMAResourceHandler0.getEAttribute((content = ((ProcessElement)owner).getPresentation()).eClass(), featureName)) != null) {
            return attrib;
        }
        if ("WorkOrder".equals(featureName) && owner instanceof ProcessPackage) {
            return UmaPackage.eINSTANCE.getProcessPackage_ProcessElements();
        }
        return super.getNewFeature(owner, featureName);
    }

    protected EObject getNewOwner(EObject oldOwner, String featureName) {
        if ("presentationName".equals(featureName) && oldOwner instanceof ContentDescription) {
            DescribableElement de = (DescribableElement)oldOwner.eContainer();
            if (de instanceof Activity) {
                return null;
            }
            return de;
        }
        if (this.procMovedFeatureNames.contains(featureName) && oldOwner instanceof ProcessElement) {
            return ((ProcessElement)oldOwner).getPresentation();
        }
        if ("WorkOrder".equals(featureName) && oldOwner instanceof ProcessPackage) {
            return oldOwner;
        }
        return super.getNewOwner(oldOwner, featureName);
    }

    protected Object getNewValue(EObject oldOwner, String featureName, AnyType value) {
        if ("WorkOrder".equals(featureName) && oldOwner instanceof ProcessPackage) {
            WorkOrder workOrder = UmaFactory.eINSTANCE.createWorkOrder();
            workOrder.setGuid((String)UMA2UMAResourceHandler0.getSingleValue(value.getAnyAttribute(), "guid"));
            String predGuid = (String)UMA2UMAResourceHandler0.getSingleValue(value.getAnyAttribute(), "pred");
            if (predGuid == null) {
                InternalEObject obj = (InternalEObject)UMA2UMAResourceHandler0.getSingleValue(value.getMixed(), "pred");
                predGuid = obj.eProxyURI().authority();
            }
            MultiFileResourceSetImpl resourceSet = (MultiFileResourceSetImpl)oldOwner.eResource().getResourceSet();
            WorkBreakdownElement pred = (WorkBreakdownElement)resourceSet.getEObject(predGuid);
            workOrder.setPred(pred);
            workOrder.setLinkType(WorkOrderType.FINISH_TO_FINISH);
            return workOrder;
        }
        return UMA2UMAResourceHandler0.getText(value);
    }

    public void savePresentationURIFor(Set classNames) {
        this.classNamesToSavePresentationURI = classNames;
    }

    public URI getPresentationURI(String guid) {
        return (URI)this.guidToPresentationMap.get(guid);
    }

    protected void handleUnknownData(EObject e, AnyType unknownData) {
        super.handleUnknownData(e, unknownData);
        if (this.classNamesToSavePresentationURI != null && e instanceof ContentPackage) {
            for (AnyType value : UMA2UMAResourceHandler0.getValue(unknownData.getMixed(), "contentElements")) {
                Object presentation;
                if (value == null || !this.classNamesToSavePresentationURI.contains(value.eClass().getName()) || (presentation = UMA2UMAResourceHandler0.getSingleValue(value.getMixed(), "presentation")) == null) continue;
                Object guid = UMA2UMAResourceHandler0.getSingleValue(value.getAnyAttribute(), "guid");
                URI uri = ((InternalEObject)presentation).eProxyURI();
                this.guidToPresentationMap.put(guid, uri);
            }
        }
    }
}

