/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.ui.xmi;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.epf.library.ui.wizards.NewLibraryWizardPage;
import org.eclipse.epf.library.ui.xmi.XMILibraryUIResources;
import org.eclipse.epf.library.xmi.preferences.XMILibraryPreferences;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class NewXMILibraryWizardPage
extends NewLibraryWizardPage {
    private Text nameText;
    private Combo locationCombo;
    private ModifyListener modifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            NewXMILibraryWizardPage.this.setPageComplete(NewXMILibraryWizardPage.this.isPageComplete());
            NewXMILibraryWizardPage.this.getWizard().getContainer().updateButtons();
        }
    };

    public NewXMILibraryWizardPage(String pageId) {
        super(pageId);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        Label nameLabel = new Label(composite, 0);
        nameLabel.setText(XMILibraryUIResources.nameLabel_text);
        this.nameText = new Text(composite, 2048);
        this.nameText.setLayoutData((Object)new GridData(768));
        this.nameText.setEditable(false);
        new Label(composite, 0);
        Label locationLabel = new Label(composite, 0);
        locationLabel.setText(XMILibraryUIResources.locationLabel_text);
        this.locationCombo = new Combo(composite, 2048);
        this.locationCombo.setLayoutData((Object)new GridData(768));
        this.locationCombo.addModifyListener(this.modifyListener);
        this.locationCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                NewXMILibraryWizardPage.this.setPageComplete(NewXMILibraryWizardPage.this.isPageComplete());
                NewXMILibraryWizardPage.this.getWizard().getContainer().updateButtons();
            }
        });
        final Shell shell = parent.getShell();
        final Button browseButton = new Button(composite, 0);
        browseButton.setText(XMILibraryUIResources.browseButton_text);
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                try {
                    DirectoryDialog dialog = new DirectoryDialog(shell, 0);
                    String selectedDir = dialog.open();
                    if (selectedDir != null) {
                        NewXMILibraryWizardPage.this.locationCombo.add(selectedDir, 0);
                        NewXMILibraryWizardPage.this.locationCombo.setText(selectedDir);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        new Label(composite, 0);
        final Button defaultPathCheckbox = new Button(composite, 32);
        defaultPathCheckbox.setText(XMILibraryUIResources.defaultPathCheckboxLabel_text);
        defaultPathCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (defaultPathCheckbox.getSelection()) {
                    NewXMILibraryWizardPage.this.locationCombo.removeModifyListener(NewXMILibraryWizardPage.this.modifyListener);
                    NewXMILibraryWizardPage.this.locationCombo.setText(XMILibraryPreferences.getDefaultLibraryPath());
                    NewXMILibraryWizardPage.this.locationCombo.addModifyListener(NewXMILibraryWizardPage.this.modifyListener);
                    NewXMILibraryWizardPage.this.locationCombo.setEnabled(false);
                    browseButton.setEnabled(false);
                } else {
                    NewXMILibraryWizardPage.this.locationCombo.setEnabled(true);
                    browseButton.setEnabled(true);
                }
            }
        });
        this.setPageComplete(true);
        this.setControl((Control)composite);
    }

    public void onEnterPage(Object obj) {
        if (obj != null && obj instanceof String) {
            String libraryName = (String)obj;
            this.nameText.setText(libraryName);
        }
        if (this.getLibraryPath().length() == 0) {
            this.locationCombo.removeModifyListener(this.modifyListener);
            this.locationCombo.setText(XMILibraryPreferences.getDefaultLibraryPath());
            this.locationCombo.addModifyListener(this.modifyListener);
        }
    }

    public boolean isPageComplete() {
        return this.getLibraryPath().length() > 0 && this.getLibraryName().length() > 0;
    }

    public IWizardPage getNextPage() {
        return null;
    }

    public String getLibraryName() {
        return this.nameText.getText().trim();
    }

    public String getLibraryPath() {
        return this.locationCombo.getText().trim();
    }

    public Map getSelections() {
        HashMap<String, String> options = new HashMap<String, String>();
        File libraryPath = new File(this.getLibraryPath(), this.getLibraryName());
        options.put("library.path", libraryPath.getAbsolutePath());
        return options;
    }
}

