/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.ui.xmi.internal.migration;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.util.EContentsEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.epf.common.ui.util.MsgBox;
import org.eclipse.epf.diagram.model.util.GraphicalDataHelper;
import org.eclipse.epf.diagram.model.util.GraphicalDataManager;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.util.ModelStructure;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.layout.LinkInfo;
import org.eclipse.epf.library.ui.xmi.internal.migration.MigrationUtil;
import org.eclipse.epf.library.ui.xmi.internal.migration.Migrator102_103;
import org.eclipse.epf.library.ui.xmi.internal.migration.SelectionDialog;
import org.eclipse.epf.library.util.ResourceUtil;
import org.eclipse.epf.library.xmi.XMILibraryPlugin;
import org.eclipse.epf.library.xmi.XMILibraryResources;
import org.eclipse.epf.persistence.MethodLibraryPersister;
import org.eclipse.epf.persistence.MultiFileResourceSetImpl;
import org.eclipse.epf.persistence.migration.MigrationResourceHandler;
import org.eclipse.epf.persistence.migration.MigratorImpl;
import org.eclipse.epf.persistence.migration.UpgradeCallerInfo;
import org.eclipse.epf.persistence.util.PersistenceResources;
import org.eclipse.epf.persistence.util.PersistenceUtil;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.Diagram;
import org.eclipse.epf.uma.GraphNode;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.MethodPackage;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.Property;
import org.eclipse.epf.uma.RoleDescriptor;
import org.eclipse.epf.uma.SemanticModelBridge;
import org.eclipse.epf.uma.TaskDescriptor;
import org.eclipse.epf.uma.UMASemanticModelBridge;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.VariabilityType;
import org.eclipse.epf.uma.ecore.impl.MultiResourceEObject;
import org.eclipse.epf.uma.util.UmaUtil;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class Migrator102
extends MigratorImpl {
    private static final boolean DEBUG = XMILibraryPlugin.getDefault().isDebugging();
    private Collection proxiesToRemove = new ArrayList();
    private Map proxyToFileMap = new HashMap();
    private HashMap proxyToFileWithLoadErrorMap = new HashMap();
    private ArrayList notFoundProxies = new ArrayList();
    private ArrayList proxiesWithUnnormalizedURI = new ArrayList();
    private MethodLibrary lib;
    private MigrationResourceHandler resourceHandler = new MigrationResourceHandler(){

        protected boolean handleUnknownFeature(EObject owner, EStructuralFeature feature, Object value) {
            if (owner instanceof RoleDescriptor && "performsAsOwner".equals(feature.getName()) && value != null) {
                ArrayList<String> GUIDs = new ArrayList<String>();
                StringTokenizer tokens = new StringTokenizer((String)value);
                while (tokens.hasMoreTokens()) {
                    GUIDs.add(tokens.nextToken());
                }
                if (GUIDs.size() > 1) {
                    Activity act = ((RoleDescriptor)owner).getSuperActivities();
                    Diagram add = GraphicalDataManager.getInstance().getUMADiagram(act, 2, false);
                    if (add != null) {
                        Object graphNode;
                        HashMap<String, GraphNode> tdGuidToGraphNodeMap = new HashMap<String, GraphNode>();
                        int size = add.getContained().size();
                        int i = 0;
                        while (i < size) {
                            List list;
                            Property property;
                            MethodElement me;
                            SemanticModelBridge bridge;
                            Object element = add.getContained().get(i);
                            if (element instanceof GraphNode && (bridge = (graphNode = (GraphNode)element).getSemanticModel()) instanceof UMASemanticModelBridge && (me = ((UMASemanticModelBridge)bridge).getElement()) instanceof TaskDescriptor && (property = GraphicalDataHelper.getPropertyByKey((List)(list = graphNode.getList(12)), (String)"wpCompositeType")) == null) {
                                tdGuidToGraphNodeMap.put(me.getGuid(), (GraphNode)graphNode);
                            }
                            ++i;
                        }
                        ArrayList<GraphNode> graphNodes = new ArrayList<GraphNode>();
                        int i2 = 0;
                        while (i2 < GUIDs.size()) {
                            graphNode = tdGuidToGraphNodeMap.get(GUIDs.get(i2));
                            if (graphNode != null) {
                                graphNodes.add((GraphNode)graphNode);
                            }
                            ++i2;
                        }
                        add.getContained().removeAll(graphNodes);
                        add.getContained().addAll(graphNodes);
                    }
                }
            }
            return true;
        }
    };
    private static final String FILE_PATH = XMILibraryResources.filePath;

    private static void updateStatus(IProgressMonitor monitor, String msg) {
        if (monitor != null) {
            monitor.subTask(msg);
            monitor.worked(1);
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
        } else {
            System.out.println(msg);
        }
    }

    public void migrate(String libPath, IProgressMonitor monitor) throws Exception {
        this.migrate(libPath, monitor, null);
    }

    public void migrate(String libPath, IProgressMonitor monitor, UpgradeCallerInfo info) throws Exception {
        this.initMigrate();
        File libFile = new File(libPath);
        boolean toVerify = true;
        if (info != null && info.getIsExportedPluginLib()) {
            toVerify = false;
        }
        ResourceUtil.open((String)libFile.getParent(), (IProgressMonitor)monitor);
        MultiFileResourceSetImpl resourceSet = null;
        try {
            Display dis;
            this.setOldDefaultValues();
            Migrator102.updateStatus(monitor, PersistenceResources.loadLibraryTask_name);
            resourceSet = toVerify ? new MultiFileResourceSetImpl(false) : PersistenceUtil.getImportPluginResourceSet();
            resourceSet.getLoadOptions().put("RECORD_UNKNOWN_FEATURE", Boolean.TRUE);
            resourceSet.getLoadOptions().put("RESOURCE_HANDLER", this.resourceHandler);
            this.lib = resourceSet.loadLibrary(libPath);
            this.removeProcessContributions(monitor);
            if (toVerify) {
                dis = Display.getDefault();
                if (dis == null || dis.getThread() == Thread.currentThread()) {
                    this.verify();
                } else {
                    dis.syncExec(new Runnable(){

                        public void run() {
                            Migrator102.this.verify();
                        }
                    });
                }
                this.removeUnresolvedReferences(monitor);
            }
            if (this instanceof Migrator102_103) {
                LinkInfo.setLibrary((MethodLibrary)this.lib);
            }
            Migrator102.updateStatus(monitor, PersistenceResources.loadResourcesTask_name);
            TreeIterator iter = this.lib.eAllContents();
            while (iter.hasNext()) {
                EObject element;
                block17: {
                    element = (EObject)iter.next();
                    if (!(element instanceof MethodElement)) continue;
                    try {
                        Iterator iterator = element.eCrossReferences().iterator();
                        while (iterator.hasNext()) {
                            iterator.next();
                        }
                    }
                    catch (Exception e) {
                        CommonPlugin.INSTANCE.log((Object)e);
                        if (!DEBUG) break block17;
                        System.err.println("Error iterate thru cross references of element: " + element);
                    }
                }
                this.update((MethodElement)element, monitor);
            }
            this.handleConverToSynFree(monitor, info, this.lib);
            this.removeOldDefaultValues();
            dis = Display.getDefault();
            if (dis == null || dis.getThread() == Thread.currentThread()) {
                this.checkModifiedResources();
            } else {
                dis.syncExec(new Runnable(){

                    public void run() {
                        Migrator102.this.checkModifiedResources();
                    }
                });
            }
            Migrator102.updateStatus(monitor, PersistenceResources.saveLibraryTask_name);
            Map saveOptions = resourceSet.getDefaultSaveOptions();
            if (toVerify) {
                saveOptions.put("DISCARD_UNRESOLVED_REFERENCES", Boolean.TRUE);
            }
            resourceSet.save(saveOptions, true);
            Migrator102.updateStatus(monitor, PersistenceResources.refreshLibraryFilesTask_name);
            ResourceUtil.refreshResources((MethodLibrary)this.lib, (IProgressMonitor)monitor);
            this.migrateDiagram(monitor);
        }
        finally {
            if (this instanceof Migrator102_103) {
                LinkInfo.setLibrary(null);
            }
            if (resourceSet != null) {
                resourceSet.reset();
                resourceSet = null;
            }
        }
    }

    private void removeProcessContributions(IProgressMonitor monitor) {
        for (MethodPlugin plugin : this.lib.getMethodPlugins()) {
            MethodPackage pkg = UmaUtil.findMethodPackage((MethodPlugin)plugin, (String[])ModelStructure.DEFAULT.processContributionPath);
            if (pkg == null) continue;
            for (MethodPackage childPkg : new ArrayList(pkg.getChildPackages())) {
                ResourceSet resourceSet;
                Resource.Internal resource;
                block4: {
                    resource = ((InternalEObject)childPkg).eDirectResource();
                    if (resource == null) continue;
                    resourceSet = resource.getResourceSet();
                    try {
                        MethodLibraryPersister.INSTANCE.delete((MethodElement)pkg);
                    }
                    catch (Exception e) {
                        if (!DEBUG) break block4;
                        e.printStackTrace();
                    }
                }
                if (resourceSet == null) continue;
                resourceSet.getResources().remove((Object)resource);
            }
            pkg.getChildPackages().clear();
        }
    }

    private void checkModifiedResources() {
        block2: {
            MultiStatus status;
            String msg;
            String title;
            ErrorDialog errDlg;
            do {
                ResourceSet resourceSet = this.lib.eResource().getResourceSet();
                ArrayList<Resource> readOnlyResources = new ArrayList<Resource>();
                String pluginId = XMILibraryPlugin.getDefault().getId();
                status = new MultiStatus(pluginId, 0, XMILibraryResources.cannotWriteToFiles, null);
                for (Resource resource : resourceSet.getResources()) {
                    File file = new File(resource.getURI().toFileString());
                    if (!file.exists() || file.canWrite()) continue;
                    readOnlyResources.add(resource);
                    status.add((IStatus)new Status(4, pluginId, 0, file.toString(), null));
                }
                if (status.isOK()) break block2;
                title = XMILibraryResources.readOnlyFiles_title;
                msg = XMILibraryResources.readOnlyFiles_msg;
            } while ((errDlg = new ErrorDialog(MsgBox.getDefaultShell(), title, msg, (IStatus)status, 7){

                protected void createButtonsForButtonBar(Composite parent) {
                    this.createButton(parent, 0, IDialogConstants.RETRY_LABEL, true);
                    this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
                    this.createDetailsButton(parent);
                }

                public int open() {
                    this.showDetailsArea();
                    return super.open();
                }
            }).open() != 1);
            throw new OperationCanceledException();
        }
    }

    private void removeUnresolvedReferences(IProgressMonitor monitor) {
        if (this.proxiesToRemove.isEmpty()) {
            return;
        }
        HashSet<String> GUIDs = new HashSet<String>();
        for (InternalEObject proxy : this.proxiesToRemove) {
            GUIDs.add(proxy.eProxyURI().fragment());
            EcoreUtil.remove((EObject)proxy);
        }
        TreeIterator iter = this.lib.eAllContents();
        while (iter.hasNext()) {
            EObject element = (EObject)iter.next();
            EContentsEList.FeatureIterator iterator = (EContentsEList.FeatureIterator)element.eCrossReferences().iterator();
            while (iterator.hasNext()) {
                EStructuralFeature feature;
                InternalEObject obj = (InternalEObject)iterator.next();
                if (!obj.eIsProxy() || !GUIDs.contains(obj.eProxyURI().fragment()) || !(feature = iterator.feature()).isChangeable() || feature.isDerived()) continue;
                if (feature.isMany()) {
                    ((List)element.eGet(feature)).remove(obj);
                    continue;
                }
                element.eSet(feature, null);
            }
        }
    }

    private void verify() {
        Iterator iter;
        Object[] objs;
        SelectionDialog dlg;
        String msg;
        AdapterFactoryLabelProvider labelProvider;
        ArrayList list;
        this.notFoundProxies.clear();
        this.proxiesToRemove.clear();
        this.proxyToFileMap.clear();
        this.proxyToFileWithLoadErrorMap.clear();
        this.proxiesWithUnnormalizedURI.clear();
        Collection proxies = PersistenceUtil.getProxies((EObject)this.lib);
        if (!proxies.isEmpty()) {
            ResourceSet resourceSet = this.lib.eResource().getResourceSet();
            URIConverter uriConverter = resourceSet.getURIConverter();
            for (InternalEObject proxy : proxies) {
                URI uri = proxy.eProxyURI();
                URI normalizedURI = uriConverter.normalize(uri);
                if (normalizedURI == null) {
                    this.proxiesWithUnnormalizedURI.add(proxy);
                    continue;
                }
                File file = new File(normalizedURI.toFileString());
                if (!file.exists()) {
                    this.proxyToFileMap.put(proxy, file);
                    continue;
                }
                try {
                    Resource resource = resourceSet.getResource(normalizedURI.trimFragment(), true);
                    if (resource.getEObject(normalizedURI.fragment()) != null) continue;
                    this.notFoundProxies.add(proxy);
                }
                catch (Exception e) {
                    String errMsg = e.getMessage() != null ? e.getMessage() : e.toString();
                    this.proxyToFileWithLoadErrorMap.put(proxy, new Object[]{file, errMsg});
                }
            }
        }
        if (!this.proxyToFileMap.isEmpty()) {
            list = new ArrayList(this.proxyToFileMap.keySet());
            String ELEMENT_PATH = XMILibraryResources.elementPath;
            labelProvider = new AdapterFactoryLabelProvider((AdapterFactory)TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory()){

                public String getText(Object object) {
                    File file = (File)Migrator102.this.proxyToFileMap.get(object);
                    return String.valueOf(file.getAbsolutePath()) + " (" + TngUtil.getLabelWithPath((Object)object) + ')';
                }

                public String getColumnText(Object object, int columnIndex) {
                    switch (columnIndex) {
                        case 0: {
                            return Migrator102.this.proxyToFileMap.get(object).toString();
                        }
                        case 1: {
                            return TngUtil.getLabelWithPath((Object)object);
                        }
                    }
                    return null;
                }
            };
            try {
                msg = XMILibraryResources.promptRemoveReferencesToMissingFiles_msg;
                dlg = new SelectionDialog(MsgBox.getDefaultShell(), list, (ILabelProvider)labelProvider, msg);
                dlg.setTitle(XMILibraryResources.missingFiles_title);
                dlg.setBlockOnOpen(true);
                dlg.setInitialElementSelections(list);
                dlg.setColumnProperties(new String[]{FILE_PATH, ELEMENT_PATH});
                if (dlg.open() == 1) {
                    throw new OperationCanceledException();
                }
                objs = dlg.getResult();
                if (objs == null) {
                    throw new OperationCanceledException();
                }
                iter = list.iterator();
                while (iter.hasNext()) {
                    this.proxiesToRemove.add(iter.next());
                }
            }
            finally {
                labelProvider.dispose();
            }
        }
        if (!this.proxyToFileWithLoadErrorMap.isEmpty()) {
            list = new ArrayList(this.proxyToFileWithLoadErrorMap.keySet());
            String LOAD_ERROR = XMILibraryResources.loadError;
            labelProvider = new AdapterFactoryLabelProvider((AdapterFactory)TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory()){

                public String getColumnText(Object object, int columnIndex) {
                    Object[] arr = (Object[])Migrator102.this.proxyToFileMap.get(object);
                    if (columnIndex < 2) {
                        return arr[columnIndex].toString();
                    }
                    return null;
                }
            };
            try {
                msg = XMILibraryResources.promptRemoveReferencesToFilesWithLoadErrors_msg;
                dlg = new SelectionDialog(MsgBox.getDefaultShell(), list, (ILabelProvider)labelProvider, msg);
                dlg.setTitle(XMILibraryResources.filesWithLoadErrors_title);
                dlg.setBlockOnOpen(true);
                dlg.setInitialElementSelections(list);
                dlg.setColumnProperties(new String[]{FILE_PATH, LOAD_ERROR});
                if (dlg.open() == 1) {
                    throw new OperationCanceledException();
                }
                objs = dlg.getResult();
                if (objs == null) {
                    throw new OperationCanceledException();
                }
                iter = list.iterator();
                while (iter.hasNext()) {
                    this.proxiesToRemove.add(iter.next());
                }
            }
            finally {
                labelProvider.dispose();
            }
        }
        ArrayList proxiesToRetain = new ArrayList();
        proxies.addAll(this.proxyToFileMap.keySet());
        proxies.addAll(this.proxyToFileWithLoadErrorMap.keySet());
        proxies.removeAll(this.proxiesToRemove);
        if (proxiesToRetain.isEmpty()) {
            this.proxiesToRemove.addAll(this.notFoundProxies);
            this.proxiesToRemove.addAll(this.proxiesWithUnnormalizedURI);
        }
        String msg2 = "Summary of unresolved proxies:";
        msg2 = String.valueOf(msg2) + "\n  Not found proxies: " + this.notFoundProxies;
        msg2 = String.valueOf(msg2) + "\n  Proxies with unnormalized URI: " + this.proxiesWithUnnormalizedURI;
        XMILibraryPlugin.getDefault().getLogger().logInfo(msg2);
    }

    private void removeOldDefaultValues() {
        MultiResourceEObject.removeDefaultValue((EStructuralFeature)UmaPackage.eINSTANCE.getMethodPlugin_UserChangeable());
    }

    private void adjustToNewDefaultValues(MethodElement e) {
        if (e instanceof MethodPlugin) {
            ((MultiResourceEObject)e).removeFeatureWithOverridenDefaultValue((EStructuralFeature)UmaPackage.eINSTANCE.getMethodPlugin_UserChangeable());
        }
    }

    private void setOldDefaultValues() {
        MultiResourceEObject.setDefaultValue((EStructuralFeature)UmaPackage.eINSTANCE.getMethodPlugin_UserChangeable(), (Object)Boolean.FALSE);
    }

    protected void update(MethodElement e, IProgressMonitor monitor) throws Exception {
        this.adjustToNewDefaultValues(e);
        if (e instanceof Activity) {
            Activity act = (Activity)e;
            VariabilityType type = act.getVariabilityType();
            if (type == VariabilityType.CONTRIBUTES) {
                act.setVariabilityType(VariabilityType.LOCAL_CONTRIBUTION);
            } else if (type == VariabilityType.REPLACES) {
                act.setVariabilityType(VariabilityType.LOCAL_REPLACEMENT);
            }
        }
        if (!(this instanceof Migrator102_103)) {
            MigrationUtil.formatValue(e);
        }
    }

    protected void initMigrate() {
    }

    protected void migrateDiagram(IProgressMonitor monitor) throws Exception {
    }

    protected void handleConverToSynFree(IProgressMonitor monitor, UpgradeCallerInfo info, MethodLibrary lib) {
        throw new UnsupportedOperationException();
    }
}

