/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.ui.xmi.internal.migration;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.epf.common.utils.FileUtil;
import org.eclipse.epf.common.utils.NetUtil;
import org.eclipse.epf.library.edit.util.ExtensionManager;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.layout.LinkInfo;
import org.eclipse.epf.library.ui.xmi.internal.migration.MigrationUtil;
import org.eclipse.epf.library.ui.xmi.internal.migration.MigratorBase;
import org.eclipse.epf.library.util.LibraryUtil;
import org.eclipse.epf.library.util.ResourceUtil;
import org.eclipse.epf.library.xmi.IDiagramMigration;
import org.eclipse.epf.library.xmi.XMILibraryPlugin;
import org.eclipse.epf.library.xmi.XMILibraryResources;
import org.eclipse.epf.persistence.MultiFileResourceSetImpl;
import org.eclipse.epf.persistence.migration.UpgradeCallerInfo;
import org.eclipse.epf.persistence.util.PersistenceResources;
import org.eclipse.epf.persistence.util.PersistenceUtil;
import org.eclipse.epf.uma.CapabilityPattern;
import org.eclipse.epf.uma.ContentDescription;
import org.eclipse.epf.uma.DeliveryProcess;
import org.eclipse.epf.uma.DescribableElement;
import org.eclipse.epf.uma.Example;
import org.eclipse.epf.uma.Guidance;
import org.eclipse.epf.uma.GuidanceDescription;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.Process;
import org.eclipse.epf.uma.ProcessComponent;
import org.eclipse.epf.uma.ReusableAsset;
import org.eclipse.epf.uma.UmaFactory;
import org.eclipse.epf.uma.Whitepaper;
import org.eclipse.epf.uma.util.UmaUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Migrator103
extends MigratorBase {
    private Map<String, Process> diagramElemMap;
    private static boolean xmlMigrate = false;

    @Override
    public void migrate(String libPath, IProgressMonitor monitor) throws Exception {
        this.migrate(libPath, monitor, null);
    }

    @Override
    public void migrate(String libPath, IProgressMonitor monitor, UpgradeCallerInfo info) throws Exception {
        this.setCallerInfo(info);
        File libFile = new File(libPath);
        boolean toVerify = true;
        if (info != null && info.getIsExportedPluginLib()) {
            toVerify = false;
        }
        xmlMigrate = false;
        ResourceUtil.open((String)libFile.getParent(), (IProgressMonitor)monitor);
        MultiFileResourceSetImpl resourceSet = null;
        this.diagramElemMap = new LinkedHashMap<String, Process>();
        try {
            Migrator103.updateStatus(monitor, PersistenceResources.loadLibraryTask_name);
            resourceSet = toVerify ? new MultiFileResourceSetImpl(false) : PersistenceUtil.getImportPluginResourceSet();
            resourceSet.getLoadOptions().put("RECORD_UNKNOWN_FEATURE", Boolean.TRUE);
            MethodLibrary lib = resourceSet.loadLibrary(libPath);
            LinkInfo.setLibrary((MethodLibrary)lib);
            Migrator103.updateStatus(monitor, PersistenceResources.loadResourcesTask_name);
            this.updateAllContents(monitor, lib);
            Migrator103.updateStatus(monitor, PersistenceResources.saveLibraryTask_name);
            Map saveOptions = resourceSet.getDefaultSaveOptions();
            resourceSet.save(saveOptions, true);
            Migrator103.updateStatus(monitor, PersistenceResources.refreshLibraryFilesTask_name);
            ResourceUtil.refreshResources((MethodLibrary)lib, (IProgressMonitor)monitor);
            Migrator103.diagramMigrate(this.diagramElemMap, monitor);
            ResourceUtil.refreshResources((MethodLibrary)lib, (IProgressMonitor)monitor);
        }
        finally {
            LinkInfo.setLibrary(null);
            if (resourceSet != null) {
                resourceSet.reset();
                resourceSet = null;
            }
        }
    }

    protected static void diagramMigrate(Map<String, Process> diagramElemMap, IProgressMonitor monitor) {
        Migrator103.updateStatus(monitor, PersistenceResources.migratingDiagram_name);
        IDiagramMigration idm = (IDiagramMigration)ExtensionManager.getExtension((String)"org.eclipse.epf.library.xmi", (String)"diagramMigration");
        if (idm != null && !diagramElemMap.isEmpty()) {
            try {
                idm.migrate(diagramElemMap.values());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    protected void updateElement(MethodElement element, IProgressMonitor monitor) throws Exception {
        Migrator103.updateElement(element, this.diagramElemMap, monitor);
    }

    protected static void updateElement(MethodElement element, Map<String, Process> diagramElemMap, IProgressMonitor monitor) throws Exception {
        Process process;
        if (diagramElemMap != null && (element instanceof CapabilityPattern || element instanceof DeliveryProcess) && (process = (Process)element).eContainer() instanceof ProcessComponent) {
            String guid = element.getGuid();
            Process proc = diagramElemMap.get(guid);
            if (proc == null) {
                diagramElemMap.put(element.getGuid(), (Process)element);
            } else assert (proc == element);
        }
        MigrationUtil.formatValue(element);
        Migrator103.handleTypeConvert(element);
        if (!xmlMigrate) {
            Migrator103.handleShapeAndNodeIcons(element);
        }
    }

    private static void handleTypeConvert(MethodElement element) throws Exception {
        Guidance guidance;
        GuidanceDescription pres;
        if ((element instanceof Example || element instanceof ReusableAsset || element instanceof Whitepaper) && (pres = Migrator103.convert((guidance = (Guidance)element).getPresentation())) != null) {
            guidance.setPresentation((ContentDescription)pres);
        }
    }

    private static GuidanceDescription convert(ContentDescription oldObj) {
        List features;
        if (oldObj == null) {
            return null;
        }
        GuidanceDescription newObj = UmaFactory.eINSTANCE.createGuidanceDescription();
        Resource res = oldObj.eResource();
        if (res != null) {
            res.getContents().remove((Object)oldObj);
            res.getContents().add((Object)newObj);
        }
        if ((features = LibraryUtil.getStructuralFeatures((MethodElement)oldObj)) != null) {
            int i = 0;
            while (i < features.size()) {
                EStructuralFeature feature = (EStructuralFeature)features.get(i);
                Object value = oldObj.eGet(feature);
                newObj.eSet(feature, value);
                ++i;
            }
        }
        return newObj;
    }

    private static void handleShapeAndNodeIcons(MethodElement element) throws Exception {
        if (element instanceof DescribableElement) {
            DescribableElement describableElement = (DescribableElement)element;
            URI fixedURI = Migrator103.fixIconURI(describableElement, describableElement.getShapeicon());
            if (fixedURI != null) {
                describableElement.setShapeicon(fixedURI);
            }
            if ((fixedURI = Migrator103.fixIconURI(describableElement, describableElement.getNodeicon())) != null) {
                describableElement.setNodeicon(fixedURI);
            }
        }
    }

    private static URI fixIconURI(DescribableElement e, URI uri) {
        if (uri == null) {
            return null;
        }
        File path = new File(NetUtil.decodedFileUrl((String)uri.toString()));
        Stack<String> stack = new Stack<String>();
        File temp = path;
        String resultPath = "";
        while (temp != null) {
            stack.push(temp.getName());
            temp = temp.getParentFile();
        }
        if (!stack.isEmpty()) {
            String pluginName = (String)stack.pop();
            while (!stack.isEmpty()) {
                if (resultPath.length() > 0) {
                    resultPath = String.valueOf(resultPath) + '/';
                }
                resultPath = String.valueOf(resultPath) + (String)stack.pop();
            }
            MethodPlugin plugin = UmaUtil.getMethodPlugin((EObject)e);
            try {
                URI resultURI = new URI(resultPath);
                if (!pluginName.equals(plugin.getName())) {
                    File libRoot = TngUtil.getLibraryRootPath((EObject)e);
                    File oldFile = new File(libRoot, NetUtil.decodedFileUrl((String)uri.toString()));
                    File newFile = new File(libRoot, String.valueOf(plugin.getName()) + File.separator + NetUtil.decodedFileUrl((String)resultURI.toString()));
                    if (!newFile.exists()) {
                        FileUtil.copyFile((File)oldFile, (File)newFile);
                    }
                }
                return resultURI;
            }
            catch (URISyntaxException ex) {
                XMILibraryPlugin.getDefault().getLogger().logError((Throwable)ex);
                return null;
            }
        }
        return null;
    }

    public void migrateXmlImportedLib(MethodLibrary lib, IProgressMonitor monitor) throws Exception {
        xmlMigrate = true;
        Migrator103.updateStatus(monitor, XMILibraryResources.migrateXMLLibrary_taskName);
        this.updateAllContents(monitor, lib);
        LibraryUtil.saveLibrary((MethodLibrary)lib, (boolean)false, (boolean)false);
        xmlMigrate = false;
    }
}

