/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.ui.xmi.internal.migration;

import java.util.Iterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.epf.library.xmi.XMILibraryPlugin;
import org.eclipse.epf.persistence.migration.MigratorImpl;
import org.eclipse.epf.persistence.migration.UpgradeCallerInfo;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodLibrary;

public abstract class MigratorBase
extends MigratorImpl {
    private UpgradeCallerInfo callerInfo;
    protected static final boolean DEBUG = XMILibraryPlugin.getDefault().isDebugging();

    public UpgradeCallerInfo getCallerInfo() {
        return this.callerInfo;
    }

    public void setCallerInfo(UpgradeCallerInfo callerInfo) {
        this.callerInfo = callerInfo;
    }

    protected static void updateStatus(IProgressMonitor monitor, String msg) {
        if (monitor != null) {
            monitor.subTask(msg);
            monitor.worked(1);
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
        } else {
            System.out.println(msg);
        }
    }

    protected void updateAllContents(IProgressMonitor monitor, MethodLibrary lib) throws Exception {
        TreeIterator iter = lib.eAllContents();
        while (iter.hasNext()) {
            EObject element;
            block4: {
                element = (EObject)iter.next();
                if (!(element instanceof MethodElement)) continue;
                try {
                    Iterator iterator = element.eCrossReferences().iterator();
                    while (iterator.hasNext()) {
                        iterator.next();
                    }
                }
                catch (Exception e) {
                    CommonPlugin.INSTANCE.log((Object)e);
                    if (!DEBUG) break block4;
                    System.err.println("Error iterate thru cross references of element: " + element);
                }
            }
            this.updateElement((MethodElement)element, monitor);
        }
    }

    protected abstract void updateElement(MethodElement var1, IProgressMonitor var2) throws Exception;

    public abstract void migrate(String var1, IProgressMonitor var2) throws Exception;

    public abstract void migrate(String var1, IProgressMonitor var2, UpgradeCallerInfo var3) throws Exception;
}

