/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.ui;

import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

public class BusyIndicatorHelper {
    static int nextBusyId = 1;
    static final String BUSYID_NAME = "SWT BusyIndicator";
    static final String BUSY_CURSOR = "SWT BusyIndicator Cursor";

    public static Integer showWhile(Display display) {
        if (display == null) {
            return null;
        }
        Integer busyId = new Integer(nextBusyId);
        ++nextBusyId;
        Cursor cursor = display.getSystemCursor(1);
        Shell[] shells = display.getShells();
        int i = 0;
        while (i < shells.length) {
            Integer id = (Integer)shells[i].getData(BUSYID_NAME);
            if (id == null) {
                shells[i].setCursor(cursor);
                shells[i].setData(BUSYID_NAME, (Object)busyId);
            }
            ++i;
        }
        return busyId;
    }

    public static void hideWhile(Display display, Integer busyId) {
        if (display == null) {
            return;
        }
        Shell[] shells = display.getShells();
        int i = 0;
        while (i < shells.length) {
            Integer id = (Integer)shells[i].getData(BUSYID_NAME);
            if (id == busyId) {
                shells[i].setCursor(null);
                shells[i].setData(BUSYID_NAME, null);
            }
            ++i;
        }
    }

    public static void setUserInterfaceActive(boolean active) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        Shell[] shells = workbench.getDisplay().getShells();
        if (active) {
            int i = 0;
            while (i < shells.length) {
                shells[i].setEnabled(active);
                ++i;
            }
        } else {
            int i = shells.length - 1;
            while (i >= 0) {
                shells[i].setEnabled(active);
                --i;
            }
        }
    }
}

