/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.ui.actions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.epf.library.ILibraryServiceListener;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.LibraryServiceUtil;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.util.Comparators;
import org.eclipse.epf.library.edit.util.DebugUtil;
import org.eclipse.epf.library.prefs.PreferenceUtil;
import org.eclipse.epf.library.ui.LibraryUIResources;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.CoolBar;
import org.eclipse.swt.widgets.CoolItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class ConfigurationContributionItem
extends ContributionItem {
    private static Combo configCombo;
    private static ComboViewer configComboViewer;
    protected ToolItem item;
    protected CoolItem coolItem;
    protected ILibraryServiceListener libSvcListener;
    protected IStructuredContentProvider contentProvider;
    protected ILabelProvider labelProvider;
    protected ISelectionChangedListener postSelectionChangedListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            ConfigurationContributionItem.performSelectionChanged(ConfigurationContributionItem.this.getCollapseConfigViewAction());
        }
    };
    private boolean libSvcListenerAdded = false;
    private IAction collapseConfigViewAction;

    public ConfigurationContributionItem(IAction action) {
    }

    public void fill(ToolBar parent, int index) {
        int start;
        this.item = new ToolItem(parent, 2);
        int i = start = parent.getItemCount();
        while (i < start + 1) {
            ToolItem item = new ToolItem(parent, 2048);
            item.setText(" ");
            ++i;
        }
        Control box = this.createControl((Composite)parent);
        this.item.setControl(box);
        this.item.setWidth(240);
    }

    public void fill(CoolBar coolBar, int index) {
        Control box = this.createControl((Composite)coolBar);
        this.coolItem = index >= 0 ? new CoolItem(coolBar, 4, index) : new CoolItem(coolBar, 4);
        this.coolItem.setData((Object)this);
        this.coolItem.setControl(box);
        Point toolBarSize = box.computeSize(-1, -1);
        this.coolItem.setMinimumSize(toolBarSize);
        this.coolItem.setPreferredSize(toolBarSize);
        this.coolItem.setSize(toolBarSize);
    }

    public void fill(Composite parent) {
        this.createControl(parent);
    }

    private Control createControl(Composite parent) {
        configCombo = new Combo(parent, 12);
        configCombo.setVisibleItemCount(10);
        configCombo.setEnabled(true);
        configComboViewer = new ComboViewer(configCombo){

            protected void handleDispose(DisposeEvent event) {
                super.handleDispose(event);
                if (ConfigurationContributionItem.this.libSvcListener != null) {
                    LibraryService.getInstance().removeListener(ConfigurationContributionItem.this.libSvcListener);
                }
                if (ConfigurationContributionItem.this.postSelectionChangedListener != null) {
                    this.removePostSelectionChangedListener(ConfigurationContributionItem.this.postSelectionChangedListener);
                }
                if (!this.getCombo().isDisposed()) {
                    IStructuredContentProvider c = new IStructuredContentProvider(){

                        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                        }

                        public Object[] getElements(Object inputElement) {
                            return new Object[0];
                        }

                        public void dispose() {
                        }
                    };
                    this.setContentProvider((IContentProvider)c);
                }
            }
        };
        this.contentProvider = new AdapterFactoryContentProvider((AdapterFactory)TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory()){

            public Object[] getElements(Object object) {
                ArrayList<Object> configsList = new ArrayList<Object>();
                configsList.addAll(Arrays.asList(LibraryServiceUtil.getMethodConfigurations((MethodLibrary)LibraryService.getInstance().getCurrentMethodLibrary())));
                Collections.sort(configsList, Comparators.DEFAULT_COMPARATOR);
                if (LibraryService.getInstance().getCurrentMethodConfiguration() == null) {
                    configsList.add(0, LibraryUIResources.selectConfigLabel_text);
                }
                return configsList.toArray();
            }
        };
        this.labelProvider = new AdapterFactoryLabelProvider((AdapterFactory)TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory()){

            public String getText(Object object) {
                if (object instanceof String) {
                    return (String)object;
                }
                if (object instanceof MethodConfiguration) {
                    return ((MethodConfiguration)object).getName();
                }
                return object.toString();
            }
        };
        configComboViewer.setContentProvider((IContentProvider)this.contentProvider);
        configComboViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        configComboViewer.setInput((Object)LibraryService.getInstance().getCurrentMethodLibrary());
        this.setInputDebugLog("createControl", LibraryService.getInstance().getCurrentMethodLibrary());
        String savedConfigName = PreferenceUtil.getSavedLastConfig();
        MethodConfiguration savedConfig = LibraryServiceUtil.getMethodConfiguration((MethodLibrary)LibraryService.getInstance().getCurrentMethodLibrary(), (String)savedConfigName);
        if (savedConfig != null) {
            configComboViewer.setSelection((ISelection)new StructuredSelection((Object)savedConfig));
        } else {
            configComboViewer.setSelection((ISelection)new StructuredSelection((Object)LibraryUIResources.selectConfigLabel_text));
        }
        configComboViewer.addPostSelectionChangedListener(this.postSelectionChangedListener);
        configComboViewer.getControl().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                ConfigurationContributionItem.this.dispose();
            }
        });
        this.libSvcListener = new ILibraryServiceListener(){

            public void configurationSet(MethodConfiguration config) {
                configComboViewer.removePostSelectionChangedListener(ConfigurationContributionItem.this.postSelectionChangedListener);
                if (configComboViewer.getCombo().isDisposed()) {
                    return;
                }
                try {
                    ConfigurationContributionItem.selectConfiguration(config);
                }
                finally {
                    configComboViewer.addPostSelectionChangedListener(ConfigurationContributionItem.this.postSelectionChangedListener);
                }
            }

            public void libraryClosed(MethodLibrary library) {
                if (configComboViewer.getCombo().isDisposed()) {
                    return;
                }
                configComboViewer.setInput(null);
                ConfigurationContributionItem.this.setInputDebugLog("libraryClosed", null);
            }

            public void libraryCreated(MethodLibrary library) {
                if (configComboViewer.getCombo().isDisposed()) {
                    return;
                }
                configComboViewer.setInput((Object)library);
                ConfigurationContributionItem.this.setInputDebugLog("libraryCreated", library);
                ConfigurationContributionItem.selectConfiguration(null);
            }

            public void libraryOpened(MethodLibrary library) {
                if (configComboViewer.getCombo().isDisposed()) {
                    return;
                }
                configComboViewer.setInput((Object)library);
                ConfigurationContributionItem.refresh();
                ConfigurationContributionItem.this.setInputDebugLog("libraryOpened", library);
                MethodConfiguration config = LibraryService.getInstance().getCurrentMethodConfiguration();
                configComboViewer.setSelection((ISelection)new StructuredSelection(config != null ? config : LibraryUIResources.selectConfigLabel_text), true);
            }

            public void libraryReopened(MethodLibrary library) {
                if (configComboViewer.getCombo().isDisposed()) {
                    return;
                }
                if (library != configComboViewer.getInput()) {
                    configComboViewer.setInput((Object)library);
                    ConfigurationContributionItem.refresh();
                    ConfigurationContributionItem.this.setInputDebugLog("libraryReopened", library);
                }
            }

            public void librarySet(MethodLibrary library) {
                if (configComboViewer.getCombo().isDisposed()) {
                    return;
                }
                if (library != configComboViewer.getInput()) {
                    configComboViewer.setInput((Object)library);
                    if (library == null) {
                        ConfigurationContributionItem.selectConfiguration(null);
                    } else {
                        ConfigurationContributionItem.refresh();
                    }
                    ConfigurationContributionItem.this.setInputDebugLog("librarySet", library);
                }
            }
        };
        LibraryService.getInstance().addListener(this.libSvcListener);
        if (DebugUtil.uiDebug) {
            DebugUtil.print((String)"libSvcListener added at createControl");
            DebugUtil.print();
        }
        this.libSvcListenerAdded = true;
        return configCombo;
    }

    public void setVisible(boolean visible) {
        if (this.libSvcListener == null) {
            return;
        }
        if (visible && !this.libSvcListenerAdded && !configCombo.isDisposed()) {
            LibraryService.getInstance().addListener(this.libSvcListener);
            if (DebugUtil.uiDebug) {
                DebugUtil.print((String)"libSvcListener added at setVisible");
                DebugUtil.print();
            }
        } else if (!visible || configCombo.isDisposed()) {
            LibraryService.getInstance().removeListener(this.libSvcListener);
            this.libSvcListenerAdded = false;
            if (DebugUtil.uiDebug) {
                DebugUtil.print((String)"libSvcListener removed at setVisible");
                DebugUtil.print();
            }
        }
        super.setVisible(visible);
    }

    private static MethodConfiguration getSelectedConfig() {
        IStructuredSelection selection = (IStructuredSelection)configComboViewer.getSelection();
        Object object = selection.getFirstElement();
        if (object instanceof MethodConfiguration) {
            return (MethodConfiguration)object;
        }
        return null;
    }

    private static String getCurrentSelectedConfigName() {
        IStructuredSelection selection = (IStructuredSelection)configComboViewer.getSelection();
        Object object = selection.getFirstElement();
        if (object != null && object instanceof MethodConfiguration) {
            return ((MethodConfiguration)object).getName();
        }
        if (object instanceof String) {
            return (String)object;
        }
        return "";
    }

    private static void performSelectionChanged(IAction collapseConfigViewAction) {
        if (LibraryService.getInstance().getCurrentMethodLibrary() != null) {
            MethodConfiguration config = ConfigurationContributionItem.getSelectedConfig();
            if (config != LibraryService.getInstance().getCurrentMethodConfiguration()) {
                if (collapseConfigViewAction != null) {
                    collapseConfigViewAction.run();
                }
                LibraryService.getInstance().setCurrentMethodConfiguration(config);
            }
            PreferenceUtil.saveSelectedConfigIntoPersistence((String)ConfigurationContributionItem.getCurrentSelectedConfigName());
            ConfigurationContributionItem.refresh();
        }
    }

    private IAction getCollapseConfigViewAction() {
        return this.collapseConfigViewAction;
    }

    public void setCollapseConfigViewAction(IAction collapseConfigViewAction) {
        this.collapseConfigViewAction = collapseConfigViewAction;
    }

    public void dispose() {
        if (this.libSvcListener != null) {
            LibraryService.getInstance().removeListener(this.libSvcListener);
        }
        if (configComboViewer != null && this.postSelectionChangedListener != null) {
            configComboViewer.removePostSelectionChangedListener(this.postSelectionChangedListener);
        }
        super.dispose();
    }

    public static void refresh() {
        if (configComboViewer == null || configComboViewer.getCombo() == null || configComboViewer.getCombo().isDisposed()) {
            return;
        }
        configComboViewer.refresh();
    }

    private static void selectConfiguration(MethodConfiguration config) {
        if (config != null && config == ConfigurationContributionItem.getSelectedConfig()) {
            return;
        }
        if (config != null) {
            configComboViewer.setSelection((ISelection)new StructuredSelection((Object)config));
        } else {
            ConfigurationContributionItem.refresh();
            configComboViewer.setSelection((ISelection)new StructuredSelection((Object)LibraryUIResources.selectConfigLabel_text), true);
        }
    }

    public void setEnabled(boolean enabled) {
        configCombo.setEnabled(enabled);
    }

    public void setInputDebugLog(String caller, Object input) {
        if (DebugUtil.uiDebug) {
            DebugUtil.print((String)(String.valueOf(caller) + ", configComboViewer input set: " + input));
            DebugUtil.print();
        }
    }
}

