/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.ui.actions;

import org.eclipse.epf.library.ui.LibraryUIUtil;
import org.eclipse.epf.library.ui.wizards.OpenLibraryWizard;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;

public class OpenLibraryAction
implements IWorkbenchWindowActionDelegate {
    private IWorkbenchWindow window;

    public void init(IWorkbenchWindow window) {
        this.window = window;
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void run(IAction action) {
        int dirtyCount = 0;
        IEditorReference[] list = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getEditorReferences();
        int i = 0;
        while (i < list.length) {
            if (list[i].isDirty()) {
                ++dirtyCount;
            }
            ++i;
        }
        if (dirtyCount == 1) {
            boolean rc = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().closeAllEditors(true);
            if (!rc) {
                return;
            }
        } else if (dirtyCount > 1) {
            switch (LibraryUIUtil.displaySaveDirtyEditorsDialog()) {
                case 64: {
                    PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().closeAllEditors(true);
                    break;
                }
                case 128: {
                    PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().closeAllEditors(false);
                    break;
                }
                case 256: {
                    return;
                }
            }
        } else if (list.length > 0) {
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().closeAllEditors(false);
        }
        OpenLibraryWizard wizard = new OpenLibraryWizard();
        wizard.init(this.window.getWorkbench(), null);
        Shell shell = Display.getCurrent().getActiveShell();
        WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
        dialog.create();
        dialog.open();
    }

    public void dispose() {
    }
}

