/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.ui.internal.wizards;

import java.io.File;
import java.util.Map;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.epf.common.service.versioning.VersionUtil;
import org.eclipse.epf.common.ui.util.MsgDialog;
import org.eclipse.epf.library.LibraryManagerFactory;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.ui.LibraryUIManager;
import org.eclipse.epf.library.ui.LibraryUIPlugin;
import org.eclipse.epf.library.ui.LibraryUIResources;
import org.eclipse.epf.library.ui.internal.wizards.OpenLibraryMainPage2;
import org.eclipse.epf.library.ui.internal.wizards.OpenLibraryWizardPageFactory;
import org.eclipse.epf.library.ui.preferences.LibraryUIPreferences;
import org.eclipse.epf.library.ui.wizards.OpenLibraryWizardPage;
import org.eclipse.epf.library.xmi.XMILibraryUtil;
import org.eclipse.epf.persistence.migration.UpgradeCallerInfo;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class OpenLibraryWizard2
extends Wizard
implements INewWizard {
    public static final String WIZARD_ID = OpenLibraryWizard2.class.getName();
    private OpenLibraryMainPage2 mainPage;

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setWindowTitle(LibraryUIResources.openLibraryWizard_title);
    }

    public void addPages() {
        this.mainPage = new OpenLibraryMainPage2();
        this.addPage((IWizardPage)this.mainPage);
        for (String persistenceId : LibraryManagerFactory.getInstance().getLibraryTypes().keySet()) {
            String pageId = String.valueOf(persistenceId) + "Page";
            OpenLibraryWizardPage page = OpenLibraryWizardPageFactory.getInstance().createWizardPage(pageId, persistenceId);
            if (page == null) continue;
            page.setImageDescriptor(LibraryUIPlugin.getDefault().getImageDescriptor("full/wizban/Open.gif"));
            this.addPage((IWizardPage)page);
        }
    }

    public void createPageControls(Composite pageContainer) {
        super.createPageControls(pageContainer);
        pageContainer.getShell().setImage(LibraryUIPlugin.getDefault().getSharedImage("full/obj16/MethodLibrary.gif"));
    }

    public boolean canFinish() {
        if (this.mainPage.isPageComplete() && !this.mainPage.isOpenUnlistedLibrary()) {
            return true;
        }
        IWizardPage[] pages = this.getPages();
        int i = 1;
        while (i < pages.length) {
            if (!pages[i].isPageComplete()) {
                return false;
            }
            ++i;
        }
        return this.getContainer().getCurrentPage() != this.mainPage;
    }

    public boolean performFinish() {
        block12: {
            String path;
            block15: {
                block13: {
                    block14: {
                        String type = this.mainPage.getLibraryType();
                        OpenLibraryWizardPage page = OpenLibraryWizardPageFactory.getInstance().getWizardPage(type);
                        try {
                            path = null;
                            if (this.mainPage.isOpenUnlistedLibrary()) {
                                Map options = page.getSelections();
                                path = (String)options.get("library.path");
                            } else {
                                path = this.mainPage.getLibraryPath();
                            }
                            if (path == null) break block12;
                            if (XMILibraryUtil.isValidLibrary((String)path, (boolean)true) != Status.OK_STATUS) break block13;
                            if (OpenLibraryWizard2.handleToolVersion(path, null)) break block14;
                            return false;
                        }
                        catch (Exception e) {
                            String reason = e.getMessage();
                            if (reason == null) {
                                reason = LibraryUIResources.openLibraryInternlError_reason;
                            }
                            reason = String.valueOf(reason) + "\n\n" + LibraryUIResources.openLibraryError_advice;
                            if (e.getMessage() != null) {
                                LibraryUIPlugin.getDefault().getMsgDialog().displayError(LibraryUIResources.openLibraryWizard_title, LibraryUIResources.openLibraryError_msg, reason);
                            } else {
                                LibraryUIPlugin.getDefault().getMsgDialog().displayError(LibraryUIResources.openLibraryWizard_title, LibraryUIResources.openLibraryError_msg, reason, (Throwable)e);
                            }
                            return false;
                        }
                    }
                    if (LibraryUIManager.getInstance().openLibrary(path)) {
                        this.addRecentlyOpenedLibrary();
                        return true;
                    }
                    break block12;
                }
                if (XMILibraryUtil.containsPluginOrConfigSpecExportFile((String)path)) {
                    throw new Exception(LibraryUIResources.openLibraryError_reason4);
                }
                MsgDialog msgDialog = LibraryUIPlugin.getDefault().getMsgDialog();
                boolean rc = msgDialog.displayConfirmation(LibraryUIResources.openLibraryWizard_title, NLS.bind((String)LibraryUIResources.openLibraryDialog_newLibrary_text, (Object[])new Object[]{path}));
                if (rc) break block15;
                return false;
            }
            if (!LibraryUIManager.getInstance().createLibrary(path)) break block12;
            this.addRecentlyOpenedLibrary();
            return true;
        }
        return true;
    }

    protected void addRecentlyOpenedLibrary() {
        MethodLibrary library = LibraryService.getInstance().getCurrentMethodLibrary();
        if (library != null) {
            String libraryURI = LibraryService.getInstance().getLibraryManager(library).getMethodLibraryURI().toString();
            LibraryUIPreferences.addOpenLibraryURI(libraryURI);
        }
    }

    public static boolean handleToolVersion(String path, UpgradeCallerInfo callerInfo) {
        VersionUtil.VersionCheckInfo info;
        String libXmi = "library.xmi";
        if (callerInfo != null && callerInfo.getIsExportedPluginLib()) {
            libXmi = "export.xmi";
        }
        if ((info = VersionUtil.checkLibraryVersion((File)new File(path, libXmi))) != null && info.result > 0) {
            String message = "";
            message = info.toolID.equals(VersionUtil.getPrimaryToolID()) ? NLS.bind((String)LibraryUIResources.versionMismatchDialog_text, (Object[])new Object[]{Platform.getProduct().getName(), info.toolVersion}) : NLS.bind((String)LibraryUIResources.versionMismatchDialog_text_unknown, (Object[])new Object[]{Platform.getProduct().getName()});
            if (!OpenLibraryWizard2.isUpgradeLibrary(callerInfo)) {
                callerInfo.setErrorMsg(message);
                return false;
            }
            LibraryUIPlugin.getDefault().getMsgDialog().displayError(LibraryUIResources.openLibraryWizard_title, message);
            return false;
        }
        if (XMILibraryUtil.isMethodLibraryUpgradeRequired((String)path, (String)libXmi, (VersionUtil.VersionCheckInfo)info)) {
            if (OpenLibraryWizard2.isUpgradeLibrary(callerInfo) && !LibraryUIPlugin.getDefault().getMsgDialog().displayConfirmation(LibraryUIResources.openLibraryWizard_title, LibraryUIResources.upgradeLibraryDialog_text)) {
                return false;
            }
            if (!OpenLibraryWizard2.isUpgradeLibrary(callerInfo)) {
                callerInfo.copyLibrary();
                if (callerInfo.getCopiedLibFile() != null) {
                    path = callerInfo.getCopiedLibFile().getParentFile().getAbsolutePath();
                }
            }
            if (!LibraryUIManager.upgradeLibrary(path, callerInfo)) {
                return false;
            }
        }
        return true;
    }

    private static boolean isUpgradeLibrary(UpgradeCallerInfo callerInfo) {
        return UpgradeCallerInfo.isUpgradeLibrary((UpgradeCallerInfo)callerInfo);
    }
}

