/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.ui.preferences;

import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.epf.common.ui.util.PreferenceUtil;
import org.eclipse.epf.common.utils.FileUtil;
import org.eclipse.epf.library.configuration.SupportingElementData;
import org.eclipse.epf.library.edit.validation.IValidationManager;
import org.eclipse.epf.library.ui.LibraryUIPlugin;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.ecore.util.DefaultValueManager;
import org.eclipse.jface.preference.IPreferenceStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LibraryUIPreferences {
    private static final String DEFAULT_LIBRARY_PATH = "defaultLibraryPath";
    private static final String SAVED_LIBRARY_PATH = "savedLibraryPath";
    private static final String PUBLISH_UNOPEN_ACTIVITY_DD = "publishUnopenActivityDetailDiagram";
    private static final String PREF_SWITCH_CONFIG = "switchConfigurationOnProcessActivate";
    private static final String PUBLISH_AD_FOR_ACTIVITY_EXTENSION = "publishActivityDiagramforActivityExtension";
    private static final String APPLICATION_SHORT_NAME = "appname";
    private static final String NEW_LIBRARY_PATHS = "newLibraryPaths";
    private static final String OPEN_LIBRARY_PATHS = "openLibraryPaths";
    private static final String OPEN_LIBRARY_URIS = "openLibraryURIs";
    private static final String WORK_BREAKDOWNELEMENT_OPTIONAL = "work_breakdownelement_optional";
    private static final String WORK_BREAKDOWNELEMENT_MULTIPLE_OCCURRANCES = "work_breakdownelement_multiple_occurrances";
    private static final String WORK_BREAKDOWNELEMENT_PLANNED = "work_breakdownelement_planned";
    private static final String WORK_BREAKDOWNELEMENT_EVENT_DRIVEN = "work_breakdownelement_event_driven";
    private static final String WORK_BREAKDOWNELEMENT_ONGOING = "work_breakdownelement_multiple_ongoing";
    private static final String WORK_BREAKDOWNELEMENT_REPEATABLE = "work_breakdownelement_repeatable";
    private static final String DESCRIPTOR_OPTIONAL = "descriptor_optional";
    private static final String DESCRIPTOR_MULTIPLE_OCCURRANCES = "descriptor_multiple_occurrances";
    private static final String DESCRIPTOR_PLANNED = "descriptor_planned";
    private static final String DESCRIPTOR_EVENT_DRIVEN = "descriptor_event_driven";
    private static final String DESCRIPTOR_ONGOING = "descriptor_multiple_ongoing";
    private static final String INCLUDE_DESCRIPTORS = "include descriptors";
    private static final String NAME_VALIDATION = "name validation";
    private static final String CIRCULAR_VALIDATION = "circular validation";
    private static final String UNDECLARED_VALIDATION = "undeclared validation";
    private static final String DESCRIPTOR_REPEATABLE = "descriptor_repeatable";
    private static final String DEFAULT_LIBRARY_FOLDER_NAME = "Method Libraries";
    private static String defaultLibraryPath = null;
    private static IPreferenceStore prefStore = LibraryUIPlugin.getDefault().getPreferenceStore();

    static {
        prefStore.setDefault(DEFAULT_LIBRARY_PATH, LibraryUIPreferences.getInitialDefaultLibraryPath());
        prefStore.setDefault(SAVED_LIBRARY_PATH, "");
        prefStore.setDefault(PREF_SWITCH_CONFIG, "prompt");
        prefStore.setDefault(NEW_LIBRARY_PATHS, "");
        prefStore.setDefault(OPEN_LIBRARY_PATHS, "");
        prefStore.setDefault(OPEN_LIBRARY_URIS, "");
        prefStore.setDefault(WORK_BREAKDOWNELEMENT_OPTIONAL, false);
        prefStore.setDefault(WORK_BREAKDOWNELEMENT_MULTIPLE_OCCURRANCES, false);
        prefStore.setDefault(WORK_BREAKDOWNELEMENT_PLANNED, true);
        prefStore.setDefault(WORK_BREAKDOWNELEMENT_EVENT_DRIVEN, false);
        prefStore.setDefault(WORK_BREAKDOWNELEMENT_ONGOING, false);
        prefStore.setDefault(WORK_BREAKDOWNELEMENT_REPEATABLE, false);
        prefStore.setDefault(DESCRIPTOR_OPTIONAL, false);
        prefStore.setDefault(DESCRIPTOR_MULTIPLE_OCCURRANCES, false);
        prefStore.setDefault(DESCRIPTOR_PLANNED, false);
        prefStore.setDefault(DESCRIPTOR_EVENT_DRIVEN, false);
        prefStore.setDefault(DESCRIPTOR_ONGOING, false);
        prefStore.setDefault(INCLUDE_DESCRIPTORS, !SupportingElementData.isDescriptorExclusiveOption());
        prefStore.setDefault(DESCRIPTOR_REPEATABLE, false);
        prefStore.setDefault(NAME_VALIDATION, false);
        prefStore.setDefault(CIRCULAR_VALIDATION, false);
        prefStore.setDefault(UNDECLARED_VALIDATION, true);
        prefStore.setDefault(PUBLISH_AD_FOR_ACTIVITY_EXTENSION, true);
        SupportingElementData.setDescriptorExclusiveOption((!LibraryUIPreferences.getIncludeDescriptors() ? 1 : 0) != 0);
    }

    public static String getInitialDefaultLibraryPath() {
        if (defaultLibraryPath == null) {
            defaultLibraryPath = System.getProperty("user.home");
            String appName = LibraryUIPreferences.getApplicationShortName();
            defaultLibraryPath = appName != null && appName.length() > 0 ? String.valueOf(defaultLibraryPath) + FileUtil.FILE_SEP + appName + FileUtil.FILE_SEP + DEFAULT_LIBRARY_FOLDER_NAME : String.valueOf(defaultLibraryPath) + FileUtil.FILE_SEP + DEFAULT_LIBRARY_FOLDER_NAME;
        }
        return defaultLibraryPath;
    }

    public static String getDefaultLibraryPath() {
        return prefStore.getString(DEFAULT_LIBRARY_PATH);
    }

    public static void setDefaultLibraryPath(String value) {
        prefStore.setValue(DEFAULT_LIBRARY_PATH, value);
    }

    public static void setPublishUnopenActivitydd(boolean enabled) {
        prefStore.setValue(PUBLISH_UNOPEN_ACTIVITY_DD, enabled);
    }

    public static boolean getPublishUnopenActivitydd() {
        return prefStore.getBoolean(PUBLISH_UNOPEN_ACTIVITY_DD);
    }

    public static void setPublishADForActivityExtension(boolean enabled) {
        prefStore.setValue(PUBLISH_AD_FOR_ACTIVITY_EXTENSION, enabled);
    }

    public static boolean getPublishADForActivityExtension() {
        return prefStore.getBoolean(PUBLISH_AD_FOR_ACTIVITY_EXTENSION);
    }

    public static String getSwitchConfig() {
        return prefStore.getString(PREF_SWITCH_CONFIG);
    }

    public static void setSwitchConfig(String value) {
        prefStore.setValue(PREF_SWITCH_CONFIG, value);
    }

    public static String getSwitchConfigPreferenceKey() {
        return PREF_SWITCH_CONFIG;
    }

    public static String getSavedLibraryPath() {
        return prefStore.getString(SAVED_LIBRARY_PATH);
    }

    public static void setSavedLibraryPath(String libPath) {
        String path = libPath;
        if (path.endsWith("library.xmi")) {
            path = FileUtil.getParentDirectory((String)path);
        }
        prefStore.setValue(SAVED_LIBRARY_PATH, path);
        LibraryUIPlugin.getDefault().savePluginPreferences();
    }

    public static String getApplicationShortName() {
        return prefStore.getString(APPLICATION_SHORT_NAME);
    }

    public static String[] getNewLibraryPaths() {
        return PreferenceUtil.getStringValues((IPreferenceStore)prefStore, (String)NEW_LIBRARY_PATHS);
    }

    public static List<String> getNewLibraryPathsList() {
        return PreferenceUtil.getList((IPreferenceStore)prefStore, (String)NEW_LIBRARY_PATHS);
    }

    public static void addNewLibraryPath(String path) {
        PreferenceUtil.addToList((IPreferenceStore)prefStore, (String)NEW_LIBRARY_PATHS, (String)path, (String)LibraryUIPreferences.getDefaultLibraryPath());
    }

    public static String[] getOpenLibraryPaths() {
        return PreferenceUtil.getStringValues((IPreferenceStore)prefStore, (String)OPEN_LIBRARY_PATHS);
    }

    public static List<String> getOpenLibraryPathsList() {
        return PreferenceUtil.getList((IPreferenceStore)prefStore, (String)OPEN_LIBRARY_PATHS);
    }

    public static void addOpenLibraryPath(String path) {
        PreferenceUtil.addToList((IPreferenceStore)prefStore, (String)OPEN_LIBRARY_PATHS, (String)path, (String)LibraryUIPreferences.getDefaultLibraryPath());
    }

    public static String[] getOpenLibraryURIs() {
        return PreferenceUtil.getStringValues((IPreferenceStore)prefStore, (String)OPEN_LIBRARY_URIS);
    }

    public static List getOpenLibraryURIsList() {
        return PreferenceUtil.getList((IPreferenceStore)prefStore, (String)OPEN_LIBRARY_URIS);
    }

    public static void addOpenLibraryURI(String uri) {
        PreferenceUtil.addToList((IPreferenceStore)prefStore, (String)OPEN_LIBRARY_URIS, (String)uri);
    }

    public static void saveAllPreferences() {
        LibraryUIPlugin.getDefault().savePluginPreferences();
    }

    public static boolean getWorkBreakDownElementOptional() {
        return prefStore.getBoolean(WORK_BREAKDOWNELEMENT_OPTIONAL);
    }

    public static void setWorkBreakdownElementOptional(boolean value) {
        prefStore.setValue(WORK_BREAKDOWNELEMENT_OPTIONAL, value);
    }

    public static boolean getWorkBreakDownElementMultipleOccurrances() {
        return prefStore.getBoolean(WORK_BREAKDOWNELEMENT_MULTIPLE_OCCURRANCES);
    }

    public static void setWorkBreakdownElementMultipleOccurrances(boolean value) {
        prefStore.setValue(WORK_BREAKDOWNELEMENT_MULTIPLE_OCCURRANCES, value);
    }

    public static boolean getWorkBreakDownElementPlanned() {
        return prefStore.getBoolean(WORK_BREAKDOWNELEMENT_PLANNED);
    }

    public static void setWorkBreakdownElementPlanned(boolean value) {
        prefStore.setValue(WORK_BREAKDOWNELEMENT_PLANNED, value);
    }

    public static boolean getWorkBreakDownElementEventDriven() {
        return prefStore.getBoolean(WORK_BREAKDOWNELEMENT_EVENT_DRIVEN);
    }

    public static void setWorkBreakdownElementEventDriven(boolean value) {
        prefStore.setValue(WORK_BREAKDOWNELEMENT_EVENT_DRIVEN, value);
    }

    public static boolean getWorkBreakDownElementOngoing() {
        return prefStore.getBoolean(WORK_BREAKDOWNELEMENT_ONGOING);
    }

    public static void setWorkBreakdownElementOngoing(boolean value) {
        prefStore.setValue(WORK_BREAKDOWNELEMENT_ONGOING, value);
    }

    public static boolean getWorkBreakDownElementRepeatable() {
        return prefStore.getBoolean(WORK_BREAKDOWNELEMENT_REPEATABLE);
    }

    public static void setWorkBreakdownElementRepeatable(boolean value) {
        prefStore.setValue(WORK_BREAKDOWNELEMENT_REPEATABLE, value);
    }

    public static boolean getDescriptorOptional() {
        return prefStore.getBoolean(DESCRIPTOR_OPTIONAL);
    }

    public static void setDescriptorOptional(boolean value) {
        prefStore.setValue(DESCRIPTOR_OPTIONAL, value);
    }

    public static boolean getDescriptorMultipleOccurrances() {
        return prefStore.getBoolean(DESCRIPTOR_MULTIPLE_OCCURRANCES);
    }

    public static void setDescriptorMultipleOccurrances(boolean value) {
        prefStore.setValue(DESCRIPTOR_MULTIPLE_OCCURRANCES, value);
    }

    public static boolean getDescriptorPlanned() {
        return prefStore.getBoolean(DESCRIPTOR_PLANNED);
    }

    public static void setDescriptorPlanned(boolean value) {
        prefStore.setValue(DESCRIPTOR_PLANNED, value);
    }

    public static boolean getDescriptorEventDriven() {
        return prefStore.getBoolean(DESCRIPTOR_EVENT_DRIVEN);
    }

    public static void setDescriptorEventDriven(boolean value) {
        prefStore.setValue(DESCRIPTOR_EVENT_DRIVEN, value);
    }

    public static boolean getDescriptorOngoing() {
        return prefStore.getBoolean(DESCRIPTOR_ONGOING);
    }

    public static void setDescriptorOngoing(boolean value) {
        prefStore.setValue(DESCRIPTOR_ONGOING, value);
    }

    public static boolean getIncludeDescriptors() {
        return prefStore.getBoolean(INCLUDE_DESCRIPTORS);
    }

    public static void setIncludeDescriptors(boolean value) {
        prefStore.setValue(INCLUDE_DESCRIPTORS, value);
        SupportingElementData.setDescriptorExclusiveOption((!value ? 1 : 0) != 0);
    }

    public static boolean getDescriptorRepeatable() {
        return prefStore.getBoolean(DESCRIPTOR_REPEATABLE);
    }

    public static void setDescriptorRepeatable(boolean value) {
        prefStore.setValue(DESCRIPTOR_REPEATABLE, value);
    }

    public static void applyDefaultValuesForBreakdownElementAttributes() {
        Object[] nonDescriptorDefaultValueDefs = new Object[]{new Object[]{UmaPackage.eINSTANCE.getWorkBreakdownElement_IsEventDriven(), LibraryUIPreferences.getWorkBreakDownElementEventDriven()}, new Object[]{UmaPackage.eINSTANCE.getBreakdownElement_HasMultipleOccurrences(), LibraryUIPreferences.getWorkBreakDownElementMultipleOccurrances()}, new Object[]{UmaPackage.eINSTANCE.getWorkBreakdownElement_IsOngoing(), LibraryUIPreferences.getWorkBreakDownElementOngoing()}, new Object[]{UmaPackage.eINSTANCE.getBreakdownElement_IsOptional(), LibraryUIPreferences.getWorkBreakDownElementOptional()}, new Object[]{UmaPackage.eINSTANCE.getBreakdownElement_IsPlanned(), LibraryUIPreferences.getWorkBreakDownElementPlanned()}, new Object[]{UmaPackage.eINSTANCE.getWorkBreakdownElement_IsRepeatable(), LibraryUIPreferences.getWorkBreakDownElementRepeatable()}};
        EClass[] nonDescriptorTypes = new EClass[]{UmaPackage.eINSTANCE.getPhase(), UmaPackage.eINSTANCE.getIteration(), UmaPackage.eINSTANCE.getActivity(), UmaPackage.eINSTANCE.getMilestone()};
        Object[] descriptorDefaultValueDefs = new Object[]{new Object[]{UmaPackage.eINSTANCE.getWorkBreakdownElement_IsEventDriven(), LibraryUIPreferences.getDescriptorEventDriven()}, new Object[]{UmaPackage.eINSTANCE.getBreakdownElement_HasMultipleOccurrences(), LibraryUIPreferences.getDescriptorMultipleOccurrances()}, new Object[]{UmaPackage.eINSTANCE.getWorkBreakdownElement_IsOngoing(), LibraryUIPreferences.getDescriptorOngoing()}, new Object[]{UmaPackage.eINSTANCE.getBreakdownElement_IsOptional(), LibraryUIPreferences.getDescriptorOptional()}, new Object[]{UmaPackage.eINSTANCE.getBreakdownElement_IsPlanned(), LibraryUIPreferences.getDescriptorPlanned()}, new Object[]{UmaPackage.eINSTANCE.getWorkBreakdownElement_IsRepeatable(), LibraryUIPreferences.getDescriptorRepeatable()}};
        EClass[] descriptorTypes = new EClass[]{UmaPackage.eINSTANCE.getRoleDescriptor(), UmaPackage.eINSTANCE.getTaskDescriptor(), UmaPackage.eINSTANCE.getWorkProductDescriptor()};
        Object[] defaultValueDefs = new Object[]{new Object[]{nonDescriptorTypes, nonDescriptorDefaultValueDefs}, new Object[]{descriptorTypes, descriptorDefaultValueDefs}};
        int i = 0;
        while (i < defaultValueDefs.length) {
            Object[] defaultValueDef = (Object[])defaultValueDefs[i];
            EClass[] types = (EClass[])defaultValueDef[0];
            Object[] featureDefaultValueDefs = (Object[])defaultValueDef[1];
            int k = 0;
            while (k < featureDefaultValueDefs.length) {
                Object[] featureDefaultValue = (Object[])featureDefaultValueDefs[k];
                EStructuralFeature feature = (EStructuralFeature)featureDefaultValue[0];
                Object defaultValue = featureDefaultValue[1];
                int j = 0;
                while (j < types.length) {
                    EClass type = types[j];
                    DefaultValueManager.INSTANCE.setDefaultValue(type, feature, defaultValue);
                    ++j;
                }
                ++k;
            }
            ++i;
        }
    }

    public static boolean getNameValidation() {
        return prefStore.getBoolean(NAME_VALIDATION);
    }

    public static void setNameValidation(boolean value) {
        prefStore.setValue(NAME_VALIDATION, value);
    }

    public static boolean getCircularValidation() {
        return prefStore.getBoolean(CIRCULAR_VALIDATION);
    }

    public static void setCircularValidation(boolean value) {
        prefStore.setValue(CIRCULAR_VALIDATION, value);
    }

    public static boolean getUndeclaredValidation() {
        return prefStore.getBoolean(UNDECLARED_VALIDATION);
    }

    public static void setUndeclaredValidation(boolean value) {
        prefStore.setValue(UNDECLARED_VALIDATION, value);
    }

    public static void update(IValidationManager mgr) {
        if (mgr != null) {
            mgr.setNameCheck(LibraryUIPreferences.getNameValidation());
            mgr.setCircularDependancyCheck(LibraryUIPreferences.getCircularValidation());
            mgr.setUndeclaredDependancyCheck(LibraryUIPreferences.getUndeclaredValidation());
        }
    }
}

